/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.preference.PreferenceManager;
import android.util.Log;
import org.acra.ACRAConfiguration;
import org.acra.ACRAConfigurationException;
import org.acra.ErrorReporter;
import org.acra.ReportField;
import org.acra.annotation.ReportsCrashes;
import org.acra.sender.EmailIntentSender;
import org.acra.sender.GoogleFormSender;
import org.acra.sender.HttpPostSender;
import org.acra.util.PackageManagerWrapper;

public class ACRA {
    public static final boolean DEV_LOGGING = false;
    public static final String LOG_TAG = ACRA.class.getSimpleName();
    public static final String PREF_DISABLE_ACRA = "acra.disable";
    public static final String PREF_ENABLE_ACRA = "acra.enable";
    public static final String PREF_ENABLE_SYSTEM_LOGS = "acra.syslog.enable";
    public static final String PREF_ENABLE_DEVICE_ID = "acra.deviceid.enable";
    public static final String PREF_USER_EMAIL_ADDRESS = "acra.user.email";
    public static final String PREF_ALWAYS_ACCEPT = "acra.alwaysaccept";
    public static final String PREF_LAST_VERSION_NR = "acra.lastVersionNr";
    private static Application mApplication;
    private static ReportsCrashes mReportsCrashes;
    private static ErrorReporter errorReporterSingleton;
    private static SharedPreferences.OnSharedPreferenceChangeListener mPrefListener;
    public static final ReportField[] DEFAULT_MAIL_REPORT_FIELDS;
    public static final ReportField[] DEFAULT_REPORT_FIELDS;
    private static ACRAConfiguration configProxy;

    public static void init(Application app) {
        if (mApplication != null) {
            throw new IllegalStateException("ACRA#init called more than once");
        }
        mApplication = app;
        mReportsCrashes = mApplication.getClass().getAnnotation(ReportsCrashes.class);
        if (mReportsCrashes == null) {
            Log.e((String)LOG_TAG, (String)("ACRA#init called but no ReportsCrashes annotation on Application " + mApplication.getPackageName()));
            return;
        }
        SharedPreferences prefs = ACRA.getACRASharedPreferences();
        Log.d((String)LOG_TAG, (String)"Set OnSharedPreferenceChangeListener.");
        try {
            ACRA.checkCrashResources();
            Log.d((String)LOG_TAG, (String)("ACRA is enabled for " + mApplication.getPackageName() + ", intializing..."));
            boolean enableAcra = !ACRA.shouldDisableACRA(prefs);
            ErrorReporter errorReporter = new ErrorReporter(mApplication.getApplicationContext(), prefs, enableAcra);
            ACRA.addReportSenders(errorReporter);
            errorReporterSingleton = errorReporter;
        }
        catch (ACRAConfigurationException e) {
            Log.w((String)LOG_TAG, (String)"Error : ", (Throwable)e);
        }
        mPrefListener = new SharedPreferences.OnSharedPreferenceChangeListener(){

            public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
                if (ACRA.PREF_DISABLE_ACRA.equals(key) || ACRA.PREF_ENABLE_ACRA.equals(key)) {
                    boolean enableAcra = !ACRA.shouldDisableACRA(sharedPreferences);
                    ACRA.getErrorReporter().setEnabled(enableAcra);
                }
            }
        };
        prefs.registerOnSharedPreferenceChangeListener(mPrefListener);
    }

    public static ErrorReporter getErrorReporter() {
        if (errorReporterSingleton == null) {
            throw new IllegalStateException("Cannot access ErrorReporter before ACRA#init");
        }
        return errorReporterSingleton;
    }

    private static void addReportSenders(ErrorReporter errorReporter) {
        ACRAConfiguration conf = ACRA.getConfig();
        if (!"".equals(conf.mailTo())) {
            Log.w((String)LOG_TAG, (String)(mApplication.getPackageName() + " reports will be sent by email (if accepted by user)."));
            errorReporter.addReportSender(new EmailIntentSender((Context)mApplication));
            return;
        }
        PackageManagerWrapper pm = new PackageManagerWrapper((Context)mApplication);
        if (!pm.hasPermission("android.permission.INTERNET")) {
            Log.e((String)LOG_TAG, (String)(mApplication.getPackageName() + " should be granted permission " + "android.permission.INTERNET" + " if you want your crash reports to be sent. If you don't want to add this permission to your application you can also enable sending reports by email. If this is your will then provide your email address in @ReportsCrashes(mailTo=\"your.account@domain.com\""));
            return;
        }
        if (conf.formUri() != null && !"".equals(conf.formUri())) {
            errorReporter.addReportSender(new HttpPostSender(conf.formUri(), null));
            return;
        }
        if (conf.formKey() != null && !"".equals(conf.formKey().trim())) {
            errorReporter.addReportSender(new GoogleFormSender(conf.formKey()));
        }
    }

    private static boolean shouldDisableACRA(SharedPreferences prefs) {
        boolean disableAcra = false;
        try {
            boolean enableAcra = prefs.getBoolean(PREF_ENABLE_ACRA, true);
            disableAcra = prefs.getBoolean(PREF_DISABLE_ACRA, !enableAcra);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return disableAcra;
    }

    static void checkCrashResources() throws ACRAConfigurationException {
        ACRAConfiguration conf = ACRA.getConfig();
        switch (conf.mode()) {
            case TOAST: {
                if (conf.resToastText() != 0) break;
                throw new ACRAConfigurationException("TOAST mode: you have to define the resToastText parameter in your application @ReportsCrashes() annotation.");
            }
            case NOTIFICATION: {
                if (conf.resNotifTickerText() != 0 && conf.resNotifTitle() != 0 && conf.resNotifText() != 0 && conf.resDialogText() != 0) break;
                throw new ACRAConfigurationException("NOTIFICATION mode: you have to define at least the resNotifTickerText, resNotifTitle, resNotifText, resDialogText parameters in your application @ReportsCrashes() annotation.");
            }
            case DIALOG: {
                if (conf.resDialogText() != 0) break;
                throw new ACRAConfigurationException("DIALOG mode: you have to define at least the resDialogText parameters in your application @ReportsCrashes() annotation.");
            }
        }
    }

    public static SharedPreferences getACRASharedPreferences() {
        ACRAConfiguration conf = ACRA.getConfig();
        if (!"".equals(conf.sharedPreferencesName())) {
            Log.d((String)LOG_TAG, (String)("Retrieve SharedPreferences " + conf.sharedPreferencesName()));
            return mApplication.getSharedPreferences(conf.sharedPreferencesName(), conf.sharedPreferencesMode());
        }
        Log.d((String)LOG_TAG, (String)"Retrieve application default SharedPreferences.");
        return PreferenceManager.getDefaultSharedPreferences((Context)mApplication);
    }

    public static ACRAConfiguration getConfig() {
        if (configProxy == null) {
            configProxy = ACRA.getNewDefaultConfig();
        }
        return configProxy;
    }

    public static void setConfig(ACRAConfiguration conf) {
        configProxy = conf;
    }

    public static ACRAConfiguration getNewDefaultConfig() {
        return new ACRAConfiguration(mReportsCrashes);
    }

    static boolean isDebuggable() {
        PackageManager pm = mApplication.getPackageManager();
        try {
            return (pm.getApplicationInfo((String)ACRA.mApplication.getPackageName(), (int)0).flags & 2) > 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    static {
        DEFAULT_MAIL_REPORT_FIELDS = new ReportField[]{ReportField.USER_COMMENT, ReportField.ANDROID_VERSION, ReportField.APP_VERSION_NAME, ReportField.BRAND, ReportField.PHONE_MODEL, ReportField.CUSTOM_DATA, ReportField.STACK_TRACE};
        DEFAULT_REPORT_FIELDS = new ReportField[]{ReportField.REPORT_ID, ReportField.APP_VERSION_CODE, ReportField.APP_VERSION_NAME, ReportField.PACKAGE_NAME, ReportField.FILE_PATH, ReportField.PHONE_MODEL, ReportField.BRAND, ReportField.PRODUCT, ReportField.ANDROID_VERSION, ReportField.BUILD, ReportField.TOTAL_MEM_SIZE, ReportField.AVAILABLE_MEM_SIZE, ReportField.CUSTOM_DATA, ReportField.IS_SILENT, ReportField.STACK_TRACE, ReportField.INITIAL_CONFIGURATION, ReportField.CRASH_CONFIGURATION, ReportField.DISPLAY, ReportField.USER_COMMENT, ReportField.USER_EMAIL, ReportField.USER_APP_START_DATE, ReportField.USER_CRASH_DATE, ReportField.DUMPSYS_MEMINFO, ReportField.LOGCAT, ReportField.INSTALLATION_ID, ReportField.DEVICE_FEATURES, ReportField.ENVIRONMENT, ReportField.SHARED_PREFERENCES, ReportField.SETTINGS_SYSTEM, ReportField.SETTINGS_SECURE};
    }
}

