#include <QtCore/QDebug> //Debug pro informace
#include <QtCore/QSettings>
#include <QtCore/QTimer>
#include "timeprofile.h"
#include "timedprofildialog.h"
#include <QtCore/QStringList>
#include <QtCore/QTime>
/** TimeProfile()
create new labels
*/
TimeProfile::TimeProfile(QWidget *parent,QSettings *set) :
        QWidget(parent)
{
    settings = set;
    timer = new QTimer(this);
    timer->setSingleShot(true);//A single-shot timer fires only once
    connect(timer,SIGNAL(timeout()),this,SLOT(TimerTimeout()));
}

/** SetTimer()
create new labels
*/
void TimeProfile::SetTimer(QStringList  list_of_profiles_n)
{
    TimedProfilDialog dialog(list_of_profiles_n, this);
    int result = dialog.exec();
    if(result)
    {
        QTime nula_cas(0,0);
        // dialog.GetTime().msec()
        //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "time:" << dialog.GetTime() ;
        //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "different:" << nula_cas.msecsTo(dialog.GetTime());
        if(dialog.GetTime() == nula_cas){
            timer->stop();
            profile = QString("");
            emit  s_set_timed_profile(QString(""));//send empty string
            return;
        }
        timer->start(nula_cas.msecsTo(dialog.GetTime()));
        profile = dialog.GetName();
        emit s_set_timed_profile(profile);
    }
}

/** TimerTimeout()
timer timeout slot
*/
void TimeProfile::TimerTimeout()
{
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "timer  timeout" ;
    profile = QString("");
    emit  s_set_timed_profile(QString(""));//send empty string
}

/** ChangeInProfles()
When profiles change , find profile
if not exist stop this profile
*/
void TimeProfile::ChangeInProfles(QStringList list_profiles)
{
    if(!list_profiles.contains(profile))
    {
        timer->stop();
        emit  s_set_timed_profile(QString(""));//send empty string
    }
}

