#ifndef TIMEDPROFILDIALOG_H
#define TIMEDPROFILDIALOG_H

/*! \file timedprofildialog.h
    \brief File .H for class  TimedProfilDialog
\author Jakub Šplíchal <jakub.bzouk@gmail.com>
Header file
*/
#include <QDialog>
class QStringList;
class QMaemo5ListPickSelector;
class QMaemo5ValueButton;
class QMaemo5TimePickSelector;
#include <QtCore/QTime>
namespace Ui {
    class TimedprofilDialog;
}

/** \class TimedProfilDialog
  \brief class for dialog for timed profiles
 */
class TimedProfilDialog : public QDialog {
    Q_OBJECT
public:
    TimedProfilDialog(QStringList list, QWidget *parent = 0);
    ~TimedProfilDialog();
    QTime GetTime();
    QString GetName();
protected:
    void changeEvent(QEvent *e);
    void accept();

private:
    Ui::TimedprofilDialog *ui;

    QMaemo5ValueButton *v1;
    QMaemo5ValueButton *v2;

    QMaemo5ListPickSelector * list_pick;
    QMaemo5TimePickSelector * time_pick;

    QString name_of_profile;
    QTime time_for_set;

    void createNewLabels();
    void createNewMaemoButtons(QStringList list);

};

#endif // TIMEDPROFILDIALOG_H
