#ifndef TELEPHONENUMPROFILE_H
#define TELEPHONENUMPROFILE_H

#include <QWidget>
class QDBusMessage;
class QStandardItemModel;
class QModelIndex;
class QItemSelectionModel;
class QTimer;

/** \class TelephoneNumProfile
  \brief class for setting profile based on telephone rules
 */
class TelephoneNumProfile : public QWidget
{
    Q_OBJECT
public:
    explicit TelephoneNumProfile(QWidget *parent = 0);
    void ShowDialog();
    void createModels(QStandardItemModel * telenum);
signals:
    void s_telnum_profile(QString);

private:
    QTimer *timer;
    QString FindTelnumInModel(QString telnum);



    QStandardItemModel *model_of_telenum;
    QItemSelectionModel *selModel_telenum;

    QStringList list_of_profiles;
public slots:
    void SetProfilenames(QStringList list_of_profiles_nf);
private slots:
    void receiveCall (const  QDBusMessage&);
    void TimerTimeout();

};

#endif // TELEPHONENUMPROFILE_H

