#include "telephonenumprofile.h"
#include "telenumdialog.h"
#include <QStringList>
#include <QtCore/QSettings>
#include <QtCore/QDebug> //Debug pro informace
#include <QtGui/QStandardItemModel>
#include <QtGui/QItemSelectionModel>
#include <QtDBus/QDBusConnection>
#include <QDBusMessage>
#include <QtCore/QTimer>
#include <QDBusInterface>
static const char* CALL_DBUS_SERVICE =  "com.nokia.csd.Call";
static const char* CALL_DBUS_OBJECT_PATH =  "/com/nokia/csd/call/1";
static const char* CALL_DBUS_INTERFACE = "com.nokia.csd.Call.Instance";
static const char* CALL_DBUS_METHOD = "GetStatus";

TelephoneNumProfile::TelephoneNumProfile(QWidget *parent) :
        QWidget(parent)
{
    //======================================================
    timer = new QTimer(this);
    timer->setSingleShot(true);//A single-shot timer fires only once
    connect(timer,SIGNAL(timeout()),this,SLOT(TimerTimeout()));
    bool succ =   QDBusConnection::systemBus().connect( "", "/com/nokia/csd/call", "com.nokia.csd.Call", "Coming", this, SLOT(receiveCall(const  QDBusMessage&)));;

    if(succ){
        //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "anooooooooooooooooooooooooooooooooooooooo:";
    } else {
        //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "neeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee:";
    }
}

/** receiveCall.
Slot for dbus signal for incoming call
\param msg msg from d bus
*/
void TelephoneNumProfile::receiveCall(  const  QDBusMessage& msg)
{
    // profile_set_value_as_bool("general", "vibrating.alert.enabled",  false);
    //profile_set_value("general", "ringing.alert.type",  "silent");
    // QList<QVariant> lst = msg.arguments();
    //    QVariant var;
    //    foreach(var, lst)
    //    {
    //        //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" <<  "příchozí hovor"  << var.toString();
    //    }
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" <<  "příchozí hovor";
    QString profil_name = FindTelnumInModel(msg.arguments().at(1).toString());
    if(!profil_name.isEmpty()){
        emit s_telnum_profile(profil_name);
        timer->start(1000);
    }
}

/** TimerTimeout()
timer timeout slot
*/
void TelephoneNumProfile::TimerTimeout()
{
   qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "timer  timeout" ;

    QDBusConnection systemDbusConnection = QDBusConnection::systemBus();
    QDBusInterface connectionInterface(CALL_DBUS_SERVICE,
                                       CALL_DBUS_OBJECT_PATH,
                                       CALL_DBUS_INTERFACE,
                                       systemDbusConnection);
    if (!connectionInterface.isValid()) {
        qWarning() << "Cannotct conect to D-BUS";
        return;
    }
    //poslu zpravu ze chcu info
    QDBusMessage reply = connectionInterface.call(QLatin1String(CALL_DBUS_METHOD));
    if (reply.type() == QDBusMessage::ReplyMessage) {
        QList<QVariant> argList = reply.arguments();
        //   currentCellNetworkStatus = argList.at(INDEX_OF_NEVIM).toInt();
        foreach(QVariant var, argList)
        {
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << " hodnota :::" << var.toString();
        }
        if(reply.arguments().at(0).toString() != "0")
        {
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "nebyl nula" ;
            timer->start(2000);
            return;
        }
        else{
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "ted jo" ;
            emit  s_telnum_profile(QString(""));//send empty string
        }
   }
    else
    {
        qWarning() << reply.errorMessage();
    }
}

/** SetProfilenames.
Set profiles names
\param list_of_profiles_nf names of profiles
*/
void TelephoneNumProfile::SetProfilenames(QStringList list_of_profiles_nf)
{
    list_of_profiles = list_of_profiles_nf;
}

/** createModels
gets model and create selection model
*/
void TelephoneNumProfile::createModels(QStandardItemModel * telenum)
{
    model_of_telenum =  telenum;
    selModel_telenum = new QItemSelectionModel(model_of_telenum);
}

/** FindIDLocInModel.
Find id location and return name of profile
\param telnum tele num
*/
QString TelephoneNumProfile::FindTelnumInModel(QString telnum)
{
    QString name = QString("");
    QList<QStandardItem *> list_of_telnum;

    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Bude hledat modelu wifi site " ;

    //labels << tr("Name") << tr("Wifi name") << tr("Profile");
    list_of_telnum = model_of_telenum->findItems(telnum, Qt::MatchExactly , 1);

    if(list_of_telnum.empty())
    {
        //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "nic nanasel " ;
        return name;
    } else
    {
        name = model_of_telenum->item(list_of_telnum.at(0)->row(),2)->data(Qt::DisplayRole).toString();
        //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "nasel ho  " << name;
        return name;
    }
}


//===========================================================================
/** ShowDialog
For dialog for modifi calendars and profiles
*/
void TelephoneNumProfile::ShowDialog()
{
    TeleNumDialog dialog(this);
    dialog.SetViews(model_of_telenum,selModel_telenum);
    dialog.SetProfilenames(list_of_profiles);

    dialog.exec();
}

