#include "telephonenumnewruledialog.h"
#include "ui_telephonenumnewruledialog.h"
#include <QStringList>
#include <QtCore/QSettings>
#include <QtCore/QDebug> //Debug pro informace
#include <QtGui/QItemSelectionModel>
#include <QtGui/QStandardItemModel>
#include <QMaemo5InformationBox>
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include <QMaemo5InformationBox>
TelePhoneNumNewRuleDialog::TelePhoneNumNewRuleDialog(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::TelePhoneNumNewRuleDialog)
{
    ui->setupUi(this);
    selectedProfile = QString("");
    ui->lineEditTelNumber->setText(QString("+420"));
}

TelePhoneNumNewRuleDialog::~TelePhoneNumNewRuleDialog()
{
    delete ui;
}


/** SetProfilenames.
  Store profile names and create maemo button fro show this names
  \param list_of_profiles_nf list of profile names
*/
void  TelePhoneNumNewRuleDialog::SetProfilenames(QStringList list_of_profiles_nf)
{
    list_of_profiles = list_of_profiles_nf;

    p_model_profile_names = new QStandardItemModel(this);//model for maemo 5 button

    foreach(QString profile, list_of_profiles )
    {
        p_model_profile_names->appendRow(new QStandardItem(profile));
    }

    p_set_Profile_button = new QMaemo5ValueButton(tr("Choose profile for Number:"), this);
    p_set_Profile_button->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    p_list_pick_profile = new QMaemo5ListPickSelector();
    p_list_pick_profile->setModel(p_model_profile_names);
    p_set_Profile_button->setPickSelector(p_list_pick_profile);
    ui->formLayout_2->addWidget(p_set_Profile_button);

    connect(p_list_pick_profile,SIGNAL(selected(QString)),this,SLOT(SelectedName(QString)));
}

/** SetModel.
set model for dialog
\param model  model
*/
void TelePhoneNumNewRuleDialog::SetModel(QStandardItemModel *model)
{
    model_of_Telnum = model;
}


/** TelePhoneNumNewRuleDialog.
number in table
\param Tel  tel number
*/
bool TelePhoneNumNewRuleDialog::FindTelModel(QString Tel)
{
    QList<QStandardItem *> list_of_num;

    //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Bude hledat modelu wifi site " ;
    //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "pocet radku  v modelu wifi " << model_of_WifiIf->rowCount();
    //labels << tr("Name") << tr("Wifi name") << tr("Profile");
    list_of_num = model_of_Telnum->findItems(Tel, Qt::MatchExactly , 1); //fing num name in 1 colum
    return list_of_num.empty();

}


/** SelectedName.
  Slot for change in list pick
  \param name name of profile
*/
void TelePhoneNumNewRuleDialog::SelectedName(QString name)
{
    selectedProfile = name;
}

/** SetNameOfLabel.
Set text for label
  \param id name of network
  \param name text for label
*/
void  TelePhoneNumNewRuleDialog::SetNameOfLabel(QString id, QString name )
{
    ui->labelText->setText(name + id);
}

/** GetNameProfile.
Return name of selected profile
*/
QString TelePhoneNumNewRuleDialog::GetNameProfile()
{
    return selectedProfile;
}

/** GetNameOfRule.
Return nameo of rule
*/
QString TelePhoneNumNewRuleDialog::GetNameOfRule()
{
    return ui->lineEditName->text();
}

/** GetNameOfRule.
Return nameo of rule
*/
QString TelePhoneNumNewRuleDialog::GetTelNum()
{
    return ui->lineEditTelNumber->text();
}

/** GetNameOfRule.
Return nameo of rule
*/
void TelePhoneNumNewRuleDialog::SetTelNum(QString str)
{
    ui->lineEditTelNumber->setText(str);
}

/** SetNameOfLabel.
set namo of rule
  \param name text for label
*/
void TelePhoneNumNewRuleDialog::SetNameOfRule(QString name)
{
    ui->lineEditName->setText(name);
}

/** accept()
Slot for signal when user click on save button.
Check is everyting is OK
*/
void TelePhoneNumNewRuleDialog::accept()
{
    if(selectedProfile.isEmpty())
    {
        QMaemo5InformationBox::information(this, tr("Select profile for number"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    if(ui->lineEditName->text().isEmpty())
    {
        QMaemo5InformationBox::information(this, tr("Please fill name"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    if(ui->lineEditTelNumber->text().split(QRegExp("\\s+"),QString::SkipEmptyParts).size() > 1)
    {
        QMaemo5InformationBox::information(this, tr("One number please"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    if((ui->lineEditTelNumber->text().length() == 13))
    {

        QString str = ui->lineEditTelNumber->text();
        if(str.contains(QRegExp("[+]\\d{12}")))
        {
            if(FindTelModel(str)){
                done(QDialog::Accepted);
            }else {
                QMaemo5InformationBox::information(this, tr("This rule for number already exists"), QMaemo5InformationBox::DefaultTimeout);
                return;
            }
        } else {
            QMaemo5InformationBox::information(this, tr("Set number in format : +XXXXXXXXXXXX"), QMaemo5InformationBox::DefaultTimeout);
            return;
        }
    }else {
        QMaemo5InformationBox::information(this, tr("Set number in format : +XXXXXXXXXXXX"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }
}

void TelePhoneNumNewRuleDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
