#include "telenumdialog.h"
#include "telephonenumnewruledialog.h"
#include "ui_telenumdialog.h"
#include <QStringList>
#include <QtCore/QSettings>
#include <QtCore/QDebug> //Debug pro informace
#include <QtGui/QItemSelectionModel>
#include <QtGui/QStandardItemModel>

#include <QtGui/QMessageBox>
TeleNumDialog::TeleNumDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::TeleNumDialog)
{
    ui->setupUi(this);
}

TeleNumDialog::~TeleNumDialog()
{
    delete ui;
}

void TeleNumDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

/** SetViews.
Set view models, behavior, mode and triggerrs
\param model_of_Telnum model of profiles
\param selModel_Telnum selection model for profiles
*/
void TeleNumDialog::SetViews(QStandardItemModel *model_of_Telnum ,
                                   QItemSelectionModel *selModel_Telnum)
{
    ui->tableView->setModel(model_of_Telnum);
    ui->tableView->setSelectionModel(selModel_Telnum);
    ui->tableView->setSelectionBehavior(QAbstractItemView::SelectRows);
    ui->tableView->setSelectionMode(QAbstractItemView::SingleSelection);
    ui->tableView->setEditTriggers(QAbstractItemView::NoEditTriggers);
    //ui->tableView_2->resizeColumnsToContents();
    ui->tableView->horizontalHeader()->setResizeMode(QHeaderView::Stretch);
    //labels << tr("Name") << tr("Wifi name") << tr("Profile");
}

/** SetProfilenames.
Set profiles names
\param list_of_profiles_nf names of profiles
*/
void TeleNumDialog::SetProfilenames(QStringList list_of_profiles_nf)
{
    list_of_profiles = list_of_profiles_nf;
}

/** createNewRule()
Create new rule for location or wifi
*/
void TeleNumDialog::createNewRule()
{

QStandardItemModel *model;
QList<QStandardItem *> listitems;

TelePhoneNumNewRuleDialog dialog(this);
    model = (QStandardItemModel *) ui->tableView->model();//model je ted id loc

        dialog.SetNameOfLabel("", QString(tr("New telephone rule")));

        dialog.SetProfilenames(list_of_profiles); //dam tomu seznan pro výběr
        dialog.SetModel(model);
        int result = dialog.exec();
        if(result)
        {
            //qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "Nove providloooooooooo";
            //nove jmeno pro pravidlo
            listitems.append(new QStandardItem(dialog.GetNameOfRule()));//jmeno pravidla
            listitems.append(new QStandardItem(dialog.GetTelNum()));//tel cislo
            listitems.append(new QStandardItem(dialog.GetNameProfile()));//jmeno profilu
            model->appendRow(listitems);
           // emit s_change_model();//vyslu zmenu
            //labels << tr("Name") << tr("Wifi name") << tr("Profile");davam tam id lokace prvna
        }
}

/** on_pushButton_clicked()
Slot for button click
*/
void TeleNumDialog::on_pushButton_clicked()
{
createNewRule();
}

/** on_tableView_clicked()
Slot for click on table
*/
void TeleNumDialog::on_tableView_clicked(QModelIndex index)
{
    Q_UNUSED(index)
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "kliknutu na idloc";

    QItemSelectionModel *selModel = ui->tableView->selectionModel();
    if(!selModel->hasSelection()) return;//no selection retirn
    QModelIndexList list_of_selected = selModel->selectedIndexes(); //get selected
    QStandardItemModel *model = (QStandardItemModel *) ui->tableView->model(); //model
    int row = list_of_selected.at(0).row();//get row

    QMessageBox msgBox;
    msgBox.setIcon(QMessageBox::Information);
    msgBox.setText(tr("Delete or modify number?"));
    msgBox.setEscapeButton(QMessageBox::Cancel);
    QPushButton *CancelButton =  msgBox.addButton(QMessageBox::Cancel);
    QPushButton *DeleteButton = msgBox.addButton(tr("Delete"), QMessageBox::ActionRole);
    QPushButton *modifyButton = msgBox.addButton(tr("Modify"),QMessageBox::DestructiveRole);

    msgBox.exec(); //delete or modifi
    if (msgBox.clickedButton() == DeleteButton) {

        //qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "bude se mazat pravidlo";
        model->removeRow(row);
        selModel->clearSelection();
       // emit s_change_model(); //vyslu zmenu
    }else if (msgBox.clickedButton() == modifyButton) {
        TelePhoneNumNewRuleDialog dialog(this); //modifi
        //labels << tr("Name") << tr("Wifi name") << tr("Profile");davam tam id lokace prvna
        dialog.SetNameOfLabel(list_of_selected.at(1).data().toString(), QString(tr("Change profile for number: ")));
        dialog.SetProfilenames(list_of_profiles); //dam tomu seznan pro výběr
        dialog.SetNameOfRule(list_of_selected.at(0).data().toString()); //dam tomu jmeno pravidla
        dialog.SetTelNum(list_of_selected.at(1).data().toString());
        int result = dialog.exec();
        if(result)
        {
            //nove jmeno pro pravidlo
            model->item(list_of_selected.at(0).row(),list_of_selected.at(0).column())->setData(QVariant(dialog.GetNameOfRule()),Qt::DisplayRole);
            //new name
            model->item(list_of_selected.at(2).row(),list_of_selected.at(2).column())->setData(QVariant(dialog.GetNameProfile()),Qt::DisplayRole);
           // emit s_change_model(); //vyslu zmenu
        }
                selModel->clearSelection();
    }else if (msgBox.clickedButton() == CancelButton) {
                selModel->clearSelection();
        return;
    }
}
