#include "rulesmanager.h"
#include <QtGui/QStandardItemModel>
#include <QtCore/QDebug> //Debug pro informace
RulesManager::RulesManager(QObject *parent) :
    QObject(parent)
{
}

/** Init
  Creates an object ProfileDeamon and connects via ProfileDeamon: ConnectToDeamon
  Create a model that will list all audio files
  Then initializes the XML file using InitFile()
  If the file exists so it attempts to read with readfile()
   and if not it creates and initializes using CreateFile()
*/
bool RulesManager::Init()
{//create a class to connect to deamon
    InitWIFIIDModels();
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "bude init file ================= ";
    //open the file
    if(InitFile() == false) {
        return false;
    }

    if(fileIDWifiNum.exists()) {
        if(ReadfileIDWifiNum() == true){
            LoadModelsWIFIIDTele();
            return true;
        } else {
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "neco spatne ve sceni souborů================= ";
            return false;
        }
    } else {
        if(CreatefileIDWifiNum() == true){
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "file created";
            return true;
        } else {
            return false;
        }
    }
    return false;
}

/** InitWIFIIDModels().
Used to initialize the models
and Horizontal Header Labels
*/
bool RulesManager::InitWIFIIDModels()
{
    model_of_CellID = new QStandardItemModel(this);
    model_of_WiFi = new QStandardItemModel(this);
    model_of_telephone_num = new QStandardItemModel(this);

    QStringList labels;
    labels << tr("Name") << tr("Id location") << tr("Profile") ;
    model_of_CellID->setHorizontalHeaderLabels(labels);

    labels.clear();
    labels << tr("Name") << tr("Wifi name") << tr("Profile");
    model_of_WiFi->setHorizontalHeaderLabels(labels);

    labels.clear();
    labels << tr("Name") << tr("Telephone") << tr("Profile");
    model_of_telephone_num->setHorizontalHeaderLabels(labels);
    return true;
}

//=============================================================
/** InitFile
Opens home folder and check if there is an dir NProfile and if not that it creates it
and set the file to Dir.filePath(profiles.xml)
*/
bool RulesManager::InitFile()
{
    QDir Dir = QDir::homePath();
    //vytvori slozku pokud neni
    if(!Dir.exists("NProfile")){
        if(!Dir.mkdir("NProfile")){
            qWarning() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "Cannot create folder NProfile in home";
            return false;
        }
    }
    //switches to a folder
    if(!Dir.cd("NProfile")){
        qWarning() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "cannot cd in NProfile";
        return false;
    }
    fileIDWifiNum.setFileName(Dir.filePath("cellidwifinum.xml")); //set
    return true;
}


//=============================================================================================================
/** CreatefileIDWifiNum
Open the file and create XML using CreateXmlTextIDWifi () and write to a file.
Sets the document and check with domDocumentIDWifiTelnum.setContent CheckDomDocIDWifi ()
and closes the file.

    QFile fileIDWifiNum;
    QDomDocument domDocumentIDWifiTelnum;
*/
bool RulesManager::CreatefileIDWifiNum()
{ //otevřu
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "vytvorim wifi soubor ================= ";
    if (!fileIDWifiNum.open(QIODevice::ReadWrite | QIODevice::Text)){
        //////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Cannot open file";
        return false;
    }
    QString errorStr;
    int errorLine;
    int errorColumn;
    QTextStream out(&fileIDWifiNum);
    QString text = CreateXmlTextIDWifi(); //create text xml
    out.setCodec("UTF-8");//set utf 8
    out.setAutoDetectUnicode(true);
    out << text;//write
    out.flush(); //

    if (!domDocumentIDWifiTelnum.setContent(text, false, &errorStr, &errorLine,
                                            &errorColumn)) {
        //////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Cannot set content " << errorStr << "line " << errorLine << "Column " << errorColumn;
        fileIDWifiNum.close();
        return false;
    }
    //check
    if(!CheckDomDocIDWifi()) {
        //////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" <<  "Error in document, this is not calendar file  ";
        fileIDWifiNum.close();
        return false;
    }
    fileIDWifiNum.close();//close
    initIDWIFTeleDoc(); //add elements

    return true;
}


/** CreateXmlTextIDWifi
Creates the xml text
*/
QString RulesManager::CreateXmlTextIDWifi()
{
    QString text("");
    text += "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    text += "<!DOCTYPE NProfIDWifi>\n";
    text +="<NProfIDWifi version=\"1.0\">\n";//začátek
    text += "</NProfIDWifi>\n";//konec souboru
    return text;
}

/** initIDWIFTeleDoc
Add chield element to doc
*/
void RulesManager::initIDWIFTeleDoc()
{
    QDomElement root = domDocumentIDWifiTelnum.documentElement();
    QDomElement Wifi = domDocumentIDWifiTelnum.createElement("WIFI");
    root.appendChild(Wifi);
    QDomElement LocID = domDocumentIDWifiTelnum.createElement("LOCID");
    root.appendChild(LocID);
    QDomElement Tele = domDocumentIDWifiTelnum.createElement("TELENUM");
    root.appendChild(Tele);
}
//=============================================================================================================
//=============================================================================================================
/** ReadfileIDWifiNum
Opens a file and reads the XML document using domDocumentIDWifiTelnum.setContent and check it with CheckDomDocIDWifi ()
*/
bool RulesManager::ReadfileIDWifiNum()
{
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "nacitam wifi soubor ================= ";
    if (!fileIDWifiNum.open(QIODevice::ReadWrite | QIODevice::Text)){
        ////qDebug() <<  __FILE__  << __LINE__  << __FUNCTION__ << "Cannot open file";
        return false;
    }
    QString errorStr;
    int errorLine;
    int errorColumn;
    if (!domDocumentIDWifiTelnum.setContent((QIODevice * )&fileIDWifiNum, false, &errorStr, &errorLine,
                                            &errorColumn)) {
        ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Cannot set content " << errorStr << "line " << errorLine << "Column " << errorColumn;
        fileIDWifiNum.close();
        return false;
    }
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "tisk toho dokumentu" << domDocumentIDWifiTelnum.toString();
    //control
    if(!CheckDomDocIDWifi()) {
        ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Error in document, this is not calendar file ";
        fileIDWifiNum.close();
        return false;
    }
    //  print();
    fileIDWifiNum.close();
    return true;
}


/** CheckDomDocIDWifi
Checks if the document is in order
*/
bool RulesManager::CheckDomDocIDWifi()
{
    QDomElement root = domDocumentIDWifiTelnum.documentElement();
    if (root.tagName() != "NProfIDWifi") {
        //////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Error in root";
        return false;
    } else if (root.hasAttribute("version")
        && root.attribute("version") != "1.0") {
        //////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Error in version";
        return false;
    }
    return true;
}


//===============================================================================================

/** LoadModelsWIFIIDTele().
Load rules for network and numbers from xml document into tables
*/
void  RulesManager::LoadModelsWIFIIDTele()
{
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "bude nacitat";
    QList<QStandardItem *>  items;
    //labels << tr("Name") << tr("Wifi name") << tr("Profile");
    QDomElement root = domDocumentIDWifiTelnum.documentElement();
    QDomElement eleLocId = root.firstChildElement("LOCID");
    QDomElement eleWifi = root.firstChildElement("WIFI");
    QDomElement eleTelenum = root.firstChildElement("TELENUM");

    QDomElement first = eleLocId.firstChildElement(); //ziskám první prvek
    QDomElement second;
    while(!first.isNull()) //pro vsechny pravidla
    {
         second = first.firstChildElement();
        while(!second.isNull()) //pravidla maj 3 elementy
        {
            items.append(new QStandardItem(second.text())); //text je hodnota
            second = second.nextSiblingElement();
        }
        model_of_CellID->appendRow(items);
        items.clear();
        ////qDebug() << "Element name and text: " << first.tagName() << first.text() << "a atribut je ???????" << first.attribute(QString("id"));
        first = first.nextSiblingElement();
    }

    first = eleWifi.firstChildElement(); //ziskám první prvek

    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "nastavuje modely";
    while(!first.isNull())
    {
         second = first.firstChildElement();
        ////qDebug() << "Element name and text: " << first.tagName() << first.text() << "a atribut je ???????" << first.attribute(QString("id"));
        while(!second.isNull()) //pravidla maj 3 elementy
        {
            items.append(new QStandardItem(second.text())); //text je hodnota
            second = second.nextSiblingElement();
        }
        model_of_WiFi->appendRow(items);
        items.clear();
        first = first.nextSiblingElement();
    }

    first = eleTelenum.firstChildElement(); //ziskám první prvek

    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "nastavuje modely";
    while(!first.isNull())
    {
            second = first.firstChildElement();
        ////qDebug() << "Element name and text: " << first.tagName() << first.text() << "a atribut je ???????" << first.attribute(QString("id"));
        while(!second.isNull()) //pravidla maj 3 elementy
        {
           qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "nastavuje modely a seckond je " << second.text();
            items.append(new QStandardItem(second.text())); //text je hodnota
            second = second.nextSiblingElement();
        }
        model_of_telephone_num->appendRow(items);
        items.clear();
        first = first.nextSiblingElement();
    }
}
//===========================================
/** SaveProfilesToXml
Saves the document to a file
*/
void RulesManager::SaveProfilesToXml()
{
    //update before saving
    UpdateWifiXml();
    UpdateIDLocXml();
    UpdateTelNumXml();

    if (!fileIDWifiNum.open(QIODevice::WriteOnly | QIODevice::Text)){
        //////qDebug() <<  __FILE__  << __LINE__  << __FUNCTION__ << "Cannot open file";
    }

    QTextStream outt(&fileIDWifiNum);
    outt.setCodec("UTF-8");//set utf 8
    outt.setAutoDetectUnicode(true);
    outt << domDocumentIDWifiTelnum.toString();//write
    outt.flush(); //
    fileIDWifiNum.close();
}

/** UpdateIDLocXml
    Update id loc part of xml document
*/
void RulesManager::UpdateIDLocXml()
{
    QDomElement root = domDocumentIDWifiTelnum.documentElement();//zikam root elemnet
    QDomElement profil_old = root.firstChildElement("LOCID");//najdu starej pro id mista
    QDomElement profil_new = this->CreateNewIDEle("LOCID", model_of_CellID);//vytvorim novy z modelu
    root.replaceChild(profil_new, profil_old); //vymenim
    // emit  s_profile_update(Data->GetName());
}

/** UpdateWifiXml
  Update wifi part of xml document
*/
void RulesManager::UpdateWifiXml()
{
    QDomElement root = domDocumentIDWifiTelnum.documentElement();//zikam root elemnet
    QDomElement profil_old = root.firstChildElement("WIFI");//najdu starej pro id mista
    QDomElement profil_new = this->CreateNewIDEle("WIFI", model_of_WiFi);//vytvorim novy z modelu
    root.replaceChild(profil_new, profil_old); //vymenim
    // emit  s_profile_update(Data->GetName());
}

/** UpdateTelNumXml
  Update tel part of xml document
*/
void RulesManager::UpdateTelNumXml()
{
    QDomElement root = domDocumentIDWifiTelnum.documentElement();//zikam root elemnet
    QDomElement profil_old = root.firstChildElement("TELENUM");//najdu starej pro id mista
    QDomElement profil_new = this->CreateNewIDEle("TELENUM", model_of_telephone_num);//vytvorim novy z modelu
    root.replaceChild(profil_new, profil_old); //vymenim
    // emit  s_profile_update(Data->GetName());
}

/** CreateNewIDEle
Save all records from table to xml and return element
 \param model Pointer to model
 \param name Name

*/
QDomElement RulesManager::CreateNewIDEle(QString name, QStandardItemModel * model)
{
    QDomElement rules = domDocumentIDWifiTelnum.createElement(name); //create element
    QDomElement rule;
    QString str;
    for(int i = 0; i < model->rowCount(); i++)
    {
        rule = domDocumentIDWifiTelnum.createElement(QString("rule") + str.setNum(i));
        CreateNodeID(&rule, QString("name"), model->item(i,0)->data(Qt::DisplayRole).toString());
        CreateNodeID(&rule, QString("id"), model->item(i,1)->data(Qt::DisplayRole).toString());
        CreateNodeID(&rule, QString("profile"), model->item(i,2)->data(Qt::DisplayRole).toString());
        rules.appendChild(rule);
    }
    //labels << tr("Name") << tr("Wifi name") << tr("Profile");
    return rules;
}

/** createNode
Creates an item in the XML file and adds it to the record
 \param id Pointer to the element in xml
 \param name Name
 \param text wifi name or id location
  \param attribute atribute for name of profile
*/
void RulesManager::CreateNodeID(QDomElement * rule, QString name, QString text)
{
    QDomElement ruleE = domDocumentIDWifiTelnum.createElement(name);
    QDomText newTitleText = domDocumentIDWifiTelnum.createTextNode(text);
    ruleE.appendChild(newTitleText);
    rule->appendChild(ruleE);
}

//==================================================================================================
/** deleteProfilesNamesFromModels
Delete profile name in models
     \param profile_name Profile name
*/
void RulesManager::deleteProfilesNamesFromModels(QString profile_name)
{
    QList<QStandardItem *> listitems;
    listitems = model_of_CellID->findItems(profile_name, Qt::MatchExactly, 2);
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "budou se mazat jmena profilu";

    foreach(QStandardItem * item, listitems )
    {
        ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "nasel v tabulce pro cell toto" << item->data(Qt::DisplayRole).toString();
        item->setData(QVariant(""),Qt::DisplayRole);
    }
    listitems.clear();

    listitems = model_of_WiFi->findItems(profile_name, Qt::MatchExactly, 2);
    foreach(QStandardItem * item, listitems )
    {
        ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "nasel v tabulce pro cell toto" << item->data(Qt::DisplayRole).toString();
        item->setData(QVariant(""),Qt::DisplayRole);
    }
    listitems.clear();

    listitems = model_of_telephone_num->findItems(profile_name, Qt::MatchExactly, 2);
    foreach(QStandardItem * item, listitems )
    {
        ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "nasel v tabulce pro cell toto" << item->data(Qt::DisplayRole).toString();
        item->setData(QVariant(""),Qt::DisplayRole);
    }
}

/** GetCellIDModel
    Return pointer to model
*/
QStandardItemModel * RulesManager::GetCellIDModel()
{
    return model_of_CellID;
}

/** GetWiFiModel
        Return pointer to model
*/
QStandardItemModel * RulesManager::GetWiFiModel()
{
    return model_of_WiFi;
}

/** GetWiFiModel
        Return pointer to model
*/
QStandardItemModel * RulesManager::GetTelNumModel()
{
    return model_of_telephone_num;
}

