#ifndef PROFILESMANAGER_H
#define PROFILESMANAGER_H

#include <QObject>
#include <QtCore/QFile>
#include <QtXml/QDomDocument>
#include <QtCore/QStringList>
#include <QtCore/QDir>
class ProfileDeamon;
class Profil;
class QStandardItemModel;
class QFileInfo;
class ProfilesManager : public QObject
{
    Q_OBJECT
public:
    explicit ProfilesManager(QObject *parent = 0);

    bool Init();

    QStringList GetProfilesNames();
    bool GetProfile(Profil * profil);
    QStandardItemModel * GetModel();
    bool  CreateProfile(Profil *Data);
    void UpdateProfile(Profil * Data );
    void SetProfile(QString str_profile);
    void DeleteProfile(QString profile_name);
    void TestPrint();
    QDomElement GetRootElement() const;
    void SaveProfilesToXml();

signals:
    void s_profiles_name_change(QStringList Profiles_names);
    void s_profile_update(QString Profil_name);
    void s_profile_delete(QString profile_name);
    void s_delete_Profiles_Name_From_Models(QString profile_name);

public slots:

private:
    ProfileDeamon * profile_deamon;
    QStandardItemModel *model_of_files;
    QFile file;

    QDomDocument domDocument;
    bool InitFile();
    bool CreateFile();
    bool ReadFile();
    bool CheckDomDoc();
    QString CreateXmlText();
    QDomElement CreateNewProfile( Profil *Data);
    void CreateNode(QDomElement * profil, QString name, QString attribute, QString text);


};

#endif // PROFILESMANAGER_H
