#ifndef PROFILEDB_H
#define PROFILEDB_H
/*! \file profiledb.h
    \brief File .H for class profiledb

    Header file
*/
#include <QtCore/QObject>
#include <QtCore/QDir>
/*!
  \class ProfileDB
  \brief Class stores and retrieves the profiles from XML
  \author Jakub Šplíchal <jakub.bzouk@gmail.com>
*/
#include "profilesmanager.h"
#include "soundfilesmanager.h"
#include "rulesmanager.h"

class ProfileDB : public QObject
{
    Q_OBJECT
public:
    ProfileDB(QObject *parent = 0);
    ~ProfileDB();

    bool Init();

    ProfilesManager *GetProfileManager() const;

    SoundFilesManager *GetSoundFilesManager() const;

    RulesManager *GetRulesManager() const;

private:
    ProfilesManager *profile_manager;
    SoundFilesManager  *sound_files_manager;
    RulesManager  *rules_manager;

public slots:
    void SaveProfilesToXml();
};

#endif // PROFILEDB_H
