#include "profiledb.h"
#include <QtCore/QDebug> //Debug pro informace
#include <QtXml/QDomElement>
#include <QtCore/QStringList>
#include <QtCore/QTextStream>
#include <QtCore/QString>
#include "profil.h"
#include <QtGui/QStandardItemModel>

/** Constructor
Sets the pointer to the object to connect to deamon to NULL
*/
ProfileDB::ProfileDB(QObject *parent) :
        QObject(parent),
        profile_manager(new ProfilesManager(this)),
        sound_files_manager(new SoundFilesManager(this)),
        rules_manager(new RulesManager(this))
{

}

/** Destructor
Deletes the object to connect to deamon
*/
ProfileDB::~ProfileDB()
{

}

/** Init
  Creates an object ProfileDeamon and connects via ProfileDeamon: ConnectToDeamon
  Create a model that will list all audio files
  Then initializes the XML file using InitFile()
  If the file exists so it attempts to read with readfile()
   and if not it creates and initializes using CreateFile()
*/
bool ProfileDB::Init()
{
    if(profile_manager->Init() == false){
        return false;
    }
    if(sound_files_manager->Init(profile_manager->GetRootElement()) == false)
    {
        return false;
    }
    if(rules_manager->Init() == false)
    {
        return false;
    }
return true;
}



//=============================================================
ProfilesManager *ProfileDB::GetProfileManager() const
{
    return profile_manager;
}

SoundFilesManager *ProfileDB::GetSoundFilesManager() const
{
    return sound_files_manager;
}

RulesManager *ProfileDB::GetRulesManager() const
{
    return rules_manager;
}

void ProfileDB::SaveProfilesToXml()
{
    profile_manager->SaveProfilesToXml();
    rules_manager->SaveProfilesToXml();

}

//================================================================
//=============================================================================================================
//=============================================================================================================

