#include "profildialog.h"
#include "ui_profildialog.h"

#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include <QMaemo5InformationBox>
#include "profil.h"
#include <QtCore/QDebug> //Debug pro informace
#include <QtGui/QStandardItemModel>
#include <QtCore/QStringList>
#include <QtCore/QFileInfo>
#include <QtGui/QFileDialog>
#include <QtGui/QListView>
#include <QtCore/QModelIndex>
#include <QtCore/QVariant>
#include <QtCore/Qt>
#include <QtCore/QString>

/** Constructor.
Setup ui and create new objects for item model and maemo5
value button and setup slider, check boxes atc. if dialog is use
for update profile
*/
ProfilDialog::ProfilDialog(QStringList  list_of_profiles_n, QWidget *parent, Profil * profil, QStandardItemModel *  model) :
        QDialog(parent),
        ui(new Ui::ProfilDialog)
{
    ui->setupUi(this);

    list_of_profiles_names = list_of_profiles_n; // save pointer
    model_of_files = model;
    profile = profil;
    //edit profile or new profile
    if(profil->GetName().isEmpty()) {
        update = false;
        setWindowTitle(tr("New profile"));
        ui->slider_ringing_volume->setValue(0);
        ui->slider_sms_volume->setValue(0);
        ui->slider_im_volume->setValue(0);
        ui->slider_email_volume->setValue(0);
    } else {
        update = true;
        setWindowTitle(tr("Edit profile"));
        ui->lineEdit_nameprofile->setText(profile->GetName());
        ui->lineEdit_nameprofile->setDisabled(true);
        ui->slider_ringing_volume->setValue(profile->GetRingingAlertVolume().toInt());
        ui->slider_sms_volume->setValue(profile->GetSmsAlertVolume().toInt());
        ui->slider_im_volume->setValue(profile->GetImAlertVolume().toInt());
        ui->slider_email_volume->setValue(profile->GetEmailAlertVolume().toInt());
    }
    createMeamoButtons();
    createRadioID();
}

/** destructor
Delete ui
*/
ProfilDialog::~ProfilDialog()
{
    delete ui;
}

/** createMeamoButtons()
Method will create Meamo5 buttons and sets
pick selector for them
*/
void ProfilDialog::createMeamoButtons()
{
    selModelMobil = new QItemSelectionModel(model_of_files); //create new selection model
    QListView * list_view = createListView(selModelMobil); //method will create QListview
    QMaemo5ListPickSelector *listpicker1 = createMeamoListPick(list_view); //method will create QMaemo5ListPickSelector
    if(update) //if update then select ringtone
    {
        setSelectedItem(listpicker1,selModelMobil,profile->GetRingingAlertTone().toString());
    }
    v1 = new QMaemo5ValueButton(tr("Ringing tone"), this); //create button
    //  v1->setIcon(QIcon::fromTheme("chat_smiley_happy"));
    v1->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    v1->setPickSelector(listpicker1);//set list pick
    ui->gridLayout->addWidget(v1,13,0,1,-1); // add to layout
    //===========================================================================================================================
    selModelSMS = new QItemSelectionModel(model_of_files);
    list_view = createListView(selModelSMS);
    QMaemo5ListPickSelector *listpicker2 = createMeamoListPick(list_view);
    if(update)
    {
        setSelectedItem(listpicker2,selModelSMS,profile->GetSmsAlertTone().toString());
    }
    v2 = new QMaemo5ValueButton(tr("SMS tone"), this);
    // v2->setIcon(QIcon::fromTheme("chat_smiley_happy"));
    v2->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    v2->setPickSelector(listpicker2);
    ui->gridLayout->addWidget(v2,14,0,1,-1);
    //===========================================================================================================================
    selModelIM = new QItemSelectionModel(model_of_files);
    list_view = createListView(selModelIM);
    QMaemo5ListPickSelector *listpicker3 = createMeamoListPick(list_view);
    if(update)
    {
        setSelectedItem(listpicker3,selModelIM,profile->GetImAlertTone().toString());
    }
    v3 = new QMaemo5ValueButton(tr("IM tone"), this);
    // v3->setIcon(QIcon::fromTheme("chat_smiley_happy"));
    v3->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    v3->setPickSelector(listpicker3);
    ui->gridLayout->addWidget(v3,15,0,1,-1);
    //===========================================================================
    selModelEmail = new QItemSelectionModel(model_of_files);
    list_view = createListView(selModelEmail);
    QMaemo5ListPickSelector *listpicker4 = createMeamoListPick(list_view);
    if(update)
    {
        setSelectedItem(listpicker4,selModelEmail,profile->GetEmailAlertTone().toString());
    }
    v4 = new QMaemo5ValueButton(tr("E-mail tone"), this);
    // v4->setIcon(QIcon::fromTheme("chat_smiley_happy"));
    v4->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    v4->setPickSelector(listpicker4);
    ui->gridLayout->addWidget(v4,16,0,1,-1);
}

/** createListView
Method will create QListView and set edit triggers to NoEditTriggers,
selection model, selection behavior to select rows and selection mode to single selection
*/
QListView * ProfilDialog::createListView(QItemSelectionModel * select_model)
{
    QListView * list_view = new QListView(this); //QListView::selectedItem() will return the selected QListViewItem*.
    list_view->setEditTriggers(QAbstractItemView::NoEditTriggers);
    /*
     MOdel má
     QList<QStandardItem *> QStandardItemModel::findItems ( const QString & text, Qt::MatchFlags flags = Qt::MatchExactly, int column = 0 ) const

     item má
     QModelIndex QStandardItem::index () const

      Model selected má
      void QItemSelectionModel::select ( const QModelIndex & index, QItemSelectionModel::SelectionFlags command )   [virtual slot]

      */
    list_view->setModel(model_of_files);
    list_view->setSelectionModel(select_model);
    list_view->setSelectionBehavior(QAbstractItemView::SelectRows);
    list_view->setSelectionMode(QAbstractItemView::SingleSelection);
    return list_view;
}

/** createMeamoListPick
Method will create QMaemo5ListPickSelector and set list pick model, model column and view
*/
QMaemo5ListPickSelector * ProfilDialog::createMeamoListPick(QListView * list_view)
{
    QMaemo5ListPickSelector *listpicker = new QMaemo5ListPickSelector(this);
    listpicker->setModel(model_of_files);
    listpicker->setModelColumn(0);
    listpicker->setView(list_view);
    return listpicker;
}

/** setSelectedItem
Method will select right row for selction model and list picker
*/
void ProfilDialog::setSelectedItem(QMaemo5ListPickSelector * listpicker, QItemSelectionModel * selModel, QString find )
{
    QList<QStandardItem *> seznam_nalezenych;
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << " co ma najit " << find;
    seznam_nalezenych = model_of_files->findItems(find, Qt::MatchExactly, 1);//find itemm
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << " Co nasel" << seznam_nalezenych;
    if(!seznam_nalezenych.empty()){
        selModel->select(seznam_nalezenych.at(0)->index(),QItemSelectionModel::Select | QItemSelectionModel::Rows);
        listpicker->setCurrentIndex(seznam_nalezenych.at(0)->row());
    }
}

/** accept()
Slot for signal when user click on save button.
Check is everyting is OK and save values into profile object
*/
void ProfilDialog::accept()
{
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << " tisk všech dat";

    if(ui->lineEdit_nameprofile->text().isEmpty()){
        QMaemo5InformationBox::information(this, tr("Profile must have name"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    if(update == false){
        if(list_of_profiles_names.contains(ui->lineEdit_nameprofile->text()))
        {
            QMaemo5InformationBox::information(this, tr("This profile elready exist"), QMaemo5InformationBox::DefaultTimeout);
            return;
        }
    }

    if(ui->lineEdit_nameprofile->text().split(QRegExp("\\s+"),QString::SkipEmptyParts).size() > 1)
    {
        QMaemo5InformationBox::information(this, tr("One word name please"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    if(ui->lineEdit_nameprofile->text().contains(QRegExp("^\\d\\D*")))
    {
        QMaemo5InformationBox::information(this, tr("You can't start name with digit"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    QModelIndexList list_of_Mobil_tone = selModelMobil->selectedIndexes();
    if(list_of_Mobil_tone.empty())
    {
        QMaemo5InformationBox::information(this, tr("Select ringtone for mobile"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    QModelIndexList list_of_SMS_tone = selModelSMS->selectedIndexes();
    if(list_of_SMS_tone.empty())
    {
        QMaemo5InformationBox::information(this, tr("Select ringtone for SMS"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    QModelIndexList list_of_IM_tone = selModelIM->selectedIndexes();
    if(list_of_IM_tone.empty())
    {
        QMaemo5InformationBox::information(this, tr("Select ringtone for IM"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    QModelIndexList list_of_Email_tone = selModelEmail->selectedIndexes();
    if(list_of_Email_tone.empty())
    {
        QMaemo5InformationBox::information(this, tr("Select ringtone for E-mail"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    // QModelIndexList list =  selModelMobil->selectedIndexes();
    //
    // for(int i = 0; i < list.size(); i++) {
    // //qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << list.at(i).data().toString();
    ////}

    //    //qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << " tisk dat z dialogu";
    //    //qDebug() << "text je " << ui->lineEdit_nameprofile->text();
    //    //qDebug() << "email volume je " << ui->slider_email_volume->value();
    //    //qDebug() << "im volume je " << ui->slider_im_volume->value();
    //    //qDebug() << "ring volume je " << ui->slider_ringing_volume->value();
    //    //qDebug() << "sms volume je " << ui->slider_sms_volume->value();
    //    //qDebug() << "key board je " << ui->buttonGroup_keyboard->checkedId();
    //    //qDebug() << "screen je " << ui->buttonGroup_screen->checkedId();
    //    //qDebug() << "system je " << ui->buttonGroup_system->checkedId();
    //    //qDebug() << list_of_Mobil_tone.at(1).data().toString() ;
    //    //qDebug() << "zvuk SMS " << list_of_SMS_tone.at(1).data().toString() ;
    //    //qDebug() << "zvuk Im " << list_of_IM_tone.at(1).data().toString() ;
    //    //qDebug() << "zvuk email " << list_of_Email_tone.at(1).data().toString() ;
    //    //qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "konec tisku dat z dialogu";
    //m_settings->setValue("Settings/rememberGeometry", geometryCb->isChecked());

    profile->SetName(ui->lineEdit_nameprofile->text());

    profile->SetRingingAlertVolume(QVariant(ui->slider_ringing_volume->value()));
    profile->SetSmsAlertVolume(QVariant(ui->slider_sms_volume->value()));
    profile->SetImAlertVolume(QVariant(ui->slider_im_volume->value()));
    profile->SetEmailAlertVolume(QVariant(ui->slider_email_volume->value()));

    profile->SetKeypadSoundLevel(QVariant(ui->buttonGroup_keyboard->checkedId()));
    profile->SetTouchscreenSoundLevel(QVariant(ui->buttonGroup_screen->checkedId()));
    profile->SetSystemSoundLevel(QVariant(ui->buttonGroup_system->checkedId()));

    profile->SetRingingAlertTone(list_of_Mobil_tone.at(1).data());
    profile->SetSmsAlertTone(list_of_SMS_tone.at(1).data());
    profile->SetImAlertTone(list_of_IM_tone.at(1).data());
    profile->SetEmailAlertTone(list_of_Email_tone.at(1).data());

    profile->SetVibratingAlertEnabled(QVariant((int)ui->check_vibration->isChecked()));
    profile->SetRingingAlertType(QVariant(QString("ringing")));

    switch (ui->buttonGroup_ringing->checkedId())
    {
    case 0:
        profile->SetRingingAlertType(QVariant(QString("ringing")));
        break;
    case 1:
        profile->SetRingingAlertType(QVariant(QString("silent")));
        break;
    default:
        profile->SetRingingAlertType(QVariant(QString("ringing")));
    }

    profile->SetCalendarAlarmEnabled(QVariant((int)ui->checkCalendarAlarm->isChecked()));
    profile->SetClockAlarmEnabled(QVariant((int)ui->checkClockAlarm->isChecked()));

    done(QDialog::Accepted);
}

/** createRadioID()
Method setup Radio buttons
If updating profile setradio buttons to profile values
*/
void ProfilDialog::createRadioID()
{
    ui->buttonGroup_system->setId(ui->radioB_system1, 0);
    ui->buttonGroup_system->setId(ui->radioB_system2, 1);
    ui->buttonGroup_system->setId(ui->radioB_system3, 2);

    ui->buttonGroup_keyboard->setId(ui->radioB_keyboard_1,0);
    ui->buttonGroup_keyboard->setId(ui->radioB_keyboard_2,1);
    ui->buttonGroup_keyboard->setId(ui->radioB_keyboard_3,2);

    ui->buttonGroup_screen->setId(ui->radioB_screen_1,0);
    ui->buttonGroup_screen->setId(ui->radioB_screen_2,1);
    ui->buttonGroup_screen->setId(ui->radioB_screen_3,2);

    ui->buttonGroup_ringing->setId(ui->radioButton_ringing,0);
    ui->buttonGroup_ringing->setId(ui->radioButton_silent,1);

    if(update)
    {
        if(profile->GetRingingAlertType().toString().contains(QString("ringing")))
        {
            ui->radioButton_ringing->setChecked(true);
        } else {
            ui->radioButton_silent->setChecked(true);
        }
        ui->check_vibration->setChecked(profile->GetVibratingAlertEnabled().toBool());
        ui->checkCalendarAlarm->setChecked(profile->GetCalendarAlarmEnabled().toBool());
        ui->checkClockAlarm->setChecked(profile->GetClockAlarmEnabled().toBool());
    } else {
        ui->radioButton_ringing->setChecked(true);
    }

    switch (profile->GetSystemSoundLevel().toInt())
    {
    case 0:
        ui->radioB_system1->setChecked(true);
        break;
    case 1:
        ui->radioB_system2->setChecked(true);
        break;
    case 2:
        ui->radioB_system3->setChecked(true);
        break;
    default:
        ui->radioB_system1->setChecked(true);
    }

    switch (profile->GetKeypadSoundLevel().toInt())
    {
    case 0:
        ui->radioB_keyboard_1->setChecked(true);
        break;
    case 1:
        ui->radioB_keyboard_2->setChecked(true);
        break;
    case 2:
        ui->radioB_keyboard_3->setChecked(true);
        break;
    default:
        ui->radioB_keyboard_1->setChecked(true);
    }

    switch (profile->GetKeypadSoundLevel().toInt())
    {
    case 0:
        ui->radioB_screen_1->setChecked(true);
        break;
    case 1:
        ui->radioB_screen_2->setChecked(true);
        break;
    case 2:
        ui->radioB_screen_3->setChecked(true);
        break;
    default:
        ui->radioB_screen_1->setChecked(true);
    }
}

/** on_ButtonLoadSound_clicked()
Slot for loading music files
*/
void ProfilDialog::on_ButtonLoadSound_clicked()
{
    QString fileName = QFileDialog::getOpenFileName(this, tr("Choose sound file"),"/home/user",tr("Sound files (*.wav *.mp3 *.AAC *.eAAC* *.acc *.wma *.m4a)"));

    if (fileName.isEmpty())
        return;

    QFileInfo file(fileName);

    QList<QStandardItem *>  items;

    if(model_of_files != NULL)
        if(checkFileInModelAndExist(file)){
        //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << " bude se pridavat do modelu toto" << file.absoluteFilePath();
        items.append(new QStandardItem(file.fileName()));
        items.append(new QStandardItem(file.absoluteFilePath()));
        model_of_files->appendRow(items);
    }
}

/** checkFileInModelAndExist()
Check if this audio file is already added
*/
bool ProfilDialog::checkFileInModelAndExist(QFileInfo inf)
{
    if(!inf.exists()) return false;
    if(!model_of_files->findItems(inf.absoluteFilePath(),Qt::MatchExactly, 1).empty()) return false;
    return true;
}

/** on_slider_ringing_volume_valueChanged
Slot for changing volume in text label
*/
void ProfilDialog::on_slider_ringing_volume_valueChanged(int value)
{
    QString str;
    str = "%1 %2";
    ui->label_ringing_volume->setText(str.arg(tr("Ringing:"),QString().setNum(value)));
}

/** on_slider_sms_volume_valueChanged
Slot for changing volume in text label
*/
void ProfilDialog::on_slider_sms_volume_valueChanged(int value)
{
    QString str;
    str = "%1 %2";
    ui->label_sms_volume->setText(str.arg(QString("SMS:"),QString().setNum(value)));
}

/** on_slider_im_volume_valueChanged
Slot for changing volume in text label
*/
void ProfilDialog::on_slider_im_volume_valueChanged(int value)
{
    QString str;
    str = "%1 %2";
    ui->label_im_volume->setText( str.arg(QString("IM:"),QString().setNum(value)));
}

/** on_slider_email_volume_valueChanged
Slot for changing volume in text label
*/
void ProfilDialog::on_slider_email_volume_valueChanged(int value)
{
    QString str;
    str = "%1 %2";
    ui->label_email_volume->setText( str.arg(QString("E-mail:"),QString().setNum(value)));
}

/** changeEvent(QEvent *e)

*/
void ProfilDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

