#ifndef PROFIL_H
#define PROFIL_H
/*! \file profildow.h
    \brief File .H for Class Profile
\author Jakub Šplíchal <jakub.bzouk@gmail.com>
    Header file
*/
#include <QtCore/QList>
#include <QtCore/QString>
#include <QtCore/QVariant>


struct ProfileValue
{
    QString key;
    QVariant value;
    QString type;
};

/*!
  \class Profil
  \brief Class is used only for data storage as they are in the profiles and their transfer between objects.
*/
class Profil
{
public:
    //! Profil(QString name).
    /*!
      The constructor receives the name of the profile
      \param name Profile Name
    */
    Profil(QString name);
    ~Profil();
    QList<ProfileValue*>* ListOfValues(); /**< returns a list of links to data in the profile */
    bool SetValue(QString key, QString value);
    QString GetName();

    QVariant  GetCalendarAlarmEnabled();
    QVariant  GetClockAlarmEnabled();
    QVariant  GetEmailAlertTone();
    QVariant  GetEmailAlertVolume();
    QVariant  GetImAlertTone();
    QVariant  GetImAlertVolume();
    QVariant  GetKeypadSoundLevel();
    QVariant  GetRingingAlertTone();
    QVariant  GetRingingAlertType();
    QVariant  GetRingingAlertVolume();
    QVariant  GetSmsAlertTone();
    QVariant  GetSmsAlertVolume();
    QVariant  GetSystemSoundLevel();
    QVariant  GetTouchscreenSoundLevel();
    QVariant  GetVibratingAlertEnabled();

    void  SetName(QString);
    void  SetCalendarAlarmEnabled(QVariant);
    void  SetClockAlarmEnabled(QVariant);
    void  SetEmailAlertTone(QVariant);
    void  SetEmailAlertVolume(QVariant);
    void  SetImAlertTone(QVariant);
    void  SetImAlertVolume(QVariant);
    void  SetKeypadSoundLevel(QVariant);
    void  SetRingingAlertTone(QVariant);
    void  SetRingingAlertType(QVariant);
    void  SetRingingAlertVolume(QVariant);
    void  SetSmsAlertTone(QVariant);
    void  SetSmsAlertVolume(QVariant);
    void  SetSystemSoundLevel(QVariant);
    void  SetTouchscreenSoundLevel(QVariant);
    void  SetVibratingAlertEnabled(QVariant);

private:
    QString m_name_of_profile;
    struct  ProfileValue calendar_alarm_enabled;
    struct  ProfileValue clock_alarm_enabled;
    struct  ProfileValue email_alert_tone;
    struct  ProfileValue email_alert_volume;
    struct  ProfileValue im_alert_tone;
    struct  ProfileValue im_alert_volume;
    struct  ProfileValue keypad_sound_level;
    struct  ProfileValue ringing_alert_tone;
    struct  ProfileValue ringing_alert_type;
    struct  ProfileValue ringing_alert_volume;
    struct  ProfileValue sms_alert_tone;
    struct  ProfileValue sms_alert_volume;
    struct  ProfileValue system_sound_level;
    struct  ProfileValue touchscreen_sound_level;
    struct  ProfileValue vibrating_alert_enabled;

    QList<ProfileValue *> list_of_profile_values;
};

#endif // PROFIL_H
