#include "networkdialogedit.h"
#include "ui_networkdialogedit.h"
#include <QtCore/QStringList>
#include <QtCore/QDebug> //Debug pro informace
#include <QtGui/QItemSelectionModel>
#include <QtGui/QStandardItemModel>
#include <QMaemo5InformationBox>
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include <QMaemo5InformationBox>
#include <QtGui/QMessageBox>

/** Constructor.
  set title for dialog
*/
NetWorkDialogEdit::NetWorkDialogEdit(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::NetWorkDialogEdit)
{
    ui->setupUi(this);
    setWindowTitle(tr("Set profile forNetwork"));
    selectedProfile = QString("");
}

/** Destructor.
*/
NetWorkDialogEdit::~NetWorkDialogEdit()
{
    delete ui;
}

void NetWorkDialogEdit::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

/** SetProfilenames.
  Store profile names and create maemo button for show this names
  \param list_of_profiles_nf list of profile names
*/
void  NetWorkDialogEdit::SetProfilenames(QStringList list_of_profiles_nf)
{
    list_of_profiles = list_of_profiles_nf;

    p_model_profile_names = new QStandardItemModel(this);//model for maemo 5 button

    foreach(QString profile, list_of_profiles )
    {
        p_model_profile_names->appendRow(new QStandardItem(profile));
    }

    p_set_Profile_button = new QMaemo5ValueButton(tr("Choose profile for Network:"), this);
    p_set_Profile_button->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    p_list_pick_profile = new QMaemo5ListPickSelector();
    p_list_pick_profile->setModel(p_model_profile_names);
    p_set_Profile_button->setPickSelector(p_list_pick_profile);
    ui->verticalLayout->addWidget(p_set_Profile_button);
    connect(p_list_pick_profile,SIGNAL(selected(QString)),this,SLOT(SelectedName(QString)));
}

/** SelectedName.
  Slot for change in list pick
  \param name name of profile
*/
void NetWorkDialogEdit::SelectedName(QString name)
{
    selectedProfile = name;
}

/** SetNameOfLabel.
Set text for label
  \param id name of network
  \param name text for label
*/
void  NetWorkDialogEdit::SetNameOfLabel(QString id, QString name )
{
    ui->label->setText(name + id);
}

/** GetNameProfile.
Return name of selected profile

*/
QString NetWorkDialogEdit::GetNameProfile()
{
    return selectedProfile;
}

/** GetNameOfRule.
Return nameo of rule
*/
QString NetWorkDialogEdit::GetNameOfRule()
{
    return ui->lineEditNameOfrule->text();
}

/** SetNameOfLabel.
set namo of rule
  \param name text for label
*/
void NetWorkDialogEdit::SetNameOfRule(QString name)
{
    ui->lineEditNameOfrule->setText(name);
}

/** accept()
Slot for signal when user click on save button.
Check is everyting is OK
*/
void NetWorkDialogEdit::accept()
{
    if(selectedProfile.isEmpty())
    {
        QMaemo5InformationBox::information(this, tr("Select profile for network"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    if(ui->lineEditNameOfrule->text().isEmpty())
    {
        QMaemo5InformationBox::information(this, tr("Please fill name"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    done(QDialog::Accepted);
}
