
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "profildialog.h"
#include "controlclass.h"
#include "profil.h"
#include "profiledb.h"
#include <QtCore/QDebug> //Debug pro informace
#include <QtGui/QMessageBox>
#include <QtGui/QListWidgetItem>
#include <QtGui/QCloseEvent>
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include <QMaemo5InformationBox>
#include <QtCore/QStringList>
#include <QtGui/QStandardItemModel>
#include "timedprofildialog.h"
#include <QtDBus/QDBusInterface>
const char name[] = "N9Profile";
/** Constructor.
Setup ui and create new object for item model and maemo5
value button
*/
MainWindow::MainWindow(QWidget *parent, Qt::WindowFlags flags) :
        QMainWindow(parent, flags),
        ui(new Ui::MainWindow),
        p_cnt_class(new ControlClass(this)),
        p_set_Profile_button(NULL),
        p_list_pick_profile(NULL),
        p_model_profile_names(NULL),
        p_Timed_Profile_button(NULL),
        p_Calendar_Profile_button(NULL),
        connectionInterface(new QDBusInterface("org.freedesktop.Notifications",
                                               "/org/freedesktop/Notifications",
                                               "org.freedesktop.Notifications",
                                               QDBusConnection::systemBus(),this))
{
    ui->setupUi(this);
    createMermoButtons();
}


void MainWindow::sendNotif(QString name_of_profile)
{
    if(isHidden()) {
        qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "profil pro zlutou";
        if (!connectionInterface->isValid()) {
            qWarning() << "Cannotct conect to D-BUS";
        } else {
            //send message
            qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "zobrazi ho ?";
            connectionInterface->call(QLatin1String("SystemNoteInfoprint"),QVariant(name_of_profile));
        }
    }
    ui->statusBar->showMessage(name_of_profile);
}

/** createMermoButtons()
Create maemo 5 buttons and model
*/
void MainWindow::createMermoButtons()
{
    p_model_profile_names = new QStandardItemModel(this);//model for maemo 5 button

    p_set_Profile_button = new QMaemo5ValueButton(tr("Default  profile"), this);
    p_set_Profile_button->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    p_list_pick_profile = new QMaemo5ListPickSelector();
    p_list_pick_profile->setModel(p_model_profile_names);
    p_set_Profile_button->setPickSelector(p_list_pick_profile);
    ui->verticalLayout_2->addWidget(p_set_Profile_button);

    //connect signal when user select profil to slot
    connect(p_list_pick_profile,SIGNAL(selected(QString)),this,SLOT(SetDeafaultProfile(QString)));

    p_Timed_Profile_button = new QMaemo5ValueButton(tr("Timed profile"), this);
    p_Timed_Profile_button->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    //when user click on Timed profile button
    connect(p_Timed_Profile_button,SIGNAL(clicked()),this,SLOT(SetTimedProfile()));


    p_Calendar_Profile_button = new QMaemo5ValueButton(tr("Calendar profiles"), this);
    p_Calendar_Profile_button->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    connect(p_Calendar_Profile_button,SIGNAL(clicked()),this, SLOT(SetCalendarProfiles()));
    ui->verticalLayout_2->addWidget(p_Calendar_Profile_button);


    p_IDWifi_Profile_button = new QMaemo5ValueButton(tr("Network profile"), this);
    p_IDWifi_Profile_button->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    connect(p_IDWifi_Profile_button,SIGNAL(clicked()),this, SLOT(SetNetworkProfile()));
    ui->verticalLayout_2->addWidget(p_IDWifi_Profile_button);

    ui->verticalLayout_2->addWidget(p_Timed_Profile_button);
}

/** Destructor.
Delete the UI and the control class
*/
MainWindow::~MainWindow()
{
    delete ui;
    delete p_cnt_class;
}

/** Init.
Used to create and initialize the control class.
*/
void MainWindow::Init()
{

    //connec signal when user sets timed profile or when timed profile ends
    connect(this,SIGNAL(s_hide_show()),p_cnt_class,SLOT(ShowHide()));
    connect(p_cnt_class,SIGNAL(s_timed_profile_name(QString)),this,SLOT(SetTimedProfilename(QString)));
    connect(p_cnt_class,SIGNAL(s_calendar_profile_name(QString)),this,SLOT(SetCalendarProfilename(QString)));
    connect(p_cnt_class,SIGNAL(s_network_profile_name(QString)),this,SLOT(SetMetworkProfilename(QString)));
    connect(p_cnt_class,SIGNAL(s_profile_now(QString)),this,SLOT(sendNotif(QString)));

    connect(this,SIGNAL(s_aboutToEnd()),p_cnt_class->GetProfileDB(),SLOT(SaveProfilesToXml())); //save xml berofe end
    //signal when profiles are changed (add profile, delete profile)
    connect(p_cnt_class->GetProfileDB()->GetProfileManager(),SIGNAL(s_profiles_name_change(QStringList)),this,SLOT(changeInProfiles(QStringList)));
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "init controll class";
    p_cnt_class->Init(&settings);

    // changeInProfiles(p_cnt_class->GetProfileDB()->GetProfilesNames());//get profiles names and sets them
}

/** changeInProfiles();.
Slot for signal when new profile is created or deleted
\param Profiles_Names list of profile names
*/
void MainWindow::changeInProfiles(QStringList Profiles_Names)
{
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "set profile names to listwidgetview ";
    ui->listWidgetProfiles->clear();//clear view
    ui->listWidgetProfiles->addItems(Profiles_Names);//set names

    p_model_profile_names->clear();//clear model for maemo buttons

    for (int i = 0; i < Profiles_Names.size(); ++i){ //add
        p_model_profile_names->appendRow(new QStandardItem(Profiles_Names.at(i)));
        //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "pridavam ted: " << Profiles_Names.at(i);
    }
    setNewIndexDeafaultProfile();
}


/** setNewIndexDeafaultProfile();.
Method for setting index in list pick
*/
void MainWindow::setNewIndexDeafaultProfile()
{
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "select index";
    QList<QStandardItem *> list_of_items;
    //get defult name,MatchExactly and find in model
    list_of_items = p_model_profile_names->findItems(p_cnt_class->GetDefaultProfile(), Qt::MatchExactly, 0);//find in 1.
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "size of list is: " << list_of_items.count();
    if(!list_of_items.empty()){
        //set list pick index
        p_list_pick_profile->setCurrentIndex(list_of_items.at(0)->row());
        //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "item in list pick selected:" ;
    }
}

/** on_listWidgetProfiles_itemClicked
Slot for  signal when user click on item in QListWidget
and show dialog to update profile
\param item item in list widget
*/
void MainWindow::on_listWidgetProfiles_itemClicked(QListWidgetItem* item)
{
    Profil * profil;
    ProfileDB* db =  p_cnt_class->GetProfileDB();// get profile DB;
    QMessageBox msgBox;
    msgBox.setIcon(QMessageBox::Information);
    msgBox.setText(tr("Delete or modify profile?"));
    msgBox.setEscapeButton(QMessageBox::Cancel);
    QPushButton *CancelButton =  msgBox.addButton(QMessageBox::Cancel);
    QPushButton *DeleteButton = msgBox.addButton(tr("Delete"), QMessageBox::ActionRole);
    QPushButton *modifyButton = msgBox.addButton(tr("Modify"),QMessageBox::DestructiveRole);


    msgBox.exec();
    if (msgBox.clickedButton() == DeleteButton) {
        if(item->text() == p_list_pick_profile->currentValueText()){
            QMaemo5InformationBox::information(this, tr("You cannot delete deafult profile"), QMaemo5InformationBox::DefaultTimeout);
        }else {
            //qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "bude se namaaz";
            db->GetProfileManager()->DeleteProfile(item->text());
        }
    } else if (msgBox.clickedButton() == modifyButton) {
        profil = new Profil(item->text()); //create profil and sets name

        if(!db->GetProfileManager()->GetProfile(profil))//
        {
            return;
        }

        ProfilDialog dialog(db->GetProfileManager()->GetProfilesNames(),this, profil,db->GetSoundFilesManager()->GetModel()); //

        int result = dialog.exec();

        if(result)
        {
            //qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "OK update profile";

            db->GetProfileManager()->UpdateProfile(profil);
        }
        delete profil;
    }else if (msgBox.clickedButton() == CancelButton) {
        return;
    }
}

/** on_ButtonNewProfile_clicked();.
Serves as a slot for the button to create a new profile.
Creates a new profile and forward links.
*/
void MainWindow::on_ButtonNewProfile_clicked()
{
    ProfileDB* db =   p_cnt_class->GetProfileDB();
    Profil * profil = new Profil("");//new profiel
    ProfilDialog dialog(db->GetProfileManager()->GetProfilesNames(),this, profil,db->GetSoundFilesManager()->GetModel()); //dostane profil, jmena profilu a model

    int result = dialog.exec();

    if(result)
    {
        //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "save profile";
        db->GetProfileManager()->CreateProfile(profil);
    }
    delete profil;
}

/** SetTimedProfile
Slot for  signal when user click on button for timed profile
*/
void MainWindow::SetTimedProfile()
{
    p_cnt_class->SetTimeProfile();
}

/** SetTimedProfilename
Slot for  signal when set profile
\param profile_name name of profile
*/
void MainWindow::SetTimedProfilename(QString profile_name)
{
    p_Timed_Profile_button->setValueText(profile_name);
}

/** SetCalendarProfiles
Slot for  signal when user click on button for calendar profile
*/
void MainWindow::SetCalendarProfiles()
{
    p_cnt_class->SetCalendar();
}

/** SetNetworkProfile
Slot for  signal when user click on button for network profile
*/
void MainWindow::SetNetworkProfile()
{
    p_cnt_class->SetNetwork();
    //=======================================
}

/** SetCalendarProfilename
Slot for  signal when calendar object select profile
\param profile_name name of profile
*/
void MainWindow::SetCalendarProfilename(QString profile_name)
{
    p_Calendar_Profile_button->setValueText(profile_name);
}

/** SetDeafaultProfile(QString profile_name)
Slot for  signal when user choose profile name from QMaemoButton
\param profile_name name of profile
*/
void MainWindow::SetDeafaultProfile(QString profile_name)
{
    p_cnt_class->SetDefaultProfile(profile_name);
}

/** SetMetworkProfilename(QString profile_name)
Slot for  signal when network object select profile
\param profile_name name of profile
*/
void MainWindow::SetMetworkProfilename(QString profile_name )
{
    p_IDWifi_Profile_button->setValueText(profile_name);
}

//======================================================================================
/** closeEvent(QCloseEvent *event)
Slot for close event.
It will call method maybeQuit()
*/
void MainWindow::closeEvent(QCloseEvent *event)
{
    hide();
    event->ignore();
    emit s_hide_show();
}

void MainWindow::on_actionExit_triggered()
{
    if (maybeQuit()) {
        emit s_aboutToEnd();
        QCoreApplication::quit();
    } else {
        return;
    }
}

/** maybeQuit()
Method for show QMessageBox before
It will ask user if he want to quit.
*/
bool MainWindow::maybeQuit()
{
    QMessageBox::StandardButton ret;
    ret = QMessageBox::warning(this, tr("Application"),
                               tr("Program will end.\n"
                                  "Do you want to quit?"),
                               QMessageBox::Ok | QMessageBox::Cancel);
    switch (ret) {
    case QMessageBox::Ok:
        return true;
        break;
    case QMessageBox::Cancel:
        return false;
        break;
    default:
        return false;
    }
    return true;
}

int MainWindow::top_application()
{
    show();
    return 0;
}


//================================================================================
/** \brief changeEvent
 *
 *
 *
 */
void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

/** \brief on_actionAboutQT_triggered
 *
 *
 *
 */
void MainWindow::on_actionAboutQT_triggered()
{
    QMessageBox::aboutQt(this);
}

/** \brief on_actionAbout_triggered
 *
 *
 *
 */
void MainWindow::on_actionAbout_triggered()
{
    QString str = QString("");
    str.append(tr("This program can create mobile profiles and set them. "));
    str.append(tr("Program will change only general profil in N900. "));
    str.append(tr("When you first start N9Profil it will create two profile from N900, general a silent. "));
    str.append(tr("You can set default profile, timed profile for "));
    str.append(tr("period of time or you can set profiles based on desctriptions "));
    str.append(tr("in events in calendar. "));
    str.append(tr("Timed profile have bigger priority, then calendar and calendar then default profile. "));
    QMessageBox::about(this,tr("About N9Profil"), str);
}

void MainWindow::on_pushButtonPhonenum_clicked()
{
    p_cnt_class->SetTelNum();
}
