/** \file event.h
  \brief   contain class for event
  \author Jakub Šplíchal <jakub.bzouk@gmail.com>
 */
#ifndef EVENT_H
#define EVENT_H

#include <QObject>
#include <QtCore/QDateTime>
class QTimer;

/** \class Event
  \brief class for store event in calendars
  class store events from calendar
 */
class Event : public QObject
{
    Q_OBJECT
public:
    explicit Event(QObject *parent = 0);
    void SetTime(QString I, QString des , QString sum, QDateTime SDate,QDateTime EDate);
    QString GetSummary();
    bool isNow();
    bool isOld();
    QString GetId();

signals:
    void  s_event_change(Event *);
public slots:

private:
    QTimer *timer;
    QString Id_event;
    QString summary; // title
    QString description;
    QDateTime start_Date;
    QDateTime end_Date;

    void timerSet();

    bool is_now;
    bool is_old;

private slots:
    void TimerTimeout();
};

#endif // EVENT_H
