#ifndef CONTROLCLASS_H
#define CONTROLCLASS_H

/*! \file controlclass.h
    \brief File .h for class ControlClass
    \author Jakub Šplíchal <jakub.bzouk@gmail.com>
    Header file
*/

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QWidget>
class QSettings;
class ProfileDB;
class TimeProfile;
class CalendarProfile;
class NetWorkProfile;
class TelephoneNumProfile;

/*!
  \class ControlClass
  \brief The ControlClass for control and setting profiles
*/
class ControlClass : public QWidget{
    Q_OBJECT
public:
    ControlClass(QWidget *parent = 0);
    ~ControlClass();

    void Init( QSettings * setting);
    ProfileDB * GetProfileDB();
    void SetTimeProfile();
    void SetCalendar();
    void SetNetwork();
    void SetTelNum();

    QString GetDefaultProfile();
    QString GetTimedProfile();
    QString GetCalendarProfile();

    void SetDefaultProfile(QString profile);

private:
    QSettings * settings;
    ProfileDB * p_profile_db;
    TimeProfile * p_time_profile;
    CalendarProfile * p_calendar_profile;
    NetWorkProfile * p_network_profile;
    TelephoneNumProfile * p_telenum_profil;

    //names of profiles that are set
    QString default_profile;
    QString timer_profile;
    QString calendar_profile;
    QString network_profile;
    QString telnum_profile;
    QString actual_set_profile;

    void ChooseProfile();

public slots:
    void ChangeInProfile(QString);




public slots:
    void ChangeTimedProfile(QString profile_name);
    void ChangeCalendarProfile(QString profile_name);
    void ChangeNetworkProfile(QString profile_name);
    void ChangeTelNumProfile(QString profile_name);


signals:
    void s_timed_profile_name(QString);
    void s_calendar_profile_name(QString);
    void s_network_profile_name(QString);

    void s_profile_now(QString);
};

#endif // CONTROLCLASS_H
