
#include <QtCore/QSettings>
#include "controlclass.h"
#include "profiledb.h"
#include <QtCore/QDebug> //Debug pro informace
#include "timeprofile.h"
#include "calendatprofile.h"
#include "networkprofile.h"
#include "telephonenumprofile.h"

/** Constructor.
  Set pointers to NULL and create new profile db
*/
ControlClass::ControlClass(QWidget *parent) :
        QWidget(parent)
{
    settings = NULL;
    p_profile_db = new ProfileDB(this); //create new db
}

/** Destructor.
*/
ControlClass::~ControlClass()
{
}

/** Init.
  Used to initialize and connect slot and signals
  \param setting reference to the setting class
*/
void ControlClass::Init( QSettings *setting )
{
    settings = setting;

    p_time_profile = new TimeProfile(this,setting); //create class for setting timed profile
    connect(p_profile_db->GetProfileManager(),SIGNAL(s_profiles_name_change(QStringList)),p_time_profile,SLOT(ChangeInProfles(QStringList)));
    p_calendar_profile = new CalendarProfile(this, settings);
    connect(p_profile_db->GetProfileManager(),SIGNAL(s_profile_update(QString)),this,SLOT(ChangeInProfile(QString)));
    connect(p_profile_db->GetProfileManager(),SIGNAL(s_profiles_name_change(QStringList)),p_calendar_profile,SLOT(setProfiles(QStringList)));
    connect(p_time_profile,SIGNAL(s_set_timed_profile(QString)),this,SLOT(ChangeTimedProfile(QString)));
    connect(p_calendar_profile,SIGNAL(s_calendar_profile(QString)),this,SLOT(ChangeCalendarProfile(QString)));
    p_network_profile = new NetWorkProfile(this,setting);
    connect(p_network_profile,SIGNAL(s_network_profile(QString)),this,SLOT(ChangeNetworkProfile(QString)));
    connect(p_profile_db->GetProfileManager(),SIGNAL(s_profiles_name_change(QStringList)),p_network_profile,SLOT(SetProfilenames(QStringList)));
    connect(p_profile_db->GetProfileManager(),SIGNAL(s_profile_delete(QString)),p_network_profile,SLOT(DeletedProfile(QString)));
    p_telenum_profil = new TelephoneNumProfile(this);
    connect(p_profile_db->GetProfileManager(),SIGNAL(s_profiles_name_change(QStringList)),p_telenum_profil,SLOT(SetProfilenames(QStringList)));
    connect(p_telenum_profil,SIGNAL(s_telnum_profile(QString)),this,SLOT(ChangeTelNumProfile(QString)));
    qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "create new db";
    //set deafult profile
    settings->beginGroup("ControlClass");
    default_profile = settings->value("DefaultProfile", "general").toString(); //set default profile
    settings->endGroup();

    //for signal when profile is changed (update profile)

    p_profile_db->Init();//init db

    p_calendar_profile->Init();
    p_network_profile->createModels(p_profile_db->GetRulesManager()->GetCellIDModel(),p_profile_db->GetRulesManager()->GetWiFiModel());
    p_telenum_profil->createModels(p_profile_db->GetRulesManager()->GetTelNumModel());
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Deafult Profile: " << default_profile;
}

/** ChangeTeNulProfile
Slot for signal from class for tel num profil to set
\param profile_name name of profile
*/
void ControlClass::ChangeTelNumProfile(QString profile_name)
{
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Timer set";
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "name of timed profile:" << profile_name;
    telnum_profile = profile_name;
    //emit s_timed_profile_name(timer_profile); //signal for MainWindow
    ChooseProfile();
}


/** ChangeTimedProfile
Slot for signal from class for timed profil to set
\param profile_name name of profile
*/
void ControlClass::ChangeTimedProfile(QString profile_name)
{
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Timer set";
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "name of timed profile:" << profile_name;
    timer_profile = profile_name;
    emit s_timed_profile_name(timer_profile); //signal for MainWindow
    ChooseProfile();
}

/** ChangeNetworkProfile
Slot for signal from class for network profil to set
*/
void ControlClass::ChangeNetworkProfile(QString profile_name)
{
    network_profile = profile_name;
    emit s_network_profile_name(network_profile);
    ChooseProfile();
}

/** ChangeCalendarProfile
Slot for signal from class for caledar profil to set
\param profile_name name of profile
*/
void ControlClass::ChangeCalendarProfile(QString profile_name)
{
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Calendar set";
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "name of calendar profile:" << profile_name;
    calendar_profile = profile_name;
    emit s_calendar_profile_name(calendar_profile);
    ChooseProfile();
}


/** SetDefaultProfile(QString profile).
Method for setting default profile
\param profile name of profile
*/
void ControlClass::SetDefaultProfile(QString profile)
{
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "profil default: " << profile;
    //not to set same profile
    if(profile != default_profile){

        settings->beginGroup("ControlClass");
        settings->setValue("DefaultProfile", profile);
        settings->endGroup();
        ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "default profile will be set: " << profile;
        default_profile = profile;
        ChooseProfile();
    }
}

/** SetTelNum
Show network dialog
*/
void ControlClass::SetTelNum()
{
    p_telenum_profil->ShowDialog();
}


/** SetNetwork
Show network dialog
*/
void ControlClass::SetNetwork()
{
    p_network_profile->ShowDialog();
}

/** SetCalendar
Show calendat dialog
*/
void ControlClass::SetCalendar()
{
    p_calendar_profile->ShowDialog();
}

/** SetTimeProfile
Call time profile class to show dialog to set timed profile
*/
void ControlClass::SetTimeProfile()
{
    p_time_profile->SetTimer(p_profile_db->GetProfileManager()->GetProfilesNames());
}


/** ChooseProfile().
This method will chosse profile from default_profile, timer_profile and calendar_profile
based of priority
*/
void ControlClass::ChooseProfile()
{
    // QString textShow = tr("Current profile is: ");
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << " timer profile empty  " << timer_profile.isEmpty();
    if(!telnum_profile.isEmpty()){
        if(telnum_profile != actual_set_profile){
            p_profile_db->GetProfileManager()->SetProfile(telnum_profile);
            actual_set_profile = telnum_profile;
            ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "time profile waill be set now";
        }
    } else if(!timer_profile.isEmpty()){
        if(timer_profile != actual_set_profile){
            if(telnum_profile.isEmpty()){
                emit s_profile_now(QObject::tr("Timer profile: ") + timer_profile);
            }
            p_profile_db->GetProfileManager()->SetProfile(timer_profile);
            actual_set_profile = timer_profile;
            ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "time profile waill be set now";
        }
    }else if(!network_profile.isEmpty())
    {
        if(network_profile != actual_set_profile)
        {
            if(telnum_profile.isEmpty()){
                emit s_profile_now(QObject::tr("Network profile: ") + network_profile);
            }
            ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "network profile will be set";
            p_profile_db->GetProfileManager()->SetProfile(network_profile);
            actual_set_profile = network_profile;
        }
    }
    else if(!calendar_profile.isEmpty())
    {
        if(calendar_profile != actual_set_profile) {
            if(telnum_profile.isEmpty()){
                emit s_profile_now(QObject::tr("Calendar profile: ") + calendar_profile);
            }
            p_profile_db->GetProfileManager()->SetProfile(calendar_profile);
            actual_set_profile = calendar_profile;

        }
    } else {
        if(default_profile != actual_set_profile) {
            if(telnum_profile.isEmpty()){
                emit s_profile_now(QObject::tr("Default profile: ") + default_profile);
            }
            ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "deafult profile will be set";
            p_profile_db->GetProfileManager()->SetProfile(default_profile);
            actual_set_profile = default_profile;

        }
    }
}
//====================================================================

/**  ChangeInProfile
Slot for change in profile
\param profile name of profile
*/
void ControlClass::ChangeInProfile(QString profile)
{
    if(actual_set_profile == profile ) p_profile_db->GetProfileManager()->SetProfile(profile);
}
/** GetProfileDB()
Returns the object reference for the database
\returns pointer to ProfileDB
*/
ProfileDB * ControlClass::GetProfileDB()
{
    return p_profile_db;
}

/** GetDefaultProfile()
Returns the name of default profile
\returns name of default profile
*/
QString ControlClass::GetDefaultProfile()
{
    return default_profile;
}

/** GetTimedProfile()
Returns the name of timed profile
\returns name of timed profile
*/
QString ControlClass::GetTimedProfile()
{
    return timer_profile;
}

/** GetCalendarProfile()
Returns the name of calendar profile
\returns name of calendar profile
*/
QString ControlClass::GetCalendarProfile()
{
    return calendar_profile;
}
