#include "calendarprofilesdialog.h"
#include "ui_calendarprofilesdialog.h"
#include <QtGui/QStandardItemModel>
#include <QtGui/QItemSelectionModel>
#include <QtCore/QModelIndex>
#include <QtCore/QSettings>
#include <QtCore/QDebug> //Debug pro informace
#include "calendarsetprofiledialog.h"
/** Constructor.
Setup ui and set window title
*/
CalendarProfilesDialog::CalendarProfilesDialog(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::CalendarProfilesDialog)
{
    ui->setupUi(this);
    setWindowTitle(tr("Edit profiles and calendars"));
}

/** SetViews.
Set view models, behavior, mode and triggerrs
\param model_of_profiles model of profiles
\param selModel_profiles selection model for profiles
\param model_of_calendars model of calendars
\param selModel_calendars selection model for calendars
*/
void CalendarProfilesDialog::SetViews(QStandardItemModel *model_of_profiles ,
                                      QItemSelectionModel *selModel_profiles,
                                      QStandardItemModel *model_of_calendars ,
                                      QItemSelectionModel *selModel_calendars)
{
    ui->Profile_tableView->setModel(model_of_profiles);
    ui->Profile_tableView->setSelectionModel(selModel_profiles);
    ui->Profile_tableView->setSelectionBehavior(QAbstractItemView::SelectRows);
    ui->Profile_tableView->setSelectionMode(QAbstractItemView::SingleSelection);
    ui->Profile_tableView->setEditTriggers(QAbstractItemView::NoEditTriggers);
    //ui->tableView_2->resizeColumnsToContents();
    ui->Profile_tableView->horizontalHeader()->setResizeMode(QHeaderView::Stretch);

    ui->CalendartableView->setModel(model_of_calendars);
    ui->CalendartableView->setSelectionModel(selModel_calendars);
    ui->CalendartableView->horizontalHeader()->setResizeMode(QHeaderView::Stretch);
    ui->CalendartableView->setSelectionBehavior(QAbstractItemView::SelectRows);
    ui->CalendartableView->setSelectionMode(QAbstractItemView::SingleSelection);
    ui->CalendartableView->setEditTriggers(QAbstractItemView::NoEditTriggers);
}

/** SetSettings.
Set settings pointer
\param sett pointer to settings class
*/
void CalendarProfilesDialog::SetSettings(QSettings *sett)
{
    settings = sett;
}

/** Destructor.
Destructor delete ui
*/
CalendarProfilesDialog::~CalendarProfilesDialog()
{
    delete ui;
}

/** changeEvent.
changeEvent
\param e event
*/
void CalendarProfilesDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

/** on_CalendartableView_clicked.
Slot for click on CalendartableView
\param index index not used
*/
void CalendarProfilesDialog::on_CalendartableView_clicked(QModelIndex index)
{
    Q_UNUSED(index)

    QItemSelectionModel *selModel_calendars = ui->CalendartableView->selectionModel();
    if(!selModel_calendars->hasSelection()) return; // nothing selected return
    QModelIndexList list_of_calendar = selModel_calendars->selectedIndexes();
    //qDebug() << "size of list" << list_of_calendar.count();
    int i = 0;
    if(list_of_calendar.at(0).data(Qt::CheckStateRole).toInt() == 2){
        i = 2;
    }
    //qDebug() << " print i " << i;
    //qDebug() << " =========================================================================== ";
    settings->beginGroup("CalendarProfileClassCalendars");
    settings->setValue(list_of_calendar.at(0).data().toString(), QVariant(i) );
    settings->endGroup();
    //qDebug() << "emit změny";
    emit s_change_calendars();
    selModel_calendars->clearSelection();
}

/** on_Profile_tableView_clicked.
Slot for click on Profile_tableView
\param index index not used
*/
void CalendarProfilesDialog::on_Profile_tableView_clicked(QModelIndex index)
{
    Q_UNUSED(index)

    QItemSelectionModel *selModel_profiles = ui->Profile_tableView->selectionModel();
    if(!selModel_profiles->hasSelection()) return;
    QModelIndexList list_of_profil = selModel_profiles->selectedIndexes();
    QStandardItemModel *model_of_profiles = (QStandardItemModel *) ui->Profile_tableView->model();
    CalendarSetProfileDialog dialog(this);
    dialog.SetDialog(list_of_profil.at(0).data().toString(),list_of_profil.at(1).data().toString(),list_of_profil.at(2).data().toInt());
    int result = dialog.exec();
    if(result)
    {
        settings->beginGroup("CalendarProfileClass");
        settings->setValue(QString("%1%2").arg(list_of_profil.at(0).data().toString(),"words"), QVariant(dialog.GetText()));
        settings->setValue(QString("%1%2").arg(list_of_profil.at(0).data().toString(),"priority"), QVariant(dialog.GetPriority()));
        settings->endGroup();

        model_of_profiles->setData(list_of_profil.at(1),QVariant(dialog.GetText()),Qt::DisplayRole);
        model_of_profiles->setData(list_of_profil.at(2),QVariant(dialog.GetPriority()),Qt::DisplayRole);
        emit s_change_calendars();
    }
    selModel_profiles->clearSelection();
}
