#include "calendar.h"
#include <QtCore/QDateTime>
#include <QtCore/QVector>
#include <QtCore/QDebug> //Debug pro informace
#include "event.h"
/**
 */
Calendar::Calendar(QObject *parent) :
        QObject(parent)
{
}

/** AddEvent
   Add event into calendar
   \param id of event
   \param des desctription
   \param sum summary
   \param SDate start date
   \param EDate end date
 */
void Calendar::AddEvent(QString id, QString des ,QString sum, QDateTime SDate, QDateTime EDate)
{
    Event *event_new;
    if((event_new = findEvent(id)) == NULL){
        event_new = new Event(this);
        vector_calendars_events.append(event_new);
        //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Create new event ";
        connect(event_new,SIGNAL(s_event_change(Event*)),this,SLOT(EventChanged(Event*)));
        event_new->SetTime(id, des, sum, SDate, EDate);
    }
}
/** Delete event
  delete event
  \param id of event
 */
void Calendar::DeleteEvent(QString id)
{
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Delete event " << id;
    for(int i = 0; i < vector_calendars_events.size();++i)
    {
        if(vector_calendars_events.at(i)->GetId() == id){
            delete vector_calendars_events.at(i);
            vector_calendars_events.remove(i);
            return;
        }
    }
}
/** Delete all old events
 */
void Calendar::DeleteOldEvents()
{
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "delete all old events ";
    QMutableVectorIterator<Event *> i(vector_calendars_events);
    while (i.hasNext()) {
        Event *val = i.next();
        if (val->isOld() == true) {
            //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Event is old delete ";
            delete val;
            i.remove();
        }
    }
}

/** Change in event
   Slot for change in event
   \param ev  event
 */
void Calendar::EventChanged(Event * ev)
{
    if(ev->isNow()) {
        emit s_eventStart(ev);
    } else {
        emit s_eventStop(ev);
    }
}
/** FindEventsNow
 find all event for now
  \returns vector of events
 */
QVector<Event *> Calendar::FindEventsNow()
{
    QVector<Event *> vector;
    qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "Search for now events ";
    foreach(Event *evt, vector_calendars_events )
    {
        if(evt->isNow()){
           qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "Select event";
            vector.append(evt);
        }
    }
    return vector;
}
/** findevent
  find event
  \param i of event
 */
Event * Calendar::findEvent(QString i)
{
    foreach(Event * evt, vector_calendars_events)
    {
        if(evt->GetId() == i) return evt;
    }
    return NULL;
}
/** Setname
  set name of calendar
  \param n  name of cal
 */
void Calendar::SetName(QString n)
{
    name_of_calendar = n;
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << " jmeno kalendare je " << n;
}
/** SetIcon
  set icon of calendar
  \param ico  icon of cal
 */
void Calendar::SetIcon(QIcon ico)
{
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Setting icon fo cal" ;
    icon = ico;
}
/** SetId
  set id of calendar
  \param i  id of cal
 */
void Calendar::SetId(int i)
{
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "Id_cal:" << Id_cal;
    Id_cal = i;
}
/** GetId
  get id of calendar
 */
int Calendar::GetId()
{
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "Id_cal:" << Id_cal;
    return Id_cal;
}
/** GetIcon
  set icon of calendar
 */
QIcon Calendar::GetIcon()
{
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "return icon";
    return icon;
}
/** GetName
get name of calendar
 */
QString Calendar::GetName()
{
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "Get name:" << name_of_calendar;
    return name_of_calendar;
}
