#include "timedprofildialog.h"
#include "ui_timedprofildialog.h"
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include <QMaemo5InformationBox>
#include <QMaemo5TimePickSelector>
#include <QtCore/QStringList>

#include <QtGui/QStandardItemModel>
#include <QLabel>
#include <QtCore/QDebug> //Debug pro informace
TimedProfilDialog::TimedProfilDialog(QStringList list,QWidget *parent) :
        QDialog(parent),
        ui(new Ui::TimedprofilDialog)
{
    ui->setupUi(this);

    createNewMaemoButtons(list);
    createNewLabels();
}

/** createNewMaemoButtons()
create maemo buttons
*/
void TimedProfilDialog::createNewMaemoButtons(QStringList list)
{
    QStandardItemModel *testmodel = new QStandardItemModel(this);
    for (int i = 0; i < list.size(); ++i)
        testmodel->appendRow(new QStandardItem(list.at(i)));

    v1 = new QMaemo5ValueButton(tr("Name of profile"), this);
    v1->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    list_pick = new QMaemo5ListPickSelector();
    list_pick->setModel(testmodel);
    v1->setPickSelector(list_pick);
    ui->gridLayout->addWidget(v1,0,1);

    v2 = new QMaemo5ValueButton(tr("Time"),this);
    v2->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    time_pick = new QMaemo5TimePickSelector();
    time_pick->setCurrentTime(QTime(0,0));//0 hours, 0 min
    v2->setPickSelector(time_pick);
    ui->gridLayout->addWidget(v2,1,1);
}

/** createNewLabels()
create new labels
*/
void TimedProfilDialog::createNewLabels()
{
    QLabel * label_name = new QLabel(this);
    label_name->setObjectName(QString::fromUtf8("label_name"));
    QFont font;
    font.setPointSize(17);
    label_name->setFont(font);
    label_name->setText(tr("Name of profile"));
    ui->gridLayout->addWidget(label_name, 0, 0);
    QLabel *label_time = new QLabel(this);
    label_time->setObjectName(QString::fromUtf8("label_time"));
    label_time->setFont(font);
    label_time->setText(tr("Select time"));
    ui->gridLayout->addWidget(label_time, 1, 0);
}


TimedProfilDialog::~TimedProfilDialog()
{
    delete ui;
}

/** accept()
Slot for signal when user click on save button.
Check is everyting is OK
*/
void TimedProfilDialog::accept()
{
    qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << " Profile is:" << list_pick->currentValueText();
    qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << " Time is : " <<  time_pick->currentValueText();
    time_for_set = time_pick->currentTime();

    name_of_profile = list_pick->currentValueText();
    if(name_of_profile.isEmpty())
    {
        QMaemo5InformationBox::information(this, tr("Select profile"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    QTime nula_cas(0,0);
    qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Hours: " << time_for_set.hour() << "min " << time_for_set.minute();
    qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "sec to" << nula_cas.secsTo(time_for_set);
    done(QDialog::Accepted);
}

/** GetTime()
Return time from time picker
*/
QTime TimedProfilDialog::GetTime()
{
    return time_for_set;
}

/** GetName()
Return name from list picker
*/
QString TimedProfilDialog::GetName()
{
    return name_of_profile;
}

void TimedProfilDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
