#include "soundfilesmanager.h"
#include <QtGui/QStandardItemModel>
#include <QtCore/QStringList>
#include <QtCore/QDir>
#include <QtXml/QDomElement>
#include <QtCore/QDebug> //Debug pro informace
SoundFilesManager::SoundFilesManager(QObject *parent) :
        QObject(parent)
{
}

bool SoundFilesManager::Init(QDomElement root)
{
    if(InitModel() == false)
        return false;

    filesFromXmlDB(root);
    return true;
}


/** InitModel().
Used to initialize the model for store names and paths to music files.
*/
bool SoundFilesManager::InitModel()
{
    model_of_files = new QStandardItemModel(this);
    //QDir dir("/usr/share/sounds");
    QDir dir("/home/user/MyDocs/.sounds/Ringtones");
    QFileInfoList list_of_in_home =   dir.entryInfoList(QDir::Files | QDir::NoDotAndDotDot);
    QFileInfoList list_of_maemo_sounds = QFileInfoList();
    //////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << " budou se pridavat soubory" ;
    appendFile(&list_of_maemo_sounds,QFileInfo("/usr/share/sounds/NokiaTune.aac"));
    appendFile(&list_of_maemo_sounds,QFileInfo("/usr/share/sounds/Beeb.aac"));
    appendFile(&list_of_maemo_sounds,QFileInfo("/usr/share/sounds/Emailalert1.aac"));
    appendFile(&list_of_maemo_sounds,QFileInfo("/usr/share/sounds/Emailalert2.aac"));
    appendFile(&list_of_maemo_sounds,QFileInfo("/usr/share/sounds/Message1.aac"));
    appendFile(&list_of_maemo_sounds,QFileInfo("/usr/share/sounds/Message2.aac"));
    appendFile(&list_of_maemo_sounds,QFileInfo("/usr/share/sounds/Message3.aac"));
    appendFile(&list_of_maemo_sounds,QFileInfo("/usr/share/sounds/Message4.aac"));
    appendFile(&list_of_maemo_sounds,QFileInfo("/usr/share/sounds/Message5.aac"));

    list_of_maemo_sounds += list_of_in_home;
    appendToModel(&list_of_maemo_sounds);
    return true;
}

/** appendToModel().
append item into model of files
*/
void SoundFilesManager::appendToModel(QFileInfoList * list_of_files)
{
    QList<QStandardItem *>  items;
    foreach(QFileInfo file, *list_of_files)
    {
        if(checkFileInModelAndExist(file)){
            //////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << " bude se pridavat do modelu toto" << file.absoluteFilePath();
            items.append(new QStandardItem(file.fileName()));
            items.append(new QStandardItem(file.absoluteFilePath()));
            model_of_files->appendRow(items);
            items.clear();
        }
    }
}

/** appendFile().
append item into list of files
*/
void SoundFilesManager::appendFile(QFileInfoList * list_of_files, QFileInfo inf)
{
    if(inf.exists()) list_of_files->append(inf);
}

/** checkFileInModelAndExist().
Check if file exist and if is its in model
*/
bool SoundFilesManager::checkFileInModelAndExist(QFileInfo inf)
{
    if(!inf.exists()) return false;
    if(!model_of_files->findItems(inf.absoluteFilePath(),Qt::MatchExactly, 1).empty()) return false;
    return true;
}

/** filesFromXmlDB().
Load files from xml
*/
void SoundFilesManager::filesFromXmlDB(QDomElement root)
{
    qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "ted z xml";
    QFileInfoList list_of_files;
    QDomElement first =  root.firstChildElement();
        qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "sml neni nulll";
        //list of all profile
        while(!first.isNull()) {
            qDebug() << "|Jmeno profilu" << first.tagName();
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "bude se pridavat z xml" << first.firstChildElement("email.alert.tone").tagName();
            appendFile(&list_of_files, QFileInfo(first.firstChildElement("email.alert.tone").text()));
            appendFile(&list_of_files, QFileInfo(first.firstChildElement("im.alert.tone").text()));
            appendFile(&list_of_files, QFileInfo(first.firstChildElement("ringing.alert.tone").text()));
            appendFile(&list_of_files, QFileInfo(first.firstChildElement("sms.alert.tone").text()));
            first = first.nextSiblingElement();
        }
    appendToModel(&list_of_files);
}

/** GetModel().
Returns a reference to the model of music files.
*/
QStandardItemModel * SoundFilesManager::GetModel()
{
    return model_of_files;
}
