#include "profilesmanager.h"
#include "profiledeamon.h"
#include <QtCore/QDebug> //Debug pro informace
#include <QtXml/QDomElement>
#include <QtCore/QStringList>
#include <QtCore/QTextStream>
#include <QtCore/QString>
#include "profil.h"
#include <QtGui/QStandardItemModel>
ProfilesManager::ProfilesManager(QObject *parent) :
    QObject(parent)
{
}

/** Init
  Creates an object ProfileDeamon and connects via ProfileDeamon: ConnectToDeamon
  Create a model that will list all audio files
  Then initializes the XML file using InitFile()
  If the file exists so it attempts to read with readfile()
   and if not it creates and initializes using CreateFile()
*/
bool ProfilesManager::Init()
{
    //connect
    if(profile_deamon->ConnectToDeamon() == false)
    {
        qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Cannot connect";
        return false;
    }
    qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "bude init file ================= ";
    //open the file
    if(InitFile() == false) {
        return false;
    }

    if(file.exists()) {
        if(ReadFile() == true){
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "File read";
            emit s_profiles_name_change(GetProfilesNames());
            return true;
        } else {
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "neco spatne ve sceni souborů================= ";
            return false;
        }
    } else {
        if(CreateFile() == true){
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "file created";
            //(general a silent)
            Profil general = profile_deamon->GetProfile("general");
            Profil silent = profile_deamon->GetProfile("silent");
            CreateProfile(&general);
            CreateProfile(&silent);
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "added two profiles general silent ";
            emit s_profiles_name_change(GetProfilesNames());
            return true;
        } else {
            return false;
        }
    }
    return false;
}
//=============================================================
/** InitFile
Opens home folder and check if there is an dir NProfile and if not that it creates it
and set the file to Dir.filePath(profiles.xml)
*/
bool ProfilesManager::InitFile()
{
    QDir Dir = QDir::homePath();

    //vytvori slozku pokud neni
    if(!Dir.exists("NProfile")){
        if(!Dir.mkdir("NProfile")){
            qWarning() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "Cannot create folder NProfile in home";
            return false;
        }
    }
    //switches to a folder
    if(!Dir.cd("NProfile")){
        qWarning() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "cannot cd in NProfile";
        return false;
    }

    file.setFileName(Dir.filePath("profiles.xml")); //set
    return true;
}

/** ReadFile
Opens a file and reads the XML document using domDocument.setContent and check it with checkDomDoc ()
*/
bool ProfilesManager::ReadFile()
{
    if (!file.open(QIODevice::ReadWrite | QIODevice::Text)){
        //////qDebug() <<  __FILE__  << __LINE__  << __FUNCTION__ << "Cannot open file";
        return false;
    }
    QString errorStr;
    int errorLine;
    int errorColumn;
    if (!domDocument.setContent((QIODevice * )&file, false, &errorStr, &errorLine,
                                &errorColumn)) {
        //////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Cannot set content " << errorStr << "line " << errorLine << "Column " << errorColumn;
        file.close();
        return false;
    }

    //control
    if(!CheckDomDoc()) {
        //////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Error in document, this is not calendar file ";
        file.close();
        return false;
    }
    //  print();
    file.close();
    return true;
}

/** CreateFile
Open the file and create XML using createXmlText () and write to a file.
Sets the document and check with domDocument.setContent checkDomDoc ()
and closes the file.
*/
bool ProfilesManager::CreateFile()
{ //otevřu
    if (!file.open(QIODevice::ReadWrite | QIODevice::Text)){
        //////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Cannot open file";
        return false;
    }
    QString errorStr;
    int errorLine;
    int errorColumn;
    QTextStream out(&file);
    QString text = CreateXmlText(); //create text xml
    out.setCodec("UTF-8");//set utf 8
    out.setAutoDetectUnicode(true);
    out << text;//write
    out.flush(); //

    if (!domDocument.setContent(text, false, &errorStr, &errorLine,
                                &errorColumn)) {
        //////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Cannot set content " << errorStr << "line " << errorLine << "Column " << errorColumn;
        file.close();
        return false;
    }
    //check
    if(!CheckDomDoc()) {
        //////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" <<  "Error in document, this is not calendar file  ";
        file.close();
        return false;
    }
    file.close();//close
    return true;
}

/** createXmlText
Creates the xml text
*/
QString ProfilesManager::CreateXmlText()
{
    QString text("");
    text += "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    text += "<!DOCTYPE NProf>\n";
    text +="<NProf version=\"1.0\">\n";//začátek
    text += "</NProf>\n";//konec souboru
    return text;
}

/** checkDomDoc
Checks if the document is in order
*/
bool ProfilesManager::CheckDomDoc()
{
    QDomElement root = domDocument.documentElement();
    if (root.tagName() != "NProf") {
        //////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Error in root";
        return false;
    } else if (root.hasAttribute("version")
        && root.attribute("version") != "1.0") {
        //////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Error in version";
        return false;
    }
    return true;
}


//=============================================================================================================
//http://www.decompile.com/cpp/faq/file_and_line_error_string.htm
// pro //////qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ <<

/** SaveProfilesToXml
Saves the document to a file
*/
void ProfilesManager::SaveProfilesToXml()
{

    if (!file.open(QIODevice::WriteOnly | QIODevice::Text)){
        //////qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "nejde otevrit soubor";
    }
    QTextStream out(&file);
    out.setCodec("UTF-8");
    out.setAutoDetectUnicode(true);
    out << domDocument.toString();
    out.flush();
    file.close();//close file
}

/** GetProfilesNames
Returns a list of names of profiles
*/
QStringList ProfilesManager::GetProfilesNames()
{
    QStringList profiles_names = QStringList();
    QDomElement root = domDocument.documentElement();
    QDomElement first =  root.firstChildElement();
    while(!first.isNull()) {
        profiles_names.append( first.tagName());
        first = first.nextSiblingElement();
    }
    return profiles_names;
}
//=============================================================================================================
/** GetRootElemetn
  Get root element
  */
QDomElement ProfilesManager::GetRootElement() const
{
    return domDocument.documentElement();
}

/** GetProfile
Returns an object filled with data
 \param profil Pointer to object to the data of the profile
*/
bool ProfilesManager::GetProfile(Profil * profil)
{
    QDomElement root = domDocument.documentElement();
    QDomElement profil_xml = root.firstChildElement(profil->GetName()); // find profile

    if(profil_xml.isNull()) return false;// if not found return

    QDomElement n = profil_xml.firstChildElement(); //ziskám první prvek
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Get profile from xml";

    while(!n.isNull())
    {
        ////qDebug() << "Element name and text: " << n.tagName() << n.text();
        profil->SetValue(n.tagName(), n.text());
        n = n.nextSiblingElement();
    }
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << " return";
    return true;
}

/** CreateProfile
Saves profile data to XML document and emit a signal, added or delete profile
 \param Data Pointer to an object with data of the profile
*/
bool ProfilesManager::CreateProfile(Profil *Data)
{
    QDomElement root = domDocument.documentElement();
    QDomElement ui = CreateNewProfile(Data);
    root.appendChild(ui);
    emit  s_profiles_name_change(GetProfilesNames());
    return true;
}

/** UpdateProfile
Changes in the profile data
 \param Data Pointer to an object with data on the profile
*/
void ProfilesManager::UpdateProfile(Profil * Data )
{
    QDomElement root = domDocument.documentElement();
    QDomElement profil_old = root.firstChildElement(Data->GetName());
    QDomElement profil_new = this->CreateNewProfile(Data);
    root.replaceChild(profil_new, profil_old);
    emit  s_profile_update(Data->GetName());
}

/** DeleteProfile
Delete profile
 \param profile_name name of profile
*/
void ProfilesManager::DeleteProfile(QString profile_name)
{
    QDomElement root = domDocument.documentElement();
    root.removeChild(root.firstChildElement(profile_name)); // find element end delete
    ////qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "smazan a emit";
    emit s_delete_Profiles_Name_From_Models(profile_name);
    emit s_profiles_name_change(GetProfilesNames());
}


/** createNewProfile
Creates records in the XLM document
 \param Data Pointer to an object with data on the profile
*/
QDomElement ProfilesManager::CreateNewProfile( Profil *Data)
{
    QDomElement ui = domDocument.createElement(Data->GetName()); //create element
    QList<ProfileValue *>* p_profile_values =  Data->ListOfValues();
    for (int i = 0; i < p_profile_values->size(); ++i)
    {
        CreateNode(&ui, p_profile_values->at(i)->key, p_profile_values->at(i)->type, p_profile_values->at(i)->value.toString());
    }
    return ui;
}

/** createNode
Creates an item in the XML file and adds it to the record
 \param profil Pointer to the element in xml
 \param name Name
 \param attribute attribute of item
 \param text text in item
*/
void ProfilesManager::CreateNode(QDomElement * profil, QString name, QString attribute, QString text)
{
    QDomElement ProfilData = domDocument.createElement(name);
    if(!attribute.isEmpty()){
        ProfilData.setAttribute("type", attribute );
    }
    QDomText newTitleText = domDocument.createTextNode(text);
    ProfilData.appendChild(newTitleText);
    profil->appendChild(ProfilData);
}

/** TestPrint
  Prints all profiles, !!! only for testing purposes
*/
void ProfilesManager::TestPrint()
{
    //////qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << " test print in DB";
    if(!domDocument.isNull()){
        QDomElement root = domDocument.documentElement();
        QDomElement first =  root.firstChildElement();
        QDomElement chield;
        //list of all profile
        while(!first.isNull()) {
            //////qDebug() << "|Jmeno profilu" << first.tagName();
            chield = first.firstChildElement();
            while(!chield.isNull()){
                //////qDebug() << "->>> atribut:"<< chield.tagName() << " hodnota: " << chield.text();
                chield = chield.nextSiblingElement();
            }
            first = first.nextSiblingElement();
        }
    }
}

/** SetProfile(QString str_profile)
  Sets profile
*/
void ProfilesManager::SetProfile(QString str_profile)
{
    ////qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Set profile into mobile-------------------" << str_profile;
    Profil * profil = new Profil(str_profile);
    if(!GetProfile(profil))
    {
        return;
    }
    profile_deamon->SetProfile(profil);
    delete profil;
}



