#include <libprofile.h> // knihovna pro přípojení k profile deamonu
#include <QtCore/QDebug> //Debug pro informace
#include "profiledeamon.h"
#include "profil.h"

/** Constructor.
Empty.
*/
ProfileDeamon::ProfileDeamon(QObject *parent) :
        QObject(parent)
{

}

/** Destruktor.
*/
ProfileDeamon::~ProfileDeamon()
{
    //odpojím se
    profile_tracker_quit();
}

/** ConnectToDeamon()
 Connect to profile deamon
*/

/**
  V dbusus je funkce
dbus_message_new_signal  	(  	const char *   	 path,
                const char *  	interface,
                const char *  	name
        )

Parameters:
        path 	the path to the object emitting the signal
        interface 	the interface the signal is emitted from
        name 	name of the signal

v DB na calendar je
static const char* CALENDAR_DBUS_LISTENER_SERVICE =  "com.nokia.calendar";
static const char* CALENDAR_DBUS_OBJECT_PATH =  "/com/nokia/calendar";
static const char* CALENDAR_DBUS_LISTENER_SIGNAL = "dbChange";

    dbusMessage = dbus_message_new_signal(CALENDAR_DBUS_OBJECT_PATH,
                      CALENDAR_DBUS_LISTENER_SERVICE,
                      CALENDAR_DBUS_LISTENER_SIGNAL);


                      lib profile má
#define 	PROFILED_SERVICE   "com.nokia.profiled"
#define 	PROFILED_PATH   "/com/nokia/profiled"
#define 	PROFILED_INTERFACE   "com.nokia.profiled"
                      #define 	PROFILED_CHANGED   "profile_changed

                      v QT4
 bool QDBusConnection::connect ( const QString & service, const QString & path, const QString & interface,
 const QString & name, QObject  * receiver, const char * slot )
  */

/** ConnectToDeamon()
connect to profiled deamon
*/
bool ProfileDeamon::ConnectToDeamon()
{
    int a = 0;
    profile_connection_enable_autoconnect(); // nastavím

    if((a = profile_tracker_init()) != 0){
        //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" <<  "cannot connect to deamon";
        return false;
    }
    //profile_track_add_active_cb(profileTrack, NULL, unlo );
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" <<  "connected to deamon";
    // QDBusConnection con = QDBusConnection::connectToBus(QDBusConnection::SessionBus,QString("muj"));

    //if(con.isConnected())  //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "neeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee pripojen";
    return true;
}

/** SetProfile( Profil * profil)
  Set profile
  \param profil reference to an object with the data profile
*/
bool ProfileDeamon::SetProfile( Profil * profil)
{

    //list of all the values in the profile
    QList<ProfileValue *>* p_profile_values =  profil->ListOfValues();
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "nastavuji:";
    for (int i = 0; i < p_profile_values->size(); ++i) {

        if(p_profile_values->at(i)->type.contains("SOUNDFILE"))//kdyz je proměnná text
        {
          //  qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ <<  "nastavuji:" << p_profile_values->at(i)->key << "hodnota " << p_profile_values->at(i)->value.toString();
            if(profile_set_value("general", p_profile_values->at(i)->key.toLatin1().data(),  p_profile_values->at(i)->value.toString().toLatin1().data()) == -1){
                return false;
            }
        }else  if(p_profile_values->at(i)->type.contains("BOOLEAN"))//kdyz je proměnná bool
        {
            //qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ <<  "nastavuji:" << p_profile_values->at(i)->key;
            if(profile_set_value_as_bool("general", p_profile_values->at(i)->key.toLatin1().data(),  p_profile_values->at(i)->value.toBool()) == -1){
                return false;
            }
        }else if(p_profile_values->at(i)->type.contains("INTEGER"))//kdyz je proměnná int
        {
            //qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ <<  "nastavuji:" << p_profile_values->at(i)->key;
            if(profile_set_value_as_int("general", p_profile_values->at(i)->key.toLatin1().data(),  p_profile_values->at(i)->value.toInt()) == -1){
                return false;
            }
        }else if(p_profile_values->at(i)->type.contains("STRING"))//kdyz je proměnná text
        {
            //qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ <<  "nastavuji:" << p_profile_values->at(i)->key;
            if(profile_set_value("general", p_profile_values->at(i)->key.toLatin1().data(),  p_profile_values->at(i)->value.toString().toLatin1().data()) == -1){
                return false;
            }
        }
    }
    return true;
}

/** GetProfile(QString profil_name)
  Return profile (general a silent)
  \param profil_name Profile Name
*/
Profil ProfileDeamon::GetProfile(QString profil_name)
{
    Profil profil(profil_name);
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Get profile from deamon";
    profileval_t* data_profile =  profile_get_values(profil_name.toLatin1().data());
    for(int i = 0; i < 15; i++)
    {
        //qDebug() << i + 1;
        //qDebug() << "|->>>klic: " << data_profile[i].pv_key ;
        //qDebug() << "|->>>hodnota: " << data_profile[i].pv_val ;
        //qDebug() << "|->>>typ: " << data_profile[i].pv_type ;
        //deamon return bool value on or off
        if(data_profile[i].pv_type == QString("BOOLEAN")){
            if(data_profile[i].pv_val == QString("On")){
                profil.SetValue(data_profile[i].pv_key, "1");
            } else {
                profil.SetValue(data_profile[i].pv_key, "0");
            }
        } else {
            profil.SetValue(data_profile[i].pv_key, data_profile[i].pv_val);
        }
    }
    //free
    profile_free_values(data_profile);
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "return from getprofile";
    return profil;
}
