#ifndef PROFILDIALOG_H
#define PROFILDIALOG_H
/*! \file profildialog.h
    \brief File .H for Class profile dialog
\author Jakub Šplíchal <jakub.bzouk@gmail.com>
    Header file
*/
#include <QDialog>

class QMaemo5ValueButton;
class Profil;
class QStandardItemModel;
class QStringList;
class QModelIndex;
class QListView;
class QItemSelectionModel;
class QMaemo5ListPickSelector;
class QFileInfo;
namespace Ui {
    class ProfilDialog;
}

/*!
  \class ProfilDialog
  \brief Class for the dialog to create or edit profiles
*/
class ProfilDialog : public QDialog {
    Q_OBJECT
public:
    ProfilDialog(QStringList  list_of_profiles_n, QWidget *parent = 0, Profil *profil = NULL,  QStandardItemModel *model = NULL);
    ~ProfilDialog();

protected:
    void changeEvent(QEvent *e);
    void accept();

private:
    Ui::ProfilDialog *ui;
    QMaemo5ValueButton *v1;
    QMaemo5ValueButton *v2;
    QMaemo5ValueButton *v3;
    QMaemo5ValueButton *v4;
    bool update;

    void createMeamoButtons();
    void createRadioID();

    int id_ButtonGroup_system;
    int id_ButtonGroup_keyboard;
    int id_ButtonGroup_screen;

    QStandardItemModel *model_of_files;
    bool checkFileInModelAndExist(QFileInfo inf);
    QStringList  list_of_profiles_names;
    Profil * profile;
    QItemSelectionModel* selModelMobil;
    QItemSelectionModel* selModelSMS;
    QItemSelectionModel* selModelIM;
    QItemSelectionModel* selModelEmail;

    QListView * createListView(QItemSelectionModel * select_model);
    QMaemo5ListPickSelector * createMeamoListPick(QListView * list_view);
    void setSelectedItem(QMaemo5ListPickSelector * listpicker, QItemSelectionModel * selModel, QString find );

private slots:
    void on_slider_email_volume_valueChanged(int value);
    void on_slider_im_volume_valueChanged(int value);
    void on_slider_sms_volume_valueChanged(int value);
    void on_slider_ringing_volume_valueChanged(int value);
    void on_ButtonLoadSound_clicked();
    //    void buttonGroup_system_clicked(int);
    //    void buttonGroup_keyboard_clicked(int);
    //    void buttonGroup_screen_clicked(int);
    //    void pokus_clicked(QModelIndex& );

};
#endif // PROFILDIALOG_H
