#ifndef NETWORKPROFILE_H
#define NETWORKPROFILE_H

#include <QWidget>
#include <QtCore/QString>
#include <QSystemNetworkInfo>
QTM_USE_NAMESPACE
class QStandardItemModel;
class QModelIndex;
class QItemSelectionModel;
class QStringList;
class QSettings;
class QTimer;

/** \class NetWorkProfile
  \brief class for setting profile based on network rules
 */
class NetWorkProfile : public QWidget
{
    Q_OBJECT
public:
    explicit NetWorkProfile(QWidget *parent = 0, QSettings *sett = 0);
    void Init();
    void ShowDialog();
    void createModels(QStandardItemModel * cellM, QStandardItemModel * wifiM);

signals:
    void s_network_profile(QString profile);

public slots:
    void SetProfilenames(QStringList  list_of_profiles_n);
    void DeletedProfile(QString name);

private slots:
    void ChangeInCellLocation();

private:
    QSystemNetworkInfo * p_networkcl;
    QTimer *timer;
    QSettings * settings;
    QString profile_Currently;
    QString CellLocation;
    QString WifiName;

    void SetProfile();

    QString FindWifiNameInModel(QString WifiNam);
    QString FindIDLocInModel(QString IDCell);

    QStandardItemModel *model_of_CellId;
    QItemSelectionModel *selModel_CellId;
    QStandardItemModel *model_of_WifiIf;
    QItemSelectionModel* selModel_WifiIf;

    void setProfile();

    QStringList list_of_profiles;

  private slots:
    void ChangeInModel();
    void ChangeInWifiName(QSystemNetworkInfo::NetworkMode,  QString );
};

#endif // NETWORKPROFILE_H
