#include "networkprofile.h"
#include <QtCore/QStringList>
#include <QtCore/QSettings>
#include <QtCore/QDebug> //Debug pro informace
#include <QtGui/QStandardItemModel>
#include <QtGui/QItemSelectionModel>
#include <QtCore/QTimer>
#include "networkdialogdialog.h"

using namespace QtMobility;
/** Constructor.
  Get setting pointer and create network class.
  Connect all signal from networkclass to slot
  and gets name of network
*/
NetWorkProfile::NetWorkProfile(QWidget *parent, QSettings *sett) :
        QWidget(parent)
{
    settings = sett;
    p_networkcl = new QSystemNetworkInfo(this);
    timer = new QTimer(this);
    connect(timer,SIGNAL(timeout()),this,SLOT(ChangeInCellLocation()));
    timer->start(10000);//each 10 seconds shot
    connect(p_networkcl,SIGNAL(networkNameChanged(QSystemNetworkInfo::NetworkMode,QString)),this,SLOT(ChangeInWifiName(QSystemNetworkInfo::NetworkMode,  QString )));
    qDebug()<< "ziskam id============================";
    CellLocation = QString::number(p_networkcl->locationAreaCode());
    qDebug()<< "==================" << CellLocation;
    WifiName = p_networkcl->networkName(QSystemNetworkInfo::WlanMode);
    qDebug()<< "==================" << WifiName;
    model_of_CellId = NULL;
    model_of_WifiIf = NULL;
}


/** SetProfilenames.
Set profiles names
\param list_of_profiles_nf names of profiles
*/
void NetWorkProfile::SetProfilenames(QStringList list_of_profiles_nf)
{
    list_of_profiles = list_of_profiles_nf;
}

/** DeletedProfile.
Slot for name of deleted profile
\param list_of_profiles_nf names of profiles
*/
void NetWorkProfile::DeletedProfile(QString name)
{
    if(name == profile_Currently)
        SetProfile();
}

/** createModels
gets model and create selection models
*/
void NetWorkProfile::createModels(QStandardItemModel * cellM, QStandardItemModel * wifiM)
{
    if((cellM == NULL) || (wifiM == NULL)){
     //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "jeden je null" ;
 }
    model_of_CellId =  cellM;
    selModel_CellId = new QItemSelectionModel(model_of_CellId);
    model_of_WifiIf = wifiM;
    selModel_WifiIf = new QItemSelectionModel(model_of_WifiIf);
    SetProfile();;//set profile
}


/** ChangeInCellLocation.
Slot for change in location
\param list_of_profiles_nf names of profiles
*/
void NetWorkProfile::ChangeInCellLocation()
{
    CellLocation = QString::number(p_networkcl->locationAreaCode());
     WifiName = p_networkcl->networkName(QSystemNetworkInfo::WlanMode);
         qDebug()<< "=====změna v id lov" << CellLocation;
    SetProfile();
}

/** ChangeInWifiName.
Slot for change in wifi name
\param list_of_profiles_nf names of profiles
*/
void NetWorkProfile::ChangeInWifiName(QSystemNetworkInfo::NetworkMode mode,  QString name )
{
    qDebug()<< "změna ve jménu" << name;

    if(mode == QSystemNetworkInfo::WlanMode)
    {
        qDebug()<< "změna ve jménu wifi" << name;
        WifiName = name;
        SetProfile();
    }
}

/** SetProfile.
Set profile based of name of wifi or location id
Find rule in tables and set profile
*/
void NetWorkProfile::SetProfile()
{
    //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "kontrola zda jsou profily null";
    if((model_of_CellId == NULL) || (model_of_WifiIf == NULL)) return;
    //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "bude se ted nastavovoat nový profil";
    profile_Currently = QString("");
    QString str = QString("");

    if(!WifiName.isEmpty())
    {
        // profile_Currently
        str = FindWifiNameInModel(WifiName);
        //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "nalezlo to profil pro wifi sit?  " << str;
        if(str.isEmpty())
        {
            //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "";
            str = FindIDLocInModel(CellLocation);
            profile_Currently = str;
            //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "profil na ic loc " << profile_Currently;
            emit s_network_profile(profile_Currently);
            return;
        } else {
            profile_Currently = str;
            //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "profil na wifi name " << profile_Currently;
            emit s_network_profile(profile_Currently);
            return;
        }
    } else
    {
        //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "wifi neni   " ;
        str = FindIDLocInModel(CellLocation);
        profile_Currently = str;
        emit s_network_profile(profile_Currently);
        return;
    }
    emit s_network_profile(profile_Currently);
}

/** FindIDLocInModel.
Find id location and return name of profile
\param IDCell location id
*/
QString NetWorkProfile::FindIDLocInModel(QString IDCell)
{
    QString name = QString("");
    QList<QStandardItem *> list_of_idcell;

    //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Bude hledat modelu wifi site " ;

    //labels << tr("Name") << tr("Wifi name") << tr("Profile");
    list_of_idcell = model_of_CellId->findItems(IDCell, Qt::MatchExactly , 1);

    if(list_of_idcell.empty())
    {
        //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "nic nanasel " ;
        return name;
    } else
    {
        name = model_of_CellId->item(list_of_idcell.at(0)->row(),2)->data(Qt::DisplayRole).toString();
        //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "nasel ho  " << name;
        return name;
    }
}

/** FindWifiNameInModel.
Find profile in table based in wifiname
\param WifiNam name of wifi
*/
QString NetWorkProfile::FindWifiNameInModel(QString WifiNam)
{
    QString name = QString("");
    QList<QStandardItem *> list_of_wifiname;

    //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Bude hledat modelu wifi site " ;
    //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "pocet radku  v modelu wifi " << model_of_WifiIf->rowCount();
    //labels << tr("Name") << tr("Wifi name") << tr("Profile");
    list_of_wifiname = model_of_WifiIf->findItems(WifiNam, Qt::MatchExactly , 1); //fing wifi name in 1 colum
    if(list_of_wifiname.empty())
    {
        return name;
    } else
    {
        name = model_of_WifiIf->item(list_of_wifiname.at(0)->row(),2)->data(Qt::DisplayRole).toString();
        //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "nasel ho  " << name;
        return name;
    }
}

//===========================================================================
/** ShowDialog
For dialog for modifi calendars and profiles
*/
void NetWorkProfile::ShowDialog()
{
    //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "dialog " ;
    NetWorkdialogDialog dialog(this, settings);
        //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "ma setings " ;
    dialog.SetViews(model_of_CellId,selModel_CellId,model_of_WifiIf,selModel_WifiIf);
        //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "modely " ;
    dialog.SetIDWIFInames(CellLocation, WifiName);
        //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "lokaci a wifi " ;
    dialog.SetProfilenames(list_of_profiles);
        //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "prily " ;
    connect(&dialog,SIGNAL(s_change_model()),this,SLOT(ChangeInModel()));
    dialog.exec();
        //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "konec " ;
    disconnect(&dialog,SIGNAL(s_change_model()),this,SLOT(ChangeInModel()));
}

/** ChangeInModel.
Slot for change in model table
*/
void NetWorkProfile::ChangeInModel()
{
    SetProfile();
}

