#ifndef NETWORKDIALOGDIALOG_H
#define NETWORKDIALOGDIALOG_H

#include <QDialog>

namespace Ui {
    class NetWorkdialogDialog;
}
class QStandardItemModel;
class QModelIndex;
class QItemSelectionModel;
class QSettings;
class QMaemo5ValueButton;
class QStringList;
class QModelIndex;
class QListView;
class QMaemo5ListPickSelector;

/** \class NetWorkdialogDialog
  \brief class for dialog rules
 */
class NetWorkdialogDialog : public QDialog {
    Q_OBJECT
public:
    NetWorkdialogDialog(QWidget *parent = 0, QSettings *sett = 0);
    ~NetWorkdialogDialog();
    void SetViews(QStandardItemModel *model_of_CellId ,
                  QItemSelectionModel *selModel_CellId,
                  QStandardItemModel *model_of_WifiIf ,
                  QItemSelectionModel *selModel_WifiIf);

    void SetProfilenames(QStringList list_of_profiles_nf);
    void SetIDWIFInames(QString idloc, QString wifiname);


protected:
    void changeEvent(QEvent *e);

private:
    Ui::NetWorkdialogDialog *ui;
       QSettings * settings;
       QStringList list_of_profiles;


       bool FindWifiNameInModel(QString WifiNam);
       bool FindIDLocInModel(QString IDCell);

signals:
    void s_change_model();

private slots:
    void on_pushButtonNewrule_clicked();
    void on_tableView_WIFIID_clicked(QModelIndex index);
    void on_tableViewLocationId_clicked(QModelIndex index);
    void createNewRule();
};

#endif // NETWORKDIALOGDIALOG_H
