#include "networkdialogdialog.h"
#include "ui_networkdialogdialog.h"
#include <QtCore/QStringList>
#include <QtCore/QDebug> //Debug pro informace
#include <QtGui/QItemSelectionModel>
#include <QtGui/QStandardItemModel>
#include <QMaemo5InformationBox>
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#include <QMaemo5InformationBox>
#include <QtGui/QMessageBox>
#include "networkdialogedit.h"

/** Constructor.
  Gets pointer to settings and set window title
*/
NetWorkdialogDialog::NetWorkdialogDialog(QWidget *parent, QSettings *sett) :
        QDialog(parent),
        ui(new Ui::NetWorkdialogDialog)
{
    ui->setupUi(this);
    settings = sett;
    setWindowTitle(tr("Network profile"));
}

/** Destructor.
   Delete ui
*/
NetWorkdialogDialog::~NetWorkdialogDialog()
{
    delete ui;
}

void NetWorkdialogDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


/** SetViews.
Set view models, behavior, mode and triggerrs
\param model_of_profiles model of profiles
\param selModel_profiles selection model for profiles
\param model_of_calendars model of calendars
\param selModel_calendars selection model for calendars
*/
void NetWorkdialogDialog::SetViews(QStandardItemModel *model_of_CellId ,
                                   QItemSelectionModel *selModel_CellId,
                                   QStandardItemModel *model_of_WifiIf ,
                                   QItemSelectionModel *selModel_WifiIf)
{
    ui->tableViewLocationId->setModel(model_of_CellId);

    ui->tableViewLocationId->setSelectionModel(selModel_CellId);
    ui->tableViewLocationId->setSelectionBehavior(QAbstractItemView::SelectRows);
    ui->tableViewLocationId->setSelectionMode(QAbstractItemView::SingleSelection);
    ui->tableViewLocationId->setEditTriggers(QAbstractItemView::NoEditTriggers);
    //ui->tableView_2->resizeColumnsToContents();
    ui->tableViewLocationId->horizontalHeader()->setResizeMode(QHeaderView::Stretch);
    //labels << tr("Name") << tr("Wifi name") << tr("Profile");
    ui->tableView_WIFIID->setModel(model_of_WifiIf);
    ui->tableView_WIFIID->setSelectionModel(selModel_WifiIf);
    ui->tableView_WIFIID->horizontalHeader()->setResizeMode(QHeaderView::Stretch);
    ui->tableView_WIFIID->setSelectionBehavior(QAbstractItemView::SelectRows);
    ui->tableView_WIFIID->setSelectionMode(QAbstractItemView::SingleSelection);
    ui->tableView_WIFIID->setEditTriggers(QAbstractItemView::NoEditTriggers);
}

/** SetProfilenames.
Set profiles names
\param list_of_profiles_nf names of profiles
*/
void NetWorkdialogDialog::SetProfilenames(QStringList list_of_profiles_nf)
{
    list_of_profiles = list_of_profiles_nf;

    ui->buttonGroup->setId(ui->radioButtonIDLoc,0);
    ui->buttonGroup->setId(ui->radioButtonWifi,1);

    ui->radioButtonIDLoc->setChecked(true);

}

/** SetIDWIFInames.
Set text for labels
\param idloc location id
\param wifiname wifi name
*/
void NetWorkdialogDialog::SetIDWIFInames(QString idloc, QString wifiname)
{
    if(idloc == "-1")
    {
        ui->labelIDloc->setText(tr("Phone not connected"));
        ui->labelIDLoacName->setText("");
    } else {
        ui->labelIDLoacName->setText(idloc);
    }

    if(wifiname.isEmpty())
    {
        ui->labelWifi->setText(tr("Wifi not connected"));
        ui->labelWifiname->setText(wifiname);
    } else {
        ui->labelWifiname->setText(wifiname);
    }
}


/** createNewRule()
Create new rule for location or wifi
*/
void NetWorkdialogDialog::createNewRule()
{
    int id = ui->buttonGroup->checkedId();
    //check is mobile connected
    if((ui->labelWifiname->text().isEmpty()) && (id == 1))
    {
        QMaemo5InformationBox::information(this, tr("Not connedted to wifi"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    if((ui->labelIDLoacName->text().isEmpty())&& (id == 0) )
    {
        QMaemo5InformationBox::information(this, tr("Mobile not connected"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    if((id == 1) && (FindWifiNameInModel(ui->labelWifiname->text())))
    {
        QMaemo5InformationBox::information(this, tr("This rule for wifi exists"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    if((id == 0) && (FindIDLocInModel(ui->labelIDLoacName->text())))
    {
        QMaemo5InformationBox::information(this, tr("This rule for location exists"), QMaemo5InformationBox::DefaultTimeout);
        return;
    }


    QStandardItemModel *model;
    QList<QStandardItem *> listitems;

    NetWorkDialogEdit dialog(this);
    if(id == 0)//for location
    {
        dialog.SetNameOfLabel(ui->labelIDLoacName->text(), QString(tr("New location rule for: ")));
        model = (QStandardItemModel *) ui->tableViewLocationId->model();//model je ted id loc
        listitems = model->findItems(ui->labelIDLoacName->text());
        if(listitems.empty())//nic nanašel
        {
            dialog.SetProfilenames(list_of_profiles); //dam tomu seznan pro výběr
            int result = dialog.exec();
            if(result)
            {
                //qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "Nove providloooooooooo";
                //nove jmeno pro pravidlo
                listitems.append(new QStandardItem(dialog.GetNameOfRule()));//jmeno pravidla
                listitems.append(new QStandardItem(ui->labelIDLoacName->text()));//nova lokace
                listitems.append(new QStandardItem(dialog.GetNameProfile()));//jmeno profilu
                model->appendRow(listitems);
                emit s_change_model();//vyslu zmenu
                //labels << tr("Name") << tr("Wifi name") << tr("Profile");davam tam id lokace prvna
            }
        }
        else // neco našel a to je špatně
        {
            QMaemo5InformationBox::information(this, tr("This rule exist"), QMaemo5InformationBox::DefaultTimeout);
        }

    } else if(id == 1)//for wifi
    {
        dialog.SetNameOfLabel(ui->labelWifiname->text(), QString(tr("New WiFi rule for: ")));
        model = (QStandardItemModel *) ui->tableView_WIFIID->model(); //model pro wifi
        listitems = model->findItems(ui->labelWifiname->text());
        if(listitems.empty())//nic nanašel
        {
            dialog.SetProfilenames(list_of_profiles); //dam tomu seznan pro výběr
            int result = dialog.exec();
            if(result)
            {
                //qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "Nove providloooooooooo";
                //nove jmeno pro pravidlo
                listitems.append(new QStandardItem(dialog.GetNameOfRule()));//jmeno pravidla
                listitems.append(new QStandardItem(ui->labelWifiname->text()));//nove wifi
                listitems.append(new QStandardItem(dialog.GetNameProfile()));//jmeno profilu
                model->appendRow(listitems);
                emit s_change_model();//vyslu zmenu
                //labels << tr("Name") << tr("Wifi name") << tr("Profile");davam tam id lokace prvna
            }
        }
        else // neco našel a to je špatně
        {
            QMaemo5InformationBox::information(this, tr("This rule exist"), QMaemo5InformationBox::DefaultTimeout);
        }
    }
}

/** on_tableViewLocationId_clicked()
Slot when user click on location
user can modifi or delete rule
*/
void NetWorkdialogDialog::on_tableViewLocationId_clicked(QModelIndex index)
{
    Q_UNUSED(index)
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "kliknutu na idloc";

    QItemSelectionModel *selModel = ui->tableViewLocationId->selectionModel();
    if(!selModel->hasSelection()) return;//no selection retirn
    QModelIndexList list_of_selected = selModel->selectedIndexes(); //get selected
    QStandardItemModel *model = (QStandardItemModel *) ui->tableViewLocationId->model(); //model
    int row = list_of_selected.at(0).row();//get row

    QMessageBox msgBox;
    msgBox.setIcon(QMessageBox::Information);
    msgBox.setText(tr("Delete or modify profile?"));
    msgBox.setEscapeButton(QMessageBox::Cancel);
    QPushButton *CancelButton =  msgBox.addButton(QMessageBox::Cancel);
    QPushButton *DeleteButton = msgBox.addButton(tr("Delete"), QMessageBox::ActionRole);
    QPushButton *modifyButton = msgBox.addButton(tr("Modify"),QMessageBox::DestructiveRole);

    msgBox.exec(); //delete or modifi
    if (msgBox.clickedButton() == DeleteButton) {

        //qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "bude se mazat pravidlo";
        model->removeRow(row);
        selModel->clearSelection();
        emit s_change_model(); //vyslu zmenu
    }else if (msgBox.clickedButton() == modifyButton) {
        NetWorkDialogEdit dialog(this); //modifi
        //labels << tr("Name") << tr("Wifi name") << tr("Profile");davam tam id lokace prvna
        dialog.SetNameOfLabel(list_of_selected.at(1).data().toString(), QString(tr("Change profile for location: ")));
        dialog.SetProfilenames(list_of_profiles); //dam tomu seznan pro výběr
        dialog.SetNameOfRule(list_of_selected.at(0).data().toString()); //dam tomu jmeno pravidla

        int result = dialog.exec();
        if(result)
        {
            //nove jmeno pro pravidlo
            model->item(list_of_selected.at(0).row(),list_of_selected.at(0).column())->setData(QVariant(dialog.GetNameOfRule()),Qt::DisplayRole);
            //new name
            model->item(list_of_selected.at(2).row(),list_of_selected.at(2).column())->setData(QVariant(dialog.GetNameProfile()),Qt::DisplayRole);

            emit s_change_model(); //vyslu zmenu
        }
        selModel->clearSelection();
    }else if (msgBox.clickedButton() == CancelButton) {
        selModel->clearSelection();
        return;
    }
}

/** on_tableView_WIFIID_clicked()
Slot when user click on location
user can modifi or delete rule
*/
void NetWorkdialogDialog::on_tableView_WIFIID_clicked(QModelIndex index)
{
    Q_UNUSED(index)
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "jmeno wifi" ;
    QItemSelectionModel *selModel = ui->tableView_WIFIID->selectionModel();
    if(!selModel->hasSelection()) return;
    QModelIndexList list_of_selected = selModel->selectedIndexes();
    QStandardItemModel *model = (QStandardItemModel *) ui->tableView_WIFIID->model();
    int row = list_of_selected.at(0).row();//get row
    //======================================
    //message box for choose
    QMessageBox msgBox;
    msgBox.setIcon(QMessageBox::Information);
    msgBox.setText(tr("Delete or modify profile?"));
    msgBox.setEscapeButton(QMessageBox::Cancel);
    QPushButton *CancelButton =  msgBox.addButton(QMessageBox::Cancel);
    QPushButton *DeleteButton = msgBox.addButton(tr("Delete"), QMessageBox::ActionRole);
    QPushButton *modifyButton = msgBox.addButton(tr("Modify"),QMessageBox::DestructiveRole);

    msgBox.exec();//======================================
    if (msgBox.clickedButton() == DeleteButton) {

        //qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "bude se mazat pravidlo";
        model->removeRow(row);
        selModel->clearSelection();
        emit s_change_model(); //vyslu zmenu
    }else if (msgBox.clickedButton() == modifyButton) { //show dialog for modifi
        NetWorkDialogEdit dialog(this);
        dialog.SetNameOfLabel(list_of_selected.at(1).data().toString(), QString(tr("Change profile for Wifi: ")));
        dialog.SetProfilenames(list_of_profiles); //dam tomu seznan pro výběr
        //labels << tr("Name") << tr("Wifi name") << tr("Profile");davam tam id lokace prvna
        dialog.SetNameOfRule(list_of_selected.at(0).data().toString()); //dam tomu jmeno pravidla
        int result = dialog.exec();

        if(result)
        {
            ////qDebug() <<  __FILE__ << ":" << __LINE__ << " " << __FUNCTION__ << "OK update profile";
            //nove jmeno pro pravidlo
            model->item(list_of_selected.at(0).row(),list_of_selected.at(0).column())->setData(QVariant(dialog.GetNameOfRule()),Qt::DisplayRole);
            //new name
            model->item(list_of_selected.at(2).row(),list_of_selected.at(2).column())->setData(QVariant(dialog.GetNameProfile()),Qt::DisplayRole);

            emit s_change_model(); //vyslu zmenu
        }
        selModel->clearSelection();
    }   else if (msgBox.clickedButton() == CancelButton) {
        selModel->clearSelection();
        return;
    }
}

/** on_pushButtonNewrule_clicked()
Slot when user click on create new rule button
*/
void NetWorkdialogDialog::on_pushButtonNewrule_clicked()
{
    createNewRule();
}


/** FindIDLocInModel.
Find id location and return name of profile
\param IDCell location id
*/
bool NetWorkdialogDialog::FindIDLocInModel(QString IDCell)
{
    QList<QStandardItem *> list_of_idcell;
    QStandardItemModel *model  ;
     model = (QStandardItemModel *) ui->tableViewLocationId->model();//model je ted id loc

    //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Bude hledat modelu wifi site " ;

    //labels << tr("Name") << tr("Wifi name") << tr("Profile");
    list_of_idcell = model->findItems(IDCell, Qt::MatchExactly , 1);

    return !list_of_idcell.empty();
}

/** FindWifiNameInModel.
Find profile in table based in wifiname
\param WifiNam name of wifi
*/
bool NetWorkdialogDialog::FindWifiNameInModel(QString WifiNam)
{
    QList<QStandardItem *> list_of_wifiname;
    QStandardItemModel *model;
    model  = (QStandardItemModel *) ui->tableView_WIFIID->model(); //model pro wifi

    //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Bude hledat modelu wifi site " ;
    //qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "pocet radku  v modelu wifi " << model_of_WifiIf->rowCount();
    //labels << tr("Name") << tr("Wifi name") << tr("Profile");
    list_of_wifiname = model->findItems(WifiNam, Qt::MatchExactly , 1); //fing wifi name in 1 colum
    return !list_of_wifiname.empty();

}

