#ifndef MAINWINDOW_H
#define MAINWINDOW_H
/*! \file mainwindow.h
    \brief File .h for class MainWindow
\author Jakub Šplíchal <jakub.bzouk@gmail.com>
    Header file
*/
#include <QMainWindow>
#include <QtCore/QSettings>
//#include <QtGui/QSystemTrayIcon>

namespace Ui {
    class MainWindow;
}
class ControlClass;
class QListWidgetItem;
class QMaemo5ListPickSelector;
class QMaemo5ValueButton;
class QStandardItemModel;
class QDBusInterface;
/*!
  \class MainWindow
  \brief Class to display the main window
*/
class MainWindow : public QMainWindow {
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.indt.N9Profil")

public:
            MainWindow(QWidget *parent = 0, Qt::WindowFlags flags = 0);
    ~MainWindow();

    void Init();

public slots:
    void changeInProfiles(QStringList Profiles_Names);
    Q_SCRIPTABLE int top_application();

signals:
    void s_aboutToEnd();
    void s_hide_show();

protected:
    void changeEvent(QEvent *e);

private:
    void createMermoButtons();
    void closeEvent(QCloseEvent *event);

    //! QT Class for storing settings.
    /*!
    *   Class will save the program settings.
    */
    QSettings settings;
    QDBusInterface *connectionInterface;

    Ui::MainWindow *ui;
    ControlClass *p_cnt_class;

    QMaemo5ValueButton *p_set_Profile_button;
    QMaemo5ListPickSelector *p_list_pick_profile;
    QStandardItemModel *p_model_profile_names;
    void setNewIndexDeafaultProfile();

    QMaemo5ValueButton *p_Timed_Profile_button;
    QMaemo5ValueButton *p_Calendar_Profile_button;
    QMaemo5ValueButton *p_IDWifi_Profile_button;
    bool maybeQuit();

private slots:
    void on_pushButtonPhonenum_clicked();
    void on_actionExit_triggered();
    void on_actionAbout_triggered();
    void on_actionAboutQT_triggered();
    void SetTimedProfile();
    void SetCalendarProfiles();
    void SetNetworkProfile();
    void on_listWidgetProfiles_itemClicked(QListWidgetItem* item);
    void on_ButtonNewProfile_clicked();
    void SetDeafaultProfile(QString);
    void SetTimedProfilename(QString);
    void SetCalendarProfilename(QString);
    void SetMetworkProfilename(QString);

    void sendNotif(QString name_of_profile);


};

#endif // MAINWINDOW_H
