/** \file main.cpp
  \brief main + loading translations
  \author Jakub Šplíchal <jakub.bzouk@gmail.com>
 */
#include <QtGui/QApplication>
#include <QtCore/QTextCodec>
#include <QtCore/QLocale>
#include <QtCore/QTranslator>
#include <QtCore/QDebug> //Debug pro informace
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusError>
#include "mainwindow.h"

int main(int argc, char *argv[])
{


    QApplication a(argc, argv);
    Q_INIT_RESOURCE(rcc);
    //names for app and setting class
    a.setOrganizationName("N9Profil");
    a.setApplicationName("N9Profil");
    a.setApplicationVersion("0.1");

    //Text in  UTF-8
    QTextCodec* utf = QTextCodec::codecForName("UTF-8");
    QTextCodec::setCodecForCStrings(utf);
    QTextCodec::setCodecForTr(utf);

    QTranslator t;

    /*! http://www.abclinuxu.cz/clanky/programovani/graficke-programy-v-qt-4-7-lokalizace-a-data-programu
      Sets the application name and the text codec to UTF-8 and
      reads the translation according to the currently set language:
      program name + _ + language of the country
      where language is a two-language code (ISO 639) in lowercase
      and the country is a two-country code (ISO 3166) in capitals,
      eg cs_CZ lupdate N9Profil.pro for updating translation
     */
    t.load(":/translations/" + a.applicationName() + "_" + QLocale::system().name() ); //QLocale::system() vrati info o jaz. systemu
    //qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "bude se nahravat" << (":/translations/" + a.applicationName() + "_" + QLocale::system().name()) ;
    // install language
    a.installTranslator(&t);


    MainWindow w;


    if (!QDBusConnection::sessionBus().isConnected()) {
        qWarning("Cannot connect to the D-Bus session bus.");
        exit(1);
    }

    if (!QDBusConnection::sessionBus().registerService("org.indt.N9Profil")) {
        qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
                                  message()));
        exit(2);
    }

    if (!QDBusConnection::sessionBus().registerObject("/org/indt/N9Profil", &w,
                                                      QDBusConnection::ExportAllContents)) {
        qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
                                  message()));
        exit(3);
    }


    w.Init();//init

    w.show();

    return a.exec();
}

/** \mainpage N9Profile for N900
  N9Profile can create profiles for N900 and set them via libprofile

  \section instal_section Instalation
You can use scratchbox and compile source or use .deb packege <br>
You will need: <br>
\> scratchbox
\> libprofile
\> calendar-backend
\> QT4.6.2 for maemo( in /opt/qt..)

*/

