#include "event.h"
#include <QtCore/QDebug> //Debug pro informace
#include <QtCore/QSettings>
#include <QtCore/QTimer>

/** Constructor.
  Set pointers to NULL and create timer
*/
Event::Event(QObject *parent) :
        QObject(parent)
{
    is_now = false;
    is_old= false;
    timer = new QTimer(this);
    timer->setSingleShot(true);//A single-shot timer fires only once
    connect(timer,SIGNAL(timeout()),this,SLOT(TimerTimeout()));
}

/** GetSummary()
Returns the summary of event
\returns  summary text
*/
QString Event::GetSummary()
{
    return summary;
}

/** GetId()
Returns id of event
\returns id
*/
QString Event::GetId()
{
    return Id_event;
}

/** isNow()
Returns if profile is now
\returns bool is event now
*/
bool Event::isNow()
{
    qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "Is profil now? " << is_now;
    return is_now;
}

/** isOld()
Returns if profile is old
\returns bool is event old
*/
bool Event::isOld()
{
    qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "Is profil old? " << is_old;
    return is_old;
}

/** SetTime
   Set time and data of event
   \param I id of event
   \param des desctription
   \param sum summary
   \param SDate start date
   \param EDate end date
 */
void Event::SetTime(QString I, QString des ,QString sum, QDateTime SDate,QDateTime EDate)
{
    Id_event = I;
    description = des;
    summary = sum;
    qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "Setting date time events name" << sum ;
    start_Date = SDate;
    end_Date = EDate;
    timerSet();
}

/** timerSet
   Check event start end end
 */
void Event::timerSet()
{
    qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "timer will be now set for event " << description ;

    if(start_Date >  QDateTime::currentDateTime()){ //id start date in future
        qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "date in future" ;
        timer->start(QDateTime::currentDateTime().secsTo(start_Date) * 1000 ); // wait to event start
        qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "sec to event start" << QDateTime::currentDateTime().secsTo(start_Date) ;
    } else if(( end_Date <=  QDateTime::currentDateTime()) ) { //is end date in past
        qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "event is old" ;
        is_old = true;
    } else if((start_Date <=  QDateTime::currentDateTime()) && ( end_Date >=  QDateTime::currentDateTime()) ) { //is now ?
        is_now = true;
        qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "event is now" ;
        timer->start(QDateTime::currentDateTime().secsTo(end_Date) * 1000);
        qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "sec to event end" << QDateTime::currentDateTime().secsTo(end_Date) ;
        emit s_event_change(this); //emit signal
    }
}

/** TimerTimeout
   slot for timer
 */
void Event::TimerTimeout()
{
    if((is_now == false) && (is_old == false )){//not not and not old
        is_now = true;
        timer->start(start_Date.secsTo(end_Date) * 1000);//timer to end of event
        qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "sec to event end" << start_Date.secsTo(end_Date) ;
        emit s_event_change(this); //emit signal
    } else if((is_now == true) && (is_old == false)) {
        qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << " end of event " ;
        is_now = false;
        is_old = true;
        emit s_event_change(this);//emit signal
    }
}
