/** \file calendatprofile.h
  \brief   contain class setting profile based on calendar
  \author Jakub Šplíchal <jakub.bzouk@gmail.com>
 */
#ifndef CALENDATPROFILE_H
#define CALENDATPROFILE_H

#include <QWidget>
#include <CCalendar.h>
#include <CMulticalendar.h>
#include <CTodo.h>
#include <CBdayEvent.h>
#include <CEvent.h>

class CCalendar;
class CComponent;
class QStandardItemModel;
class QModelIndex;
class QItemSelectionModel;
class QIcon;
class Event;
class Calendar;
class CMulticalendar;
class QStringList;
class QSettings;
class QTime;

/** \class CalendarProfile
  \brief class for setting calendar profile
  class set profile based o rules
 */
class CalendarProfile : public QWidget
{
    Q_OBJECT
public:
    explicit CalendarProfile(QWidget *parent = 0, QSettings *sett = 0);
    ~CalendarProfile();
    void Init();
    void ShowDialog();

signals:
    void s_calendar_profile(QString profile);

public slots:
    void setProfiles(QStringList  list_of_profiles_n);

private:
    QSettings * settings;
    CMulticalendar* multiCalendar;
    void loadCalendarsAndEvents();
    QVector<Calendar *> vector_of_calendars;
    QIcon createIcon(CalendarColour col);
    Calendar * findCalendar(int Id);

    int wordsCount(QStringList words, QString text);
    QString evaluateEvent( QVector<Event *> vector_ev);
    int getProfilePriority(QString name_of_profile);
    void SetProfile();

    QString eventCurrently;
    QString profile_Currently;

    void createModels();
    void setCalendarModel();

    QStandardItemModel *model_of_calendars;
    QItemSelectionModel *selModel_calendars;
    QStandardItemModel *model_of_profiles;
    QItemSelectionModel* selModel_profiles;

    QTimer *timer;

private slots:
    void event_start(Event * ev);
    void event_stop(Event* ev);
    void TimerTimeout();
    void ChangeInCalendarsCheck();
    void calendarTrack(QString);
};

#endif // CALENDATPROFILE_H
