#include "calendatprofile.h"
#include <QStringList>
#include <QtCore/QSettings>
#include <QtCore/QDebug> //Debug pro informace
#include <QtGui/QStandardItemModel>
#include <QtCore/QVector>
#include <QtCore/QVariant>
#include <QtGui/QPixmap>
#include <QtGui/QItemSelectionModel>
#include <QtCore/QDateTime>
#include <QtCore/QTimer>
#include <QtCore/QTime>
#include <QtDBus/QDBusConnection>
#include "event.h"
#include "calendar.h"
#include "calendarprofilesdialog.h"

static const char* CALENDAR_DBUS_LISTENER_SERVICE =  "com.nokia.calendar";
static const char* CALENDAR_DBUS_OBJECT_PATH =  "/com/nokia/calendar";
static const char* CALENDAR_DBUS_LISTENER_SIGNAL = "dbChange";

/** Constructor.
Setup ui, create multiCalendar, set QSettings pointer, create timer and model
*/
CalendarProfile::CalendarProfile(QWidget *parent, QSettings *sett) :
        QWidget(parent)
{
    multiCalendar = CMulticalendar::MCInstance();
    settings = sett;
    timer = new QTimer(this);
    timer->setSingleShot(true);//A single-shot timer fires only once
    connect(timer,SIGNAL(timeout()),this,SLOT(TimerTimeout()));
    QDBusConnection::sessionBus().connect( "", CALENDAR_DBUS_OBJECT_PATH, CALENDAR_DBUS_LISTENER_SERVICE,CALENDAR_DBUS_LISTENER_SIGNAL,this,SLOT(calendarTrack(QString)));
    createModels();//
}

/** calendarTrack
Slot for signal when db for calendar change
*/
void CalendarProfile::calendarTrack(QString str)
{
    qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << str ;
    qDeleteAll(vector_of_calendars);
    vector_of_calendars.clear();
    profile_Currently = QString("");
    eventCurrently = QString("");
    emit s_calendar_profile(profile_Currently);
    loadCalendarsAndEvents();
}

/**
  V dbusus je funkce
dbus_message_new_signal  	(  	const char *   	 path,
                const char *  	interface,
                const char *  	name
        )

Parameters:
        path 	the path to the object emitting the signal
        interface 	the interface the signal is emitted from
        name 	name of the signal

v DB na calendar je
static const char* CALENDAR_DBUS_LISTENER_SERVICE =  "com.nokia.calendar";
static const char* CALENDAR_DBUS_OBJECT_PATH =  "/com/nokia/calendar";
static const char* CALENDAR_DBUS_LISTENER_SIGNAL = "dbChange";

    dbusMessage = dbus_message_new_signal(CALENDAR_DBUS_OBJECT_PATH,
                      CALENDAR_DBUS_LISTENER_SERVICE,
                      CALENDAR_DBUS_LISTENER_SIGNAL);

                      v QT4
 bool QDBusConnection::connect ( const QString & service, const QString & path, const QString & interface,
 const QString & name, QObject  * receiver, const char * slot )
  */



/** Destructor.
Destructor delete ui
*/
CalendarProfile::~CalendarProfile()
{
    delete multiCalendar;
}

/** TimerTimeout
slot for timer timeout
*/
void CalendarProfile::TimerTimeout()
{
    loadCalendarsAndEvents();
}

/** createModels
create models
*/
void CalendarProfile::createModels()
{
    model_of_profiles = new QStandardItemModel(this);
    selModel_profiles = new QItemSelectionModel(model_of_profiles);
    model_of_calendars = new QStandardItemModel(this);
    selModel_calendars = new QItemSelectionModel(model_of_calendars);
}

/** Init
Init start calendar profile class
This will download first data from calendar
*/
void CalendarProfile::Init()
{
    qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ ;
    // setProfiles(list_of_profiles_n); //profile model
    loadCalendarsAndEvents();
}

/** loadCalendarsAndEvents
Load calendar data
This will download  data from calendar
*/
void CalendarProfile::loadCalendarsAndEvents()
{
    int errorCode = 0;

    QDateTime startofday = QDateTime::currentDateTime();
    startofday.setTime(QTime(0,0)); // time to 0,0
    startofday =  startofday.addDays(-1);
    QDateTime endofday = QDateTime::currentDateTime();
    endofday= endofday.addDays(1);
    endofday.setTime(QTime(23,59)); // time to 23,59
    qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "zacatek" << startofday << "konec" << endofday;
    vector< CComponent * > components;
    QVector<CComponent *> vector_of_events;
    vector < CCalendar  * > vector_of_cal_std = multiCalendar->getListCalFromMc();

    QVector<CCalendar  *> qvector_of_cal = QVector< CCalendar  *>::fromStdVector(vector_of_cal_std); //
    Calendar *cal;
    if(!qvector_of_cal.empty())
    {
        foreach(CCalendar * ccal, qvector_of_cal ){
            //if calendar exist return pointer else create new
            if(( cal = findCalendar(ccal->getCalendarId())) == NULL)
            {
                qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "judela se novy cal ";
                cal = new Calendar(this);
                cal->SetName(QString::fromStdString(ccal->getCalendarName()));
                vector_of_calendars.append(cal);
                connect(cal,SIGNAL(s_eventStart(Event*)),this,SLOT(event_start(Event*)));
                connect(cal,SIGNAL(s_eventStop(Event*)),this,SLOT(event_stop(Event*)));
                cal->SetIcon(createIcon(ccal->getCalendarColor()));
            }
            qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "ziskaj se eventy kalendar" << QString::fromStdString(ccal->getCalendarName());
            qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "id cal " << ccal->getCalendarId();
            qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "start datum " << startofday;
                        qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "end datum " << endofday;
            components = multiCalendar->getComponents(ccal->getCalendarId(),
                                                      1, startofday.toTime_t(),
                                                      endofday.toTime_t(), errorCode);
                                    qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "err  code " << errorCode;
            vector_of_events = QVector<CComponent *>::fromStdVector(components);
            if(!vector_of_events.empty()){
                foreach(CComponent *ccompo, vector_of_events){
                    cal->AddEvent(QString::fromStdString(ccompo->getId()),QString::fromStdString(ccompo->getDescription()),QString::fromStdString(ccompo->getSummary()), QDateTime::fromTime_t(ccompo->getDateStart()),QDateTime::fromTime_t(ccompo->getDateEnd()));
                    qDebug()<< "getId" << QString::fromStdString(ccompo->getId());
                    qDebug()<< " get summary " << QString::fromStdString(ccompo->getSummary());
                    qDebug()<< "getDescription" << QString::fromStdString(ccompo->getDescription());
                }
                cal->DeleteOldEvents();//delete old events
            } else {
                qDebug()<< "Vektor s udalostma je prazdnej ?" ;
            }
           qDeleteAll( components);
           components.clear();
        }
    }
    multiCalendar->releaseListCalendars(vector_of_cal_std);
    setCalendarModel();
    timer->start(QDateTime::currentDateTime().secsTo(startofday.addDays(2)) * 1000 + 1000);//timer set for next day + 1 sec
}

enum CalendarColour;
/** createIcon
Create icon fro calendar
\param col color from maemo
\returns QIcon for calendar
*/
QIcon CalendarProfile::createIcon(CalendarColour col)
{
    qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ ;
    QPixmap pix_map = QPixmap(40,40);
    if(col == COLOUR_DARKBLUE)
    {
        pix_map.fill(QColor("darkblue"));
        return QIcon(pix_map);
    }else if( col == COLOUR_DARKGREEN){
        pix_map.fill(QColor("darkseagreen"));
        return QIcon(pix_map);
    }else if( col == COLOUR_DARKRED){
        pix_map.fill(QColor("darkred"));
        return QIcon(pix_map);
    }else if( col == COLOUR_ORANGE){
        pix_map.fill(QColor("orange"));
        return QIcon(pix_map);
    }else if( col == COLOUR_VIOLET){
        pix_map.fill(QColor("violet"));
        return QIcon(pix_map);
    }else if( col == COLOUR_YELLOW){
        pix_map.fill(QColor("yellow"));
        return QIcon(pix_map);
    }else if( col == COLOUR_WHITE){
        pix_map.fill(QColor("white"));
        return QIcon(pix_map);
    }else if( col == COLOUR_BLUE){
        pix_map.fill(QColor("blue"));
        return QIcon(pix_map);
    }else if( col == COLOUR_RED){
        pix_map.fill(QColor("red"));
        return QIcon(pix_map);
    }else if( col == COLOUR_GREEN){
        pix_map.fill(QColor("green"));
        return QIcon(pix_map);
    }
    pix_map.fill(QColor("white"));
    return QIcon(pix_map);
}

/** setCalendarModel
Sets calendar model
*/
void CalendarProfile::setCalendarModel()
{
    model_of_calendars->clear();
    QStringList labels;
    labels << tr("Name od calendars")  ;
    model_of_calendars->setHorizontalHeaderLabels(labels);
    QList<QStandardItem *>  items;
    QStandardItem *item;

    foreach(Calendar *cal, vector_of_calendars){
        item = new QStandardItem(cal->GetIcon(),cal->GetName());
        item->setCheckable(true);

        settings->beginGroup("CalendarProfileClassCalendars");
        if(settings->value(cal->GetName(), QVariant("0")).toString() == "2"){

            item->setCheckState(Qt::Checked);
        }
        settings->endGroup();
        items.append(item);
        model_of_calendars->appendRow(items);
        items.clear();
    }
}

/** findCalendar
Find calendar
\param Id Id of calendar
\returns poiter to calendar
*/
Calendar * CalendarProfile::findCalendar(int Id)
{
    qDebug()<< "search for calendar";
    foreach(Calendar *cal, vector_of_calendars){
        if(cal->GetId() == Id)
            return cal;
    }
    return NULL;
}

//===========================================================================================
/** setProfiles
Set model for profiles
\param list_of_profiles_n list of profiles
*/
void CalendarProfile::setProfiles(QStringList list_of_profiles_n)
{
    qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "zavolat se a bude se nastavovat))))))))))))))))))))))))))))))))))))))))))))))))))))))" ;
    model_of_profiles->clear();//smazu ho
    QList<QStandardItem *>  items;
    QStandardItem *item;
    qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ ;
    settings->beginGroup("CalendarProfileClass");
    foreach(QString profile, list_of_profiles_n)
    {
        qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "set profile" << profile ;
        item = new QStandardItem(profile);
        items.append(item);
        item = new QStandardItem(settings->value(QString("%1%2").arg(profile,"words"), QVariant("")).toString());
        items.append(item);
        item = new QStandardItem(settings->value(QString("%1%2").arg(profile,"priority"), QVariant("0")).toString());
        qDebug() << "novej model priorita" << settings->value(QString("%1%2").arg(profile,"priority"), QVariant("0"));
        items.append(item);
        model_of_profiles->appendRow(items);
        items.clear();
    }
    qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << settings->value("Novy2priority", 0); ;
    qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << settings->value("Novy2words", "nic") ;
    settings->endGroup();

    QStringList labels;
    labels << tr("Name of profile") << tr("Words") << tr("Priority");
    model_of_profiles->setHorizontalHeaderLabels(labels);

    profile_Currently = QString("");
    eventCurrently = QString("");
    SetProfile();
}

/** event_start
Slot for events start
\param ev event
*/
void CalendarProfile::event_start(Event * ev)
{
    // int i = 0;
    // i = getProfilePriority(evaluateEvent(ev)); //ziskam prioritu
    qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__  << "profil co zacal je spocitana priorita";
    qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__  << "profil cp ted je " << profile_Currently;
    // if(i > getProfilePriority(profile_Currently)){
    qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__  << "start event with bigger priority";
    SetProfile();
    // }
}

/** event_stop
Slot for events stop
\param ev event
*/
void CalendarProfile::event_stop(Event* ev)
{
    qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__  << "event_stop";
    if(eventCurrently == ev->GetId())
    {
        profile_Currently = QString("");
        eventCurrently = QString("");
        SetProfile();
    }
}

/** SetProfile
Set profile based on caledars, events and profiles words
*/
void CalendarProfile::SetProfile()
{
    qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "SetProfile";
    QVector<Event *> vector_ev;
    QString prof = QString("");

    settings->beginGroup("CalendarProfileClassCalendars");
    foreach(Calendar* cal, vector_of_calendars)
    {
        if(settings->value(cal->GetName(), QVariant("0")).toString() == "2"){
            qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "Pro kalendar" << cal->GetName() << "Search for profiles";
            qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "Tak co tam ted je" << settings->value(QString("%1").arg(cal->GetId()), QVariant("0")).toString();

            vector_ev += cal->FindEventsNow();
        }
    }
    settings->endGroup();
    profile_Currently = QString("");
    eventCurrently = QString("");
    if(vector_ev.empty()){
        qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "Found nothing";

        emit s_calendar_profile(profile_Currently);
        return;

    }

    QString str = evaluateEvent(vector_ev);

    //
    qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "Profole for now" << profile_Currently;
    emit s_calendar_profile(profile_Currently);
}

/** evaluateEvent
Method for finding profile for event
\param ev event
*/
QString CalendarProfile::evaluateEvent( QVector<Event *> vector_ev)
{
    QString profile = QString("");
    QStringList list_names;
    int wordscount_old = 0;
    int wordscount_new = 0;
    int priority_old = 0;
    int priority_new = 0;

    foreach(Event * ev, vector_ev)//forech event
    {
        for(int i = 0; i < model_of_profiles->rowCount(); i++) //fing best profiel
        {
            list_names = model_of_profiles->item(i,1)->data(Qt::DisplayRole).toString().split(QRegExp("\\s+"),QString::SkipEmptyParts);
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "list of words" <<  list_names;
            qDebug() << "pro profil " << model_of_profiles->item(i,0)->data(Qt::DisplayRole).toString() << "jsem našel počet stjeenjch " << wordsCount(list_names,ev->GetSummary()) << "a ma proioritu " << model_of_profiles->item(i,2)->data(Qt::DisplayRole).toInt();

            wordscount_new = wordsCount(list_names,ev->GetSummary());
            if(wordscount_new == 0) continue;//pokud nenasel zadan slova pokracuje
            priority_new = model_of_profiles->item(i,2)->data(Qt::DisplayRole).toInt();

            if(priority_new > priority_old)
            {
                qDebug() << "priorita je větsi nez tam byl ";
                qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "count is " <<  wordscount_new;
                wordscount_old = wordscount_new;
                wordscount_new = 0;
                profile = model_of_profiles->item(i,0)->data(Qt::DisplayRole).toString();
                profile_Currently = profile;

                eventCurrently = ev->GetId();

                priority_old = priority_new;
                qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "for profil" <<  profile;
            } else if((priority_new == priority_old) && (wordscount_new > wordscount_old))
            {
                qDebug() << "stejna prio ale vetsi pocet slov";
                qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "count is " <<  wordscount_new;
                wordscount_old = wordscount_new;
                wordscount_new = 0;
                profile = model_of_profiles->item(i,0)->data(Qt::DisplayRole).toString();
                priority_old = priority_new;
                qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "for profil" <<  profile;
                profile_Currently = profile;
                eventCurrently = ev->GetId();
            }
        }
    }
    qDebug() << "budu vracet profil co se na to hodi:" << profile;
    return profile;
}

/**

void CalendarProfile::SetProfile()
{
    qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "SetProfile";
    QVector<Event *> vector_ev;
    QString prof = QString("");

    settings->beginGroup("CalendarProfileClassCalendars");
    foreach(Calendar* cal, vector_of_calendars)
    {
        if(settings->value(cal->GetName(), QVariant("0")).toString() == "2"){
            qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "Pro kalendar" << cal->GetName() << "Search for profiles";
            qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "Tak co tam ted je" << settings->value(QString("%1").arg(cal->GetId()), QVariant("0")).toString();

            vector_ev += cal->FindEventsNow();
        }
    }
    settings->endGroup();

    if(vector_ev.empty()){
        qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "Found nothing";
        profile_Currently = QString("");
        eventCurrently = QString("");
    }

    foreach(Event * ev, vector_ev)
    {
         qDebug() << "pro nejakej event evaluate";
        prof = evaluateEvent(ev);
         qDebug() << "konec evaluate";
        if(!profile_Currently.isEmpty())
        {
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "Profil uz tam ted nastavenej je a to" << profile_Currently;
            if(getProfilePriority(profile_Currently) < getProfilePriority(prof))
            {
                qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "prof je ted" << prof;
                profile_Currently = prof;

                eventCurrently = ev->GetId();
            }
        } else {
            profile_Currently = prof;
            eventCurrently = ev->GetId();
        }

    }
    qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Text:" << "Profole for now" << profile_Currently;
    emit s_calendar_profile(profile_Currently);
}


QString CalendarProfile::evaluateEvent(Event * ev)
{
    QString profile = QString("");
    QStringList list_names;
    int wordscount_old = 0;
    int wordscount_new = 0;
    int priority_old = 0;
    int priority_new = 0;

    for(int i = 0; i < model_of_profiles->rowCount(); i++)
    {

        list_names = model_of_profiles->item(i,1)->data(Qt::DisplayRole).toString().split(QRegExp("\\s+"),QString::SkipEmptyParts);
        qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "list of words" <<  list_names;
        qDebug() << "pro profil " << model_of_profiles->item(i,0)->data(Qt::DisplayRole).toString() << "jsem našel počet stjeenjch " << wordsCount(list_names,ev->GetSummary()) << "a ma proioritu " << model_of_profiles->item(i,2)->data(Qt::DisplayRole).toInt();

        wordscount_new = wordsCount(list_names,ev->GetSummary());
        priority_new = model_of_profiles->item(i,2)->data(Qt::DisplayRole).toInt();

        if(priority_new > priority_old)
        {
            qDebug() << "priorita je větsi nez tam byl ";
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "count is " <<  wordscount_new;
            wordscount_old = wordscount_new;
            wordscount_new = 0;
            profile = model_of_profiles->item(i,0)->data(Qt::DisplayRole).toString();
            priority_old = priority_new;
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "for profil" <<  profile;
        } else if((priority_new == priority_old) && (wordscount_new > wordscount_old))
        {
            qDebug() << "stejna prio ale vetsi pocet slov";
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "count is " <<  wordscount_new;
            wordscount_old = wordscount_new;
            wordscount_new = 0;
            profile = model_of_profiles->item(i,0)->data(Qt::DisplayRole).toString();
            priority_old = priority_new;
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "for profil" <<  profile;
        }
    }
    qDebug() << "budu vracet profil co se na to hodi:" << profile;
    return profile;
}

















QString CalendarProfile::evaluateEvent(Event * ev)
{
    QString profile = QString("");
    QStringList list_names;
    int ccount = 0;
    int x = 0;
    int prio = 0;
    for(int i = 0; i < model_of_profiles->rowCount(); i++)
    {

        list_names = model_of_profiles->item(i,1)->data(Qt::DisplayRole).toString().split(QRegExp("\\s+"),QString::SkipEmptyParts);
        qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "list of words" <<  list_names;



        if(((x = wordsCount(list_names,ev->GetSummary())) > ccount) && (model_of_profiles->item(i,2)->data().toInt() >= prio)){
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "count is " <<  x;
            ccount = x;
            x = 0;
            profile = model_of_profiles->item(i,0)->data(Qt::DisplayRole).toString();
            prio = getProfilePriority(profile);
            qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "for profil" <<  profile;
        }
    }
    return profile;
}
  */


/** getProfilePriority
Priority for profile
\param name_of_profile name of event
*/
int CalendarProfile::getProfilePriority(QString name_of_profile)
{
    if(name_of_profile.isEmpty()) return 0;
    int ro = 0;
    ro =  model_of_profiles->findItems(name_of_profile).at(0)->row(); // najdu  na kterým je to řádku
    qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << " profil " << name_of_profile << "je na řádku" <<  ro;
    qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << " profil " << name_of_profile << " jeho prio je " <<  model_of_profiles->item(ro,2)->data(Qt::DisplayRole).toInt();
    return model_of_profiles->item(ro,2)->data(Qt::DisplayRole).toInt(); // vratim
}

/** wordsCount
Return number of words in event summary
\param words list of words in profile
\param text text in event
*/
int CalendarProfile::wordsCount(QStringList words, QString text)
{
    int count = 0;
    foreach(QString word, words)
    {
        if(text.contains(word,Qt::CaseInsensitive)) ++count;
    }
    qDebug()<< "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "Pocet slov:" <<  count << "v textu" << text << "slova co se maj najit" << words;
    return count;
}

//===========================================================================
/** ShowDialog
For dialog for modifi calendars and profiles
*/
void CalendarProfile::ShowDialog()
{
    CalendarProfilesDialog dialog(this);
    dialog.SetViews(model_of_profiles,selModel_profiles,model_of_calendars,selModel_calendars);
    dialog.SetSettings(settings);
    connect(&dialog,SIGNAL(s_change_calendars()),this,SLOT(ChangeInCalendarsCheck()));
    dialog.exec();
    disconnect(&dialog,SIGNAL(s_change_calendars()),this,SLOT(ChangeInCalendarsCheck()));
}

/** ChangeInCalendarsCheck
Slot for chnages in calendars check
*/
void CalendarProfile::ChangeInCalendarsCheck()
{
    SetProfile();
}
