#include "calendarsetprofiledialog.h"
#include "ui_calendarsetprofiledialog.h"
#include <QtGui/QStandardItemModel>
#include <QtGui/QItemSelectionModel>
#include <QtCore/QModelIndex>
#include <QtCore/QSettings>
#include <QtCore/QDebug> //Debug pro informace
/** Constructor.
Setup ui
*/
CalendarSetProfileDialog::CalendarSetProfileDialog(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::CalendarSetProfileDialog)
{
    ui->setupUi(this);
}

/** SetDialog.
Init dialog
\param profil name of profile
\param text words in profile
\param priority priority for profile
*/
void CalendarSetProfileDialog::SetDialog(QString profil, QString text, int priority)
{
    ui->lineEdit->setText(text);
    ui->label->setText(profil);
    ui->PriorityspinBox->setValue(priority);
    setWindowTitle(profil);
}

/** SetSettings.
Set settings pointer
\param sett pointer to settings class
*/
void CalendarSetProfileDialog::SetSettings(QSettings *sett)
{
    settings = sett;
}

/** Destructor.
Destructor delete ui
*/
CalendarSetProfileDialog::~CalendarSetProfileDialog()
{
    delete ui;
}

/** accept
Slot for accept
*/
void CalendarSetProfileDialog::accept()
{
    done(QDialog::Accepted);
}

/** GetText
Return text
\returns text for profile
*/
QString CalendarSetProfileDialog::GetText()
{
    return ui->lineEdit->text();
}

/** GetPriority
Return priority
\returns priority for profile
*/
int CalendarSetProfileDialog::GetPriority()
{
    return ui->PriorityspinBox->value();
}

/** changeEvent.
changeEvent
\param e event
*/
void CalendarSetProfileDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
