/** \file calendarprofilesdialog.h
  \brief   contain class for show dialog
  \author Jakub Šplíchal <jakub.bzouk@gmail.com>
 */
#ifndef CALENDARPROFILESDIALOG_H
#define CALENDARPROFILESDIALOG_H

#include <QDialog>
class QStandardItemModel;
class QModelIndex;
class QItemSelectionModel;
class QSettings;
namespace Ui {
    class CalendarProfilesDialog;
}

/** \class CalendarProfilesDialog
  \brief class for calendar dialog
  class show dialog for  calendar rules
 */
class CalendarProfilesDialog : public QDialog {
    Q_OBJECT
public:
    CalendarProfilesDialog(QWidget *parent = 0);
    ~CalendarProfilesDialog();

    void SetSettings(QSettings *sett);
    void SetViews(QStandardItemModel *model_of_profiles ,
                  QItemSelectionModel *selModel_profiles,
                  QStandardItemModel *model_of_calendars ,
                  QItemSelectionModel *selModel_calendars);

signals:
    void s_change_calendars();
    void s_change_profiles();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::CalendarProfilesDialog *ui;
    QSettings *settings;

private slots:
    void on_Profile_tableView_clicked(QModelIndex index);
    void on_CalendartableView_clicked(QModelIndex index);
};

#endif // CALENDARPROFILESDIALOG_H
