/** \file calendar.h
  \brief   contain class for saving calendar data
  \author Jakub Šplíchal <jakub.bzouk@gmail.com>
 */
#ifndef CALENDAR_H
#define CALENDAR_H
#include <QtCore/QVector>
#include <QObject>
#include <QtGui/QIcon>
class Event;
class QDateTime;

/** \class Calendar
  \brief class for saving calendar data
  class store calendar data and events in calendar
 */
class Calendar : public QObject
{
Q_OBJECT
public:
    explicit Calendar(QObject *parent = 0);
    void AddEvent(QString id, QString des ,QString sum, QDateTime SDate, QDateTime EDate);
    void SetName(QString n);
    void SetId(int i);
    int GetId();
    QString GetName();
    Event * findEvent(QString i);
    void SetIcon(QIcon ico);
    QIcon GetIcon();
    QVector<Event *> FindEventsNow();
    void DeleteOldEvents();
    void DeleteEvent(QString id);
signals:
    void s_eventStart(Event *);
    void s_eventStop(Event *);

private slots:
    void EventChanged(Event * ev);

private:
    int Id_cal;
    QString name_of_calendar;
    QVector<Event *> vector_calendars_events;
    QIcon icon;

};

#endif // CALENDAR_H
