# -*- coding: utf-8 -*-

"""
Module implementing BookmarkEdit.
"""

from PyQt4.QtGui import QMainWindow
from PyQt4.QtGui import *
from PyQt4.QtCore import pyqtSignature

from Ui_bookmarkedit import Ui_MainWindow
from helper.xmlbookmark import XmlBookmark
from helper.server import Server

class BookmarkEdit(QMainWindow, Ui_MainWindow):
    """
    Class documentation goes here.
    """
    def __init__(self, parent = None):
		"""
		Constructor
		"""
		QMainWindow.__init__(self, parent)
		self.parentWindow = parent
		self.setupUi(self)
		try :
			self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
			USE_MAEMO=True
		except :
			USE_MAEMO=False	
		self.action = 0
    
    @pyqtSignature("")
    def on_m_bu_cancel_clicked(self):
		self.m_le_servername.setText("")
		self.m_le_server.setText("")
		self.m_le_user.setText("")
		self.m_le_password.setText("")
		self.m_le_port.setText("21")
		self.m_cb_connection_type.setCurrentIndex(0)
		self.parentWindow
		self.hide()
    
    @pyqtSignature("")
    def on_m_bu_add_server_clicked(self):
		xmlBookmark = XmlBookmark(self)
		if not xmlBookmark.initialize():
			QMessageBox.inform(self.parentWindow,  "FTP", "Bookmarklist can not be loaded")
			return
			
		newserv = Server(self.m_le_servername.text(), self.m_le_server.text(), self.m_le_user.text(),  self.m_le_password.text(),  self.m_le_port.text(),  self.m_cb_connection_type.currentText())
	
		#Update Bookmark = action = 2
		if self.action == 2:
			xmlBookmark.updateServer(newserv)
			self.action =1
			self.m_bu_add_server.setText("Add Server")

		else:
			if self.m_le_servername.text() == "":
				QMessageBox.information(self,  "FTP",  "Enter a servername at least!")
				return

			if xmlBookmark.doesBookmarkExist(self.m_le_servername.text()):
				ret = QMessageBox.question(self,  "FTP Delete", "Bookmarkname already exists. Do you want to update the existing bookmark?",  "",  "No")
				if ret == 0:		
					print "Bookmark will be updated!"
					xmlBookmark.updateServer(newserv)
			else:
				xmlBookmark.addServer(newserv)
			
		self.m_le_servername.setText("")
		self.m_le_server.setText("")
		self.m_le_user.setText("")
		self.m_le_password.setText("")
		self.m_le_port.setText("21")
		self.m_cb_connection_type.setCurrentIndex(0)
		self.m_le_servername.setEnabled(True)
		self.parentWindow.readList()
		self.hide()
		
    def editServer(self,  servername):
		self.action = 2
		self.m_bu_add_server.setText("Update Bookmark")
		self.m_le_servername.setEnabled(False)

		xmlBookmark = XmlBookmark(self)
		if not xmlBookmark.initialize():
			QMessageBox.inform(self.parentWindow,  "FTP", "Bookmarklist can not be loaded")
		else:
			server = xmlBookmark.getServer(servername)
			self.m_le_servername.setText(servername)
			self.m_le_server.setText(server.server)
			self.m_le_user.setText(server.login)
			self.m_le_password.setText(server.password)
			
			port = server.port
			if port =="":
				port ="21"
			self.m_le_port.setText(port)
			connectiontype = server.connection
			if connectiontype == "FTP":
				self.m_cb_connection_type.setCurrentIndex(0)
			else:
				self.m_cb_connection_type.setCurrentIndex(1)
    
    @pyqtSignature("QString")
    def on_m_cb_connection_type_currentIndexChanged(self, p0):
        if p0 == "FTP" and self.m_le_port.text()=="22":
			self.m_le_port.setText("21")
        elif p0 != "FTP" and self.m_le_port.text() == "21":
			self.m_le_port.setText("22")
