#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-
#
# n900Fly
#
# Copyright (c) 2009 cpscotti (Clovis Peruchi Scotti)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
#
# BAD CODE DISCLAIMER:
# This is my first maemo app AND my first gtk needing some "concurrency".. this is BAD code... but.. it works.. =]
#
# [cpscotti, roboscotti, scotti@ieee.org]

import hildon
import gtk
import osso

import jumpBE
import time

import gconf

class n900Fly (hildon.Window):
	
	def __init__(self):
		hildon.Window.__init__ (self)

		self.running = True
		self.idle = False

		self.loadConf()

		self.set_title("n900Fly")
		self.build_gui()
		self.show()
		self.connect("delete-event",self.on_close)
		self.connect("focus-in-event",self.on_infocus)
		self.connect("focus-out-event",self.on_outfocus)

		while gtk.events_pending():
			gtk.main_iteration(False)
		
		self.be = jumpBE.JumpBe()
		self.main_loop()

	def main_loop(self):
		while self.running:
			if self.idle:
				while gtk.events_pending():
					gtk.main_iteration(False)
				#print "idle"
				time.sleep(0.3)
				continue
			for step in self.be.doAcqui():
				if self.idle:
					break
				if len(step) > 0:
					self.status_label.set_text(step[0])
					while gtk.events_pending():
						gtk.main_iteration(False)
				else:
					while gtk.events_pending():
						gtk.main_iteration(False)
					if not self.running:
						break

			self.tof_label.set_text("Time of flight: " + str(self.be.flightTime) + "s")
			self.hof_label.set_text("Height: " + str(self.be.flightHeight) + "m")
			if self.be.flightHeight > self.record:
				self.record = self.be.flightHeight
				self.top_label.set_text("Your record is: " + str(self.record) + "m")

			while gtk.events_pending():
				gtk.main_iteration(False)
			
			if not self.running:
				break
			time.sleep(1)

	def loadConf(self):
		self.client = gconf.client_get_default ()
		self.client.add_dir ("/apps/n900fly", gconf.CLIENT_PRELOAD_NONE)
		if not self.client.dir_exists("/apps/n900fly"):
			self.client.set_float("/apps/n900fly/record", 0.0)
			self.client.suggest_sync()
		self.record = self.client.get_float("/apps/n900fly/record")

	def saveConf(self):
		self.client.set_float("/apps/n900fly/record",self.record)
		self.client.suggest_sync()

	def build_gui(self):
		menu = self.create_menu()
		menu.show_all()
		self.set_app_menu(menu)

		self.box_v = gtk.VBox(False,0)
		self.add(self.box_v)

		if self.record == 0.0:
			self.top_label = gtk.Label("Go on! Throw it!")
		else:
			self.top_label = gtk.Label("Your record is: " + str(self.record) + "m")
		
		self.box_v.pack_start(self.top_label,True, True, 0) #expand, fill, padding
		self.top_label.show()

		self.status_label = gtk.Label("Waiting for Take Off")
		self.box_v.pack_start(self.status_label,True, True, 0)
		self.status_label.show()

		self.tof_label = gtk.Label("Time of Flight: 0.0")
		self.box_v.pack_start(self.tof_label,True, True, 0)
		self.tof_label.show()

		self.hof_label = gtk.Label("Height of Flight: 0.0")
		self.box_v.pack_start(self.hof_label,True, True, 0)
		self.hof_label.show()

		self.box_end_h = gtk.HBox(False,0)
		self.box_v.pack_start(self.box_end_h)

		self.quit_bt = gtk.Button("Quit")
		self.quit_bt.connect("clicked", self.on_close)
		self.box_end_h.pack_start(self.quit_bt,True, True, 0)
		self.quit_bt.show()

		self.ab_bt = gtk.Button("About")
		self.ab_bt.connect("clicked", self.on_about)
		self.box_end_h.pack_start(self.ab_bt,True, True, 0)
		self.ab_bt.show()

		self.box_end_h.show()

		self.box_v.show()

		hildon.hildon_banner_show_information(self, '', "Use this program at your own risk. Developer is not responsible for whatever happens!")

	def on_close(self, *args):
		self.idle = False
		self.running = False
		self.saveConf()

	def on_infocus(self, *args):
		self.idle = False
		#print "In focus"

	def on_outfocus(self, *args):
		self.idle = True
		#print "Out of focus"

	def create_menu(self):
		menu = hildon.AppMenu()
		
		self.reset_menu_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		label = 'Reset Record'
		self.reset_menu_button.set_label(label)
		self.reset_menu_button.connect("clicked", self.on_reset)
		menu.append(self.reset_menu_button)
		
		self.ab_menu_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		label = 'About'
		self.ab_menu_button.set_label(label)
		self.ab_menu_button.connect("clicked", self.on_about)
		menu.append(self.ab_menu_button)

		self.quit_menu_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		label = 'Quit'
		self.quit_menu_button.set_label(label)
		self.quit_menu_button.connect("clicked", self.on_close)
		menu.append(self.quit_menu_button)
		return menu

	def on_reset(self, *args):
		self.record = 0.0
		self.client.set_float("/apps/n900fly/record",self.record)
		self.client.suggest_sync()
		self.top_label.set_text("Go on! Throw it!")

	def on_about(self, *args):
		dialog = gtk.AboutDialog()
		dialog.set_name("n900Fly")
		dialog.set_logo_icon_name("n900Fly")
		dialog.set_comments('Free-Fall Stopwatch and Distance Estimator. Irresponsibly throw your phone into the air and check how high it goes!')
		dialog.set_version("0.1.4")
		dialog.set_copyright("By Clovis Peruchi Scotti (aka cpscotti)")
		dialog.set_website("www.das.ufsc.br/~scotti")
		dialog.connect ("response", lambda d, r: d.destroy())
		dialog.show()

if __name__ == "__main__":
	fend = n900Fly()
