# -*- coding: utf-8 -*-
#
# n900Fly
#
# Copyright (c) 2009 cpscotti (Clovis Peruchi Scotti)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# [cpscotti, roboscotti, scotti@ieee.org]

import math
import time

class JumpBe():
	def __init__(self):
		self.start = 0.0
		self.end = 0.0
		self.flightTime = 0.0
		self.flightHeight = 0.0
	
	
	def doAcqui(self):
		"""
		This is an iterator that [waits for free fall, set start t, wait for end, set end, compute]
		"""
		while True:
			v = get_abs(acc_read())
			if v < 400:
				break
			time.sleep(1/20) # accel documentation states that 25Hz is ok.. so... we get 20... hehehe
			yield []
		self.start = time.time()
		yield ["Fly pelican, fly!!"]
		while True:
			v = get_abs(acc_read())
			if v > 500:
				break
			time.sleep(1/20) # accel documentation states that 25Hz is ok.. so... we get 20... hehehe
			yield[]
		self.end = time.time()
		yield ["The eagle has landed"]
		self.flightTime = math.floor((self.end - self.start)*100)/100
		self.flightHeight = math.pow(self.flightTime/2,2)*9.8/2 # (a*t^2)/2 - distance.
		self.flightHeight = math.floor(self.flightHeight*10)/10
	
	def TextModeRun(self):
		for step in self.doAcqui():
			if len(step) > 0:
				print step[0]
		print "Time of flight: " + str(self.flightTime) + "s"
		print "Height: " + str(self.flightHeight) + "m"


def acc_read():
	f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
	coords = [int(w) for w in f.readline().split()]
	f.close()
	return coords
	
def get_abs(v):
	return math.sqrt(math.pow(v[0],2)+math.pow(v[1],2)+math.pow(v[2],2))

if __name__ == '__main__':
	be = JumpBe()
	be.TextModeRun()