import gtk
from ..lgc import mutils,mtags
from ..lgc import ystorage
from ..lgc.yentry import YEntry
from tagtoolbar import TagToolbar

class Ui(gtk.Table):

    def __init__(self, window):
        gtk.Table.__init__(self, 7, 2)
        
        self.parentWnd = window
        self.__table = self
        self.__table.set_row_spacings(0)
        self.__table.set_col_spacings(0)
        
        self.__table.set_border_width(0)
        self.__table.set_size_request(1, -1)
        
        self.__video = None
        
        
    def setVideo(self, video):
        print ">>>>set details"
        self.__video = video
        if video == None:
            bgColor = self.parentWnd.get_style().bg[gtk.STATE_SELECTED]
            #top 
            self.detailsTopImg = gtk.Image();
            self.detailsTopImg.set_from_pixbuf(ystorage.THUMB_LOAD)
            self.detailsTitle = gtk.Label();
            
            self.detailsDesc = gtk.Label()
            self.dateAdded = gtk.Label()
            self.detailsCat = gtk.Label()
            self.detailsTags = TagToolbar(mtags.getTagNames(),4, self.cb_toggleTag)
            
            ag = [[self.detailsTopImg, self.detailsTitle],
                  [gtk.Label("Description"), self.detailsDesc],
                  [gtk.Label("Date added"), self.dateAdded],
                  [gtk.Label("Category"), self.detailsCat],
                  [gtk.Button("Tags"), self.detailsTags]]
            
            pos = 0
            for [label, obj] in ag:
                label.set_alignment(1, 0)
                
                if isinstance(label, gtk.Label):
                    label.set_justify(gtk.JUSTIFY_RIGHT)
                    label.set_markup("<span  font_desc=\"Sans Bold 12\">"+label.get_text()+"</span>")
                elif isinstance(label, gtk.Button):
                    label.set_size_request(60,40)
                    label.connect("clicked", self.cb_tags)

                a = gtk.Alignment(1, 0)
                a.set_property('left-padding', 5)
                a.set_property('top-padding', 3)
                a.set_property('bottom-padding', 3)
                a.add(label)
                
                #
                self.__table.attach(mutils.addBg(a, bgColor), 0, 1, pos, pos+1, gtk.FILL, gtk.FILL)
                
                a = gtk.Alignment(0, 0)
                a.set_property('left-padding', 5)
                a.set_property('top-padding', 3)
                a.set_property('bottom-padding', 3)

                if isinstance(obj, gtk.Label):
                    obj.set_alignment(0, 0)
                    obj.set_justify(gtk.JUSTIFY_LEFT)
                    obj.set_line_wrap(True)
                else:
                    obj.set_size_request(500, 40)
                    obj.show()
                
                #TODO: bug in maemo gtkrc?
                if obj == self.detailsDesc: #pos == 1
                    if mutils.isMaemo():
                        obj.set_usize(340, 140)
                    else:
                        obj.set_size_request(340, 200)
                
                a.add(obj)
                #gtk.gdk.color_parse("#DDDDDD")
                self.__table.attach(mutils.addBg(a, bgColor), 1, 2, pos, pos+1, gtk.EXPAND|gtk.FILL, gtk.FILL, 0, 0)
                
                pos = pos + 1
            
            self.__table.set_row_spacing(0, 10)
            
            #fill empty space
            self.__table.attach(gtk.Label(), 0, 5, 5, 6)
            
            #create go back button
            hbox = gtk.HBox()
            
            #XXX: buttons moved from here in toolbar
            hbox.show_all()
            self.__table.attach(hbox, 0, 5, 6, 7, gtk.FILL, 0)
            
            self.__table.show_all()
        #set video information
        else:
            videoTags = mtags.getEntryTags(video.getVideoId())
            self.detailsTags.generateButtons(mtags.getTagNames(), videoTags)
            #TODO: gtk annoyance fix: main window got resized
            self.set_size_request(self.allocation.width, self.allocation.height)

            self.detailsTopImg.set_from_pixbuf(video.thumbpix);
            self.detailsTitle.set_markup('<span font_desc="Sans 12">'+video.title+'</span>\n<span  font_desc="Sans Bold 10" foreground="#E66C2C">'+str(video.rating)+'/5</span>'+
                                         '  <span foreground="#555555" font_desc="Sans 10">'+str(video.views)+' views</span>\n'+
                                         '<span font_desc="Sans Bold 10">'+YEntry.formatDuration(video.duration)+' </span>'+
                                         '  <span foreground="#FF6666" font_desc="Sans Bold 10">'+video.author+' </span>');
            #foreground="#555555"
            self.detailsDesc.set_markup('<span  font_desc="Sans 10">'+mutils.escapeHtml(video.desc)+' </span>');
            self.dateAdded.set_markup('<span font_desc="Sans 10">'+video.added+' </span>');
            self.detailsCat.set_markup('<span font_desc="Sans 10">'+video.cat+' </span>');
            #TODO: here
            #self.detailsTags.set_markup('<span font_desc="Sans 10">'+video.tags+' </span>');
    
    def showChildren(self, show):
        for child in self.__table.get_children():
            if show:
                child.show()
            else:
                child.hide()
    
    def get_width(self):
        return self.__table.allocation.width
        
        
    def cb_tags(self, widget, args=None):
        from ..ui import mtags as ui_mtags
        from ..lgc import mtags as lgc_mtags
        ui_mtags.showDialog(lgc_mtags.getTagNames(), 
                            lgc_mtags.createTag,
                            lgc_mtags.destroyTag)
        self.detailsTags.generateButtons(lgc_mtags.getTagNames())
    
    
    def cb_toggleTag(self, tagname, pressed):
        if pressed:
            mtags.addTag(self.__video, tagname)
        else:
            mtags.delTag(self.__video, tagname)

def createDetails(window):
    ui = Ui(window)
    #frame = gtk.Frame()
    #frame.add(ui)
    return ui
         
#    def expose(self, widget=None, event=None, data=None):
#        print ">>>details expose ",event," "#,self.do_expose_event
#        return False
        