import gtk, sys
sys.path.append("../src")
from ui.widgets import *

CMD_MPLAYER = "mplayer -osdlevel 3 -correct-pts -- %s".split()

def setPref(var, val):
    print var + " " + str(val)

def createPrefPageMplayer():
    pg = gtk.Table(1,2,False)
    cmd = gtk.Entry()
    set = gtk.Button("apply")
    cmd.set_text("mplayer -nofs")
    pg.attach(cmd, 0, 1, 0, 1)
    pg.attach(set, 1, 2, 0, 1)
    set.connect("clicked", lambda w, p: setPref("mplayer", cmd.get_text()), None)
    return pg

def createPrefPageYoutubeDl():
    pg = gtk.Table(1,2,False)
    cmd = gtk.Entry()
    set = gtk.Button("apply")
    cmd.set_text("youtube-dl-x")
    pg.attach(cmd, 0, 1, 0, 1)
    pg.attach(set, 1, 2, 0, 1)
    set.connect("clicked", lambda w, p: setPref("youtube-dl", cmd.get_text()), None)
    return pg

def createPrefPageThemes():
    pg = gtk.Table(1,2,False)
    set = gtk.Button("apply")
    cbx = SimpleComboBox(False)
    cbx.append_item("none", None, lambda w, p: setPref("none", None))
    cbx.append_item("black1", None, lambda w, p: setPref("black", None))
    pg.attach(cbx, 0, 1, 0, 1)
    pg.attach(set, 1, 2, 0, 1)
    return pg

def createEditableCbx():
    pg = gtk.Table(1,2,False)
    set = gtk.Button("apply")
    cbx = SimpleComboBox(False)
    cbx.append_item("------", None, lambda w, p: setPref("none", None))
    cbx.append_item("add mtag", None, lambda w, p: setPref("none", None))
    cbx.append_item("black1", None, lambda w, p: setPref("black", None))
    cbx.append_item("black1", None, lambda w, p: setPref("black", None))
    cbx.append_item("black1", None, lambda w, p: setPref("black", None))
    pg.attach(cbx, 0, 1, 0, 1)
    pg.attach(set, 1, 2, 0, 1)
    return pg

def createPrefPageMisc():
    pg = gtk.Table(1,2,False)
    set = gtk.Button("apply")
    lbl = gtk.Label("entries per page")
    spin = gtk.SpinButton(adjustment=gtk.Adjustment(value=10, lower=10, upper=100, step_incr=5, page_incr=5, page_size=5), climb_rate=5, digits=0)
    spin.set_range(10, 100)
    spin.set_value(10)
    pg.attach(lbl, 0, 1, 0, 1)
    pg.attach(spin, 1, 2, 0, 1)
    pg.attach(set, 2, 3, 0, 1)
    
    set.connect("clicked", lambda w, p: setPref("per_page", spin.get_value_as_int()), None)
    return pg


if __name__ == "__main__":
    print CMD_MPLAYER
    print " ".join(CMD_MPLAYER)
    
    dia = gtk.Dialog('Window Title',
                     None,#somewidget.get_toplevel(),  #the toplevel wgt of your app
                     gtk.DIALOG_DESTROY_WITH_PARENT,  #binary flags or'ed together gtk.MODAL_DIALOG
                     (
                      #"Play Now", 77, 
                      gtk.STOCK_CLOSE, gtk.RESPONSE_CLOSE))
    #dia.vbox.pack_start(gtk.Label('Do you want to play a game?'))
    tabs = gtk.Notebook()
    tabs.set_tab_pos(gtk.POS_TOP)
    page = createEditableCbx()
    tabs.append_page(page, gtk.Label('ecbx'))
    page = createPrefPageMisc()
    tabs.append_page(page, gtk.Label('misc'))
    page = createPrefPageMplayer()
    tabs.append_page(page, gtk.Label('mplayer'))
    page = createPrefPageYoutubeDl()
    tabs.append_page(page, gtk.Label('youtube-dl'))
    page = createPrefPageThemes()
    tabs.append_page(page, gtk.Label('themes'))
    dia.vbox.pack_start(tabs)
    dia.show_all()
    dia.show()
    result = dia.run()
    if result == 77:
       pass
    elif result == gtk.RESPONSE_CLOSE:
       pass
    dia.destroy()