from string import atoi,atof
import sys, os, gtk

class YEntry:
    def __init__ (self, title, url, author, tags, thumbpix, thumburl):
        self.title = title
        self.url = None
        self.author = author
        self.tags = tags
        self.thumbpix = thumbpix
        self.thumburl = thumburl
        self.percentDl = 0
        self.duration = 0
        self.downloadedKb = 0
        self.rating = 0
        self.videoId = None
        self.views = "1234321"
        self.desc ="Yada yada, bla bla, i  don't have a good description. Should stop drinking (coffee)"
        self.added = "2008 BC"
        self.cat = "Comics"
        self.tags = "tag1, tag2, tag3, tag4,tag2, tag3, tag4"
        self.related = None
        
        #volatile members
        self.thumbW = -1
        self.dispAnim = -1
        self.slideAnim = False
        self.imgCache = None
        self.dirty = True
        
        self.setUrl(url)
        self.setThumbPix(thumbpix)
        

    def isStored(self):
        storagePath = ystorage.getVideoStoragePath(self)
        if os.path.isfile(storagePath):
            return True
        return False

    def isCached(self):
        cachePath =ystorage.getVideoCachePath(self)
        if os.path.isfile(cachePath):
            return True
        return False
    
    def setThumbPix(self, thumbpix):
        self.thumbpix = thumbpix;
        if (self.thumbpix != None):
            self.thumbW = thumbpix.get_width()
        
    def setRating(self, value):
        if value < 0:
            value = 0
        self.rating = value
    
    def setUrl(self, url):
        self.url = url
        self.videoId = self.getVideoId()

    #time format
    def formatDuration(duration):
        str = ""
        min = duration/60
        sec = duration%60
        
        if (min < 10):
            str += "0"
        str = "%s%d" %(str, min);
        str +=":"
        if (sec < 10):
            str += "0"
        str = "%s%d" %(str, sec);
        return str    
    formatDuration = staticmethod(formatDuration)
    
    #load an youtube entry from the network response
    #@param cli: youtube client
    #@param video: xml video entry
    def loadVideoFromResp(video, cli):
        thumb_url = cli.get_smallest_thumbnail(video)
        href_url = video.link[0].href
        yentry = YEntry(video.title.text, href_url, cli.get_author(video), "tagS", None, thumb_url)
        yentry.setThumbPix(ystorage.THUMB_LOAD)
        yentry.duration = cli.get_duration(video)
        yentry.setRating(cli.get_average(video))
        yentry.desc = cli.get_description(video)
        yentry.cat = cli.get_cat(video)
        yentry.added = cli.get_date(video)
        yentry.views = cli.get_viewed(video)
        yentry.related = cli.get_related(video)
        #try to update the size from the storage
        #then from the cache
        ystorage.updateEntrySize(yentry)
        return yentry
    loadVideoFromResp = staticmethod(loadVideoFromResp)
    
    def getVideoId(self):
        if (self.videoId == None):
            self.videoId = self.url.split("=")[1].split("&")[0];
        return self.videoId
    
    def serializeToString(self):
        data = str(self.duration)+"\n";     #0
        data += self.title+"\n";            #1
        data += self.url+"\n";              #2
        data += str(self.rating)+"\n";      #3
        data += self.desc.replace("\n", "<br>").replace("\r", "<br>")+"\n";
        data += self.cat+"\n";              #5
        data += self.added+"\n";            #6
        data += str(self.views)+"\n";       #7
        data += str(self.related)+"\n";     #8
        data += str(self.author)+"\n";      #9
        return data
    
    def deserializeFromString(self, data):
        toks = data.split("\n");
        self.duration = atoi(toks[0].strip())
        self.title = toks[1].strip()
        self.url = toks[2].strip()
        self.setRating(atof(toks[3].strip()))
        self.desc = toks[4].strip().replace("<br>", "\n")
        self.cat = toks[5].strip()
        self.added = toks[6].strip()
        self.views = atoi(toks[7].strip())
        self.related = toks[8].strip()
        self.author = toks[9].strip()

from conf import *
import ystorage