import time, os

__maemo = False
try:
    import hildon
    __maemo = True
except:
    pass

def isMaemo():
    return __maemo

__dbg_time = time.clock()

def dbgTime(info=""):
    print "###DeltaTime[",info,"]: ",str(time.clock()-__dbg_time)


def enableBtnImages(widget, enable=True):
    settings = widget.get_settings()
    settings.set_property( "gtk-button-images", enable)
    
def enableFriendlyScroll(widget, enable=True):
    try:
        hildon.hildon_helper_set_thumb_scrollbar(widget, enable)
    except:
        print "finger friendly scrollbar not available"

#color is like "#FFAAAA"
#wraps a widget in a event box with a bg color
def addBg(widget, color, border=0):
    import gtk
    eb = gtk.EventBox()
    eb.show()
    if color != None:
        eb.modify_bg(gtk.STATE_NORMAL, color)
    if border > 0:
        eb.set_border_width(border)
    eb.add(widget)
    return eb
    
#TODO: state of the art html escape function
def escapeHtml(text):
    return text.replace('&', '&amp;')

def log(msg):
    #save the user to add another dependency here: python-osso 
    if __maemo:
        cmd = "dbus-send --session --print-reply --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \"string:%s\"&" %msg
        os.system(cmd)
    cmd ="ERROR %s" %msg
    print cmd
    import traceback, sys
    traceback.print_exc(file=sys.stdout)
    
def info(msg):
    #save the user to add another dependency here: python-osso 
    if __maemo:
        cmd = "dbus-send --session --print-reply --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \"string:%s\"&" %msg
        os.system(cmd)
    cmd ="[INFO] %s" %msg
    print cmd
    
def __bsearch(lst, val, i, j):
    if i > j:
        return -1
    h = i + (j - i) / 2
    if   val < lst[h]:
        return __bsearch(lst, val, i, h - 1)
    elif val > lst[h]:
        return __bsearch(lst, val, h + 1, j)
    else:
        return h

def __binsert(lst, val, i, j):
    if i > j:
        lst.insert(i, val)
        return i
    h = i + (j - i) / 2
    if   val < lst[h]:
        return __binsert(lst, val, i, h - 1)
    elif val > lst[h]:
        return __binsert(lst, val, h + 1, j)
    else:
        return h
 
def bsearch(lst, val):
    if lst == None:
        return -1
    return __bsearch(lst, val, 0, len(lst) - 1)

def binsert(lst, val):
    return __binsert(lst, val, 0, len(lst) - 1)

if __name__ == "__main__":
    print bsearch([1,2,3,4,5], 99)
    print bsearch(['mus', 'cars'], 'mus')
    print bsearch(['mus', 'cars'], 'cars')
    