#!/usr/bin/python
import urllib2
import re
import traceback

class Southpark:
    search_feed = "http://www.southparkstudios.com/feeds/season_json.jhtml?season="
    video_name_re = re.compile(r', "t": "([^"]+)"')
    
    def __init__(self, data=""):
        self.data = data
    
    def _request(self, episode):
        req = urllib2.urlopen(self.search_feed+episode)
        data = req.read()
        return data
        #return service.Get(feed)
    
    def search_direct_feed(self, feed, start=1, end=20):
        feed_url = "%s?start-index=%d&max-results=%d" % (feed, start, end)
        return self._request(feed_url).entry
        
    def search_video_by_id(self, id):
        feed_url = "%s/%s" %(self.search_feed, id)
        resp = self._request(feed_url)
        return [resp]
        
    def search_video(self, query, start=1, end=20):
        feed_url = "%s?vq=%s&start-index=%d&max-results=%d" % (self.search_feed, query, start, end)
        return self._request(feed_url).entry

    def get_recentlyfeatured(self,  start=1, end=20, time='today'):
        return self._request("%s/recently_featured?start-index=%d&max-results=%d" % (self.std_feeds, start, end)).entry

    def get_toprated(self, start=1, end=20):
        return self._request("%s/top_rated?start-index=%d&max-results=%d&time=%s" % (self.std_feeds, start, end, self.date)).entry

    def get_mostviewed(self, start=1, end=20):
        return self._request("%s/most_viewed?start-index=%d&max-results=%d&time=%s" % (self.std_feeds, start, end, self.date)).entry

    def videos_upload_by(self, username, start=1, end=20):
        return self._request("%s/%s/uploads?start-index=%d&max-results=%d" %(self.users_feed, username, start, end)).entry
    
    def get_by_category(self, cat, start=1, end=20):
        return self._request("%s/-/%s?start-index=%d&max-results=%d" %(self.search_feed, cat, start, end)).entry
    
    def favorite_videos(self, username):
        return self._request("%s/%s/favorites", self.users_feed, username).entry

    def get_contacts(self, username):
        users = self._request("%s/%s/contacts", self.users_feed, username).entry
        contacts = [ user.title.text for user in users ]
        return contacts
        
    def get_categories(self):
        feed_url = "http://gdata.youtube.com/schemas/2007/categories.cat"
        xml = self._request(feed_url)
        tree = ElementTree.fromstring(xml)
        categories = {}
        for child in tree.getchildren():
            categories[child.get('term')] = child.get('label')
        return categories
    
    def get_category(self, cid):
        feed_url = "http://gdata.youtube.com/feeds/videos/-/%s" % cid
        return self._request(feed_url).entry
        
    def get_thumbnails(self, video):
        doc = video._ToElementTree()
        urls = {}
        for c in doc.findall(".//{http://search.yahoo.com/mrss/}group"):
            for cc in c.findall("{http://search.yahoo.com/mrss/}thumbnail"):
                width = int(cc.get("width"))
                height = int(cc.get("height"))
                size = (width, height)
                url = cc.get("url")
                if size not in urls:
                    urls[size] = [url,]
                else:
                    urls[size].append(url)
        return urls
    def get_duration(self, video):
        doc = video._ToElementTree()
        for c in doc.findall(".//{http://search.yahoo.com/mrss/}group"):
            for cc in c.findall("{http://gdata.youtube.com/schemas/2007}duration"):
                sec = int(cc.get("seconds"))
                return sec
        return -1
    
    def get_viewed(self, video):
        doc = video._ToElementTree()
        for cc in doc.findall("{http://gdata.youtube.com/schemas/2007}statistics"):
            sec = int(cc.get("viewCount"))
            return sec
        return -1
    
    def get_average(self, video):
        doc = video._ToElementTree()
        for c in doc.findall(".//{http://schemas.google.com/g/2005}rating"):
            sec = float(c.get("average"))
            return sec
        return -1
    
    def get_author(self, video):
        try:
            return video.author[0].name.text
        except:
            return "error"
    
    def get_date(self, video):
        try:
            return video.published.text[0:10]
        except:
            return "error"
    
    def get_description(self, video):
        try:
            return video.FindExtensions(tag='group')[0].FindChildren(tag='description')[0].text 
        except:
            return "error"
    
    def get_cat(self, video):
        try:
            return video.FindExtensions(tag='group')[0].FindChildren(tag='category')[0].text 
        except:
            return "error"
    
    def get_related(self, video):
        for link in video.link:
            rel = link.rel
            if rel.endswith(".related"):
                return link.href
        return "error"
    
    def get_largest_thumbnail(self, video):
        thumbnails = self.get_thumbnails(video)
        sizes = thumbnails.keys()
        sizes.sort()
        return thumbnails[sizes[-1]][0]
    
    def get_smallest_thumbnail(self, video):
        thumbnails = self.get_thumbnails(video)
        sizes = thumbnails.keys()
        sizes.sort()
        return thumbnails[sizes[0]][0]

    def get_flv_video_url(self, url):
        flv_url = 'not found'
        doc = urllib2.urlopen(url)
        data = doc.read()

        # extract video name
        match = self.video_name_re.search(data)
        if match is not None:
            video_name = match.group(1)

            # extract video id
            url_splited = url.split("watch?v=")
            video_id = url_splited[1]     

            flv_url = "http://www.youtube.com/get_video?video_id=%s&t=%s"
            flv_url = flv_url % (video_id, video_name)
        return flv_url

if __name__ == '__main__':
    cli = Southpark("")
    
    resp = cli._request("12");
    print resp
    import sjson
    obj = sjson.loads(resp)
    print obj
    

    """
    for video in cli.search_video_by_id("Yu_moia-oVI"):
      thumb_url = cli.get_largest_thumbnail(video)
      flv_url = 'nada' #cli.get_flv_video_url(video.link[1].href)
      print "[%s][%s][%s]" %(video.title.text, thumb_url, cli.get_related(video))
      print cli.get_average(video)
      
    import pdb; pdb.set_trace()
    """

