
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         MYSQLparse
#define yylex           MYSQLlex
#define yyerror         MYSQLerror
#define yylval          MYSQLlval
#define yychar          MYSQLchar
#define yydebug         MYSQLdebug
#define yynerrs         MYSQLnerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)
#define YYLIP (& YYTHD->m_parser_state->m_lip)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include <myisam.h>
#include <myisammrg.h>

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= (ulong) *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#undef 	WARN_DEPRECATED			/* this macro is also defined in mysql_priv.h */
#define WARN_DEPRECATED(A,B)                                        \
  push_warning_printf(((THD *)yythd), MYSQL_ERROR::WARN_LEVEL_WARN, \
		      ER_WARN_DEPRECATED_SYNTAX,                    \
		      ER(ER_WARN_DEPRECATED_SYNTAX), (A), (B));

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->tok_start;
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? yytext : ""),
                  lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  return sp->add_instr(i);
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

int case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  return !test(i) ||
         sp->push_backpatch(i, ctx->push_label((char *)"", 0)) ||
         sp->add_cont_backpatch(i) ||
         sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

int case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  if (!test(i) || sp->add_instr(i))
    return 1;

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  return sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}



/* Line 189 of yacc.c  */
#line 487 "sql_yacc.cc"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     END_OF_INPUT = 258,
     ABORT_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     ATAN = 277,
     AUTO_INC = 278,
     AVG_ROW_LENGTH = 279,
     AVG_SYM = 280,
     BACKUP_SYM = 281,
     BEFORE_SYM = 282,
     BEGIN_SYM = 283,
     BENCHMARK_SYM = 284,
     BERKELEY_DB_SYM = 285,
     BIGINT = 286,
     BINARY = 287,
     BINLOG_SYM = 288,
     BIN_NUM = 289,
     BIT_AND = 290,
     BIT_OR = 291,
     BIT_SYM = 292,
     BIT_XOR = 293,
     BLOB_SYM = 294,
     BLOCK_SYM = 295,
     BOOLEAN_SYM = 296,
     BOOL_SYM = 297,
     BOTH = 298,
     BTREE_SYM = 299,
     BY = 300,
     BYTE_SYM = 301,
     CACHE_SYM = 302,
     CALL_SYM = 303,
     CASCADE = 304,
     CASCADED = 305,
     CAST_SYM = 306,
     CHAIN_SYM = 307,
     CHANGE = 308,
     CHANGED = 309,
     CHARSET = 310,
     CHAR_SYM = 311,
     CHECKSUM_SYM = 312,
     CHECK_SYM = 313,
     CIPHER_SYM = 314,
     CLIENT_SYM = 315,
     CLOSE_SYM = 316,
     COALESCE = 317,
     CODE_SYM = 318,
     COLLATE_SYM = 319,
     COLLATION_SYM = 320,
     COLUMNS = 321,
     COLUMN_SYM = 322,
     COMMENT_SYM = 323,
     COMMITTED_SYM = 324,
     COMMIT_SYM = 325,
     COMPACT_SYM = 326,
     COMPRESSED_SYM = 327,
     CONCAT = 328,
     CONCAT_WS = 329,
     CONCURRENT = 330,
     CONDITION_SYM = 331,
     CONNECTION_SYM = 332,
     CONSISTENT_SYM = 333,
     CONSTRAINT = 334,
     CONTAINS_SYM = 335,
     CONTEXT_SYM = 336,
     CONTINUE_SYM = 337,
     CONVERT_SYM = 338,
     CONVERT_TZ_SYM = 339,
     COUNT_SYM = 340,
     CPU_SYM = 341,
     CREATE = 342,
     CROSS = 343,
     CUBE_SYM = 344,
     CURDATE = 345,
     CURRENT_USER = 346,
     CURSOR_SYM = 347,
     CURTIME = 348,
     DATABASE = 349,
     DATABASES = 350,
     DATA_SYM = 351,
     DATETIME = 352,
     DATE_ADD_INTERVAL = 353,
     DATE_SUB_INTERVAL = 354,
     DATE_SYM = 355,
     DAY_HOUR_SYM = 356,
     DAY_MICROSECOND_SYM = 357,
     DAY_MINUTE_SYM = 358,
     DAY_SECOND_SYM = 359,
     DAY_SYM = 360,
     DEALLOCATE_SYM = 361,
     DECIMAL_NUM = 362,
     DECIMAL_SYM = 363,
     DECLARE_SYM = 364,
     DECODE_SYM = 365,
     DEFAULT = 366,
     DEFINER_SYM = 367,
     DELAYED_SYM = 368,
     DELAY_KEY_WRITE_SYM = 369,
     DELETE_SYM = 370,
     DESC = 371,
     DESCRIBE = 372,
     DES_DECRYPT_SYM = 373,
     DES_ENCRYPT_SYM = 374,
     DES_KEY_FILE = 375,
     DETERMINISTIC_SYM = 376,
     DIRECTORY_SYM = 377,
     DISABLE_SYM = 378,
     DISCARD = 379,
     DISTINCT = 380,
     DIV_SYM = 381,
     DOUBLE_SYM = 382,
     DO_SYM = 383,
     DROP = 384,
     DUAL_SYM = 385,
     DUMPFILE = 386,
     DUPLICATE_SYM = 387,
     DYNAMIC_SYM = 388,
     EACH_SYM = 389,
     ELSEIF_SYM = 390,
     ELT_FUNC = 391,
     ENABLE_SYM = 392,
     ENCLOSED = 393,
     ENCODE_SYM = 394,
     ENCRYPT = 395,
     END = 396,
     ENGINES_SYM = 397,
     ENGINE_SYM = 398,
     ENUM = 399,
     EQ = 400,
     EQUAL_SYM = 401,
     ERRORS = 402,
     ESCAPED = 403,
     ESCAPE_SYM = 404,
     EVENTS_SYM = 405,
     EXECUTE_SYM = 406,
     EXISTS = 407,
     EXIT_SYM = 408,
     EXPANSION_SYM = 409,
     EXPORT_SET = 410,
     EXTENDED_SYM = 411,
     EXTRACT_SYM = 412,
     FALSE_SYM = 413,
     FAST_SYM = 414,
     FAULTS_SYM = 415,
     FETCH_SYM = 416,
     FIELD_FUNC = 417,
     FILE_SYM = 418,
     FIRST_SYM = 419,
     FIXED_SYM = 420,
     FLOAT_NUM = 421,
     FLOAT_SYM = 422,
     FLUSH_SYM = 423,
     FORCE_SYM = 424,
     FOREIGN = 425,
     FORMAT_SYM = 426,
     FOR_SYM = 427,
     FOUND_SYM = 428,
     FRAC_SECOND_SYM = 429,
     FROM = 430,
     FROM_UNIXTIME = 431,
     FULL = 432,
     FULLTEXT_SYM = 433,
     FUNCTION_SYM = 434,
     FUNC_ARG0 = 435,
     FUNC_ARG1 = 436,
     FUNC_ARG2 = 437,
     FUNC_ARG3 = 438,
     GE = 439,
     GEOMCOLLFROMTEXT = 440,
     GEOMETRYCOLLECTION = 441,
     GEOMETRY_SYM = 442,
     GEOMFROMTEXT = 443,
     GEOMFROMWKB = 444,
     GET_FORMAT = 445,
     GLOBAL_SYM = 446,
     GRANT = 447,
     GRANTS = 448,
     GREATEST_SYM = 449,
     GROUP = 450,
     GROUP_CONCAT_SYM = 451,
     GROUP_UNIQUE_USERS = 452,
     GT_SYM = 453,
     HANDLER_SYM = 454,
     HASH_SYM = 455,
     HAVING = 456,
     HELP_SYM = 457,
     HEX_NUM = 458,
     HIGH_PRIORITY = 459,
     HOSTS_SYM = 460,
     HOUR_MICROSECOND_SYM = 461,
     HOUR_MINUTE_SYM = 462,
     HOUR_SECOND_SYM = 463,
     HOUR_SYM = 464,
     IDENT = 465,
     IDENTIFIED_SYM = 466,
     IDENT_QUOTED = 467,
     IF = 468,
     IGNORE_SYM = 469,
     IMPORT = 470,
     INDEXES = 471,
     INDEX_SYM = 472,
     INFILE = 473,
     INNER_SYM = 474,
     INNOBASE_SYM = 475,
     INOUT_SYM = 476,
     INSENSITIVE_SYM = 477,
     INSERT = 478,
     INSERT_METHOD = 479,
     INTERVAL_SYM = 480,
     INTO = 481,
     INT_SYM = 482,
     INVOKER_SYM = 483,
     IN_SYM = 484,
     IO_SYM = 485,
     IPC_SYM = 486,
     IS = 487,
     ISOLATION = 488,
     ISSUER_SYM = 489,
     ITERATE_SYM = 490,
     JOIN_SYM = 491,
     KEYS = 492,
     KEY_SYM = 493,
     KILL_SYM = 494,
     LABEL_SYM = 495,
     LANGUAGE_SYM = 496,
     LAST_INSERT_ID = 497,
     LAST_SYM = 498,
     LE = 499,
     LEADING = 500,
     LEAST_SYM = 501,
     LEAVES = 502,
     LEAVE_SYM = 503,
     LEFT = 504,
     LEVEL_SYM = 505,
     LEX_HOSTNAME = 506,
     LIKE = 507,
     LIMIT = 508,
     LINEFROMTEXT = 509,
     LINES = 510,
     LINESTRING = 511,
     LOAD = 512,
     LOCAL_SYM = 513,
     LOCATE = 514,
     LOCATOR_SYM = 515,
     LOCKS_SYM = 516,
     LOCK_SYM = 517,
     LOGS_SYM = 518,
     LOG_SYM = 519,
     LONGBLOB = 520,
     LONGTEXT = 521,
     LONG_NUM = 522,
     LONG_SYM = 523,
     LOOP_SYM = 524,
     LOW_PRIORITY = 525,
     LT = 526,
     MAKE_SET_SYM = 527,
     MASTER_CONNECT_RETRY_SYM = 528,
     MASTER_HOST_SYM = 529,
     MASTER_LOG_FILE_SYM = 530,
     MASTER_LOG_POS_SYM = 531,
     MASTER_PASSWORD_SYM = 532,
     MASTER_PORT_SYM = 533,
     MASTER_POS_WAIT = 534,
     MASTER_SERVER_ID_SYM = 535,
     MASTER_SSL_CAPATH_SYM = 536,
     MASTER_SSL_CA_SYM = 537,
     MASTER_SSL_CERT_SYM = 538,
     MASTER_SSL_CIPHER_SYM = 539,
     MASTER_SSL_KEY_SYM = 540,
     MASTER_SSL_SYM = 541,
     MASTER_SYM = 542,
     MASTER_USER_SYM = 543,
     MATCH = 544,
     MAX_CONNECTIONS_PER_HOUR = 545,
     MAX_QUERIES_PER_HOUR = 546,
     MAX_ROWS = 547,
     MAX_SYM = 548,
     MAX_UPDATES_PER_HOUR = 549,
     MAX_USER_CONNECTIONS_SYM = 550,
     MEDIUMBLOB = 551,
     MEDIUMINT = 552,
     MEDIUMTEXT = 553,
     MEDIUM_SYM = 554,
     MEMORY_SYM = 555,
     MERGE_SYM = 556,
     MICROSECOND_SYM = 557,
     MIGRATE_SYM = 558,
     MINUTE_MICROSECOND_SYM = 559,
     MINUTE_SECOND_SYM = 560,
     MINUTE_SYM = 561,
     MIN_ROWS = 562,
     MIN_SYM = 563,
     MLINEFROMTEXT = 564,
     MODE_SYM = 565,
     MODIFIES_SYM = 566,
     MODIFY_SYM = 567,
     MOD_SYM = 568,
     MONTH_SYM = 569,
     MPOINTFROMTEXT = 570,
     MPOLYFROMTEXT = 571,
     MULTILINESTRING = 572,
     MULTIPOINT = 573,
     MULTIPOLYGON = 574,
     MUTEX_SYM = 575,
     NAMES_SYM = 576,
     NAME_SYM = 577,
     NATIONAL_SYM = 578,
     NATURAL = 579,
     NCHAR_STRING = 580,
     NCHAR_SYM = 581,
     NDBCLUSTER_SYM = 582,
     NE = 583,
     NEW_SYM = 584,
     NEXT_SYM = 585,
     NONE_SYM = 586,
     NOT2_SYM = 587,
     NOT_SYM = 588,
     NOW_SYM = 589,
     NO_SYM = 590,
     NO_WRITE_TO_BINLOG = 591,
     NULL_SYM = 592,
     NUM = 593,
     NUMERIC_SYM = 594,
     NVARCHAR_SYM = 595,
     OFFSET_SYM = 596,
     OJ_SYM = 597,
     OLD_PASSWORD = 598,
     ON = 599,
     ONE_SHOT_SYM = 600,
     ONE_SYM = 601,
     OPEN_SYM = 602,
     OPTIMIZE = 603,
     OPTION = 604,
     OPTIONALLY = 605,
     OR2_SYM = 606,
     ORDER_SYM = 607,
     OR_OR_SYM = 608,
     OR_SYM = 609,
     OUTER = 610,
     OUTFILE = 611,
     OUT_SYM = 612,
     PACK_KEYS_SYM = 613,
     PAGE_SYM = 614,
     PARTIAL = 615,
     PASSWORD = 616,
     PARAM_MARKER = 617,
     PHASE_SYM = 618,
     POINTFROMTEXT = 619,
     POINT_SYM = 620,
     POLYFROMTEXT = 621,
     POLYGON = 622,
     POSITION_SYM = 623,
     PRECISION = 624,
     PREPARE_SYM = 625,
     PREV_SYM = 626,
     PRIMARY_SYM = 627,
     PRIVILEGES = 628,
     PROCEDURE = 629,
     PROCESS = 630,
     PROCESSLIST_SYM = 631,
     PROFILE_SYM = 632,
     PROFILES_SYM = 633,
     PURGE = 634,
     QUARTER_SYM = 635,
     QUERY_SYM = 636,
     QUICK = 637,
     RAID_0_SYM = 638,
     RAID_CHUNKS = 639,
     RAID_CHUNKSIZE = 640,
     RAID_STRIPED_SYM = 641,
     RAID_TYPE = 642,
     RAND = 643,
     READS_SYM = 644,
     READ_SYM = 645,
     REAL = 646,
     RECOVER_SYM = 647,
     REDUNDANT_SYM = 648,
     REFERENCES = 649,
     REGEXP = 650,
     RELAY_LOG_FILE_SYM = 651,
     RELAY_LOG_POS_SYM = 652,
     RELAY_THREAD = 653,
     RELEASE_SYM = 654,
     RELOAD = 655,
     RENAME = 656,
     REPAIR = 657,
     REPEATABLE_SYM = 658,
     REPEAT_SYM = 659,
     REPLACE = 660,
     REPLICATION = 661,
     REQUIRE_SYM = 662,
     RESET_SYM = 663,
     RESOURCES = 664,
     RESTORE_SYM = 665,
     RESTRICT = 666,
     RESUME_SYM = 667,
     RETURNS_SYM = 668,
     RETURN_SYM = 669,
     REVOKE = 670,
     RIGHT = 671,
     ROLLBACK_SYM = 672,
     ROLLUP_SYM = 673,
     ROUND = 674,
     ROUTINE_SYM = 675,
     ROWS_SYM = 676,
     ROW_COUNT_SYM = 677,
     ROW_FORMAT_SYM = 678,
     ROW_SYM = 679,
     RTREE_SYM = 680,
     SAVEPOINT_SYM = 681,
     SECOND_MICROSECOND_SYM = 682,
     SECOND_SYM = 683,
     SECURITY_SYM = 684,
     SELECT_SYM = 685,
     SENSITIVE_SYM = 686,
     SEPARATOR_SYM = 687,
     SERIALIZABLE_SYM = 688,
     SERIAL_SYM = 689,
     SESSION_SYM = 690,
     SET = 691,
     SET_VAR = 692,
     SHARE_SYM = 693,
     SHIFT_LEFT = 694,
     SHIFT_RIGHT = 695,
     SHOW = 696,
     SHUTDOWN = 697,
     SIGNED_SYM = 698,
     SIMPLE_SYM = 699,
     SLAVE = 700,
     SMALLINT = 701,
     SNAPSHOT_SYM = 702,
     SOUNDS_SYM = 703,
     SOURCE_SYM = 704,
     SPATIAL_SYM = 705,
     SPECIFIC_SYM = 706,
     SQLEXCEPTION_SYM = 707,
     SQLSTATE_SYM = 708,
     SQLWARNING_SYM = 709,
     SQL_BIG_RESULT = 710,
     SQL_BUFFER_RESULT = 711,
     SQL_CACHE_SYM = 712,
     SQL_CALC_FOUND_ROWS = 713,
     SQL_NO_CACHE_SYM = 714,
     SQL_SMALL_RESULT = 715,
     SQL_SYM = 716,
     SQL_THREAD = 717,
     SSL_SYM = 718,
     STARTING = 719,
     START_SYM = 720,
     STATUS_SYM = 721,
     STD_SYM = 722,
     STDDEV_SAMP_SYM = 723,
     STOP_SYM = 724,
     STORAGE_SYM = 725,
     STRAIGHT_JOIN = 726,
     STRING_SYM = 727,
     SUBDATE_SYM = 728,
     SUBJECT_SYM = 729,
     SUBSTRING = 730,
     SUBSTRING_INDEX = 731,
     SUM_SYM = 732,
     SUPER_SYM = 733,
     SUSPEND_SYM = 734,
     SWAPS_SYM = 735,
     SWITCHES_SYM = 736,
     SYSDATE = 737,
     TABLES = 738,
     TABLESPACE = 739,
     TABLE_SYM = 740,
     TEMPORARY = 741,
     TEMPTABLE_SYM = 742,
     TERMINATED = 743,
     TEXT_STRING = 744,
     TEXT_SYM = 745,
     TIMESTAMP = 746,
     TIMESTAMP_ADD = 747,
     TIMESTAMP_DIFF = 748,
     TIME_SYM = 749,
     TINYBLOB = 750,
     TINYINT = 751,
     TINYTEXT = 752,
     TO_SYM = 753,
     TRAILING = 754,
     TRANSACTION_SYM = 755,
     TRIGGER_SYM = 756,
     TRIGGERS_SYM = 757,
     TRIM = 758,
     TRUE_SYM = 759,
     TRUNCATE_SYM = 760,
     TYPES_SYM = 761,
     TYPE_SYM = 762,
     UDF_RETURNS_SYM = 763,
     UDF_SONAME_SYM = 764,
     ULONGLONG_NUM = 765,
     UNCOMMITTED_SYM = 766,
     UNDEFINED_SYM = 767,
     UNDERSCORE_CHARSET = 768,
     UNDO_SYM = 769,
     UNICODE_SYM = 770,
     UNION_SYM = 771,
     UNIQUE_SYM = 772,
     UNIQUE_USERS = 773,
     UNIX_TIMESTAMP = 774,
     UNKNOWN_SYM = 775,
     UNLOCK_SYM = 776,
     UNSIGNED = 777,
     UNTIL_SYM = 778,
     UPDATE_SYM = 779,
     UPGRADE_SYM = 780,
     USAGE = 781,
     USER = 782,
     USE_FRM = 783,
     USE_SYM = 784,
     USING = 785,
     UTC_DATE_SYM = 786,
     UTC_TIMESTAMP_SYM = 787,
     UTC_TIME_SYM = 788,
     VAR_SAMP_SYM = 789,
     VALUES = 790,
     VALUE_SYM = 791,
     VARBINARY = 792,
     VARCHAR = 793,
     VARIABLES = 794,
     VARIANCE_SYM = 795,
     VARYING = 796,
     VIEW_SYM = 797,
     WARNINGS = 798,
     WEEK_SYM = 799,
     WHEN_SYM = 800,
     WHERE = 801,
     WHILE_SYM = 802,
     WITH = 803,
     WORK_SYM = 804,
     WRITE_SYM = 805,
     X509_SYM = 806,
     XA_SYM = 807,
     XOR = 808,
     YEARWEEK = 809,
     YEAR_MONTH_SYM = 810,
     YEAR_SYM = 811,
     ZEROFILL = 812,
     TABLE_REF_PRIORITY = 813,
     ELSE = 814,
     THEN_SYM = 815,
     CASE_SYM = 816,
     BETWEEN_SYM = 817,
     NEG = 818
   };
#endif
/* Tokens.  */
#define END_OF_INPUT 258
#define ABORT_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define ATAN 277
#define AUTO_INC 278
#define AVG_ROW_LENGTH 279
#define AVG_SYM 280
#define BACKUP_SYM 281
#define BEFORE_SYM 282
#define BEGIN_SYM 283
#define BENCHMARK_SYM 284
#define BERKELEY_DB_SYM 285
#define BIGINT 286
#define BINARY 287
#define BINLOG_SYM 288
#define BIN_NUM 289
#define BIT_AND 290
#define BIT_OR 291
#define BIT_SYM 292
#define BIT_XOR 293
#define BLOB_SYM 294
#define BLOCK_SYM 295
#define BOOLEAN_SYM 296
#define BOOL_SYM 297
#define BOTH 298
#define BTREE_SYM 299
#define BY 300
#define BYTE_SYM 301
#define CACHE_SYM 302
#define CALL_SYM 303
#define CASCADE 304
#define CASCADED 305
#define CAST_SYM 306
#define CHAIN_SYM 307
#define CHANGE 308
#define CHANGED 309
#define CHARSET 310
#define CHAR_SYM 311
#define CHECKSUM_SYM 312
#define CHECK_SYM 313
#define CIPHER_SYM 314
#define CLIENT_SYM 315
#define CLOSE_SYM 316
#define COALESCE 317
#define CODE_SYM 318
#define COLLATE_SYM 319
#define COLLATION_SYM 320
#define COLUMNS 321
#define COLUMN_SYM 322
#define COMMENT_SYM 323
#define COMMITTED_SYM 324
#define COMMIT_SYM 325
#define COMPACT_SYM 326
#define COMPRESSED_SYM 327
#define CONCAT 328
#define CONCAT_WS 329
#define CONCURRENT 330
#define CONDITION_SYM 331
#define CONNECTION_SYM 332
#define CONSISTENT_SYM 333
#define CONSTRAINT 334
#define CONTAINS_SYM 335
#define CONTEXT_SYM 336
#define CONTINUE_SYM 337
#define CONVERT_SYM 338
#define CONVERT_TZ_SYM 339
#define COUNT_SYM 340
#define CPU_SYM 341
#define CREATE 342
#define CROSS 343
#define CUBE_SYM 344
#define CURDATE 345
#define CURRENT_USER 346
#define CURSOR_SYM 347
#define CURTIME 348
#define DATABASE 349
#define DATABASES 350
#define DATA_SYM 351
#define DATETIME 352
#define DATE_ADD_INTERVAL 353
#define DATE_SUB_INTERVAL 354
#define DATE_SYM 355
#define DAY_HOUR_SYM 356
#define DAY_MICROSECOND_SYM 357
#define DAY_MINUTE_SYM 358
#define DAY_SECOND_SYM 359
#define DAY_SYM 360
#define DEALLOCATE_SYM 361
#define DECIMAL_NUM 362
#define DECIMAL_SYM 363
#define DECLARE_SYM 364
#define DECODE_SYM 365
#define DEFAULT 366
#define DEFINER_SYM 367
#define DELAYED_SYM 368
#define DELAY_KEY_WRITE_SYM 369
#define DELETE_SYM 370
#define DESC 371
#define DESCRIBE 372
#define DES_DECRYPT_SYM 373
#define DES_ENCRYPT_SYM 374
#define DES_KEY_FILE 375
#define DETERMINISTIC_SYM 376
#define DIRECTORY_SYM 377
#define DISABLE_SYM 378
#define DISCARD 379
#define DISTINCT 380
#define DIV_SYM 381
#define DOUBLE_SYM 382
#define DO_SYM 383
#define DROP 384
#define DUAL_SYM 385
#define DUMPFILE 386
#define DUPLICATE_SYM 387
#define DYNAMIC_SYM 388
#define EACH_SYM 389
#define ELSEIF_SYM 390
#define ELT_FUNC 391
#define ENABLE_SYM 392
#define ENCLOSED 393
#define ENCODE_SYM 394
#define ENCRYPT 395
#define END 396
#define ENGINES_SYM 397
#define ENGINE_SYM 398
#define ENUM 399
#define EQ 400
#define EQUAL_SYM 401
#define ERRORS 402
#define ESCAPED 403
#define ESCAPE_SYM 404
#define EVENTS_SYM 405
#define EXECUTE_SYM 406
#define EXISTS 407
#define EXIT_SYM 408
#define EXPANSION_SYM 409
#define EXPORT_SET 410
#define EXTENDED_SYM 411
#define EXTRACT_SYM 412
#define FALSE_SYM 413
#define FAST_SYM 414
#define FAULTS_SYM 415
#define FETCH_SYM 416
#define FIELD_FUNC 417
#define FILE_SYM 418
#define FIRST_SYM 419
#define FIXED_SYM 420
#define FLOAT_NUM 421
#define FLOAT_SYM 422
#define FLUSH_SYM 423
#define FORCE_SYM 424
#define FOREIGN 425
#define FORMAT_SYM 426
#define FOR_SYM 427
#define FOUND_SYM 428
#define FRAC_SECOND_SYM 429
#define FROM 430
#define FROM_UNIXTIME 431
#define FULL 432
#define FULLTEXT_SYM 433
#define FUNCTION_SYM 434
#define FUNC_ARG0 435
#define FUNC_ARG1 436
#define FUNC_ARG2 437
#define FUNC_ARG3 438
#define GE 439
#define GEOMCOLLFROMTEXT 440
#define GEOMETRYCOLLECTION 441
#define GEOMETRY_SYM 442
#define GEOMFROMTEXT 443
#define GEOMFROMWKB 444
#define GET_FORMAT 445
#define GLOBAL_SYM 446
#define GRANT 447
#define GRANTS 448
#define GREATEST_SYM 449
#define GROUP 450
#define GROUP_CONCAT_SYM 451
#define GROUP_UNIQUE_USERS 452
#define GT_SYM 453
#define HANDLER_SYM 454
#define HASH_SYM 455
#define HAVING 456
#define HELP_SYM 457
#define HEX_NUM 458
#define HIGH_PRIORITY 459
#define HOSTS_SYM 460
#define HOUR_MICROSECOND_SYM 461
#define HOUR_MINUTE_SYM 462
#define HOUR_SECOND_SYM 463
#define HOUR_SYM 464
#define IDENT 465
#define IDENTIFIED_SYM 466
#define IDENT_QUOTED 467
#define IF 468
#define IGNORE_SYM 469
#define IMPORT 470
#define INDEXES 471
#define INDEX_SYM 472
#define INFILE 473
#define INNER_SYM 474
#define INNOBASE_SYM 475
#define INOUT_SYM 476
#define INSENSITIVE_SYM 477
#define INSERT 478
#define INSERT_METHOD 479
#define INTERVAL_SYM 480
#define INTO 481
#define INT_SYM 482
#define INVOKER_SYM 483
#define IN_SYM 484
#define IO_SYM 485
#define IPC_SYM 486
#define IS 487
#define ISOLATION 488
#define ISSUER_SYM 489
#define ITERATE_SYM 490
#define JOIN_SYM 491
#define KEYS 492
#define KEY_SYM 493
#define KILL_SYM 494
#define LABEL_SYM 495
#define LANGUAGE_SYM 496
#define LAST_INSERT_ID 497
#define LAST_SYM 498
#define LE 499
#define LEADING 500
#define LEAST_SYM 501
#define LEAVES 502
#define LEAVE_SYM 503
#define LEFT 504
#define LEVEL_SYM 505
#define LEX_HOSTNAME 506
#define LIKE 507
#define LIMIT 508
#define LINEFROMTEXT 509
#define LINES 510
#define LINESTRING 511
#define LOAD 512
#define LOCAL_SYM 513
#define LOCATE 514
#define LOCATOR_SYM 515
#define LOCKS_SYM 516
#define LOCK_SYM 517
#define LOGS_SYM 518
#define LOG_SYM 519
#define LONGBLOB 520
#define LONGTEXT 521
#define LONG_NUM 522
#define LONG_SYM 523
#define LOOP_SYM 524
#define LOW_PRIORITY 525
#define LT 526
#define MAKE_SET_SYM 527
#define MASTER_CONNECT_RETRY_SYM 528
#define MASTER_HOST_SYM 529
#define MASTER_LOG_FILE_SYM 530
#define MASTER_LOG_POS_SYM 531
#define MASTER_PASSWORD_SYM 532
#define MASTER_PORT_SYM 533
#define MASTER_POS_WAIT 534
#define MASTER_SERVER_ID_SYM 535
#define MASTER_SSL_CAPATH_SYM 536
#define MASTER_SSL_CA_SYM 537
#define MASTER_SSL_CERT_SYM 538
#define MASTER_SSL_CIPHER_SYM 539
#define MASTER_SSL_KEY_SYM 540
#define MASTER_SSL_SYM 541
#define MASTER_SYM 542
#define MASTER_USER_SYM 543
#define MATCH 544
#define MAX_CONNECTIONS_PER_HOUR 545
#define MAX_QUERIES_PER_HOUR 546
#define MAX_ROWS 547
#define MAX_SYM 548
#define MAX_UPDATES_PER_HOUR 549
#define MAX_USER_CONNECTIONS_SYM 550
#define MEDIUMBLOB 551
#define MEDIUMINT 552
#define MEDIUMTEXT 553
#define MEDIUM_SYM 554
#define MEMORY_SYM 555
#define MERGE_SYM 556
#define MICROSECOND_SYM 557
#define MIGRATE_SYM 558
#define MINUTE_MICROSECOND_SYM 559
#define MINUTE_SECOND_SYM 560
#define MINUTE_SYM 561
#define MIN_ROWS 562
#define MIN_SYM 563
#define MLINEFROMTEXT 564
#define MODE_SYM 565
#define MODIFIES_SYM 566
#define MODIFY_SYM 567
#define MOD_SYM 568
#define MONTH_SYM 569
#define MPOINTFROMTEXT 570
#define MPOLYFROMTEXT 571
#define MULTILINESTRING 572
#define MULTIPOINT 573
#define MULTIPOLYGON 574
#define MUTEX_SYM 575
#define NAMES_SYM 576
#define NAME_SYM 577
#define NATIONAL_SYM 578
#define NATURAL 579
#define NCHAR_STRING 580
#define NCHAR_SYM 581
#define NDBCLUSTER_SYM 582
#define NE 583
#define NEW_SYM 584
#define NEXT_SYM 585
#define NONE_SYM 586
#define NOT2_SYM 587
#define NOT_SYM 588
#define NOW_SYM 589
#define NO_SYM 590
#define NO_WRITE_TO_BINLOG 591
#define NULL_SYM 592
#define NUM 593
#define NUMERIC_SYM 594
#define NVARCHAR_SYM 595
#define OFFSET_SYM 596
#define OJ_SYM 597
#define OLD_PASSWORD 598
#define ON 599
#define ONE_SHOT_SYM 600
#define ONE_SYM 601
#define OPEN_SYM 602
#define OPTIMIZE 603
#define OPTION 604
#define OPTIONALLY 605
#define OR2_SYM 606
#define ORDER_SYM 607
#define OR_OR_SYM 608
#define OR_SYM 609
#define OUTER 610
#define OUTFILE 611
#define OUT_SYM 612
#define PACK_KEYS_SYM 613
#define PAGE_SYM 614
#define PARTIAL 615
#define PASSWORD 616
#define PARAM_MARKER 617
#define PHASE_SYM 618
#define POINTFROMTEXT 619
#define POINT_SYM 620
#define POLYFROMTEXT 621
#define POLYGON 622
#define POSITION_SYM 623
#define PRECISION 624
#define PREPARE_SYM 625
#define PREV_SYM 626
#define PRIMARY_SYM 627
#define PRIVILEGES 628
#define PROCEDURE 629
#define PROCESS 630
#define PROCESSLIST_SYM 631
#define PROFILE_SYM 632
#define PROFILES_SYM 633
#define PURGE 634
#define QUARTER_SYM 635
#define QUERY_SYM 636
#define QUICK 637
#define RAID_0_SYM 638
#define RAID_CHUNKS 639
#define RAID_CHUNKSIZE 640
#define RAID_STRIPED_SYM 641
#define RAID_TYPE 642
#define RAND 643
#define READS_SYM 644
#define READ_SYM 645
#define REAL 646
#define RECOVER_SYM 647
#define REDUNDANT_SYM 648
#define REFERENCES 649
#define REGEXP 650
#define RELAY_LOG_FILE_SYM 651
#define RELAY_LOG_POS_SYM 652
#define RELAY_THREAD 653
#define RELEASE_SYM 654
#define RELOAD 655
#define RENAME 656
#define REPAIR 657
#define REPEATABLE_SYM 658
#define REPEAT_SYM 659
#define REPLACE 660
#define REPLICATION 661
#define REQUIRE_SYM 662
#define RESET_SYM 663
#define RESOURCES 664
#define RESTORE_SYM 665
#define RESTRICT 666
#define RESUME_SYM 667
#define RETURNS_SYM 668
#define RETURN_SYM 669
#define REVOKE 670
#define RIGHT 671
#define ROLLBACK_SYM 672
#define ROLLUP_SYM 673
#define ROUND 674
#define ROUTINE_SYM 675
#define ROWS_SYM 676
#define ROW_COUNT_SYM 677
#define ROW_FORMAT_SYM 678
#define ROW_SYM 679
#define RTREE_SYM 680
#define SAVEPOINT_SYM 681
#define SECOND_MICROSECOND_SYM 682
#define SECOND_SYM 683
#define SECURITY_SYM 684
#define SELECT_SYM 685
#define SENSITIVE_SYM 686
#define SEPARATOR_SYM 687
#define SERIALIZABLE_SYM 688
#define SERIAL_SYM 689
#define SESSION_SYM 690
#define SET 691
#define SET_VAR 692
#define SHARE_SYM 693
#define SHIFT_LEFT 694
#define SHIFT_RIGHT 695
#define SHOW 696
#define SHUTDOWN 697
#define SIGNED_SYM 698
#define SIMPLE_SYM 699
#define SLAVE 700
#define SMALLINT 701
#define SNAPSHOT_SYM 702
#define SOUNDS_SYM 703
#define SOURCE_SYM 704
#define SPATIAL_SYM 705
#define SPECIFIC_SYM 706
#define SQLEXCEPTION_SYM 707
#define SQLSTATE_SYM 708
#define SQLWARNING_SYM 709
#define SQL_BIG_RESULT 710
#define SQL_BUFFER_RESULT 711
#define SQL_CACHE_SYM 712
#define SQL_CALC_FOUND_ROWS 713
#define SQL_NO_CACHE_SYM 714
#define SQL_SMALL_RESULT 715
#define SQL_SYM 716
#define SQL_THREAD 717
#define SSL_SYM 718
#define STARTING 719
#define START_SYM 720
#define STATUS_SYM 721
#define STD_SYM 722
#define STDDEV_SAMP_SYM 723
#define STOP_SYM 724
#define STORAGE_SYM 725
#define STRAIGHT_JOIN 726
#define STRING_SYM 727
#define SUBDATE_SYM 728
#define SUBJECT_SYM 729
#define SUBSTRING 730
#define SUBSTRING_INDEX 731
#define SUM_SYM 732
#define SUPER_SYM 733
#define SUSPEND_SYM 734
#define SWAPS_SYM 735
#define SWITCHES_SYM 736
#define SYSDATE 737
#define TABLES 738
#define TABLESPACE 739
#define TABLE_SYM 740
#define TEMPORARY 741
#define TEMPTABLE_SYM 742
#define TERMINATED 743
#define TEXT_STRING 744
#define TEXT_SYM 745
#define TIMESTAMP 746
#define TIMESTAMP_ADD 747
#define TIMESTAMP_DIFF 748
#define TIME_SYM 749
#define TINYBLOB 750
#define TINYINT 751
#define TINYTEXT 752
#define TO_SYM 753
#define TRAILING 754
#define TRANSACTION_SYM 755
#define TRIGGER_SYM 756
#define TRIGGERS_SYM 757
#define TRIM 758
#define TRUE_SYM 759
#define TRUNCATE_SYM 760
#define TYPES_SYM 761
#define TYPE_SYM 762
#define UDF_RETURNS_SYM 763
#define UDF_SONAME_SYM 764
#define ULONGLONG_NUM 765
#define UNCOMMITTED_SYM 766
#define UNDEFINED_SYM 767
#define UNDERSCORE_CHARSET 768
#define UNDO_SYM 769
#define UNICODE_SYM 770
#define UNION_SYM 771
#define UNIQUE_SYM 772
#define UNIQUE_USERS 773
#define UNIX_TIMESTAMP 774
#define UNKNOWN_SYM 775
#define UNLOCK_SYM 776
#define UNSIGNED 777
#define UNTIL_SYM 778
#define UPDATE_SYM 779
#define UPGRADE_SYM 780
#define USAGE 781
#define USER 782
#define USE_FRM 783
#define USE_SYM 784
#define USING 785
#define UTC_DATE_SYM 786
#define UTC_TIMESTAMP_SYM 787
#define UTC_TIME_SYM 788
#define VAR_SAMP_SYM 789
#define VALUES 790
#define VALUE_SYM 791
#define VARBINARY 792
#define VARCHAR 793
#define VARIABLES 794
#define VARIANCE_SYM 795
#define VARYING 796
#define VIEW_SYM 797
#define WARNINGS 798
#define WEEK_SYM 799
#define WHEN_SYM 800
#define WHERE 801
#define WHILE_SYM 802
#define WITH 803
#define WORK_SYM 804
#define WRITE_SYM 805
#define X509_SYM 806
#define XA_SYM 807
#define XOR 808
#define YEARWEEK 809
#define YEAR_MONTH_SYM 810
#define YEAR_SYM 811
#define ZEROFILL 812
#define TABLE_REF_PRIORITY 813
#define ELSE 814
#define THEN_SYM 815
#define CASE_SYM 816
#define BETWEEN_SYM 817
#define NEG 818




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 422 "sql_yacc.yy"

  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  enum db_type db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;



/* Line 214 of yacc.c  */
#line 1691 "sql_yacc.cc"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */

/* Line 264 of yacc.c  */
#line 462 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 264 of yacc.c  */
#line 1708 "sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  472
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   43899

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  583
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  676
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2065
/* YYNRULES -- Number of states.  */
#define YYNSTATES  3720

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   818

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   576,     2,     2,     2,   569,   564,     2,
     573,   574,   567,   566,   575,   565,   581,   568,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   582,   579,
       2,     2,     2,     2,   580,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   570,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   577,   563,   578,   571,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   572
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    14,    15,    17,    19,
      21,    23,    25,    27,    29,    31,    33,    35,    37,    39,
      41,    43,    45,    47,    49,    51,    53,    55,    57,    59,
      61,    63,    65,    67,    69,    71,    73,    75,    77,    79,
      81,    83,    85,    87,    89,    91,    93,    95,    97,    99,
     101,   103,   105,   107,   109,   111,   113,   115,   119,   121,
     123,   128,   130,   133,   134,   139,   140,   143,   147,   149,
     152,   153,   157,   158,   164,   166,   170,   174,   178,   182,
     186,   190,   194,   198,   202,   206,   210,   214,   216,   220,
     224,   228,   232,   233,   241,   242,   254,   255,   262,   263,
     267,   272,   273,   277,   279,   280,   283,   284,   287,   290,
     293,   296,   299,   303,   307,   309,   311,   313,   316,   320,
     324,   325,   330,   331,   335,   336,   338,   342,   344,   345,
     347,   351,   353,   354,   358,   359,   361,   365,   367,   372,
     373,   375,   377,   379,   380,   384,   387,   391,   392,   396,
     397,   403,   409,   410,   418,   424,   425,   428,   430,   432,
     434,   438,   440,   442,   446,   447,   449,   451,   453,   455,
     458,   460,   462,   466,   467,   470,   471,   474,   475,   479,
     480,   486,   488,   490,   491,   494,   496,   498,   501,   504,
     507,   508,   515,   518,   519,   522,   524,   526,   530,   531,
     532,   533,   541,   542,   545,   548,   550,   552,   553,   554,
     563,   564,   571,   573,   576,   578,   581,   582,   583,   590,
     591,   592,   599,   600,   603,   604,   610,   611,   613,   614,
     620,   621,   624,   625,   631,   636,   637,   638,   647,   648,
     656,   658,   660,   662,   664,   666,   669,   672,   675,   680,
     685,   686,   691,   692,   693,   699,   700,   708,   709,   710,
     717,   718,   720,   721,   723,   725,   728,   730,   732,   733,
     735,   737,   740,   742,   743,   747,   748,   750,   752,   755,
     757,   760,   764,   768,   772,   776,   780,   784,   788,   792,
     796,   800,   804,   808,   812,   816,   820,   824,   828,   834,
     836,   838,   842,   847,   852,   856,   861,   866,   868,   870,
     872,   874,   876,   878,   880,   882,   884,   886,   888,   890,
     892,   894,   897,   899,   901,   903,   905,   907,   911,   913,
     915,   918,   921,   929,   938,   947,   950,   953,   954,   956,
     959,   960,   962,   965,   966,   971,   975,   979,   983,   985,
     988,   990,   992,   996,   999,  1003,  1006,  1009,  1011,  1015,
    1019,  1022,  1026,  1028,  1030,  1033,  1035,  1037,  1040,  1042,
    1044,  1046,  1049,  1053,  1056,  1060,  1063,  1066,  1070,  1074,
    1078,  1079,  1086,  1087,  1094,  1097,  1099,  1101,  1103,  1105,
    1107,  1109,  1111,  1113,  1115,  1117,  1119,  1122,  1125,  1127,
    1130,  1132,  1135,  1139,  1142,  1144,  1146,  1148,  1150,  1152,
    1154,  1156,  1159,  1160,  1162,  1164,  1170,  1171,  1173,  1176,
    1178,  1180,  1182,  1184,  1185,  1187,  1191,  1195,  1199,  1203,
    1204,  1206,  1207,  1209,  1212,  1214,  1216,  1219,  1222,  1227,
    1229,  1233,  1236,  1238,  1241,  1244,  1247,  1250,  1252,  1255,
    1257,  1259,  1261,  1263,  1265,  1266,  1269,  1271,  1273,  1275,
    1277,  1279,  1280,  1283,  1285,  1287,  1288,  1290,  1291,  1294,
    1296,  1299,  1303,  1306,  1307,  1309,  1310,  1312,  1314,  1317,
    1318,  1320,  1321,  1326,  1328,  1333,  1337,  1339,  1340,  1342,
    1345,  1347,  1351,  1355,  1358,  1361,  1364,  1366,  1368,  1371,
    1374,  1377,  1379,  1382,  1385,  1388,  1391,  1393,  1395,  1396,
    1398,  1400,  1402,  1404,  1405,  1407,  1409,  1411,  1412,  1415,
    1418,  1420,  1422,  1424,  1429,  1432,  1434,  1439,  1440,  1442,
    1443,  1446,  1448,  1452,  1453,  1460,  1461,  1467,  1468,  1474,
    1475,  1481,  1482,  1494,  1495,  1497,  1498,  1501,  1504,  1506,
    1510,  1513,  1517,  1520,  1525,  1526,  1533,  1534,  1535,  1544,
    1549,  1554,  1558,  1562,  1565,  1568,  1575,  1581,  1585,  1591,
    1593,  1595,  1597,  1598,  1600,  1601,  1603,  1604,  1606,  1608,
    1609,  1612,  1614,  1615,  1617,  1619,  1621,  1622,  1628,  1632,
    1633,  1639,  1643,  1647,  1648,  1652,  1653,  1656,  1658,  1662,
    1663,  1665,  1667,  1668,  1671,  1673,  1677,  1678,  1685,  1686,
    1693,  1694,  1700,  1701,  1703,  1705,  1706,  1713,  1714,  1716,
    1718,  1721,  1723,  1725,  1727,  1728,  1734,  1735,  1741,  1742,
    1744,  1746,  1749,  1751,  1753,  1755,  1757,  1759,  1762,  1763,
    1769,  1770,  1772,  1774,  1775,  1780,  1785,  1789,  1795,  1797,
    1801,  1805,  1811,  1813,  1817,  1820,  1822,  1824,  1825,  1832,
    1834,  1838,  1842,  1843,  1846,  1847,  1852,  1853,  1856,  1858,
    1861,  1866,  1869,  1873,  1874,  1878,  1879,  1880,  1887,  1890,
    1892,  1894,  1897,  1900,  1909,  1914,  1915,  1917,  1920,  1922,
    1924,  1926,  1928,  1930,  1932,  1934,  1936,  1938,  1940,  1942,
    1943,  1946,  1951,  1955,  1957,  1959,  1964,  1965,  1966,  1968,
    1970,  1971,  1974,  1977,  1979,  1981,  1982,  1985,  1989,  1993,
    1997,  2000,  2004,  2009,  2013,  2018,  2022,  2027,  2029,  2033,
    2038,  2042,  2046,  2053,  2055,  2061,  2068,  2074,  2082,  2089,
    2098,  2104,  2111,  2116,  2121,  2127,  2131,  2136,  2138,  2142,
    2146,  2150,  2154,  2158,  2162,  2167,  2172,  2176,  2180,  2184,
    2188,  2192,  2196,  2198,  2200,  2202,  2204,  2206,  2208,  2210,
    2212,  2214,  2216,  2218,  2220,  2222,  2224,  2226,  2228,  2230,
    2233,  2235,  2239,  2241,  2243,  2245,  2247,  2251,  2254,  2257,
    2260,  2263,  2267,  2271,  2277,  2284,  2289,  2294,  2302,  2307,
    2310,  2317,  2323,  2330,  2337,  2342,  2347,  2351,  2356,  2363,
    2372,  2379,  2388,  2395,  2400,  2407,  2412,  2419,  2424,  2429,
    2434,  2439,  2446,  2455,  2458,  2461,  2466,  2469,  2477,  2485,
    2489,  2494,  2499,  2506,  2513,  2518,  2525,  2532,  2539,  2544,
    2551,  2556,  2563,  2572,  2583,  2596,  2603,  2608,  2615,  2622,
    2624,  2631,  2636,  2645,  2656,  2661,  2663,  2667,  2672,  2679,
    2686,  2695,  2702,  2709,  2714,  2721,  2728,  2737,  2742,  2747,
    2754,  2759,  2762,  2767,  2772,  2777,  2784,  2789,  2794,  2798,
    2807,  2814,  2819,  2826,  2830,  2837,  2846,  2851,  2860,  2867,
    2876,  2883,  2892,  2895,  2900,  2905,  2910,  2917,  2926,  2935,
    2940,  2948,  2956,  2964,  2971,  2978,  2985,  2992,  2999,  3006,
    3007,  3013,  3024,  3028,  3033,  3037,  3040,  3043,  3046,  3051,
    3058,  3063,  3068,  3075,  3082,  3089,  3096,  3101,  3108,  3113,
    3120,  3125,  3130,  3135,  3140,  3147,  3152,  3159,  3164,  3171,
    3176,  3181,  3188,  3193,  3200,  3205,  3212,  3217,  3222,  3229,
    3234,  3241,  3242,  3246,  3250,  3251,  3253,  3254,  3257,  3259,
    3263,  3268,  3273,  3279,  3284,  3289,  3294,  3300,  3305,  3306,
    3307,  3315,  3326,  3331,  3337,  3342,  3348,  3353,  3358,  3363,
    3368,  3373,  3379,  3380,  3389,  3390,  3394,  3398,  3400,  3405,
    3406,  3408,  3409,  3412,  3413,  3415,  3416,  3420,  3423,  3427,
    3430,  3432,  3435,  3437,  3440,  3442,  3444,  3446,  3449,  3450,
    3452,  3453,  3456,  3458,  3462,  3464,  3468,  3469,  3472,  3474,
    3478,  3479,  3481,  3482,  3485,  3490,  3496,  3498,  3500,  3502,
    3504,  3508,  3512,  3516,  3517,  3524,  3525,  3532,  3533,  3542,
    3547,  3548,  3557,  3558,  3569,  3576,  3577,  3586,  3587,  3598,
    3605,  3607,  3610,  3613,  3614,  3619,  3620,  3632,  3636,  3643,
    3644,  3648,  3649,  3650,  3656,  3657,  3659,  3660,  3662,  3663,
    3666,  3667,  3670,  3673,  3676,  3677,  3684,  3685,  3687,  3691,
    3693,  3695,  3697,  3701,  3703,  3705,  3707,  3709,  3711,  3713,
    3715,  3717,  3719,  3721,  3723,  3725,  3727,  3729,  3731,  3733,
    3735,  3737,  3739,  3741,  3743,  3745,  3747,  3749,  3751,  3753,
    3755,  3756,  3758,  3760,  3761,  3764,  3765,  3767,  3768,  3769,
    3773,  3774,  3775,  3779,  3782,  3783,  3784,  3789,  3794,  3797,
    3798,  3801,  3804,  3808,  3812,  3814,  3817,  3818,  3820,  3821,
    3826,  3831,  3834,  3835,  3837,  3839,  3840,  3842,  3843,  3845,
    3848,  3850,  3854,  3858,  3860,  3862,  3864,  3866,  3867,  3870,
    3872,  3874,  3876,  3878,  3880,  3882,  3884,  3886,  3888,  3890,
    3892,  3893,  3894,  3901,  3902,  3904,  3908,  3910,  3913,  3914,
    3917,  3921,  3923,  3926,  3928,  3929,  3933,  3934,  3940,  3943,
    3945,  3946,  3950,  3957,  3958,  3965,  3970,  3977,  3982,  3987,
    3992,  3998,  4003,  4005,  4009,  4011,  4012,  4015,  4016,  4018,
    4019,  4020,  4029,  4030,  4031,  4038,  4039,  4041,  4043,  4045,
    4047,  4049,  4052,  4054,  4056,  4058,  4062,  4067,  4068,  4072,
    4076,  4078,  4081,  4084,  4085,  4089,  4090,  4096,  4100,  4102,
    4106,  4108,  4112,  4114,  4116,  4117,  4119,  4120,  4125,  4126,
    4128,  4132,  4134,  4136,  4138,  4139,  4140,  4147,  4148,  4149,
    4161,  4165,  4167,  4171,  4175,  4177,  4181,  4182,  4184,  4185,
    4190,  4191,  4198,  4199,  4205,  4206,  4213,  4215,  4219,  4223,
    4229,  4230,  4233,  4234,  4237,  4239,  4241,  4243,  4247,  4248,
    4250,  4251,  4253,  4255,  4259,  4261,  4263,  4266,  4269,  4272,
    4274,  4276,  4278,  4280,  4281,  4285,  4286,  4290,  4293,  4298,
    4303,  4308,  4313,  4314,  4319,  4326,  4343,  4346,  4349,  4350,
    4357,  4363,  4366,  4369,  4372,  4374,  4380,  4386,  4389,  4392,
    4394,  4399,  4403,  4406,  4409,  4412,  4416,  4419,  4422,  4425,
    4427,  4429,  4433,  4438,  4442,  4446,  4449,  4452,  4456,  4460,
    4464,  4468,  4472,  4476,  4478,  4480,  4482,  4484,  4485,  4487,
    4488,  4491,  4492,  4494,  4496,  4498,  4499,  4502,  4503,  4506,
    4507,  4510,  4513,  4514,  4519,  4520,  4525,  4527,  4529,  4530,
    4532,  4533,  4535,  4537,  4538,  4543,  4547,  4549,  4550,  4554,
    4559,  4562,  4564,  4566,  4568,  4570,  4572,  4574,  4576,  4578,
    4579,  4581,  4582,  4586,  4590,  4592,  4594,  4596,  4599,  4600,
    4604,  4608,  4611,  4614,  4615,  4620,  4621,  4623,  4625,  4628,
    4629,  4634,  4640,  4641,  4642,  4643,  4644,  4663,  4666,  4667,
    4669,  4670,  4672,  4674,  4675,  4677,  4679,  4680,  4683,  4686,
    4688,  4692,  4697,  4701,  4705,  4706,  4709,  4712,  4714,  4718,
    4722,  4723,  4727,  4728,  4732,  4735,  4739,  4741,  4743,  4746,
    4747,  4750,  4752,  4754,  4757,  4760,  4762,  4764,  4766,  4768,
    4770,  4773,  4776,  4778,  4780,  4782,  4784,  4786,  4788,  4790,
    4793,  4796,  4799,  4802,  4805,  4807,  4809,  4811,  4813,  4815,
    4817,  4819,  4823,  4829,  4831,  4833,  4835,  4837,  4839,  4843,
    4848,  4854,  4856,  4862,  4866,  4869,  4871,  4875,  4878,  4880,
    4882,  4884,  4886,  4888,  4890,  4892,  4894,  4896,  4898,  4900,
    4902,  4904,  4906,  4910,  4913,  4915,  4917,  4919,  4921,  4923,
    4925,  4927,  4929,  4931,  4933,  4935,  4937,  4939,  4941,  4943,
    4945,  4947,  4949,  4951,  4953,  4955,  4957,  4959,  4961,  4963,
    4965,  4967,  4969,  4971,  4973,  4975,  4977,  4979,  4981,  4983,
    4985,  4987,  4989,  4991,  4993,  4995,  4997,  4999,  5001,  5003,
    5005,  5007,  5009,  5011,  5013,  5015,  5017,  5019,  5021,  5023,
    5025,  5027,  5029,  5031,  5033,  5035,  5037,  5039,  5041,  5043,
    5045,  5047,  5049,  5051,  5053,  5055,  5057,  5059,  5061,  5063,
    5065,  5067,  5069,  5071,  5073,  5075,  5077,  5079,  5081,  5083,
    5085,  5087,  5089,  5091,  5093,  5095,  5097,  5099,  5101,  5103,
    5105,  5107,  5109,  5111,  5113,  5115,  5117,  5119,  5121,  5123,
    5125,  5127,  5129,  5131,  5133,  5135,  5137,  5139,  5141,  5143,
    5145,  5147,  5149,  5151,  5153,  5155,  5157,  5159,  5161,  5163,
    5165,  5167,  5169,  5171,  5173,  5175,  5177,  5179,  5181,  5183,
    5185,  5187,  5189,  5191,  5193,  5195,  5197,  5199,  5201,  5203,
    5205,  5207,  5209,  5211,  5213,  5215,  5217,  5219,  5221,  5223,
    5225,  5227,  5229,  5231,  5233,  5235,  5237,  5239,  5241,  5243,
    5245,  5247,  5249,  5251,  5253,  5255,  5257,  5259,  5261,  5263,
    5265,  5267,  5269,  5271,  5273,  5275,  5277,  5279,  5281,  5283,
    5285,  5287,  5289,  5291,  5293,  5295,  5297,  5299,  5301,  5303,
    5305,  5307,  5309,  5311,  5313,  5315,  5317,  5319,  5321,  5323,
    5325,  5327,  5329,  5331,  5333,  5335,  5337,  5339,  5341,  5343,
    5345,  5347,  5349,  5351,  5353,  5355,  5357,  5359,  5361,  5363,
    5365,  5367,  5369,  5371,  5373,  5375,  5377,  5379,  5381,  5383,
    5385,  5387,  5389,  5391,  5393,  5395,  5397,  5399,  5401,  5403,
    5405,  5407,  5409,  5411,  5413,  5415,  5417,  5419,  5421,  5423,
    5425,  5427,  5429,  5431,  5433,  5435,  5437,  5439,  5440,  5445,
    5446,  5448,  5450,  5454,  5455,  5458,  5460,  5462,  5464,  5466,
    5467,  5469,  5470,  5472,  5474,  5476,  5477,  5480,  5483,  5486,
    5488,  5491,  5496,  5502,  5507,  5514,  5517,  5521,  5525,  5529,
    5535,  5537,  5541,  5545,  5548,  5551,  5554,  5556,  5558,  5563,
    5568,  5570,  5572,  5574,  5576,  5578,  5579,  5584,  5586,  5588,
    5590,  5594,  5598,  5600,  5602,  5605,  5608,  5609,  5613,  5618,
    5622,  5623,  5631,  5633,  5636,  5638,  5640,  5642,  5644,  5646,
    5648,  5649,  5655,  5657,  5659,  5661,  5663,  5665,  5669,  5676,
    5683,  5690,  5698,  5702,  5711,  5720,  5729,  5730,  5732,  5734,
    5737,  5738,  5740,  5742,  5746,  5747,  5751,  5752,  5756,  5757,
    5761,  5762,  5766,  5768,  5770,  5772,  5774,  5776,  5778,  5780,
    5782,  5784,  5786,  5788,  5791,  5794,  5796,  5800,  5803,  5806,
    5809,  5812,  5815,  5818,  5821,  5824,  5825,  5827,  5831,  5833,
    5836,  5839,  5842,  5844,  5848,  5852,  5854,  5856,  5860,  5862,
    5866,  5871,  5877,  5879,  5880,  5884,  5888,  5890,  5892,  5893,
    5896,  5899,  5902,  5905,  5906,  5909,  5912,  5914,  5917,  5920,
    5923,  5926,  5929,  5930,  5934,  5935,  5937,  5938,  5942,  5945,
    5946,  5948,  5951,  5952,  5954,  5959,  5964,  5970,  5973,  5977,
    5978,  5980,  5981,  5986,  5987,  5989,  5991,  5992,  5995,  5998,
    6000,  6001,  6003,  6005,  6006,  6012,  6019,  6020,  6021,  6024,
    6027,  6031,  6033,  6035,  6037,  6039,  6041,  6043,  6045,  6047,
    6049,  6051,  6053,  6054,  6058,  6060,  6063,  6065,  6068,  6072,
    6076,  6080,  6081,  6083,  6084,  6088,  6092,  6093,  6102,  6103,
    6107,  6109,  6113,  6114,  6117,  6121,  6127,  6128,  6132,  6137,
    6142,  6143,  6158,  6167,  6175,  6176,  6177,  6178,  6179,  6180,
    6196,  6197,  6198,  6199,  6200,  6213,  6218,  6223,  6227,  6232,
    6236,  6239,  6241,  6245,  6251,  6253,  6255,  6256,  6258,  6260,
    6261,  6264,  6265,  6266,  6270,  6271
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     584,     0,    -1,     3,    -1,    -1,   587,   585,   579,   586,
      -1,   587,     3,    -1,    -1,     3,    -1,   588,    -1,  1196,
      -1,   785,    -1,   826,    -1,   816,    -1,   617,    -1,   600,
      -1,   828,    -1,   818,    -1,  1202,    -1,   605,    -1,   589,
      -1,  1036,    -1,  1067,    -1,   992,    -1,   994,    -1,   593,
      -1,  1073,    -1,  1171,    -1,  1162,    -1,   598,    -1,  1000,
      -1,  1087,    -1,  1091,    -1,  1154,    -1,   833,    -1,   841,
      -1,   845,    -1,   591,    -1,  1083,    -1,  1205,    -1,   836,
      -1,   821,    -1,  1003,    -1,  1079,    -1,   814,    -1,  1169,
      -1,  1203,    -1,  1204,    -1,   853,    -1,  1137,    -1,  1053,
      -1,   803,    -1,   806,    -1,  1047,    -1,  1160,    -1,  1028,
      -1,  1090,    -1,  1251,    -1,   590,   370,  1131,    -1,   106,
      -1,   129,    -1,   370,  1131,   175,   592,    -1,  1128,    -1,
     580,  1133,    -1,    -1,   151,  1131,   594,   595,    -1,    -1,
     530,   596,    -1,   596,   575,   597,    -1,   597,    -1,   580,
    1133,    -1,    -1,   202,   599,  1133,    -1,    -1,    53,   287,
     498,   601,   602,    -1,   603,    -1,   602,   575,   603,    -1,
     274,   145,  1128,    -1,   288,   145,  1128,    -1,   277,   145,
    1128,    -1,   278,   145,   977,    -1,   273,   145,   977,    -1,
     286,   145,   977,    -1,   282,   145,  1128,    -1,   281,   145,
    1128,    -1,   283,   145,  1128,    -1,   284,   145,  1128,    -1,
     285,   145,  1128,    -1,   604,    -1,   275,   145,  1128,    -1,
     276,   145,   978,    -1,   396,   145,  1128,    -1,   397,   145,
     977,    -1,    -1,    87,   702,   485,   705,  1125,   606,   689,
      -1,    -1,    87,   777,   217,  1131,   778,   344,  1125,   607,
     573,   780,   574,    -1,    -1,    87,    94,   705,  1131,   608,
     699,    -1,    -1,    87,   609,  1218,    -1,    87,   527,   610,
    1187,    -1,    -1,  1131,   581,  1131,    -1,  1131,    -1,    -1,
     612,   614,    -1,    -1,   613,   615,    -1,    68,  1128,    -1,
     241,   461,    -1,   335,   461,    -1,    80,   461,    -1,   389,
     461,    96,    -1,   311,   461,    96,    -1,   616,    -1,   614,
      -1,   121,    -1,   880,   121,    -1,   461,   429,   112,    -1,
     461,   429,   228,    -1,    -1,    48,   611,   618,   619,    -1,
      -1,   573,   620,   574,    -1,    -1,   621,    -1,   621,   575,
     874,    -1,   874,    -1,    -1,   623,    -1,   623,   575,   625,
      -1,   625,    -1,    -1,  1131,   624,   728,    -1,    -1,   627,
      -1,   627,   575,   628,    -1,   628,    -1,   629,   624,  1131,
     728,    -1,    -1,   229,    -1,   357,    -1,   221,    -1,    -1,
     630,   646,   579,    -1,   646,   579,    -1,   631,   646,   579,
      -1,    -1,   632,   633,   579,    -1,    -1,   109,   644,   634,
     728,   645,    -1,   109,  1131,    76,   172,   641,    -1,    -1,
     109,   638,   199,   172,   635,   639,   646,    -1,   109,  1131,
      92,   172,   636,    -1,    -1,   637,   588,    -1,   153,    -1,
      82,    -1,   640,    -1,   639,   575,   640,    -1,   643,    -1,
     977,    -1,   453,   642,  1129,    -1,    -1,   536,    -1,   641,
      -1,  1131,    -1,   454,    -1,   880,   173,    -1,   452,    -1,
    1131,    -1,   644,   575,  1131,    -1,    -1,   111,   874,    -1,
      -1,   647,   588,    -1,    -1,   414,   648,   874,    -1,    -1,
     213,   649,   654,   141,   213,    -1,   659,    -1,   674,    -1,
      -1,   650,   683,    -1,   677,    -1,   679,    -1,   248,  1132,
      -1,   235,  1132,    -1,   347,  1131,    -1,    -1,   161,   652,
    1131,   226,   651,   653,    -1,    61,  1131,    -1,    -1,   330,
     175,    -1,   175,    -1,  1131,    -1,   653,   575,  1131,    -1,
      -1,    -1,    -1,   655,   874,   560,   656,   631,   657,   658,
      -1,    -1,   135,   654,    -1,   559,   631,    -1,   660,    -1,
     663,    -1,    -1,    -1,   561,   661,   874,   662,   665,   673,
     141,   561,    -1,    -1,   561,   664,   666,   673,   141,   561,
      -1,   667,    -1,   665,   667,    -1,   670,    -1,   666,   670,
      -1,    -1,    -1,   545,   668,   874,   669,   560,   631,    -1,
      -1,    -1,   545,   671,   874,   672,   560,   631,    -1,    -1,
     559,   631,    -1,    -1,  1132,   582,   675,   683,   676,    -1,
      -1,  1132,    -1,    -1,  1132,   582,   678,   681,   676,    -1,
      -1,   680,   681,    -1,    -1,    28,   682,   632,   630,   141,
      -1,   269,   631,   141,   269,    -1,    -1,    -1,   547,   684,
     874,   128,   685,   631,   141,   547,    -1,    -1,   404,   631,
     523,   686,   874,   141,   404,    -1,    27,    -1,     8,    -1,
     223,    -1,   524,    -1,   115,    -1,   573,   690,    -1,   706,
     692,    -1,   252,  1125,    -1,   573,   252,  1125,   574,    -1,
     718,   574,   706,   692,    -1,    -1,   695,   574,   691,  1209,
      -1,    -1,    -1,  1100,   698,   695,   693,  1206,    -1,    -1,
    1100,   698,   573,   695,   574,   694,  1209,    -1,    -1,    -1,
     430,   696,   863,   867,   697,   716,    -1,    -1,    18,    -1,
      -1,   700,    -1,   701,    -1,   700,   701,    -1,   711,    -1,
     710,    -1,    -1,   703,    -1,   704,    -1,   704,   703,    -1,
     486,    -1,    -1,   213,   880,   152,    -1,    -1,   708,    -1,
     709,    -1,   709,   707,    -1,   709,    -1,   709,   708,    -1,
     709,   575,   708,    -1,   143,  1020,   712,    -1,   507,  1020,
     712,    -1,   292,  1020,   978,    -1,   307,  1020,   978,    -1,
      24,  1020,   977,    -1,   361,  1020,  1128,    -1,    68,  1020,
    1128,    -1,    23,  1020,   978,    -1,   358,  1020,   977,    -1,
     358,  1020,   111,    -1,    57,  1020,   977,    -1,   114,  1020,
     977,    -1,   423,  1020,   713,    -1,   387,  1020,   714,    -1,
     384,  1020,   977,    -1,   385,  1020,   977,    -1,   516,  1020,
     573,  1078,   574,    -1,   710,    -1,   711,    -1,   224,  1020,
     715,    -1,    96,   122,  1020,  1128,    -1,   217,   122,  1020,
    1128,    -1,    77,  1020,  1128,    -1,   759,   750,  1020,   752,
      -1,   759,    64,  1020,   758,    -1,  1133,    -1,   111,    -1,
     165,    -1,   133,    -1,    72,    -1,   393,    -1,    71,    -1,
     386,    -1,   383,    -1,   977,    -1,   335,    -1,   164,    -1,
     243,    -1,   972,    -1,   862,   866,    -1,   472,    -1,   391,
      -1,   108,    -1,   227,    -1,   719,    -1,   718,   575,   719,
      -1,   720,    -1,   721,    -1,   726,   722,    -1,   726,   764,
      -1,   772,   782,   778,   573,   780,   574,   778,    -1,   724,
     773,   782,   778,   573,   780,   574,   778,    -1,   724,   170,
     238,   782,   573,   780,   574,   764,    -1,   725,   722,    -1,
     724,   723,    -1,    -1,   723,    -1,    58,   874,    -1,    -1,
     725,    -1,    79,   782,    -1,    -1,  1124,   727,   728,   746,
      -1,   736,   743,   740,    -1,   737,   745,   740,    -1,   167,
     738,   740,    -1,    37,    -1,    37,   744,    -1,    42,    -1,
      41,    -1,   732,   744,   760,    -1,   732,   760,    -1,   733,
     744,   761,    -1,   733,   761,    -1,    32,   744,    -1,    32,
      -1,   734,   744,   760,    -1,   735,   744,   761,    -1,   537,
     744,    -1,   556,   743,   740,    -1,   100,    -1,   494,    -1,
     491,   743,    -1,    97,    -1,   495,    -1,    39,   743,    -1,
     731,    -1,   296,    -1,   265,    -1,   268,   537,    -1,   268,
     734,   760,    -1,   497,   760,    -1,   490,   743,   760,    -1,
     298,   760,    -1,   266,   760,    -1,   108,   738,   740,    -1,
     339,   738,   740,    -1,   165,   738,   740,    -1,    -1,   144,
     729,   573,   784,   574,   760,    -1,    -1,   436,   730,   573,
     784,   574,   760,    -1,   268,   760,    -1,   434,    -1,   187,
      -1,   186,    -1,   365,    -1,   318,    -1,   256,    -1,   317,
      -1,   367,    -1,   319,    -1,    56,    -1,   326,    -1,   323,
      56,    -1,   732,   541,    -1,   538,    -1,   323,   538,    -1,
     340,    -1,   326,   538,    -1,   323,    56,   541,    -1,   326,
     541,    -1,   227,    -1,   496,    -1,   446,    -1,   297,    -1,
      31,    -1,   391,    -1,   127,    -1,   127,   369,    -1,    -1,
     744,    -1,   739,    -1,   573,   338,   575,   338,   574,    -1,
      -1,   741,    -1,   741,   742,    -1,   742,    -1,   443,    -1,
     522,    -1,   557,    -1,    -1,   744,    -1,   573,   267,   574,
      -1,   573,   510,   574,    -1,   573,   107,   574,    -1,   573,
     338,   574,    -1,    -1,   739,    -1,    -1,   747,    -1,   747,
     748,    -1,   748,    -1,   337,    -1,   880,   337,    -1,   111,
     749,    -1,   344,   524,   334,   873,    -1,    23,    -1,   434,
     111,   536,    -1,   763,   238,    -1,   517,    -1,   517,   238,
      -1,    68,  1128,    -1,    64,   756,    -1,   334,   873,    -1,
    1115,    -1,    56,   436,    -1,    55,    -1,  1133,    -1,    32,
      -1,   751,    -1,   111,    -1,    -1,   750,   752,    -1,  1133,
      -1,    32,    -1,   754,    -1,   111,    -1,  1133,    -1,    -1,
      64,   758,    -1,   756,    -1,   111,    -1,    -1,   111,    -1,
      -1,    20,   761,    -1,    46,    -1,   515,   761,    -1,   750,
     751,   761,    -1,    32,   762,    -1,    -1,    32,    -1,    -1,
      20,    -1,   515,    -1,   750,   751,    -1,    -1,   372,    -1,
      -1,   394,  1125,   765,   766,    -1,   768,    -1,   573,   767,
     574,   768,    -1,   767,   575,  1131,    -1,  1131,    -1,    -1,
     769,    -1,   769,   770,    -1,   770,    -1,   344,   115,   771,
      -1,   344,   524,   771,    -1,   289,   177,    -1,   289,   360,
      -1,   289,   444,    -1,   411,    -1,    49,    -1,   436,   337,
      -1,   335,     5,    -1,   436,   111,    -1,   774,    -1,   178,
     775,    -1,   450,   775,    -1,   372,   238,    -1,   517,   775,
      -1,   238,    -1,   217,    -1,    -1,   774,    -1,   237,    -1,
     217,    -1,   216,    -1,    -1,   517,    -1,   178,    -1,   450,
      -1,    -1,   530,   779,    -1,   507,   779,    -1,    44,    -1,
     425,    -1,   200,    -1,   780,   575,   781,   970,    -1,   781,
     970,    -1,  1131,    -1,  1131,   573,   338,   574,    -1,    -1,
    1124,    -1,    -1,   581,  1131,    -1,  1113,    -1,   784,   575,
    1113,    -1,    -1,    13,   799,   485,  1125,   786,   792,    -1,
      -1,    13,    94,   791,   787,   700,    -1,    -1,    13,   374,
     611,   788,   612,    -1,    -1,    13,   179,   611,   789,   612,
      -1,    -1,    13,  1227,  1221,  1228,   542,  1125,   790,  1231,
      18,  1233,  1236,    -1,    -1,  1131,    -1,    -1,   124,   484,
      -1,   215,   484,    -1,   794,    -1,   792,   575,   794,    -1,
       6,   798,    -1,   793,   720,   801,    -1,     6,   721,    -1,
     793,   573,   718,   574,    -1,    -1,    53,   798,  1124,   795,
     726,   801,    -1,    -1,    -1,   312,   798,  1124,   796,   728,
     746,   797,   801,    -1,   129,   798,  1124,   800,    -1,   129,
     170,   238,   782,    -1,   129,   372,   238,    -1,   129,   774,
    1124,    -1,   123,   237,    -1,   137,   237,    -1,    13,   798,
    1124,   436,   111,  1115,    -1,    13,   798,  1124,   129,   111,
      -1,   401,   802,  1125,    -1,    83,   498,   750,   752,   757,
      -1,   707,    -1,   169,    -1,   963,    -1,    -1,    67,    -1,
      -1,   214,    -1,    -1,   411,    -1,    49,    -1,    -1,     8,
    1131,    -1,   164,    -1,    -1,   498,    -1,   145,    -1,    18,
      -1,    -1,   465,   445,   808,   804,   812,    -1,   469,   445,
     808,    -1,    -1,   445,   465,   808,   805,   812,    -1,   445,
     469,   808,    -1,   465,   500,   807,    -1,    -1,   548,    78,
     447,    -1,    -1,   809,   810,    -1,   811,    -1,   810,   575,
     811,    -1,    -1,   462,    -1,   398,    -1,    -1,   523,   813,
      -1,   604,    -1,   813,   575,   604,    -1,    -1,   410,  1156,
     815,   996,   175,  1128,    -1,    -1,    26,  1156,   817,   996,
     498,  1128,    -1,    -1,    57,  1156,   819,   996,   820,    -1,
      -1,   382,    -1,   156,    -1,    -1,   402,   835,  1156,   822,
     996,   823,    -1,    -1,   824,    -1,   825,    -1,   825,   824,
      -1,   382,    -1,   156,    -1,   528,    -1,    -1,    14,   835,
    1156,   827,   996,    -1,    -1,    58,  1156,   829,   996,   830,
      -1,    -1,   831,    -1,   832,    -1,   832,   831,    -1,   382,
      -1,   159,    -1,   299,    -1,   156,    -1,    54,    -1,   172,
     525,    -1,    -1,   348,   835,  1156,   834,   996,    -1,    -1,
     336,    -1,   258,    -1,    -1,   401,  1156,   837,   839,    -1,
     401,   527,   610,   838,    -1,  1134,   498,  1134,    -1,   838,
     575,  1134,   498,  1134,    -1,   840,    -1,   839,   575,   840,
      -1,  1125,   498,  1125,    -1,    47,   217,   842,   229,   844,
      -1,   843,    -1,   842,   575,   843,    -1,  1125,   849,    -1,
    1131,    -1,   111,    -1,    -1,   257,   217,   226,    47,   846,
     847,    -1,   848,    -1,   847,   575,   848,    -1,  1125,   849,
     852,    -1,    -1,   850,   851,    -1,    -1,   775,   573,   946,
     574,    -1,    -1,   214,   247,    -1,   854,    -1,   430,   856,
      -1,   573,   855,   574,  1209,    -1,   430,   858,    -1,   573,
     855,   574,    -1,    -1,   858,   857,  1206,    -1,    -1,    -1,
     859,   863,   867,   860,   861,   866,    -1,   966,   972,    -1,
     988,    -1,   862,    -1,   988,   862,    -1,   862,   988,    -1,
     175,   919,   955,   960,   957,   966,   972,   979,    -1,   175,
     130,   955,   972,    -1,    -1,   864,    -1,   864,   865,    -1,
     865,    -1,   471,    -1,   204,    -1,   125,    -1,   460,    -1,
     455,    -1,   456,    -1,   458,    -1,   459,    -1,   457,    -1,
      12,    -1,    -1,   172,   524,    -1,   262,   229,   438,   310,
      -1,   867,   575,   868,    -1,   868,    -1,   567,    -1,   869,
     871,   870,   872,    -1,    -1,    -1,  1119,    -1,   874,    -1,
      -1,    18,  1131,    -1,    18,  1128,    -1,  1131,    -1,  1128,
      -1,    -1,   573,   574,    -1,   874,   878,   874,    -1,   874,
     553,   874,    -1,   874,   879,   874,    -1,   333,   874,    -1,
     875,   232,   504,    -1,   875,   232,   880,   504,    -1,   875,
     232,   158,    -1,   875,   232,   880,   158,    -1,   875,   232,
     520,    -1,   875,   232,   880,   520,    -1,   875,    -1,   875,
     232,   337,    -1,   875,   232,   880,   337,    -1,   875,   146,
     876,    -1,   875,   882,   876,    -1,   875,   882,   883,   573,
    1215,   574,    -1,   876,    -1,   877,   229,   573,  1215,   574,
      -1,   877,   880,   229,   573,  1215,   574,    -1,   877,   229,
     573,   874,   574,    -1,   877,   229,   573,   874,   575,   908,
     574,    -1,   877,   880,   229,   573,   874,   574,    -1,   877,
     880,   229,   573,   874,   575,   908,   574,    -1,   877,   562,
     877,    16,   876,    -1,   877,   880,   562,   877,    16,   876,
      -1,   877,   448,   252,   877,    -1,   877,   252,   885,   959,
      -1,   877,   880,   252,   885,   959,    -1,   877,   395,   877,
      -1,   877,   880,   395,   877,    -1,   877,    -1,   877,   563,
     877,    -1,   877,   564,   877,    -1,   877,   439,   877,    -1,
     877,   440,   877,    -1,   877,   566,   877,    -1,   877,   565,
     877,    -1,   877,   566,   884,   948,    -1,   877,   565,   884,
     948,    -1,   877,   567,   877,    -1,   877,   568,   877,    -1,
     877,   569,   877,    -1,   877,   126,   877,    -1,   877,   313,
     877,    -1,   877,   570,   877,    -1,   885,    -1,   354,    -1,
     351,    -1,    16,    -1,    15,    -1,   333,    -1,   332,    -1,
     576,    -1,   332,    -1,   145,    -1,   184,    -1,   198,    -1,
     244,    -1,   271,    -1,   328,    -1,    12,    -1,    17,    -1,
     225,   874,    -1,  1121,    -1,   885,    64,  1133,    -1,  1116,
      -1,  1114,    -1,   898,    -1,   894,    -1,   885,   353,   885,
      -1,   566,   885,    -1,   565,   885,    -1,   571,   885,    -1,
     881,   885,    -1,   573,  1215,   574,    -1,   573,   874,   574,
      -1,   573,   874,   575,   908,   574,    -1,   424,   573,   874,
     575,   908,   574,    -1,   152,   573,  1215,   574,    -1,   577,
    1131,   874,   578,    -1,   289,   911,     9,   573,   877,   888,
     574,    -1,    20,   573,   874,   574,    -1,    32,   885,    -1,
      51,   573,   874,    18,   906,   574,    -1,   561,   915,   917,
     916,   141,    -1,    83,   573,   874,   575,   906,   574,    -1,
      83,   573,   874,   530,   751,   574,    -1,   111,   573,  1121,
     574,    -1,   535,   573,  1122,   574,    -1,   180,   573,   574,
      -1,   181,   573,   874,   574,    -1,   182,   573,   874,   575,
     874,   574,    -1,   183,   573,   874,   575,   874,   575,   874,
     574,    -1,     7,   573,   874,   575,   874,   574,    -1,     7,
     573,   874,   575,   225,   874,   948,   574,    -1,   404,   573,
     874,   575,   874,   574,    -1,    22,   573,   874,   574,    -1,
      22,   573,   874,   575,   874,   574,    -1,    56,   573,   908,
     574,    -1,    56,   573,   908,   530,   751,   574,    -1,    55,
     573,   874,   574,    -1,    62,   573,   908,   574,    -1,    65,
     573,   874,   574,    -1,    73,   573,   908,   574,    -1,    74,
     573,   874,   575,   908,   574,    -1,    84,   573,   874,   575,
     874,   575,   874,   574,    -1,    90,   873,    -1,    93,   873,
      -1,    93,   573,   874,   574,    -1,    91,   873,    -1,    98,
     573,   874,   575,   884,   948,   574,    -1,    99,   573,   874,
     575,   884,   948,   574,    -1,    94,   573,   574,    -1,   100,
     573,   874,   574,    -1,   105,   573,   874,   574,    -1,   136,
     573,   874,   575,   908,   574,    -1,   272,   573,   874,   575,
     908,   574,    -1,   140,   573,   874,   574,    -1,   140,   573,
     874,   575,   874,   574,    -1,   110,   573,   874,   575,  1129,
     574,    -1,   139,   573,   874,   575,  1129,   574,    -1,   118,
     573,   874,   574,    -1,   118,   573,   874,   575,   874,   574,
      -1,   119,   573,   874,   574,    -1,   119,   573,   874,   575,
     874,   574,    -1,   155,   573,   874,   575,   874,   575,   874,
     574,    -1,   155,   573,   874,   575,   874,   575,   874,   575,
     874,   574,    -1,   155,   573,   874,   575,   874,   575,   874,
     575,   874,   575,   874,   574,    -1,   171,   573,   874,   575,
     338,   574,    -1,   176,   573,   874,   574,    -1,   176,   573,
     874,   575,   874,   574,    -1,   162,   573,   874,   575,   908,
     574,    -1,   887,    -1,   190,   573,   951,   575,   874,   574,
      -1,   209,   573,   874,   574,    -1,   213,   573,   874,   575,
     874,   575,   874,   574,    -1,   223,   573,   874,   575,   874,
     575,   874,   575,   874,   574,    -1,   884,   948,   566,   874,
      -1,   884,    -1,   242,   573,   574,    -1,   242,   573,   874,
     574,    -1,   249,   573,   874,   575,   874,   574,    -1,   259,
     573,   874,   575,   874,   574,    -1,   259,   573,   874,   575,
     874,   575,   874,   574,    -1,   194,   573,   874,   575,   908,
     574,    -1,   246,   573,   874,   575,   908,   574,    -1,   264,
     573,   874,   574,    -1,   264,   573,   874,   575,   874,   574,
      -1,   279,   573,   874,   575,   874,   574,    -1,   279,   573,
     874,   575,   874,   575,   874,   574,    -1,   302,   573,   874,
     574,    -1,   306,   573,   874,   574,    -1,   313,   573,   874,
     575,   874,   574,    -1,   314,   573,   874,   574,    -1,   334,
     873,    -1,   334,   573,   874,   574,    -1,   361,   573,   874,
     574,    -1,   343,   573,   874,   574,    -1,   368,   573,   877,
     229,   874,   574,    -1,   380,   573,   874,   574,    -1,   388,
     573,   874,   574,    -1,   388,   573,   574,    -1,   405,   573,
     874,   575,   874,   575,   874,   574,    -1,   416,   573,   874,
     575,   874,   574,    -1,   419,   573,   874,   574,    -1,   419,
     573,   874,   575,   874,   574,    -1,   422,   573,   574,    -1,
     473,   573,   874,   575,   874,   574,    -1,   473,   573,   874,
     575,   225,   874,   948,   574,    -1,   428,   573,   874,   574,
      -1,   475,   573,   874,   575,   874,   575,   874,   574,    -1,
     475,   573,   874,   575,   874,   574,    -1,   475,   573,   874,
     175,   874,   172,   874,   574,    -1,   475,   573,   874,   175,
     874,   574,    -1,   476,   573,   874,   575,   874,   575,   874,
     574,    -1,   482,   873,    -1,   482,   573,   874,   574,    -1,
     494,   573,   874,   574,    -1,   491,   573,   874,   574,    -1,
     491,   573,   874,   575,   874,   574,    -1,   492,   573,   949,
     575,   874,   575,   874,   574,    -1,   493,   573,   949,   575,
     874,   575,   874,   574,    -1,   503,   573,   874,   574,    -1,
     503,   573,   245,   874,   175,   874,   574,    -1,   503,   573,
     499,   874,   175,   874,   574,    -1,   503,   573,    43,   874,
     175,   874,   574,    -1,   503,   573,   245,   175,   874,   574,
      -1,   503,   573,   499,   175,   874,   574,    -1,   503,   573,
      43,   175,   874,   574,    -1,   503,   573,   874,   175,   874,
     574,    -1,   505,   573,   874,   575,   874,   574,    -1,  1131,
     581,  1131,   573,   907,   574,    -1,    -1,  1127,   573,   886,
     889,   574,    -1,   518,   573,  1112,   575,   338,   575,   338,
     575,   908,   574,    -1,   519,   573,   574,    -1,   519,   573,
     874,   574,    -1,   527,   573,   574,    -1,   531,   873,    -1,
     533,   873,    -1,   532,   873,    -1,   544,   573,   874,   574,
      -1,   544,   573,   874,   575,   874,   574,    -1,   556,   573,
     874,   574,    -1,   554,   573,   874,   574,    -1,   554,   573,
     874,   575,   874,   574,    -1,    29,   573,   977,   575,   874,
     574,    -1,   157,   573,   948,   175,   874,   574,    -1,    80,
     573,   874,   575,   874,   574,    -1,   188,   573,   874,   574,
      -1,   188,   573,   874,   575,   874,   574,    -1,   189,   573,
     874,   574,    -1,   189,   573,   874,   575,   874,   574,    -1,
     186,   573,   908,   574,    -1,   256,   573,   908,   574,    -1,
     317,   573,   908,   574,    -1,   309,   573,   874,   574,    -1,
     309,   573,   874,   575,   874,   574,    -1,   315,   573,   874,
     574,    -1,   315,   573,   874,   575,   874,   574,    -1,   316,
     573,   874,   574,    -1,   316,   573,   874,   575,   874,   574,
      -1,   318,   573,   908,   574,    -1,   319,   573,   908,   574,
      -1,   365,   573,   874,   575,   874,   574,    -1,   364,   573,
     874,   574,    -1,   364,   573,   874,   575,   874,   574,    -1,
     366,   573,   874,   574,    -1,   366,   573,   874,   575,   874,
     574,    -1,   367,   573,   908,   574,    -1,   185,   573,   874,
     574,    -1,   185,   573,   874,   575,   874,   574,    -1,   254,
     573,   874,   574,    -1,   254,   573,   874,   575,   874,   574,
      -1,    -1,   548,   381,   154,    -1,   229,    41,   310,    -1,
      -1,   890,    -1,    -1,   891,   892,    -1,   893,    -1,   892,
     575,   893,    -1,   869,   874,   870,   872,    -1,    25,   573,
     904,   574,    -1,    25,   573,   125,   904,   574,    -1,    35,
     573,   904,   574,    -1,    36,   573,   904,   574,    -1,    38,
     573,   904,   574,    -1,    85,   573,   954,   567,   574,    -1,
      85,   573,   904,   574,    -1,    -1,    -1,    85,   573,   125,
     895,   908,   896,   574,    -1,   197,   573,  1112,   575,   338,
     575,   338,   575,   904,   574,    -1,   308,   573,   904,   574,
      -1,   308,   573,   125,   904,   574,    -1,   293,   573,   904,
     574,    -1,   293,   573,   125,   904,   574,    -1,   467,   573,
     904,   574,    -1,   540,   573,   904,   574,    -1,   468,   573,
     904,   574,    -1,   534,   573,   904,   574,    -1,   477,   573,
     904,   574,    -1,   477,   573,   125,   904,   574,    -1,    -1,
     196,   573,   901,   897,   908,   903,   902,   574,    -1,    -1,
     580,   899,   900,    -1,  1133,   437,   874,    -1,  1133,    -1,
     580,  1146,  1133,   783,    -1,    -1,   125,    -1,    -1,   432,
    1113,    -1,    -1,   967,    -1,    -1,   954,   905,   874,    -1,
      32,   743,    -1,    56,   743,   760,    -1,   326,   743,    -1,
     443,    -1,   443,   227,    -1,   522,    -1,   522,   227,    -1,
     100,    -1,   494,    -1,    97,    -1,   108,   738,    -1,    -1,
     908,    -1,    -1,   909,   910,    -1,   874,    -1,   910,   575,
     874,    -1,   912,    -1,   573,   912,   574,    -1,    -1,   913,
     914,    -1,  1121,    -1,   914,   575,  1121,    -1,    -1,   874,
      -1,    -1,   559,   874,    -1,   545,   874,   560,   874,    -1,
     917,   545,   874,   560,   874,    -1,   930,    -1,   921,    -1,
     920,    -1,   918,    -1,   920,   575,   918,    -1,   918,   929,
     918,    -1,   918,   471,   930,    -1,    -1,   918,   929,   918,
     344,   922,   874,    -1,    -1,   918,   471,   930,   344,   923,
     874,    -1,    -1,   918,   929,   918,   530,   924,   573,   947,
     574,    -1,   918,   324,   236,   930,    -1,    -1,   918,   249,
     940,   236,   918,   344,   925,   874,    -1,    -1,   918,   249,
     940,   236,   930,   926,   530,   573,   947,   574,    -1,   918,
     324,   249,   940,   236,   930,    -1,    -1,   918,   416,   940,
     236,   918,   344,   927,   874,    -1,    -1,   918,   416,   940,
     236,   930,   928,   530,   573,   947,   574,    -1,   918,   324,
     416,   940,   236,   930,    -1,   236,    -1,   219,   236,    -1,
      88,   236,    -1,    -1,   931,  1125,   953,   942,    -1,    -1,
     577,  1131,   918,   249,   355,   236,   918,   344,   932,   874,
     578,    -1,   939,   938,   935,    -1,   573,   938,   933,  1209,
     574,   953,    -1,    -1,   938,   934,   920,    -1,    -1,    -1,
     936,   863,   867,   937,   716,    -1,    -1,   430,    -1,    -1,
     355,    -1,    -1,   172,   236,    -1,    -1,   529,   943,    -1,
     169,   943,    -1,   214,   943,    -1,    -1,   774,   941,   944,
     573,   945,   574,    -1,    -1,   946,    -1,   946,   575,  1131,
      -1,  1131,    -1,   372,    -1,  1131,    -1,   947,   575,  1131,
      -1,   950,    -1,   101,    -1,   102,    -1,   103,    -1,   104,
      -1,   206,    -1,   207,    -1,   208,    -1,   304,    -1,   305,
      -1,   427,    -1,   555,    -1,   950,    -1,   174,    -1,   105,
      -1,   544,    -1,   209,    -1,   306,    -1,   314,    -1,   380,
      -1,   428,    -1,   302,    -1,   556,    -1,   100,    -1,   494,
      -1,    97,    -1,   491,    -1,    -1,    18,    -1,   145,    -1,
      -1,   952,  1131,    -1,    -1,    12,    -1,    -1,    -1,   546,
     956,   874,    -1,    -1,    -1,   201,   958,   874,    -1,   149,
     885,    -1,    -1,    -1,   195,    45,   961,   962,    -1,   961,
     575,  1120,   970,    -1,  1120,   970,    -1,    -1,   548,    89,
      -1,   548,   418,    -1,   352,    45,   964,    -1,   964,   575,
     965,    -1,   965,    -1,  1122,   970,    -1,    -1,   967,    -1,
      -1,   352,    45,   968,   969,    -1,   969,   575,  1120,   970,
      -1,  1120,   970,    -1,    -1,    19,    -1,   116,    -1,    -1,
     973,    -1,    -1,   973,    -1,   253,   974,    -1,   975,    -1,
     975,   575,   975,    -1,   975,   341,   975,    -1,  1114,    -1,
     510,    -1,   267,    -1,   338,    -1,    -1,   253,   975,    -1,
     338,    -1,   203,    -1,   267,    -1,   510,    -1,   107,    -1,
     166,    -1,   338,    -1,   510,    -1,   267,    -1,   107,    -1,
     166,    -1,    -1,    -1,   374,  1131,   980,   573,   981,   574,
      -1,    -1,   982,    -1,   982,   575,   983,    -1,   983,    -1,
     869,   874,    -1,    -1,   985,   986,    -1,   986,   575,   987,
      -1,   987,    -1,   580,  1133,    -1,  1133,    -1,    -1,   226,
     989,   990,    -1,    -1,   356,  1130,   991,  1101,  1104,    -1,
     131,  1130,    -1,   984,    -1,    -1,   128,   993,   908,    -1,
     129,   999,  1156,   998,   996,   800,    -1,    -1,   129,   217,
    1131,   344,  1125,   995,    -1,   129,    94,   998,  1131,    -1,
     129,   179,   998,  1131,   581,  1131,    -1,   129,   179,   998,
    1131,    -1,   129,   374,   998,   611,    -1,   129,   527,   610,
    1186,    -1,   129,   542,   998,   996,   800,    -1,   129,   501,
     998,   611,    -1,   997,    -1,   996,   575,   997,    -1,  1125,
      -1,    -1,   213,   152,    -1,    -1,   486,    -1,    -1,    -1,
     223,  1001,  1006,   799,  1008,  1002,  1010,  1026,    -1,    -1,
      -1,   405,  1004,  1007,  1008,  1005,  1010,    -1,    -1,   270,
      -1,   113,    -1,   204,    -1,  1035,    -1,   113,    -1,   226,
    1009,    -1,  1009,    -1,   997,    -1,  1013,    -1,   573,   574,
    1013,    -1,   573,  1012,   574,  1013,    -1,    -1,   436,  1011,
    1017,    -1,  1012,   575,  1118,    -1,  1118,    -1,   535,  1016,
      -1,   536,  1016,    -1,    -1,   695,  1014,  1206,    -1,    -1,
     573,   695,   574,  1015,  1209,    -1,  1016,   575,  1021,    -1,
    1021,    -1,  1017,   575,  1018,    -1,  1018,    -1,  1122,  1019,
    1025,    -1,   145,    -1,   437,    -1,    -1,  1019,    -1,    -1,
     573,  1022,  1023,   574,    -1,    -1,  1024,    -1,  1024,   575,
    1025,    -1,  1025,    -1,   874,    -1,   111,    -1,    -1,    -1,
     344,   132,  1027,   238,   524,  1033,    -1,    -1,    -1,   524,
    1029,  1035,   799,   919,   436,  1031,  1030,   955,   966,   976,
      -1,  1031,   575,  1032,    -1,  1032,    -1,  1122,  1019,  1025,
      -1,  1033,   575,  1034,    -1,  1034,    -1,  1122,  1019,  1025,
      -1,    -1,   270,    -1,    -1,   115,  1037,  1045,  1038,    -1,
      -1,   175,  1125,  1039,   955,   966,   976,    -1,    -1,  1042,
    1040,   175,   919,   955,    -1,    -1,   175,  1042,  1041,   530,
     919,   955,    -1,  1043,    -1,  1042,   575,  1043,    -1,  1131,
    1044,   953,    -1,  1131,   581,  1131,  1044,   953,    -1,    -1,
     581,   567,    -1,    -1,  1046,  1045,    -1,   382,    -1,   270,
      -1,   214,    -1,   505,  1048,   997,    -1,    -1,   485,    -1,
      -1,  1050,    -1,  1051,    -1,  1050,   575,  1051,    -1,    86,
      -1,   300,    -1,    40,   230,    -1,    81,   481,    -1,   359,
     160,    -1,   231,    -1,   480,    -1,   449,    -1,    12,    -1,
      -1,   172,   381,   338,    -1,    -1,   441,  1054,  1055,    -1,
      95,  1066,    -1,  1062,   483,  1061,  1066,    -1,  1062,   502,
    1061,  1066,    -1,   485,   466,  1061,  1066,    -1,   347,   483,
    1061,  1066,    -1,    -1,   143,   712,  1056,  1058,    -1,  1062,
      66,  1063,  1125,  1061,  1066,    -1,   329,   287,   172,   445,
     548,   275,   145,  1128,    16,   276,   145,   978,    16,   280,
     145,   977,    -1,  1059,   263,    -1,   445,   205,    -1,    -1,
      33,   150,  1064,  1065,  1057,   971,    -1,   776,  1063,  1125,
    1061,   955,    -1,    67,   506,    -1,   485,   506,    -1,  1060,
     142,    -1,   373,    -1,    85,   573,   567,   574,   543,    -1,
      85,   573,   567,   574,   147,    -1,   543,   971,    -1,   147,
     971,    -1,   378,    -1,   377,  1049,  1052,   971,    -1,  1145,
     466,  1066,    -1,   220,   466,    -1,   320,   466,    -1,  1062,
     376,    -1,  1145,   539,  1066,    -1,   750,  1066,    -1,    65,
    1066,    -1,    30,   263,    -1,   263,    -1,   193,    -1,   193,
     172,  1134,    -1,    87,    94,   705,  1131,    -1,    87,   485,
    1125,    -1,    87,   542,  1125,    -1,   287,   466,    -1,   445,
     466,    -1,    87,   374,   611,    -1,    87,   179,   611,    -1,
     374,   466,  1066,    -1,   179,   466,  1066,    -1,   374,    63,
     611,    -1,   179,    63,   611,    -1,   466,    -1,   263,    -1,
     287,    -1,    32,    -1,    -1,   470,    -1,    -1,  1063,  1131,
      -1,    -1,   177,    -1,   175,    -1,   229,    -1,    -1,   229,
    1128,    -1,    -1,   175,   978,    -1,    -1,   252,  1128,    -1,
     546,   874,    -1,    -1,  1070,  1125,  1068,  1072,    -1,    -1,
    1070,  1071,  1069,   853,    -1,   116,    -1,   117,    -1,    -1,
     156,    -1,    -1,  1113,    -1,  1131,    -1,    -1,   168,   835,
    1074,  1075,    -1,  1075,   575,  1076,    -1,  1076,    -1,    -1,
    1156,  1077,  1078,    -1,   483,   548,   390,   262,    -1,   381,
      47,    -1,   205,    -1,   373,    -1,   263,    -1,   466,    -1,
     445,    -1,   287,    -1,   120,    -1,   409,    -1,    -1,   996,
      -1,    -1,   408,  1080,  1081,    -1,  1081,   575,  1082,    -1,
    1082,    -1,   445,    -1,   287,    -1,   381,    47,    -1,    -1,
     379,  1084,  1085,    -1,  1059,   263,  1086,    -1,   498,  1128,
      -1,    27,   874,    -1,    -1,   239,  1088,  1089,   874,    -1,
      -1,    77,    -1,   381,    -1,   529,  1131,    -1,    -1,   257,
      96,  1092,  1093,    -1,   257,   485,  1125,   175,   287,    -1,
      -1,    -1,    -1,    -1,  1099,  1098,   218,  1130,  1094,  1100,
     226,  1095,   485,  1125,  1096,   753,  1097,  1101,  1104,  1107,
    1108,  1111,    -1,   175,   287,    -1,    -1,   258,    -1,    -1,
      75,    -1,   270,    -1,    -1,   405,    -1,   214,    -1,    -1,
      66,  1102,    -1,  1102,  1103,    -1,  1103,    -1,   488,    45,
    1113,    -1,   350,   138,    45,  1113,    -1,   138,    45,  1113,
      -1,   148,    45,  1113,    -1,    -1,   255,  1105,    -1,  1105,
    1106,    -1,  1106,    -1,   488,    45,  1113,    -1,   464,    45,
    1113,    -1,    -1,   214,   338,   255,    -1,    -1,   573,  1109,
     574,    -1,   573,   574,    -1,  1109,   575,  1110,    -1,  1110,
      -1,  1122,    -1,   580,  1133,    -1,    -1,   436,  1033,    -1,
     489,    -1,   325,    -1,   513,   489,    -1,  1112,  1129,    -1,
    1129,    -1,   203,    -1,    34,    -1,   362,    -1,  1116,    -1,
     566,  1117,    -1,   565,  1117,    -1,  1112,    -1,  1117,    -1,
     337,    -1,   158,    -1,   504,    -1,   203,    -1,    34,    -1,
     513,   203,    -1,   513,    34,    -1,   100,  1112,    -1,   494,
    1112,    -1,   491,  1112,    -1,   338,    -1,   267,    -1,   510,
      -1,   107,    -1,   166,    -1,  1122,    -1,  1119,    -1,  1131,
     581,   567,    -1,  1131,   581,  1131,   581,   567,    -1,   874,
      -1,  1131,    -1,  1123,    -1,  1131,    -1,  1123,    -1,  1131,
     581,  1131,    -1,   581,  1131,   581,  1131,    -1,  1131,   581,
    1131,   581,  1131,    -1,  1131,    -1,  1131,   581,  1131,   581,
    1131,    -1,  1131,   581,  1131,    -1,   581,  1131,    -1,  1131,
      -1,  1131,   581,  1131,    -1,   581,  1131,    -1,  1131,    -1,
     210,    -1,   212,    -1,   489,    -1,   489,    -1,   489,    -1,
    1127,    -1,  1135,    -1,  1127,    -1,  1136,    -1,  1131,    -1,
    1128,    -1,   251,    -1,  1133,    -1,  1133,   580,  1133,    -1,
      91,   873,    -1,  1136,    -1,    20,    -1,    26,    -1,    28,
      -1,    46,    -1,    47,    -1,    55,    -1,    57,    -1,    61,
      -1,    68,    -1,    70,    -1,    80,    -1,   106,    -1,   128,
      -1,   141,    -1,   151,    -1,   168,    -1,   199,    -1,   202,
      -1,   241,    -1,   335,    -1,   347,    -1,   370,    -1,   402,
      -1,   408,    -1,   410,    -1,   417,    -1,   426,    -1,   429,
      -1,   443,    -1,   445,    -1,   465,    -1,   469,    -1,   505,
      -1,   515,    -1,   552,    -1,   525,    -1,     5,    -1,     7,
      -1,     8,    -1,     9,    -1,    10,    -1,    11,    -1,    17,
      -1,    23,    -1,    24,    -1,    25,    -1,    30,    -1,    33,
      -1,    37,    -1,    40,    -1,    42,    -1,    41,    -1,    44,
      -1,    50,    -1,    52,    -1,    54,    -1,    59,    -1,    60,
      -1,    63,    -1,    65,    -1,    66,    -1,    69,    -1,    71,
      -1,    72,    -1,    75,    -1,    77,    -1,    78,    -1,    81,
      -1,    86,    -1,    89,    -1,    96,    -1,    97,    -1,   100,
      -1,   105,    -1,   112,    -1,   114,    -1,   120,    -1,   122,
      -1,   124,    -1,   131,    -1,   132,    -1,   133,    -1,   144,
      -1,   143,    -1,   142,    -1,   147,    -1,   149,    -1,   150,
      -1,   154,    -1,   156,    -1,   159,    -1,   160,    -1,   173,
      -1,   123,    -1,   137,    -1,   177,    -1,   163,    -1,   164,
      -1,   165,    -1,   174,    -1,   187,    -1,   186,    -1,   190,
      -1,   193,    -1,   191,    -1,   200,    -1,   205,    -1,   209,
      -1,   211,    -1,   228,    -1,   215,    -1,   216,    -1,   233,
      -1,   234,    -1,   220,    -1,   224,    -1,   230,    -1,   231,
      -1,   398,    -1,   243,    -1,   247,    -1,   250,    -1,   256,
      -1,   258,    -1,   261,    -1,   263,    -1,   292,    -1,   287,
      -1,   274,    -1,   278,    -1,   275,    -1,   276,    -1,   288,
      -1,   277,    -1,   280,    -1,   273,    -1,   286,    -1,   282,
      -1,   281,    -1,   283,    -1,   284,    -1,   285,    -1,   290,
      -1,   291,    -1,   294,    -1,   295,    -1,   299,    -1,   300,
      -1,   301,    -1,   302,    -1,   303,    -1,   306,    -1,   307,
      -1,   312,    -1,   310,    -1,   314,    -1,   317,    -1,   318,
      -1,   319,    -1,   320,    -1,   322,    -1,   321,    -1,   323,
      -1,   326,    -1,   327,    -1,   330,    -1,   329,    -1,   331,
      -1,   340,    -1,   341,    -1,   343,    -1,   345,    -1,   346,
      -1,   358,    -1,   359,    -1,   360,    -1,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,   371,    -1,   373,    -1,   375,
      -1,   376,    -1,   377,    -1,   378,    -1,   380,    -1,   381,
      -1,   382,    -1,   383,    -1,   384,    -1,   385,    -1,   386,
      -1,   387,    -1,   392,    -1,   393,    -1,   396,    -1,   397,
      -1,   400,    -1,   403,    -1,   406,    -1,   409,    -1,   412,
      -1,   413,    -1,   418,    -1,   420,    -1,   421,    -1,   423,
      -1,   424,    -1,   425,    -1,   428,    -1,   434,    -1,   433,
      -1,   435,    -1,   444,    -1,   438,    -1,   442,    -1,   447,
      -1,   448,    -1,   449,    -1,   457,    -1,   456,    -1,   459,
      -1,   462,    -1,   466,    -1,   470,    -1,   472,    -1,   473,
      -1,   474,    -1,   478,    -1,   479,    -1,   480,    -1,   481,
      -1,   483,    -1,   484,    -1,   486,    -1,   487,    -1,   490,
      -1,   500,    -1,   502,    -1,   491,    -1,   492,    -1,   493,
      -1,   494,    -1,   506,    -1,   507,    -1,   508,    -1,   179,
      -1,   511,    -1,   512,    -1,   520,    -1,   523,    -1,   527,
      -1,   528,    -1,   539,    -1,   542,    -1,   536,    -1,   543,
      -1,   544,    -1,   549,    -1,   551,    -1,   556,    -1,    -1,
     436,  1139,  1138,  1140,    -1,    -1,   349,    -1,  1141,    -1,
    1140,   575,  1141,    -1,    -1,  1142,  1147,    -1,  1144,    -1,
     191,    -1,   258,    -1,   435,    -1,    -1,   345,    -1,    -1,
     191,    -1,   258,    -1,   435,    -1,    -1,   191,   581,    -1,
     258,   581,    -1,   435,   581,    -1,  1148,    -1,  1144,  1149,
      -1,  1143,  1150,  1019,  1153,    -1,  1143,   500,   233,   250,
    1151,    -1,   580,  1133,  1019,   874,    -1,   580,   580,  1146,
    1150,  1019,  1153,    -1,   750,   755,    -1,   321,  1019,   874,
      -1,   321,   752,   757,    -1,   361,  1019,  1152,    -1,   361,
     172,  1134,  1019,  1152,    -1,  1131,    -1,  1131,   581,  1131,
      -1,   111,   581,  1131,    -1,   390,   511,    -1,   390,    69,
      -1,   403,   390,    -1,   433,    -1,   489,    -1,   361,   573,
     489,   574,    -1,   343,   573,   489,   574,    -1,   874,    -1,
     111,    -1,   344,    -1,    12,    -1,    32,    -1,    -1,   262,
    1156,  1155,  1157,    -1,   485,    -1,   483,    -1,  1158,    -1,
    1157,   575,  1158,    -1,  1125,   953,  1159,    -1,   390,    -1,
     550,    -1,   270,   550,    -1,   390,   258,    -1,    -1,   521,
    1161,  1156,    -1,   199,  1125,   347,   953,    -1,   199,  1126,
      61,    -1,    -1,   199,  1126,   390,  1163,  1164,   955,   972,
      -1,  1165,    -1,  1131,  1166,    -1,   164,    -1,   330,    -1,
     164,    -1,   330,    -1,   371,    -1,   243,    -1,    -1,  1168,
    1167,   573,  1024,   574,    -1,   145,    -1,   184,    -1,   244,
      -1,   198,    -1,   271,    -1,   415,   610,  1170,    -1,  1174,
     344,  1173,  1185,   175,  1187,    -1,  1174,   344,   179,  1185,
     175,  1187,    -1,  1174,   344,   374,  1185,   175,  1187,    -1,
      12,  1175,   575,   192,   349,   175,  1187,    -1,   192,   610,
    1172,    -1,  1174,   344,  1173,  1185,   498,  1187,  1192,  1193,
      -1,  1174,   344,   179,  1185,   498,  1187,  1192,  1193,    -1,
    1174,   344,   374,  1185,   498,  1187,  1192,  1193,    -1,    -1,
     485,    -1,  1176,    -1,    12,  1175,    -1,    -1,   373,    -1,
    1177,    -1,  1176,   575,  1177,    -1,    -1,   430,  1178,  1189,
      -1,    -1,   223,  1179,  1189,    -1,    -1,   524,  1180,  1189,
      -1,    -1,   394,  1181,  1189,    -1,   115,    -1,   526,    -1,
     217,    -1,    13,    -1,    87,    -1,   129,    -1,   151,    -1,
     400,    -1,   442,    -1,   375,    -1,   163,    -1,   192,   349,
      -1,   441,    95,    -1,   478,    -1,    87,   486,   483,    -1,
     262,   483,    -1,   406,   445,    -1,   406,    60,    -1,    87,
     542,    -1,   441,   542,    -1,    87,   420,    -1,    13,   420,
      -1,    87,   527,    -1,    -1,    16,    -1,  1184,  1182,  1183,
      -1,  1184,    -1,   474,   489,    -1,   234,   489,    -1,    59,
     489,    -1,   567,    -1,  1131,   581,   567,    -1,   567,   581,
     567,    -1,  1125,    -1,  1134,    -1,  1186,   575,  1134,    -1,
    1188,    -1,  1187,   575,  1188,    -1,  1134,   211,    45,   489,
      -1,  1134,   211,    45,   361,   489,    -1,  1134,    -1,    -1,
     573,  1190,   574,    -1,  1190,   575,  1191,    -1,  1191,    -1,
    1131,    -1,    -1,   407,  1183,    -1,   407,   463,    -1,   407,
     551,    -1,   407,   331,    -1,    -1,   548,  1194,    -1,  1194,
    1195,    -1,  1195,    -1,   192,   349,    -1,   291,   977,    -1,
     294,   977,    -1,   290,   977,    -1,   295,   977,    -1,    -1,
      28,  1197,  1198,    -1,    -1,   549,    -1,    -1,    16,   335,
      52,    -1,    16,    52,    -1,    -1,   399,    -1,   335,   399,
      -1,    -1,   426,    -1,    70,  1198,  1199,  1200,    -1,   417,
    1198,  1199,  1200,    -1,   417,  1198,   498,  1201,  1131,    -1,
     426,  1131,    -1,   399,   426,  1131,    -1,    -1,  1207,    -1,
      -1,   516,  1213,  1208,   854,    -1,    -1,  1207,    -1,  1210,
      -1,    -1,  1211,  1212,    -1,   967,   971,    -1,   973,    -1,
      -1,   125,    -1,    12,    -1,    -1,   430,  1216,   856,  1214,
    1217,    -1,   573,  1216,   855,  1214,  1217,   574,    -1,    -1,
      -1,  1223,  1219,    -1,  1222,  1220,    -1,  1224,  1221,  1229,
      -1,  1229,    -1,  1237,    -1,  1246,    -1,  1240,    -1,  1229,
      -1,  1237,    -1,  1246,    -1,  1240,    -1,  1239,    -1,  1222,
      -1,  1223,    -1,    -1,   112,   145,  1134,    -1,  1225,    -1,
    1225,  1226,    -1,  1226,    -1,   354,   405,    -1,    11,   145,
     512,    -1,    11,   145,   301,    -1,    11,   145,   487,    -1,
      -1,  1226,    -1,    -1,   461,   429,   112,    -1,   461,   429,
     228,    -1,    -1,  1228,   542,  1125,  1230,  1231,    18,  1233,
    1236,    -1,    -1,   573,  1232,   574,    -1,  1131,    -1,  1232,
     575,  1131,    -1,    -1,  1234,  1235,    -1,   430,   869,   856,
      -1,   573,   869,   855,   574,  1209,    -1,    -1,   548,    58,
     349,    -1,   548,    50,    58,   349,    -1,   548,   258,    58,
     349,    -1,    -1,   501,   869,   611,   687,   688,   344,   869,
    1125,   172,   869,   134,   424,  1238,   646,    -1,    10,   869,
     179,  1131,   413,   717,   509,  1128,    -1,   869,   179,  1131,
     413,   717,   509,  1128,    -1,    -1,    -1,    -1,    -1,    -1,
     869,   179,   611,   573,  1241,   622,   574,  1242,   413,  1243,
     728,  1244,   613,  1245,   646,    -1,    -1,    -1,    -1,    -1,
     374,   869,   611,  1247,   573,  1248,   626,   574,  1249,   613,
    1250,   646,    -1,   552,  1253,  1252,  1254,    -1,   552,   141,
    1252,  1256,    -1,   552,   370,  1252,    -1,   552,    70,  1252,
    1255,    -1,   552,   417,  1252,    -1,   552,   392,    -1,  1113,
      -1,  1113,   575,  1113,    -1,  1113,   575,  1113,   575,   977,
      -1,    28,    -1,   465,    -1,    -1,   236,    -1,   412,    -1,
      -1,   346,   363,    -1,    -1,    -1,   479,  1257,  1258,    -1,
      -1,   172,   303,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1226,  1226,  1239,  1238,  1263,  1270,  1272,  1276,  1277,
    1282,  1283,  1284,  1285,  1286,  1287,  1288,  1289,  1290,  1291,
    1292,  1293,  1294,  1295,  1296,  1297,  1298,  1299,  1300,  1301,
    1302,  1303,  1304,  1305,  1306,  1307,  1308,  1309,  1310,  1311,
    1312,  1313,  1314,  1315,  1316,  1317,  1318,  1319,  1320,  1321,
    1322,  1323,  1324,  1325,  1326,  1327,  1328,  1332,  1341,  1342,
    1347,  1356,  1363,  1373,  1372,  1383,  1385,  1389,  1390,  1393,
    1406,  1405,  1424,  1423,  1434,  1435,  1438,  1443,  1448,  1453,
    1458,  1462,  1467,  1471,  1475,  1479,  1483,  1488,  1492,  1496,
    1512,  1516,  1528,  1527,  1547,  1546,  1569,  1568,  1581,  1580,
    1588,  1596,  1610,  1627,  1647,  1648,  1652,  1653,  1658,  1660,
    1662,  1664,  1666,  1668,  1670,  1676,  1677,  1678,  1682,  1686,
    1694,  1693,  1706,  1708,  1711,  1713,  1717,  1721,  1728,  1730,
    1734,  1735,  1740,  1759,  1785,  1787,  1791,  1792,  1796,  1822,
    1823,  1824,  1825,  1829,  1830,  1834,  1835,  1840,  1843,  1870,
    1869,  1938,  1954,  1953,  2002,  2028,  2028,  2060,  2061,  2066,
    2068,  2073,  2096,  2104,  2121,  2122,  2126,  2130,  2139,  2146,
    2153,  2163,  2178,  2196,  2197,  2201,  2201,  2254,  2253,  2282,
    2281,  2285,  2286,  2288,  2288,  2299,  2301,  2303,  2353,  2393,
    2411,  2410,  2429,  2448,  2450,  2451,  2455,  2476,  2499,  2504,
    2519,  2499,  2538,  2540,  2541,  2545,  2546,  2551,  2558,  2550,
    2577,  2576,  2592,  2593,  2597,  2598,  2603,  2608,  2602,  2627,
    2632,  2626,  2649,  2659,  2664,  2663,  2699,  2700,  2705,  2704,
    2737,  2737,  2752,  2751,  2788,  2800,  2805,  2799,  2831,  2830,
    2853,  2855,  2860,  2862,  2864,  2869,  2870,  2871,  2877,  2886,
    2887,  2887,  2891,  2893,  2892,  2895,  2894,  2900,  2916,  2899,
    2930,  2931,  2934,  2935,  2938,  2939,  2942,  2943,  2946,  2947,
    2950,  2951,  2954,  2957,  2958,  2960,  2962,  2965,  2966,  2969,
    2970,  2971,  2974,  2975,  2976,  2977,  2978,  2979,  2980,  2981,
    2982,  2997,  3003,  3004,  3005,  3006,  3011,  3016,  3021,  3036,
    3037,  3038,  3039,  3040,  3041,  3045,  3062,  3078,  3088,  3089,
    3090,  3091,  3092,  3093,  3096,  3097,  3098,  3101,  3102,  3103,
    3106,  3107,  3110,  3111,  3112,  3113,  3116,  3117,  3121,  3122,
    3126,  3127,  3134,  3144,  3154,  3175,  3179,  3185,  3187,  3191,
    3195,  3196,  3200,  3205,  3204,  3226,  3227,  3228,  3229,  3231,
    3232,  3234,  3236,  3237,  3239,  3241,  3244,  3246,  3249,  3250,
    3252,  3254,  3255,  3256,  3257,  3270,  3271,  3273,  3275,  3287,
    3289,  3291,  3293,  3294,  3295,  3296,  3297,  3298,  3300,  3302,
    3304,  3304,  3306,  3306,  3308,  3309,  3318,  3319,  3320,  3323,
    3324,  3325,  3326,  3327,  3331,  3335,  3336,  3340,  3341,  3345,
    3346,  3347,  3348,  3349,  3353,  3354,  3355,  3356,  3357,  3360,
    3362,  3363,  3367,  3368,  3369,  3372,  3379,  3380,  3383,  3384,
    3387,  3388,  3389,  3392,  3393,  3396,  3397,  3398,  3399,  3402,
    3403,  3406,  3407,  3410,  3411,  3414,  3415,  3416,  3417,  3419,
    3420,  3426,  3432,  3438,  3444,  3445,  3461,  3467,  3471,  3472,
    3476,  3484,  3488,  3489,  3492,  3493,  3497,  3506,  3510,  3511,
    3514,  3524,  3525,  3529,  3530,  3533,  3534,  3537,  3538,  3539,
    3540,  3549,  3550,  3553,  3554,  3557,  3558,  3559,  3568,  3570,
    3572,  3577,  3576,  3588,  3589,  3592,  3599,  3610,  3611,  3614,
    3615,  3618,  3619,  3620,  3621,  3622,  3625,  3626,  3627,  3628,
    3629,  3632,  3633,  3634,  3646,  3647,  3650,  3651,  3654,  3655,
    3659,  3660,  3661,  3664,  3665,  3666,  3667,  3680,  3681,  3682,
    3685,  3686,  3690,  3693,  3694,  3697,  3703,  3717,  3718,  3721,
    3722,  3725,  3726,  3734,  3733,  3757,  3756,  3770,  3769,  3788,
    3787,  3807,  3805,  3825,  3826,  3828,  3829,  3830,  3831,  3832,
    3835,  3843,  3844,  3848,  3853,  3852,  3860,  3869,  3859,  3881,
    3890,  3894,  3903,  3912,  3918,  3924,  3933,  3942,  3960,  3981,
    3986,  3990,  3997,  3998,  4001,  4002,  4006,  4007,  4008,  4012,
    4013,  4014,  4017,  4018,  4019,  4020,  4028,  4027,  4038,  4046,
    4045,  4055,  4065,  4074,  4075,  4082,  4082,  4088,  4089,  4093,
    4094,  4095,  4099,  4100,  4117,  4118,  4123,  4122,  4133,  4132,
    4143,  4142,  4152,  4153,  4154,  4159,  4158,  4170,  4171,  4174,
    4175,  4178,  4179,  4180,  4184,  4183,  4196,  4195,  4212,  4213,
    4216,  4217,  4220,  4221,  4222,  4223,  4224,  4225,  4229,  4228,
    4240,  4241,  4242,  4247,  4246,  4252,  4259,  4264,  4272,  4273,
    4276,  4288,  4297,  4298,  4301,  4314,  4315,  4320,  4319,  4329,
    4330,  4333,  4346,  4346,  4356,  4357,  4366,  4367,  4376,  4385,
    4387,  4390,  4420,  4424,  4423,  4445,  4453,  4445,  4459,  4460,
    4461,  4462,  4463,  4466,  4473,  4480,  4482,  4493,  4494,  4497,
    4498,  4504,  4505,  4506,  4507,  4513,  4519,  4525,  4539,  4542,
    4544,  4551,  4561,  4562,  4563,  4577,  4603,  4608,  4613,  4614,
    4617,  4618,  4619,  4620,  4621,  4625,  4626,  4630,  4681,  4688,
    4731,  4737,  4743,  4749,  4755,  4761,  4767,  4773,  4777,  4783,
    4789,  4795,  4801,  4807,  4810,  4816,  4826,  4832,  4840,  4846,
    4856,  4862,  4870,  4880,  4886,  4895,  4901,  4910,  4913,  4919,
    4925,  4931,  4937,  4943,  4949,  4955,  4961,  4967,  4973,  4979,
    4985,  4991,  4997,  5000,  5000,  5001,  5001,  5002,  5002,  5003,
    5003,  5005,  5006,  5007,  5008,  5009,  5010,  5013,  5014,  5018,
    5023,  5024,  5033,  5034,  5035,  5036,  5037,  5043,  5045,  5051,
    5057,  5063,  5069,  5070,  5077,  5084,  5090,  5092,  5101,  5107,
    5113,  5120,  5126,  5132,  5138,  5151,  5157,  5170,  5183,  5196,
    5209,  5215,  5221,  5227,  5233,  5239,  5245,  5251,  5257,  5263,
    5269,  5275,  5282,  5290,  5297,  5304,  5311,  5318,  5324,  5330,
    5337,  5343,  5349,  5356,  5362,  5369,  5375,  5381,  5387,  5393,
    5399,  5405,  5411,  5417,  5423,  5429,  5435,  5441,  5450,  5457,
    5470,  5476,  5482,  5488,  5494,  5501,  5512,  5519,  5526,  5532,
    5538,  5544,  5551,  5558,  5564,  5570,  5577,  5584,  5590,  5596,
    5602,  5608,  5615,  5622,  5630,  5636,  5642,  5648,  5655,  5662,
    5668,  5674,  5683,  5689,  5696,  5702,  5708,  5714,  5720,  5726,
    5732,  5738,  5744,  5753,  5762,  5768,  5774,  5780,  5786,  5792,
    5798,  5804,  5810,  5816,  5822,  5828,  5834,  5840,  5846,  5863,
    5862,  6005,  6011,  6018,  6024,  6031,  6038,  6045,  6052,  6063,
    6069,  6075,  6084,  6090,  6097,  6106,  6108,  6110,  6112,  6114,
    6116,  6120,  6123,  6126,  6128,  6130,  6132,  6134,  6136,  6138,
    6141,  6144,  6146,  6148,  6150,  6152,  6154,  6157,  6159,  6161,
    6163,  6168,  6169,  6170,  6174,  6175,  6179,  6179,  6190,  6194,
    6201,  6232,  6238,  6244,  6250,  6256,  6262,  6271,  6278,  6280,
    6277,  6287,  6293,  6304,  6310,  6316,  6322,  6328,  6334,  6340,
    6346,  6352,  6359,  6358,  6375,  6374,  6389,  6397,  6405,  6418,
    6419,  6423,  6428,  6434,  6437,  6451,  6450,  6466,  6467,  6468,
    6469,  6470,  6471,  6472,  6473,  6474,  6475,  6476,  6480,  6481,
    6485,  6485,  6495,  6496,  6499,  6500,  6503,  6503,  6513,  6514,
    6517,  6518,  6521,  6522,  6525,  6533,  6543,  6544,  6553,  6558,
    6559,  6579,  6581,  6585,  6583,  6600,  6598,  6616,  6614,  6621,
    6630,  6628,  6646,  6645,  6655,  6666,  6664,  6683,  6682,  6693,
    6703,  6704,  6705,  6710,  6710,  6729,  6727,  6746,  6768,  6816,
    6815,  6838,  6856,  6838,  6863,  6867,  6893,  6894,  6896,  6898,
    6901,  6902,  6908,  6915,  6924,  6923,  6930,  6931,  6935,  6944,
    6953,  6964,  6975,  6987,  6988,  6989,  6990,  6991,  6992,  6993,
    6994,  6995,  6996,  6997,  6998,  7001,  7002,  7021,  7022,  7023,
    7024,  7025,  7026,  7027,  7028,  7029,  7033,  7034,  7035,  7036,
    7039,  7041,  7042,  7045,  7046,  7054,  7056,  7060,  7062,  7061,
    7075,  7078,  7077,  7092,  7098,  7113,  7115,  7118,  7120,  7124,
    7125,  7138,  7156,  7160,  7161,  7165,  7178,  7180,  7184,  7183,
    7216,  7218,  7222,  7223,  7224,  7229,  7235,  7239,  7240,  7244,
    7248,  7255,  7262,  7271,  7275,  7281,  7287,  7297,  7301,  7309,
    7310,  7311,  7312,  7313,  7314,  7318,  7319,  7320,  7321,  7322,
    7325,  7328,  7327,  7357,  7358,  7361,  7362,  7365,  7380,  7380,
    7391,  7392,  7396,  7415,  7448,  7447,  7460,  7459,  7468,  7480,
    7491,  7490,  7507,  7514,  7514,  7528,  7535,  7558,  7579,  7591,
    7595,  7601,  7611,  7612,  7615,  7623,  7624,  7628,  7629,  7637,
    7646,  7636,  7656,  7663,  7655,  7673,  7685,  7686,  7687,  7691,
    7692,  7695,  7696,  7699,  7708,  7709,  7710,  7712,  7711,  7721,
    7722,  7725,  7726,  7727,  7727,  7728,  7728,  7732,  7733,  7736,
    7738,  7741,  7749,  7750,  7754,  7755,  7760,  7759,  7772,  7773,
    7776,  7781,  7789,  7790,  7798,  7800,  7800,  7808,  7817,  7807,
    7839,  7840,  7843,  7850,  7851,  7854,  7863,  7864,  7870,  7869,
    7883,  7882,  7891,  7890,  7898,  7897,  7907,  7908,  7911,  7921,
    7937,  7938,  7942,  7943,  7946,  7947,  7948,  7951,  7961,  7963,
    7965,  7967,  7970,  7971,  7974,  7978,  7982,  7986,  7990,  7994,
    7998,  8002,  8006,  8014,  8017,  8026,  8025,  8039,  8047,  8056,
    8065,  8074,  8084,  8083,  8086,  8096,  8106,  8110,  8115,  8114,
    8119,  8129,  8134,  8140,  8145,  8150,  8152,  8154,  8156,  8158,
    8160,  8168,  8177,  8179,  8181,  8183,  8192,  8200,  8208,  8210,
    8212,  8222,  8229,  8235,  8243,  8251,  8255,  8259,  8266,  8273,
    8281,  8289,  8299,  8312,  8326,  8339,  8340,  8342,  8344,  8347,
    8348,  8351,  8352,  8355,  8356,  8359,  8360,  8363,  8364,  8366,
    8368,  8375,  8387,  8386,  8401,  8400,  8410,  8411,  8414,  8415,
    8419,  8420,  8421,  8436,  8435,  8447,  8448,  8451,  8451,  8452,
    8453,  8454,  8455,  8456,  8457,  8458,  8459,  8460,  8461,  8464,
    8465,  8469,  8468,  8477,  8478,  8481,  8482,  8483,  8487,  8486,
    8496,  8500,  8504,  8516,  8516,  8524,  8525,  8526,  8531,  8541,
    8540,  8556,  8574,  8585,  8589,  8599,  8573,  8604,  8613,  8614,
    8617,  8618,  8630,  8634,  8635,  8636,  8638,  8640,  8643,  8644,
    8647,  8652,  8659,  8664,  8670,  8672,  8675,  8676,  8679,  8684,
    8690,  8692,  8699,  8700,  8701,  8704,  8706,  8711,  8712,  8721,
    8722,  8728,  8751,  8761,  8768,  8787,  8795,  8807,  8822,  8843,
    8844,  8845,  8854,  8855,  8856,  8863,  8869,  8875,  8881,  8887,
    8911,  8934,  8935,  8936,  8939,  8946,  8953,  8957,  8965,  8980,
    8981,  8984,  8992,  9005,  9008,  9049,  9053,  9063,  9067,  9137,
    9154,  9180,  9181,  9197,  9207,  9210,  9216,  9222,  9231,  9241,
    9242,  9270,  9285,  9301,  9316,  9317,  9328,  9329,  9340,  9341,
    9342,  9345,  9358,  9370,  9384,  9385,  9386,  9387,  9388,  9389,
    9390,  9391,  9392,  9393,  9394,  9395,  9396,  9397,  9398,  9399,
    9400,  9401,  9402,  9403,  9404,  9405,  9406,  9407,  9408,  9409,
    9410,  9411,  9412,  9413,  9414,  9415,  9416,  9417,  9418,  9419,
    9420,  9430,  9431,  9432,  9433,  9434,  9435,  9436,  9437,  9438,
    9439,  9440,  9441,  9442,  9443,  9444,  9445,  9446,  9447,  9448,
    9449,  9450,  9451,  9452,  9453,  9454,  9455,  9456,  9457,  9458,
    9459,  9460,  9461,  9462,  9463,  9464,  9465,  9466,  9467,  9468,
    9469,  9470,  9471,  9472,  9473,  9474,  9475,  9476,  9477,  9478,
    9479,  9480,  9481,  9482,  9483,  9484,  9485,  9486,  9487,  9488,
    9489,  9490,  9491,  9492,  9493,  9494,  9495,  9496,  9497,  9498,
    9499,  9500,  9501,  9502,  9503,  9504,  9505,  9506,  9507,  9508,
    9509,  9510,  9511,  9512,  9513,  9514,  9515,  9516,  9517,  9518,
    9519,  9520,  9521,  9522,  9523,  9524,  9525,  9526,  9527,  9528,
    9529,  9530,  9531,  9532,  9533,  9534,  9535,  9536,  9537,  9538,
    9539,  9540,  9541,  9542,  9543,  9544,  9545,  9546,  9547,  9548,
    9549,  9550,  9551,  9552,  9553,  9554,  9555,  9556,  9557,  9558,
    9559,  9560,  9561,  9562,  9563,  9564,  9565,  9566,  9567,  9568,
    9569,  9570,  9571,  9572,  9573,  9574,  9575,  9576,  9577,  9578,
    9579,  9580,  9581,  9582,  9583,  9584,  9585,  9586,  9587,  9588,
    9589,  9590,  9591,  9592,  9593,  9594,  9595,  9596,  9597,  9598,
    9599,  9600,  9601,  9602,  9603,  9604,  9605,  9606,  9607,  9608,
    9609,  9610,  9611,  9612,  9613,  9614,  9615,  9616,  9617,  9618,
    9619,  9620,  9621,  9622,  9623,  9624,  9625,  9626,  9627,  9628,
    9629,  9630,  9631,  9632,  9633,  9634,  9635,  9636,  9637,  9638,
    9639,  9640,  9641,  9642,  9643,  9644,  9645,  9646,  9647,  9648,
    9649,  9650,  9651,  9652,  9653,  9654,  9655,  9662,  9661,  9675,
    9676,  9679,  9680,  9683,  9683,  9762,  9763,  9764,  9765,  9769,
    9770,  9774,  9775,  9776,  9777,  9781,  9782,  9783,  9784,  9788,
    9789,  9792,  9876,  9895,  9905,  9913,  9926,  9941,  9958,  9982,
    9992, 10030, 10073, 10087, 10088, 10089, 10090, 10094, 10095, 10104,
   10116, 10117, 10118, 10124, 10130, 10143, 10142, 10158, 10159, 10162,
   10163, 10166, 10178, 10179, 10180, 10181, 10186, 10185, 10206, 10218,
   10231, 10230, 10252, 10253, 10257, 10258, 10262, 10263, 10264, 10265,
   10267, 10266, 10277, 10278, 10279, 10280, 10281, 10287, 10292, 10299,
   10312, 10324, 10331, 10336, 10344, 10357, 10371, 10373, 10376, 10377,
   10384, 10386, 10390, 10391, 10394, 10394, 10395, 10395, 10396, 10396,
   10397, 10397, 10398, 10399, 10400, 10401, 10402, 10403, 10404, 10405,
   10406, 10407, 10408, 10409, 10410, 10411, 10412, 10413, 10414, 10415,
   10416, 10417, 10418, 10419, 10420, 10425, 10426, 10430, 10431, 10435,
   10445, 10455, 10468, 10482, 10495, 10508, 10521, 10522, 10531, 10532,
   10541, 10568, 10570, 10577, 10581, 10584, 10585, 10588, 10616, 10617,
   10621, 10625, 10629, 10636, 10637, 10640, 10641, 10645, 10646, 10652,
   10658, 10664, 10674, 10673, 10683, 10684, 10688, 10689, 10690, 10694,
   10695, 10696, 10700, 10701, 10705, 10715, 10722, 10732, 10741, 10755,
   10756, 10761, 10760, 10801, 10802, 10803, 10807, 10807, 10831, 10832,
   10836, 10837, 10838, 10842, 10847, 10852, 10859, 10880, 10902, 10904,
   10906, 10911, 10912, 10913, 10914, 10918, 10919, 10920, 10921, 10922,
   10932, 10933, 10938, 10951, 10964, 10966, 10968, 10973, 10978, 10980,
   10982, 10988, 10989, 10995, 10996, 10998, 11004, 11003, 11018, 11019,
   11023, 11030, 11040, 11040, 11058, 11067, 11080, 11081, 11083, 11085,
   11098, 11096, 11162, 11173, 11191, 11220, 11224, 11232, 11244, 11187,
   11274, 11298, 11303, 11312, 11273, 11333, 11337, 11341, 11345, 11349,
   11353, 11359, 11366, 11373, 11382, 11383, 11387, 11388, 11389, 11393,
   11394, 11398, 11399, 11399, 11404, 11405
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "END_OF_INPUT", "ABORT_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "ATAN",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BENCHMARK_SYM", "BERKELEY_DB_SYM", "BIGINT", "BINARY",
  "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR",
  "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM",
  "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED",
  "CAST_SYM", "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM",
  "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_SYM", "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM",
  "COMPACT_SYM", "COMPRESSED_SYM", "CONCAT", "CONCAT_WS", "CONCURRENT",
  "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONVERT_SYM",
  "CONVERT_TZ_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURTIME", "DATABASE",
  "DATABASES", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DECODE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_DECRYPT_SYM", "DES_ENCRYPT_SYM", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSEIF_SYM",
  "ELT_FUNC", "ENABLE_SYM", "ENCLOSED", "ENCODE_SYM", "ENCRYPT", "END",
  "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SET", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FAULTS_SYM", "FETCH_SYM", "FIELD_FUNC",
  "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM",
  "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FORMAT_SYM", "FOR_SYM",
  "FOUND_SYM", "FRAC_SECOND_SYM", "FROM", "FROM_UNIXTIME", "FULL",
  "FULLTEXT_SYM", "FUNCTION_SYM", "FUNC_ARG0", "FUNC_ARG1", "FUNC_ARG2",
  "FUNC_ARG3", "GE", "GEOMCOLLFROMTEXT", "GEOMETRYCOLLECTION",
  "GEOMETRY_SYM", "GEOMFROMTEXT", "GEOMFROMWKB", "GET_FORMAT",
  "GLOBAL_SYM", "GRANT", "GRANTS", "GREATEST_SYM", "GROUP",
  "GROUP_CONCAT_SYM", "GROUP_UNIQUE_USERS", "GT_SYM", "HANDLER_SYM",
  "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY",
  "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM",
  "ITERATE_SYM", "JOIN_SYM", "KEYS", "KEY_SYM", "KILL_SYM", "LABEL_SYM",
  "LANGUAGE_SYM", "LAST_INSERT_ID", "LAST_SYM", "LE", "LEADING",
  "LEAST_SYM", "LEAVES", "LEAVE_SYM", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME",
  "LIKE", "LIMIT", "LINEFROMTEXT", "LINES", "LINESTRING", "LOAD",
  "LOCAL_SYM", "LOCATE", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM",
  "LOGS_SYM", "LOG_SYM", "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM",
  "LOOP_SYM", "LOW_PRIORITY", "LT", "MAKE_SET_SYM",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM",
  "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM",
  "MASTER_POS_WAIT", "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM",
  "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MATCH", "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SYM", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM",
  "MERGE_SYM", "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM",
  "MLINEFROMTEXT", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MPOINTFROMTEXT", "MPOLYFROMTEXT", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEW_SYM", "NEXT_SYM", "NONE_SYM", "NOT2_SYM", "NOT_SYM",
  "NOW_SYM", "NO_SYM", "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM",
  "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM", "OJ_SYM", "OLD_PASSWORD",
  "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PARTIAL", "PASSWORD",
  "PARAM_MARKER", "PHASE_SYM", "POINTFROMTEXT", "POINT_SYM",
  "POLYFROMTEXT", "POLYGON", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PURGE", "QUARTER_SYM",
  "QUERY_SYM", "QUICK", "RAID_0_SYM", "RAID_CHUNKS", "RAID_CHUNKSIZE",
  "RAID_STRIPED_SYM", "RAID_TYPE", "RAND", "READS_SYM", "READ_SYM", "REAL",
  "RECOVER_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP",
  "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM",
  "RELOAD", "RENAME", "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE",
  "REPLICATION", "REQUIRE_SYM", "RESET_SYM", "RESOURCES", "RESTORE_SYM",
  "RESTRICT", "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUND", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_COUNT_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM",
  "SERIAL_SYM", "SESSION_SYM", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE",
  "SMALLINT", "SNAPSHOT_SYM", "SOUNDS_SYM", "SOURCE_SYM", "SPATIAL_SYM",
  "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM",
  "SQL_BIG_RESULT", "SQL_BUFFER_RESULT", "SQL_CACHE_SYM",
  "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM",
  "SQL_THREAD", "SSL_SYM", "STARTING", "START_SYM", "STATUS_SYM",
  "STD_SYM", "STDDEV_SAMP_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUBSTRING_INDEX", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM",
  "SWITCHES_SYM", "SYSDATE", "TABLES", "TABLESPACE", "TABLE_SYM",
  "TEMPORARY", "TEMPTABLE_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRIGGER_SYM", "TRIGGERS_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM",
  "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM", "UDF_SONAME_SYM",
  "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDO_SYM", "UNICODE_SYM", "UNION_SYM",
  "UNIQUE_SYM", "UNIQUE_USERS", "UNIX_TIMESTAMP", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USE_FRM", "USE_SYM", "USING", "UTC_DATE_SYM",
  "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VAR_SAMP_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VIEW_SYM", "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE",
  "WHILE_SYM", "WITH", "WORK_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM",
  "XOR", "YEARWEEK", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL",
  "TABLE_REF_PRIORITY", "ELSE", "THEN_SYM", "CASE_SYM", "BETWEEN_SYM",
  "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "NEG",
  "'('", "')'", "','", "'!'", "'{'", "'}'", "';'", "'@'", "'.'", "':'",
  "$accept", "query", "$@1", "opt_end_of_input", "verb_clause",
  "statement", "deallocate", "deallocate_or_drop", "prepare",
  "prepare_src", "execute", "$@2", "execute_using", "execute_var_list",
  "execute_var_ident", "help", "$@3", "change", "$@4", "master_defs",
  "master_def", "master_file_def", "create", "$@5", "$@6", "$@7", "$@8",
  "clear_privileges", "sp_name", "sp_a_chistics", "sp_c_chistics",
  "sp_chistic", "sp_c_chistic", "sp_suid", "call", "$@9",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "$@10", "$@11",
  "sp_cursor_stmt", "$@12", "sp_handler_type", "sp_hcond_list",
  "sp_hcond_element", "sp_cond", "opt_value", "sp_hcond", "sp_decl_idents",
  "sp_opt_default", "sp_proc_stmt", "$@13", "$@14", "$@15", "$@16", "$@17",
  "sp_opt_fetch_noise", "sp_fetch_list", "sp_if", "$@18", "$@19", "$@20",
  "sp_elseifs", "case_stmt_specification", "simple_case_stmt", "$@21",
  "$@22", "searched_case_stmt", "$@23", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "$@24", "$@25",
  "searched_when_clause", "$@26", "$@27", "else_clause_opt",
  "sp_labeled_control", "$@28", "sp_opt_label", "sp_labeled_block", "$@29",
  "sp_unlabeled_block", "$@30", "sp_block_content", "$@31",
  "sp_unlabeled_control", "$@32", "$@33", "$@34", "trg_action_time",
  "trg_event", "create2", "create2a", "$@35", "create3", "$@36", "$@37",
  "create_select", "$@38", "$@39", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "row_types", "raid_types",
  "merge_insert_types", "opt_select_from", "udf_type", "field_list",
  "field_list_item", "column_def", "key_def", "opt_check_constraint",
  "check_constraint", "opt_constraint", "constraint", "field_spec", "$@40",
  "type", "$@41", "$@42", "spatial_type", "char", "nchar", "varchar",
  "nvarchar", "int_type", "real_type", "float_options", "precision",
  "field_options", "field_opt_list", "field_option", "opt_field_length",
  "field_length", "opt_precision", "opt_attribute", "opt_attribute_list",
  "attribute", "now_or_signed_literal", "charset", "charset_name",
  "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "opt_binary", "opt_bin_mod", "opt_bin_charset",
  "opt_primary", "references", "$@43", "opt_ref_list", "ref_list",
  "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext", "key_alg",
  "opt_btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_component", "string_list", "alter", "$@44", "$@45", "$@46", "$@47",
  "$@48", "ident_or_empty", "alter_list", "add_column", "alter_list_item",
  "$@49", "$@50", "$@51", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "$@52", "$@53", "start",
  "start_transaction_opts", "slave_thread_opts", "$@54",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "$@55", "backup", "$@56", "checksum",
  "$@57", "opt_checksum_type", "repair", "$@58", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "$@59", "check", "$@60",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "$@61", "opt_no_write_to_binlog", "rename", "$@62", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "$@63",
  "preload_list", "preload_keys", "cache_keys_spec", "$@64",
  "cache_key_list_or_empty", "opt_ignore_leaves", "select", "select_init",
  "select_paren", "select_init2", "$@65", "select_part2", "$@66", "$@67",
  "select_into", "select_from", "select_options", "select_option_list",
  "select_option", "select_lock_type", "select_item_list", "select_item",
  "remember_name", "remember_end", "select_item2", "select_alias",
  "optional_braces", "expr", "bool_pri", "predicate", "bit_expr", "or",
  "and", "not", "not2", "comp_op", "all_or_any", "interval_expr",
  "simple_expr", "$@68", "geometry_function", "fulltext_options",
  "udf_expr_list", "udf_expr_list2", "$@69", "udf_expr_list3", "udf_expr",
  "sum_expr", "$@70", "$@71", "$@72", "variable", "$@73", "variable_aux",
  "opt_distinct", "opt_gconcat_separator", "opt_gorder_clause",
  "in_sum_expr", "$@74", "cast_type", "opt_expr_list", "expr_list", "$@75",
  "expr_list2", "ident_list_arg", "ident_list", "$@76", "ident_list2",
  "opt_expr", "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "$@77", "$@78", "$@79", "$@80",
  "$@81", "$@82", "$@83", "normal_join", "table_factor", "$@84", "$@85",
  "select_derived", "$@86", "select_derived2", "$@87", "$@88",
  "get_select_lex", "select_derived_init", "opt_outer", "opt_for_join",
  "opt_key_definition", "key_usage_list", "$@89", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_stamp",
  "interval_time_st", "date_time_type", "table_alias", "opt_table_alias",
  "opt_all", "where_clause", "$@90", "having_clause", "$@91", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@92", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "procedure_clause", "$@93", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "$@94",
  "select_var_list", "select_var_ident", "into", "$@95",
  "into_destination", "$@96", "do", "$@97", "drop", "$@98", "table_list",
  "table_name", "if_exists", "opt_temporary", "insert", "$@99", "$@100",
  "replace", "$@101", "$@102", "insert_lock_option", "replace_lock_option",
  "insert2", "insert_table", "insert_field_spec", "$@103", "fields",
  "insert_values", "$@104", "$@105", "values_list", "ident_eq_list",
  "ident_eq_value", "equal", "opt_equal", "no_braces", "$@106",
  "opt_values", "values", "expr_or_default", "opt_insert_update", "$@107",
  "update", "$@108", "$@109", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "$@110", "single_multi", "$@111", "$@112", "$@113", "table_wild_list",
  "table_wild_one", "opt_wild", "opt_delete_options", "opt_delete_option",
  "truncate", "opt_table_sym", "opt_profile_defs", "profile_defs",
  "profile_def", "opt_profile_args", "show", "$@114", "show_param",
  "$@115", "$@116", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "$@117", "$@118", "describe_command",
  "opt_extended_describe", "opt_describe_column", "flush", "$@119",
  "flush_options", "flush_option", "$@120", "opt_table_list", "reset",
  "$@121", "reset_options", "reset_option", "purge", "$@122",
  "purge_options", "purge_option", "kill", "$@123", "kill_option", "use",
  "load", "$@124", "load_data", "$@125", "$@126", "$@127", "$@128",
  "opt_local", "load_data_lock", "opt_duplicate", "opt_field_term",
  "field_term_list", "field_term", "opt_line_term", "line_term_list",
  "line_term", "opt_ignore_lines", "opt_field_or_var_spec",
  "fields_or_vars", "field_or_var", "opt_load_data_set_spec",
  "text_literal", "text_string", "param_marker", "signed_literal",
  "literal", "NUM_literal", "insert_ident", "table_wild", "order_ident",
  "simple_ident", "simple_ident_nospvar", "simple_ident_q", "field_ident",
  "table_ident", "table_ident_nodb", "IDENT_sys", "TEXT_STRING_sys",
  "TEXT_STRING_literal", "TEXT_STRING_filesystem", "ident", "label_ident",
  "ident_or_text", "user", "keyword", "keyword_sp", "set", "$@129",
  "opt_option", "option_value_list", "option_type_value", "$@130",
  "option_type", "option_type2", "opt_var_type", "opt_var_ident_type",
  "ext_option_value", "sys_option_value", "option_value",
  "internal_variable_name", "isolation_types", "text_or_password",
  "set_expr_or_default", "lock", "$@131", "table_or_tables",
  "table_lock_list", "table_lock", "lock_option", "unlock", "$@132",
  "handler", "$@133", "handler_read_or_scan", "handler_scan_function",
  "handler_rkey_function", "$@134", "handler_rkey_mode", "revoke",
  "revoke_command", "grant", "grant_command", "opt_table",
  "grant_privileges", "opt_privileges", "object_privilege_list",
  "object_privilege", "$@135", "$@136", "$@137", "$@138", "opt_and",
  "require_list", "require_list_element", "grant_ident", "user_list",
  "grant_list", "grant_user", "opt_column_list", "column_list",
  "column_list_id", "require_clause", "grant_options", "grant_option_list",
  "grant_option", "begin", "$@139", "opt_work", "opt_chain", "opt_release",
  "opt_savepoint", "commit", "rollback", "savepoint", "release",
  "union_clause", "union_list", "$@140", "union_opt",
  "union_order_or_limit", "$@141", "order_or_limit", "union_option",
  "take_first_select", "subselect", "subselect_start", "subselect_end",
  "view_or_trigger_or_sp", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_replace_or_algorithm",
  "view_replace", "view_algorithm", "view_algorithm_opt", "view_suid",
  "view_tail", "$@142", "view_list_opt", "view_list", "view_select",
  "$@143", "view_select_aux", "view_check_option", "trigger_tail", "$@144",
  "udf_tail", "sf_tail", "$@145", "$@146", "$@147", "$@148", "$@149",
  "sp_tail", "$@150", "$@151", "$@152", "$@153", "xa", "xid",
  "begin_or_start", "opt_join_or_resume", "opt_one_phase", "opt_suspend",
  "$@154", "opt_migrate", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   124,    38,    45,    43,    42,    47,    37,
      94,   126,   818,    40,    41,    44,    33,   123,   125,    59,
      64,    46,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   583,   584,   585,   584,   584,   586,   586,   587,   587,
     588,   588,   588,   588,   588,   588,   588,   588,   588,   588,
     588,   588,   588,   588,   588,   588,   588,   588,   588,   588,
     588,   588,   588,   588,   588,   588,   588,   588,   588,   588,
     588,   588,   588,   588,   588,   588,   588,   588,   588,   588,
     588,   588,   588,   588,   588,   588,   588,   589,   590,   590,
     591,   592,   592,   594,   593,   595,   595,   596,   596,   597,
     599,   598,   601,   600,   602,   602,   603,   603,   603,   603,
     603,   603,   603,   603,   603,   603,   603,   603,   604,   604,
     604,   604,   606,   605,   607,   605,   608,   605,   609,   605,
     605,   610,   611,   611,   612,   612,   613,   613,   614,   614,
     614,   614,   614,   614,   614,   615,   615,   615,   616,   616,
     618,   617,   619,   619,   620,   620,   621,   621,   622,   622,
     623,   623,   624,   625,   626,   626,   627,   627,   628,   629,
     629,   629,   629,   630,   630,   631,   631,   632,   632,   634,
     633,   633,   635,   633,   633,   637,   636,   638,   638,   639,
     639,   640,   641,   641,   642,   642,   643,   643,   643,   643,
     643,   644,   644,   645,   645,   647,   646,   648,   646,   649,
     646,   646,   646,   650,   646,   646,   646,   646,   646,   646,
     651,   646,   646,   652,   652,   652,   653,   653,   655,   656,
     657,   654,   658,   658,   658,   659,   659,   661,   662,   660,
     664,   663,   665,   665,   666,   666,   668,   669,   667,   671,
     672,   670,   673,   673,   675,   674,   676,   676,   678,   677,
     680,   679,   682,   681,   683,   684,   685,   683,   686,   683,
     687,   687,   688,   688,   688,   689,   689,   689,   689,   690,
     691,   690,   692,   693,   692,   694,   692,   696,   697,   695,
     698,   698,   699,   699,   700,   700,   701,   701,   702,   702,
     703,   703,   704,   705,   705,   706,   706,   707,   707,   708,
     708,   708,   709,   709,   709,   709,   709,   709,   709,   709,
     709,   709,   709,   709,   709,   709,   709,   709,   709,   709,
     709,   709,   709,   709,   709,   710,   711,   712,   713,   713,
     713,   713,   713,   713,   714,   714,   714,   715,   715,   715,
     716,   716,   717,   717,   717,   717,   718,   718,   719,   719,
     720,   720,   721,   721,   721,   721,   721,   722,   722,   723,
     724,   724,   725,   727,   726,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   728,   728,   728,   728,
     729,   728,   730,   728,   728,   728,   731,   731,   731,   731,
     731,   731,   731,   731,   732,   733,   733,   734,   734,   735,
     735,   735,   735,   735,   736,   736,   736,   736,   736,   737,
     737,   737,   738,   738,   738,   739,   740,   740,   741,   741,
     742,   742,   742,   743,   743,   744,   744,   744,   744,   745,
     745,   746,   746,   747,   747,   748,   748,   748,   748,   748,
     748,   748,   748,   748,   748,   748,   749,   749,   750,   750,
     751,   751,   752,   752,   753,   753,   754,   754,   755,   755,
     756,   757,   757,   758,   758,   759,   759,   760,   760,   760,
     760,   760,   760,   761,   761,   762,   762,   762,   762,   763,
     763,   765,   764,   766,   766,   767,   767,   768,   768,   769,
     769,   770,   770,   770,   770,   770,   771,   771,   771,   771,
     771,   772,   772,   772,   773,   773,   774,   774,   775,   775,
     776,   776,   776,   777,   777,   777,   777,   778,   778,   778,
     779,   779,   779,   780,   780,   781,   781,   782,   782,   783,
     783,   784,   784,   786,   785,   787,   785,   788,   785,   789,
     785,   790,   785,   791,   791,   792,   792,   792,   792,   792,
     793,   794,   794,   794,   795,   794,   796,   797,   794,   794,
     794,   794,   794,   794,   794,   794,   794,   794,   794,   794,
     794,   794,   798,   798,   799,   799,   800,   800,   800,   801,
     801,   801,   802,   802,   802,   802,   804,   803,   803,   805,
     803,   803,   806,   807,   807,   809,   808,   810,   810,   811,
     811,   811,   812,   812,   813,   813,   815,   814,   817,   816,
     819,   818,   820,   820,   820,   822,   821,   823,   823,   824,
     824,   825,   825,   825,   827,   826,   829,   828,   830,   830,
     831,   831,   832,   832,   832,   832,   832,   832,   834,   833,
     835,   835,   835,   837,   836,   836,   838,   838,   839,   839,
     840,   841,   842,   842,   843,   844,   844,   846,   845,   847,
     847,   848,   850,   849,   851,   851,   852,   852,   853,   854,
     854,   855,   855,   857,   856,   859,   860,   858,   861,   861,
     861,   861,   861,   862,   862,   863,   863,   864,   864,   865,
     865,   865,   865,   865,   865,   865,   865,   865,   865,   866,
     866,   866,   867,   867,   867,   868,   869,   870,   871,   871,
     872,   872,   872,   872,   872,   873,   873,   874,   874,   874,
     874,   874,   874,   874,   874,   874,   874,   874,   875,   875,
     875,   875,   875,   875,   876,   876,   876,   876,   876,   876,
     876,   876,   876,   876,   876,   876,   876,   876,   877,   877,
     877,   877,   877,   877,   877,   877,   877,   877,   877,   877,
     877,   877,   877,   878,   878,   879,   879,   880,   880,   881,
     881,   882,   882,   882,   882,   882,   882,   883,   883,   884,
     885,   885,   885,   885,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   885,   886,
     885,   885,   885,   885,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   885,   887,   887,   887,   887,   887,
     887,   887,   887,   887,   887,   887,   887,   887,   887,   887,
     887,   887,   887,   887,   887,   887,   887,   887,   887,   887,
     887,   888,   888,   888,   889,   889,   891,   890,   892,   892,
     893,   894,   894,   894,   894,   894,   894,   894,   895,   896,
     894,   894,   894,   894,   894,   894,   894,   894,   894,   894,
     894,   894,   897,   894,   899,   898,   900,   900,   900,   901,
     901,   902,   902,   903,   903,   905,   904,   906,   906,   906,
     906,   906,   906,   906,   906,   906,   906,   906,   907,   907,
     909,   908,   910,   910,   911,   911,   913,   912,   914,   914,
     915,   915,   916,   916,   917,   917,   918,   918,   919,   920,
     920,   921,   921,   922,   921,   923,   921,   924,   921,   921,
     925,   921,   926,   921,   921,   927,   921,   928,   921,   921,
     929,   929,   929,   931,   930,   932,   930,   930,   930,   934,
     933,   936,   937,   935,   938,   939,   940,   940,   941,   941,
     942,   942,   942,   942,   944,   943,   945,   945,   946,   946,
     946,   947,   947,   948,   948,   948,   948,   948,   948,   948,
     948,   948,   948,   948,   948,   949,   949,   950,   950,   950,
     950,   950,   950,   950,   950,   950,   951,   951,   951,   951,
     952,   952,   952,   953,   953,   954,   954,   955,   956,   955,
     957,   958,   957,   959,   959,   960,   960,   961,   961,   962,
     962,   962,   963,   964,   964,   965,   966,   966,   968,   967,
     969,   969,   970,   970,   970,   971,   971,   972,   972,   973,
     974,   974,   974,   975,   975,   975,   975,   976,   976,   977,
     977,   977,   977,   977,   977,   978,   978,   978,   978,   978,
     979,   980,   979,   981,   981,   982,   982,   983,   985,   984,
     986,   986,   987,   987,   989,   988,   991,   990,   990,   990,
     993,   992,   994,   995,   994,   994,   994,   994,   994,   994,
     994,   994,   996,   996,   997,   998,   998,   999,   999,  1001,
    1002,  1000,  1004,  1005,  1003,  1006,  1006,  1006,  1006,  1007,
    1007,  1008,  1008,  1009,  1010,  1010,  1010,  1011,  1010,  1012,
    1012,  1013,  1013,  1014,  1013,  1015,  1013,  1016,  1016,  1017,
    1017,  1018,  1019,  1019,  1020,  1020,  1022,  1021,  1023,  1023,
    1024,  1024,  1025,  1025,  1026,  1027,  1026,  1029,  1030,  1028,
    1031,  1031,  1032,  1033,  1033,  1034,  1035,  1035,  1037,  1036,
    1039,  1038,  1040,  1038,  1041,  1038,  1042,  1042,  1043,  1043,
    1044,  1044,  1045,  1045,  1046,  1046,  1046,  1047,  1048,  1048,
    1049,  1049,  1050,  1050,  1051,  1051,  1051,  1051,  1051,  1051,
    1051,  1051,  1051,  1052,  1052,  1054,  1053,  1055,  1055,  1055,
    1055,  1055,  1056,  1055,  1055,  1055,  1055,  1055,  1057,  1055,
    1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,
    1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,
    1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,
    1055,  1055,  1055,  1058,  1058,  1059,  1059,  1060,  1060,  1061,
    1061,  1062,  1062,  1063,  1063,  1064,  1064,  1065,  1065,  1066,
    1066,  1066,  1068,  1067,  1069,  1067,  1070,  1070,  1071,  1071,
    1072,  1072,  1072,  1074,  1073,  1075,  1075,  1077,  1076,  1076,
    1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1078,
    1078,  1080,  1079,  1081,  1081,  1082,  1082,  1082,  1084,  1083,
    1085,  1086,  1086,  1088,  1087,  1089,  1089,  1089,  1090,  1092,
    1091,  1091,  1094,  1095,  1096,  1097,  1093,  1093,  1098,  1098,
    1099,  1099,  1099,  1100,  1100,  1100,  1101,  1101,  1102,  1102,
    1103,  1103,  1103,  1103,  1104,  1104,  1105,  1105,  1106,  1106,
    1107,  1107,  1108,  1108,  1108,  1109,  1109,  1110,  1110,  1111,
    1111,  1112,  1112,  1112,  1112,  1113,  1113,  1113,  1114,  1115,
    1115,  1115,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1117,  1117,  1117,  1117,  1117,  1118,
    1118,  1119,  1119,  1120,  1121,  1121,  1122,  1122,  1123,  1123,
    1123,  1124,  1124,  1124,  1124,  1125,  1125,  1125,  1126,  1127,
    1127,  1128,  1129,  1130,  1131,  1131,  1132,  1132,  1133,  1133,
    1133,  1134,  1134,  1134,  1135,  1135,  1135,  1135,  1135,  1135,
    1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,
    1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,
    1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,
    1135,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1138,  1137,  1139,
    1139,  1140,  1140,  1142,  1141,  1143,  1143,  1143,  1143,  1144,
    1144,  1145,  1145,  1145,  1145,  1146,  1146,  1146,  1146,  1147,
    1147,  1148,  1148,  1149,  1149,  1149,  1149,  1149,  1149,  1149,
    1150,  1150,  1150,  1151,  1151,  1151,  1151,  1152,  1152,  1152,
    1153,  1153,  1153,  1153,  1153,  1155,  1154,  1156,  1156,  1157,
    1157,  1158,  1159,  1159,  1159,  1159,  1161,  1160,  1162,  1162,
    1163,  1162,  1164,  1164,  1165,  1165,  1166,  1166,  1166,  1166,
    1167,  1166,  1168,  1168,  1168,  1168,  1168,  1169,  1170,  1170,
    1170,  1170,  1171,  1172,  1172,  1172,  1173,  1173,  1174,  1174,
    1175,  1175,  1176,  1176,  1178,  1177,  1179,  1177,  1180,  1177,
    1181,  1177,  1177,  1177,  1177,  1177,  1177,  1177,  1177,  1177,
    1177,  1177,  1177,  1177,  1177,  1177,  1177,  1177,  1177,  1177,
    1177,  1177,  1177,  1177,  1177,  1182,  1182,  1183,  1183,  1184,
    1184,  1184,  1185,  1185,  1185,  1185,  1186,  1186,  1187,  1187,
    1188,  1188,  1188,  1189,  1189,  1190,  1190,  1191,  1192,  1192,
    1192,  1192,  1192,  1193,  1193,  1194,  1194,  1195,  1195,  1195,
    1195,  1195,  1197,  1196,  1198,  1198,  1199,  1199,  1199,  1200,
    1200,  1200,  1201,  1201,  1202,  1203,  1203,  1204,  1205,  1206,
    1206,  1208,  1207,  1209,  1209,  1209,  1211,  1210,  1212,  1212,
    1213,  1213,  1213,  1214,  1215,  1215,  1216,  1217,  1218,  1218,
    1218,  1219,  1219,  1219,  1219,  1220,  1220,  1220,  1220,  1220,
    1221,  1221,  1222,  1223,  1224,  1224,  1224,  1225,  1226,  1226,
    1226,  1227,  1227,  1228,  1228,  1228,  1230,  1229,  1231,  1231,
    1232,  1232,  1234,  1233,  1235,  1235,  1236,  1236,  1236,  1236,
    1238,  1237,  1239,  1239,  1241,  1242,  1243,  1244,  1245,  1240,
    1247,  1248,  1249,  1250,  1246,  1251,  1251,  1251,  1251,  1251,
    1251,  1252,  1252,  1252,  1253,  1253,  1254,  1254,  1254,  1255,
    1255,  1256,  1257,  1256,  1258,  1258
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     0,     4,     2,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     1,     1,
       4,     1,     2,     0,     4,     0,     2,     3,     1,     2,
       0,     3,     0,     5,     1,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     1,     3,     3,
       3,     3,     0,     7,     0,    11,     0,     6,     0,     3,
       4,     0,     3,     1,     0,     2,     0,     2,     2,     2,
       2,     2,     3,     3,     1,     1,     1,     2,     3,     3,
       0,     4,     0,     3,     0,     1,     3,     1,     0,     1,
       3,     1,     0,     3,     0,     1,     3,     1,     4,     0,
       1,     1,     1,     0,     3,     2,     3,     0,     3,     0,
       5,     5,     0,     7,     5,     0,     2,     1,     1,     1,
       3,     1,     1,     3,     0,     1,     1,     1,     1,     2,
       1,     1,     3,     0,     2,     0,     2,     0,     3,     0,
       5,     1,     1,     0,     2,     1,     1,     2,     2,     2,
       0,     6,     2,     0,     2,     1,     1,     3,     0,     0,
       0,     7,     0,     2,     2,     1,     1,     0,     0,     8,
       0,     6,     1,     2,     1,     2,     0,     0,     6,     0,
       0,     6,     0,     2,     0,     5,     0,     1,     0,     5,
       0,     2,     0,     5,     4,     0,     0,     8,     0,     7,
       1,     1,     1,     1,     1,     2,     2,     2,     4,     4,
       0,     4,     0,     0,     5,     0,     7,     0,     0,     6,
       0,     1,     0,     1,     1,     2,     1,     1,     0,     1,
       1,     2,     1,     0,     3,     0,     1,     1,     2,     1,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     5,     1,
       1,     3,     4,     4,     3,     4,     4,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     3,     1,     1,
       2,     2,     7,     8,     8,     2,     2,     0,     1,     2,
       0,     1,     2,     0,     4,     3,     3,     3,     1,     2,
       1,     1,     3,     2,     3,     2,     2,     1,     3,     3,
       2,     3,     1,     1,     2,     1,     1,     2,     1,     1,
       1,     2,     3,     2,     3,     2,     2,     3,     3,     3,
       0,     6,     0,     6,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     2,
       1,     2,     3,     2,     1,     1,     1,     1,     1,     1,
       1,     2,     0,     1,     1,     5,     0,     1,     2,     1,
       1,     1,     1,     0,     1,     3,     3,     3,     3,     0,
       1,     0,     1,     2,     1,     1,     2,     2,     4,     1,
       3,     2,     1,     2,     2,     2,     2,     1,     2,     1,
       1,     1,     1,     1,     0,     2,     1,     1,     1,     1,
       1,     0,     2,     1,     1,     0,     1,     0,     2,     1,
       2,     3,     2,     0,     1,     0,     1,     1,     2,     0,
       1,     0,     4,     1,     4,     3,     1,     0,     1,     2,
       1,     3,     3,     2,     2,     2,     1,     1,     2,     2,
       2,     1,     2,     2,     2,     2,     1,     1,     0,     1,
       1,     1,     1,     0,     1,     1,     1,     0,     2,     2,
       1,     1,     1,     4,     2,     1,     4,     0,     1,     0,
       2,     1,     3,     0,     6,     0,     5,     0,     5,     0,
       5,     0,    11,     0,     1,     0,     2,     2,     1,     3,
       2,     3,     2,     4,     0,     6,     0,     0,     8,     4,
       4,     3,     3,     2,     2,     6,     5,     3,     5,     1,
       1,     1,     0,     1,     0,     1,     0,     1,     1,     0,
       2,     1,     0,     1,     1,     1,     0,     5,     3,     0,
       5,     3,     3,     0,     3,     0,     2,     1,     3,     0,
       1,     1,     0,     2,     1,     3,     0,     6,     0,     6,
       0,     5,     0,     1,     1,     0,     6,     0,     1,     1,
       2,     1,     1,     1,     0,     5,     0,     5,     0,     1,
       1,     2,     1,     1,     1,     1,     1,     2,     0,     5,
       0,     1,     1,     0,     4,     4,     3,     5,     1,     3,
       3,     5,     1,     3,     2,     1,     1,     0,     6,     1,
       3,     3,     0,     2,     0,     4,     0,     2,     1,     2,
       4,     2,     3,     0,     3,     0,     0,     6,     2,     1,
       1,     2,     2,     8,     4,     0,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       2,     4,     3,     1,     1,     4,     0,     0,     1,     1,
       0,     2,     2,     1,     1,     0,     2,     3,     3,     3,
       2,     3,     4,     3,     4,     3,     4,     1,     3,     4,
       3,     3,     6,     1,     5,     6,     5,     7,     6,     8,
       5,     6,     4,     4,     5,     3,     4,     1,     3,     3,
       3,     3,     3,     3,     4,     4,     3,     3,     3,     3,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     3,     1,     1,     1,     1,     3,     2,     2,     2,
       2,     3,     3,     5,     6,     4,     4,     7,     4,     2,
       6,     5,     6,     6,     4,     4,     3,     4,     6,     8,
       6,     8,     6,     4,     6,     4,     6,     4,     4,     4,
       4,     6,     8,     2,     2,     4,     2,     7,     7,     3,
       4,     4,     6,     6,     4,     6,     6,     6,     4,     6,
       4,     6,     8,    10,    12,     6,     4,     6,     6,     1,
       6,     4,     8,    10,     4,     1,     3,     4,     6,     6,
       8,     6,     6,     4,     6,     6,     8,     4,     4,     6,
       4,     2,     4,     4,     4,     6,     4,     4,     3,     8,
       6,     4,     6,     3,     6,     8,     4,     8,     6,     8,
       6,     8,     2,     4,     4,     4,     6,     8,     8,     4,
       7,     7,     7,     6,     6,     6,     6,     6,     6,     0,
       5,    10,     3,     4,     3,     2,     2,     2,     4,     6,
       4,     4,     6,     6,     6,     6,     4,     6,     4,     6,
       4,     4,     4,     4,     6,     4,     6,     4,     6,     4,
       4,     6,     4,     6,     4,     6,     4,     4,     6,     4,
       6,     0,     3,     3,     0,     1,     0,     2,     1,     3,
       4,     4,     5,     4,     4,     4,     5,     4,     0,     0,
       7,    10,     4,     5,     4,     5,     4,     4,     4,     4,
       4,     5,     0,     8,     0,     3,     3,     1,     4,     0,
       1,     0,     2,     0,     1,     0,     3,     2,     3,     2,
       1,     2,     1,     2,     1,     1,     1,     2,     0,     1,
       0,     2,     1,     3,     1,     3,     0,     2,     1,     3,
       0,     1,     0,     2,     4,     5,     1,     1,     1,     1,
       3,     3,     3,     0,     6,     0,     6,     0,     8,     4,
       0,     8,     0,    10,     6,     0,     8,     0,    10,     6,
       1,     2,     2,     0,     4,     0,    11,     3,     6,     0,
       3,     0,     0,     5,     0,     1,     0,     1,     0,     2,
       0,     2,     2,     2,     0,     6,     0,     1,     3,     1,
       1,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     1,     1,     0,     2,     0,     1,     0,     0,     3,
       0,     0,     3,     2,     0,     0,     4,     4,     2,     0,
       2,     2,     3,     3,     1,     2,     0,     1,     0,     4,
       4,     2,     0,     1,     1,     0,     1,     0,     1,     2,
       1,     3,     3,     1,     1,     1,     1,     0,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     0,     6,     0,     1,     3,     1,     2,     0,     2,
       3,     1,     2,     1,     0,     3,     0,     5,     2,     1,
       0,     3,     6,     0,     6,     4,     6,     4,     4,     4,
       5,     4,     1,     3,     1,     0,     2,     0,     1,     0,
       0,     8,     0,     0,     6,     0,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     3,     4,     0,     3,     3,
       1,     2,     2,     0,     3,     0,     5,     3,     1,     3,
       1,     3,     1,     1,     0,     1,     0,     4,     0,     1,
       3,     1,     1,     1,     0,     0,     6,     0,     0,    11,
       3,     1,     3,     3,     1,     3,     0,     1,     0,     4,
       0,     6,     0,     5,     0,     6,     1,     3,     3,     5,
       0,     2,     0,     2,     1,     1,     1,     3,     0,     1,
       0,     1,     1,     3,     1,     1,     2,     2,     2,     1,
       1,     1,     1,     0,     3,     0,     3,     2,     4,     4,
       4,     4,     0,     4,     6,    16,     2,     2,     0,     6,
       5,     2,     2,     2,     1,     5,     5,     2,     2,     1,
       4,     3,     2,     2,     2,     3,     2,     2,     2,     1,
       1,     3,     4,     3,     3,     2,     2,     3,     3,     3,
       3,     3,     3,     1,     1,     1,     1,     0,     1,     0,
       2,     0,     1,     1,     1,     0,     2,     0,     2,     0,
       2,     2,     0,     4,     0,     4,     1,     1,     0,     1,
       0,     1,     1,     0,     4,     3,     1,     0,     3,     4,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     0,     3,     3,     1,     1,     1,     2,     0,     3,
       3,     2,     2,     0,     4,     0,     1,     1,     2,     0,
       4,     5,     0,     0,     0,     0,    18,     2,     0,     1,
       0,     1,     1,     0,     1,     1,     0,     2,     2,     1,
       3,     4,     3,     3,     0,     2,     2,     1,     3,     3,
       0,     3,     0,     3,     2,     3,     1,     1,     2,     0,
       2,     1,     1,     2,     2,     1,     1,     1,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     3,     5,     1,     1,     1,     1,     1,     3,     4,
       5,     1,     5,     3,     2,     1,     3,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     4,     0,
       1,     1,     3,     0,     2,     1,     1,     1,     1,     0,
       1,     0,     1,     1,     1,     0,     2,     2,     2,     1,
       2,     4,     5,     4,     6,     2,     3,     3,     3,     5,
       1,     3,     3,     2,     2,     2,     1,     1,     4,     4,
       1,     1,     1,     1,     1,     0,     4,     1,     1,     1,
       3,     3,     1,     1,     2,     2,     0,     3,     4,     3,
       0,     7,     1,     2,     1,     1,     1,     1,     1,     1,
       0,     5,     1,     1,     1,     1,     1,     3,     6,     6,
       6,     7,     3,     8,     8,     8,     0,     1,     1,     2,
       0,     1,     1,     3,     0,     3,     0,     3,     0,     3,
       0,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     1,     3,     2,     2,     2,
       2,     2,     2,     2,     2,     0,     1,     3,     1,     2,
       2,     2,     1,     3,     3,     1,     1,     3,     1,     3,
       4,     5,     1,     0,     3,     3,     1,     1,     0,     2,
       2,     2,     2,     0,     2,     2,     1,     2,     2,     2,
       2,     2,     0,     3,     0,     1,     0,     3,     2,     0,
       1,     2,     0,     1,     4,     4,     5,     2,     3,     0,
       1,     0,     4,     0,     1,     1,     0,     2,     2,     1,
       0,     1,     1,     0,     5,     6,     0,     0,     2,     2,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     3,     1,     2,     1,     2,     3,     3,
       3,     0,     1,     0,     3,     3,     0,     8,     0,     3,
       1,     3,     0,     2,     3,     5,     0,     3,     4,     4,
       0,    14,     8,     7,     0,     0,     0,     0,     0,    15,
       0,     0,     0,     0,    12,     4,     4,     3,     4,     3,
       2,     1,     3,     5,     1,     1,     0,     1,     1,     0,
       2,     0,     0,     3,     0,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,     2,  2011,   640,     0,  1952,     0,     0,     0,     0,
       0,  1954,    98,    58,  1268,  1376,  1377,  1190,  1207,     0,
     640,   101,     0,    70,  1209,  1413,     0,     0,   640,     0,
    1408,     0,     0,   640,  1212,  1401,     0,   101,  1954,     0,
     675,  1789,  1305,     0,     0,     0,  1288,  1846,  1257,     0,
       0,     0,     0,     3,     8,    19,     0,    36,    24,    28,
      14,    18,    13,    10,    50,    51,    43,    12,    16,    40,
      11,    15,    33,    39,    34,    35,    47,   668,    22,    23,
      29,    41,    54,    20,    52,    49,    21,  1378,    25,    42,
      37,    30,    55,    31,    48,    32,    53,    27,    44,    26,
       9,    17,    45,    46,    38,    56,     0,   543,     0,   575,
       0,     0,  2012,  2002,   642,   641,     0,  1838,  1837,   608,
    1954,     0,  1561,  1562,  1563,  1564,  1565,  1566,  1567,  1525,
    1568,  1569,  1570,  1526,  1527,  1571,  1572,  1573,  1574,  1576,
    1575,  1577,  1528,  1529,  1578,  1579,  1580,  1530,  1531,  1581,
    1582,  1532,  1583,  1584,  1585,  1533,  1586,  1534,  1587,  1588,
    1589,  1590,  1591,  1535,  1592,  1593,  1594,  1595,  1596,  1597,
    1598,  1536,  1599,  1600,  1601,  1602,  1618,  1603,  1537,  1604,
    1605,  1606,  1619,  1538,  1609,  1608,  1607,  1610,  1611,  1612,
    1539,  1613,  1614,  1615,  1616,  1621,  1622,  1623,  1540,  1617,
    1624,  1620,  1772,  1626,  1625,  1627,  1629,  1628,  1541,  1630,
    1542,  1631,  1632,  1509,  1633,  1510,  1635,  1636,  1639,  1640,
    1634,  1641,  1642,  1637,  1638,  1543,  1644,  1645,  1646,  1647,
    1648,  1649,  1650,  1660,  1653,  1655,  1656,  1658,  1654,  1659,
    1663,  1662,  1664,  1665,  1666,  1661,  1652,  1657,  1667,  1668,
    1651,  1669,  1670,  1671,  1672,  1673,  1674,  1675,  1676,  1677,
    1679,  1678,  1680,  1681,  1682,  1683,  1684,  1686,  1685,  1687,
    1688,  1689,  1691,  1690,  1692,  1544,  1693,  1694,  1695,  1696,
    1697,  1545,  1698,  1699,  1700,  1701,  1702,  1703,  1704,  1546,
    1705,  1706,  1707,  1708,  1709,  1710,  1711,  1712,  1713,  1714,
    1715,  1716,  1717,  1718,  1719,  1720,  1721,  1722,  1643,  1723,
    1547,  1724,  1725,  1548,  1726,  1549,  1727,  1728,  1550,  1729,
    1730,  1731,  1732,  1733,  1734,  1551,  1735,  1552,  1737,  1736,
    1738,  1740,  1741,  1553,  1739,  1554,  1742,  1743,  1744,  1746,
    1745,  1747,  1748,  1555,  1749,  1556,  1750,  1751,  1752,  1753,
    1754,  1755,  1756,  1757,  1758,  1759,  1760,  1761,  1762,  1765,
    1766,  1767,  1768,  1763,  1764,  1557,  1769,  1770,  1771,  1773,
    1774,  1558,  1775,  1776,  1560,  1777,  1778,  1781,  1779,  1780,
    1782,  1783,  1784,  1785,  1559,  1786,   120,  1514,   103,  1515,
    1524,     0,   610,   626,  1955,  1956,   273,   515,   516,   272,
     514,   101,  2002,     0,   269,   270,     0,  1282,  1010,  1205,
    1205,     0,  1205,  1208,  1205,   101,  1205,     0,    63,  1383,
       0,     0,     0,     0,  1508,     0,  1215,  1415,  1419,     0,
       0,  1835,     0,     0,     0,     0,   101,   643,     0,  1266,
       0,   606,     0,  1956,  1967,   669,   673,   685,  1790,  1787,
    1361,   595,   595,   595,   593,   595,  1289,     0,     0,  1266,
    1418,  2054,     0,     0,     0,  2050,     0,  2055,     0,   675,
       0,     0,     1,     5,     0,     0,  1614,  1374,  1372,  1505,
       0,   535,   544,   539,   537,     0,     0,  2013,  2000,  2001,
     624,     0,  1953,     0,   652,   662,   122,     0,    72,     0,
       0,     0,  1959,     0,     0,     0,     0,    99,   706,   706,
    2002,  2004,  2006,   273,   271,     0,  1286,  1285,  1284,     0,
    1282,  1191,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1205,    65,     0,  1880,  1895,  1896,  1892,  1897,  1898,
    1902,     0,  1894,  1886,     0,  1901,  1890,  1899,     0,  1884,
       0,  1900,  1905,  1888,  1893,  1872,     0,  1878,  1882,  1507,
    1110,  1849,  1850,     0,  1520,  1511,  1519,  1518,    71,  1217,
    1218,  1216,   574,  1416,  1417,     0,  1430,     0,     0,     0,
     638,     0,  1356,  1355,     0,  1409,  1968,     0,     0,   615,
    1220,  1267,     0,  1219,  1406,     0,  1405,  1402,  1404,     0,
    1880,  1867,     0,  1962,  1959,  1969,   698,   691,   690,   693,
     694,   697,   695,   696,   692,   689,   706,   686,   688,  1793,
       0,     0,   449,     0,  1369,     0,     0,     0,  1369,     0,
    1145,  1362,     0,  1802,  1340,   512,   511,     0,   510,  1803,
    1339,  1355,     0,     0,     0,  1324,     0,  1290,  1329,  1804,
       0,  1358,     0,  1145,  1369,     0,  1306,     0,     0,     0,
       0,   589,   599,   591,   586,     0,   592,   588,  1287,  1204,
    1847,   574,  1467,  1466,  1512,  2051,  1465,  2059,  2061,  2047,
    2049,  2056,   671,     0,  1973,     6,    57,     0,  1380,  2009,
    2010,  2008,   465,   104,   104,   533,     0,     0,     0,     0,
       0,  1202,     0,     0,   654,   664,   124,   121,   102,     0,
     612,   628,  1958,     0,     0,  1960,  1964,   768,   767,     0,
      96,   715,  1521,  1932,   100,  1928,  2007,   706,   706,   706,
       0,  1989,     0,  1995,  1996,  1999,  1998,  1997,     0,  1988,
    1991,  1992,  1994,  1993,  2013,  2005,     0,   517,     0,  1269,
    1272,  1276,  1280,  1283,  1562,  1525,     0,  1570,     0,     0,
    1478,     0,     0,     0,     0,  1530,     0,     0,  1584,     0,
       0,  1535,     0,     0,     0,   715,   715,   715,     0,     0,
       0,  1597,  1598,  1487,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1475,     0,  1488,     0,     0,     0,
       0,     0,     0,     0,  1626,     0,     0,  1627,     0,     0,
       0,  1477,  1632,     0,     0,     0,     0,     0,     0,     0,
    1647,     0,     0,  1485,     0,     0,  1016,     0,  1674,  1676,
       0,     0,     0,  1680,     0,     0,  1681,  1682,  1683,  1462,
     770,     0,   715,  1474,  1484,  1695,  1701,  1468,     0,  1703,
       0,  1704,     0,  1711,     0,     0,     0,     0,     0,     0,
    1733,  1735,     0,     0,  1752,     0,     0,     0,   715,  1461,
    1765,  1766,  1767,  1768,     0,  1476,  1557,  1486,     0,     0,
       0,  1777,   715,   715,   715,     0,     0,     0,  1783,     0,
    1786,  1020,     0,     0,     0,     0,   769,     0,   984,     0,
    1012,   727,   733,   747,     0,   855,   762,   849,   785,   784,
    1011,  1472,   783,   782,  1473,   780,  1495,  1514,  1494,  1206,
    1195,  1197,     0,  1198,  1201,  1926,  1199,   576,     0,     0,
      64,  1397,  1391,  1393,  1396,  1392,     0,  1398,  1395,  1394,
    1838,  1384,  1386,  1387,  1881,  1879,  1913,  1912,     0,  1914,
    1910,  1903,  1933,  1907,  1933,  1909,  1908,  1933,  1904,  1911,
    1933,  1876,     0,  1111,  1112,     0,  1848,     0,  1506,     0,
    1414,  1431,     0,  1432,  1420,  1428,   657,     0,  1110,  1836,
    1839,     0,     0,    60,    61,     0,   645,     0,   644,   648,
       0,     0,     0,  1223,  1213,  1222,  1407,     0,     0,  1879,
    1876,  1963,     0,  1965,  1980,   674,  1970,   704,   676,   703,
       0,   687,  1788,  1791,  1799,  1338,  1365,   448,     0,     0,
    1337,  1321,     0,   273,     0,     0,     0,     0,  1307,  1312,
     307,     0,  1328,  1146,     0,  1369,     0,  1332,  1345,  1333,
       0,  1359,     0,  1369,  1302,     0,     0,  1294,  1299,  1295,
       0,  1301,  1300,  1303,  1291,  1292,  1317,  1346,  1359,  1322,
    1327,  1336,  1363,  1364,     0,  1316,  1323,     0,  1334,  1359,
    1359,  1369,  1369,   602,   601,   600,   596,   597,   602,     0,
    1053,     0,     0,  2048,  2062,  2046,  2057,  2058,  2045,   672,
    1974,   670,  1975,     0,     7,     4,  1375,  1373,  1381,  1382,
     466,   465,   264,   267,   266,     0,   540,   538,   465,  2003,
       0,     0,   625,     0,     0,   656,   651,   655,   653,   507,
     506,   509,     0,   663,     0,   125,   127,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    73,    74,    87,   614,   613,   611,   636,   635,
     633,     0,   634,   632,   627,   629,   630,  1957,  1961,   274,
     465,     0,  1523,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1990,    92,     0,     0,     0,  1274,  1270,  1280,
       0,     0,     0,  1110,     0,     0,     0,  1115,     0,   799,
    1115,  1115,  1115,     0,     0,  1010,  1010,     0,  1010,     0,
       0,     0,     0,  1115,   823,   826,     0,   824,     0,     0,
       0,     0,     0,  1481,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1010,     0,     0,     0,     0,   989,     0,
       0,     0,     0,   779,     0,     0,     0,     0,  1010,     0,
       0,     0,     0,  1016,     0,  1014,     0,  1115,     0,     0,
    1115,     0,     0,     0,     0,     0,  1010,  1010,  1010,   720,
       0,   871,     0,     0,     0,     0,     0,  1010,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1115,  1115,
       0,     0,     0,  1115,     0,   892,     0,  1483,     0,     0,
       0,  1482,     0,     0,  1480,  1479,  1463,     0,     0,     0,
     915,   917,   916,  1115,     0,  1115,     0,     0,     0,  1021,
       0,   788,   787,   789,  1986,     0,     0,     0,     0,     0,
       0,   766,   765,   764,   763,     0,     0,     0,   771,     0,
     772,   773,     0,   774,   775,   776,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   790,  1084,  1085,  1086,  1087,
    1097,  1088,  1089,  1090,  1099,  1104,  1091,  1092,  1100,  1101,
    1102,  1093,  1103,  1098,  1094,  1105,     0,  1083,     0,     0,
       0,  1464,   909,     0,     0,  1193,     0,   578,   577,  1200,
     576,     0,    66,    68,  1390,     0,     0,  1399,  1906,     0,
    1887,  1891,  1885,  1889,     0,     0,  1877,     0,  1883,  1114,
    1622,  1690,     0,  1117,  1852,  1210,  1427,  1429,     0,     0,
    1421,     0,     0,   639,    62,     0,     0,  1410,     0,     0,
       0,     0,   617,  1221,     0,  1403,     0,     0,     0,     0,
       0,  1966,  1982,  1981,  1971,   706,  1136,   707,   709,   708,
    1494,  1793,  1796,  1797,  1800,  1798,     0,  1795,  1794,  1809,
       0,  1367,  1370,  1371,     0,     0,  1348,  1347,  1343,  1344,
       0,  1155,  1156,  1154,  1149,  1150,  1153,  1352,  1350,  1341,
       0,  1369,     0,  1351,  1349,  1296,  1297,  1298,     0,  1145,
       0,  1369,  1359,     0,  1369,  1369,  1331,  1335,     0,   590,
     599,   587,   594,  1065,  1064,     0,  1029,     0,  1028,  1027,
    1026,     0,  1064,  2052,  2060,  2064,     0,  1145,  1979,  1977,
     265,  1244,  1244,     0,     0,     0,     0,     0,     0,     0,
     105,   114,   572,   572,  1244,  1244,   572,  1244,  1244,  1244,
       0,     0,  1244,     0,     0,   572,     0,  1244,   570,     0,
       0,  1244,  1244,  1244,   572,     0,  1244,  1244,  1244,  1244,
    1244,   582,  1244,  1244,  1244,   569,   277,   299,   300,   534,
       0,   548,   571,  2014,  2015,   541,   609,  1203,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   637,   631,    97,
     465,   716,  1522,     0,  1929,     0,  2040,     0,     0,   103,
    2016,   275,   520,   522,   521,   519,   518,     0,     0,  1117,
       0,  1277,  1053,  1281,  1280,  1278,     0,     0,     0,  1116,
    1115,     0,   995,  1163,  1164,  1160,  1161,  1159,  1162,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   968,     0,   995,     0,   829,     0,     0,
       0,     0,     0,     0,  1494,     0,     0,     0,     0,     0,
    1986,     0,     0,     0,     0,     0,     0,   806,     0,     0,
       0,     0,     0,     0,     0,  1108,  1106,  1109,  1107,     0,
       0,   990,   982,     0,     0,     0,     0,   856,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1017,
    1018,  1115,     0,     0,     0,  1115,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   878,     0,     0,     0,     0,     0,
     883,     0,     0,     0,     0,     0,     0,     0,  1115,     0,
       0,     0,  1096,     0,  1095,     0,     0,     0,     0,     0,
       0,     0,     0,   912,     0,   914,     0,     0,  1497,  1496,
       0,     0,     0,     0,     0,  1022,   675,     0,   792,  1010,
     791,     0,  1805,   985,   987,     0,   718,   717,   719,   730,
     723,   728,   721,   725,     0,   777,  1567,   731,     0,   759,
       0,  1124,   760,   745,   750,   751,     0,     0,   748,   749,
     753,   855,   752,   855,   756,   757,   758,   761,     0,     0,
       0,     0,     0,   781,   786,  1013,   956,  1498,  1196,  1194,
    1927,  1192,    69,     0,     0,  1385,  1400,  1388,  1937,     0,
    1936,  1922,  1925,  1505,     0,     0,     0,  1862,  1856,  1863,
    1865,  1859,  1864,  1866,  1857,  1858,  1853,  1860,  1118,  1147,
       0,     0,   658,   659,   662,     0,  1842,  1843,  1841,  1840,
    1412,  1411,     0,   646,   649,   650,   622,   621,   623,   616,
     618,   619,   257,  1227,     0,     0,     0,  1233,  1214,  1224,
     607,     0,     0,     0,     0,     0,   702,  1053,  1184,   699,
     680,  1147,  1137,   679,   710,     0,  1792,     0,  1763,  1820,
       0,     0,     0,     0,     0,  1810,  1366,     0,  1318,     0,
    1342,  1354,  1353,  1313,     0,     0,     0,  1311,  1360,     0,
    1330,  1293,  1310,  1117,  1359,  1308,  1309,   604,   603,   598,
    1064,  1053,     0,     0,  1050,  1066,     0,  1066,  1053,  1053,
       0,  1053,  1110,  1061,     0,     0,  2063,  1138,  1978,  1242,
    1243,  1245,     0,     0,   108,   111,   109,     0,   110,     0,
       0,   573,   527,   508,   508,   552,     0,   337,   527,   501,
     550,     0,     0,     0,     0,     0,     0,     0,     0,  1244,
       0,   563,   546,     0,     0,     0,     0,   564,     0,   547,
    1244,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   585,   584,   583,     0,     0,     0,     0,   278,   465,
     340,     0,   579,   337,   343,  1501,  2018,  1080,     0,  1079,
     126,    80,    76,    88,  1168,  1169,  1167,  1165,  1166,    89,
      78,    79,    83,    82,    84,    85,    86,    81,    77,    90,
      91,    75,     0,  1930,     0,     0,   241,   240,     0,  2034,
       0,  2018,     0,   340,    93,  1433,   276,   279,    94,  1053,
    1136,  1280,  1117,     0,  1110,     0,   798,   813,     0,     0,
     961,     0,     0,   963,   964,   965,     0,   817,     0,   815,
     818,   819,   820,  1010,     0,     0,     0,     0,  1010,   967,
       0,   825,     0,     0,   830,   831,     0,   804,     0,   838,
       0,   840,     0,  1010,     0,   834,     0,   795,     0,     0,
    1010,     0,   846,     0,   807,     0,     0,   947,     0,   930,
     926,     0,   928,     0,     0,  1010,  1010,     0,   851,     0,
       0,   857,  1010,     0,   949,     0,   931,     0,   863,     0,
    1010,     0,  1015,     0,     0,     0,   974,   867,   868,     0,
     972,   933,     0,     0,   870,   935,     0,   937,     0,   932,
     939,   940,   872,   874,   873,   942,     0,     0,   944,     0,
     946,     0,   876,   877,     0,     0,     0,   881,     0,  1010,
     886,   976,   978,     0,     0,     0,     0,     0,   980,   893,
     895,     0,     0,     0,   894,     0,     0,     0,     0,     0,
       0,     0,   899,     0,     0,   913,   979,   805,   977,   918,
       0,   921,     0,   920,     0,     0,     0,     0,  1983,  1983,
       0,   796,     0,     0,     0,     0,     0,  1499,   724,   729,
     722,   726,     0,     0,     0,     0,   743,   742,     0,   755,
     754,     0,  1124,   746,     0,   854,     0,   955,   706,  1010,
       0,    67,  1389,  1934,     0,     0,     0,     0,     0,     0,
       0,     0,  1851,  1148,  1254,  1513,  1422,     0,   666,  1844,
    1845,     0,   620,   685,     0,  1246,  1231,  1238,  1232,     0,
       0,     0,  1230,  1490,  1489,  1496,  1969,     0,     0,     0,
       0,  1972,  1117,  1117,  1178,     0,     0,   677,   682,   678,
     681,     0,   705,   714,   713,  1491,  1498,     0,     0,     0,
       0,   451,   453,   452,   461,     0,   450,     0,     0,  1805,
       0,   457,   459,   458,  1815,   456,  1368,  1145,  1326,  1325,
    1152,  1151,     0,  1304,  1320,  1369,     0,  1976,  1059,     0,
    1052,  1051,  1067,     0,  1053,  1066,  1066,     0,  1032,  1031,
    1258,  1261,     0,  1030,  1070,  1057,   685,  2053,  2065,     0,
     464,   463,   306,   460,   305,   113,   112,   118,   119,   342,
     528,   502,   503,     0,     0,     0,   508,   336,   527,   335,
     338,   517,     0,   289,   286,   554,   292,   288,   304,     0,
       0,   293,   527,   561,   562,   576,   282,     0,   318,   319,
     317,   301,   284,   285,   556,  1132,  1134,  1142,   291,   290,
     287,   296,   297,   315,   314,   295,   316,   567,   313,   311,
     308,   310,   309,   312,   294,   283,  1399,   549,     0,   326,
     328,   329,  1504,     0,   581,   551,     0,   330,   331,     0,
       0,     0,     0,   665,     0,  1931,     0,  2041,   244,   242,
     243,     0,   128,   324,   325,   323,   322,     0,     0,   247,
       0,   245,     0,     0,  1435,  1434,   246,   260,   465,   280,
       0,  1117,  1157,  1273,  1279,     0,     0,     0,   962,   996,
       0,   423,   423,  1006,  1004,   412,   423,  1000,  1005,  1002,
       0,     0,     0,     0,     0,     0,     0,   969,   966,     0,
       0,     0,  1498,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     993,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   951,  1019,   975,   973,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   981,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1023,   801,  1987,  1987,   793,  1806,  1807,  1808,   529,   986,
       0,   736,  1010,   734,  1123,   740,     0,     0,   744,     0,
     910,     0,   957,   958,     0,  1009,  1500,  1935,  1924,  1923,
    1938,  1938,  1938,     0,  1119,     0,  1211,  1433,   660,     0,
     661,   647,   706,  1228,  1240,     0,  1248,     0,     0,  1225,
    1235,     0,     0,     0,  1234,     0,  1869,  1870,  1868,  1147,
    1125,     0,     0,  1189,     0,  1185,   700,     0,   712,   711,
       0,  1822,     0,  1821,  1833,  1834,  1831,  1832,  1830,  1811,
       0,  1817,  1816,     0,     0,     0,  1827,  1818,     0,     0,
    1319,     0,  1314,   605,     0,  1053,  1066,  1053,  1039,     0,
       0,  1053,  1035,  1033,  1037,     0,  1117,     0,     0,     0,
       0,  1054,   706,  1493,  1139,  1142,   339,   527,   504,   505,
     517,     0,     0,     0,     0,   461,   302,   560,   559,   303,
       0,     0,  1143,  1144,  1135,     0,   553,   340,   580,   481,
     408,   357,   348,   423,   351,   350,   394,   365,   362,   412,
     410,   380,   412,   412,   387,   386,   404,   390,   370,   467,
     467,   369,   407,   467,   391,   389,   393,     0,   395,   412,
     400,   388,   392,   409,   385,   382,   406,   423,   423,   363,
     366,   405,   467,     0,   398,   423,   431,   368,   467,   473,
       0,     0,   423,   429,  1503,  2020,     0,  2022,  1078,     0,
     139,   706,     0,   129,   131,   132,     0,  2022,     0,   250,
     275,   261,     0,   281,     0,  1275,     0,  1271,   779,   810,
     814,   923,     0,   997,   424,   467,     0,  1007,   414,   413,
     999,  1001,  1003,   800,   816,   821,   925,   803,   802,     0,
       0,     0,     0,   836,   839,   841,   832,   837,   835,     0,
     924,   848,   845,   847,   808,     0,   948,   927,   929,   850,
     861,   991,   994,     0,     0,     0,   862,   858,   950,   859,
       0,   864,   833,   865,     0,     0,     0,     0,   934,   869,
     936,   938,   943,   941,   945,   875,   812,     0,   880,   882,
     794,   779,   884,     0,   890,   888,     0,     0,   896,     0,
       0,   905,     0,   903,     0,   904,     0,   906,   907,     0,
     919,   922,  1024,     0,  1984,     0,     0,   988,   732,     0,
     738,  1010,   735,   741,   707,   706,   908,     0,  1943,  1943,
    1943,  1253,  1252,     0,  1251,  1255,     0,   667,   258,     0,
       0,     0,  1249,  1237,  1973,  1226,  1229,  1498,  1871,   684,
       0,  1120,  1188,  1186,     0,  1179,  1181,  1183,     0,  1492,
       0,     0,  1826,  1812,   462,     0,     0,     0,     0,  1813,
       0,  1110,  1060,     0,     0,  1026,  1053,  1053,     0,  1026,
       0,     0,     0,  1260,  1136,  1262,  1068,  1072,  1073,  1071,
    1062,     0,  1141,     0,     0,     0,   566,     0,   579,   568,
     431,  1133,   298,   327,   487,   356,   349,   367,   416,   411,
       0,   416,   416,   473,   475,   469,   473,     0,   376,   394,
     371,     0,   467,   384,   375,   396,   399,   401,   403,   416,
       0,   467,   364,   373,   360,   416,   439,     0,     0,     0,
     435,     0,   480,     0,   442,   344,   432,   434,     0,     0,
     397,   467,   353,   474,   473,   355,   467,   473,   416,     0,
     430,   416,     0,  2019,     0,  2026,     0,     0,   142,   140,
     141,     0,   135,   137,   132,     0,  2035,     0,     0,  2033,
    2026,   248,  1973,  1433,     0,   253,     0,  1142,   525,  1158,
       0,     0,     0,     0,     0,   998,     0,     0,   970,   827,
     828,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   797,     0,     0,     0,     0,     0,     0,     0,
     902,   900,   901,     0,  1025,  1985,   530,   737,     0,   710,
     959,     0,     0,  1942,  1940,     0,  1941,  1939,  1915,     0,
    1874,  1875,  1873,  1861,     0,     0,  1423,  1147,  1239,  1241,
    1247,  1236,     0,  1121,  1136,  1436,  1182,     0,   701,  1824,
    1823,  1825,  1819,     0,     0,     0,     0,  1058,  1053,  1040,
       0,  1044,  1049,  1045,     0,  1036,  1034,     0,  1157,     0,
    1074,  1147,  1142,     0,     0,     0,     0,     0,     0,     0,
       0,   565,  1469,   555,   557,     0,     0,     0,   482,   483,
     488,   490,   420,   421,   422,   377,   417,   419,     0,   379,
     347,   468,   476,   477,     0,   472,   470,   473,   372,   402,
     378,     0,   374,   361,   445,   444,   715,   437,   447,     0,
       0,   443,   433,   441,   436,   352,   354,   358,   359,   345,
       0,   346,  1502,  2021,     0,   542,   706,   706,  2023,  2032,
    2042,   139,     0,     0,     0,   130,   133,  2017,   251,   249,
       0,  1969,    95,     0,   524,     0,   811,   427,   425,   428,
     426,     0,   822,   842,     0,   809,   992,   983,  1115,   852,
       0,   860,   866,   953,   952,   879,   885,   889,   887,   891,
     897,   898,  1010,   739,   960,  1921,  1920,  1919,  1916,     0,
       0,     0,     0,     0,     0,  1944,  1946,  1250,     0,     0,
     259,   699,   320,  1129,  1142,     0,  1147,     0,  1444,  1180,
    1829,  1828,  1814,     0,     0,     0,     0,     0,     0,     0,
    1081,  1259,  1069,     0,  1063,  1140,     0,     0,   517,  1471,
    1470,   579,   493,   494,   495,     0,     0,     0,   486,   489,
     418,     0,   531,   478,   471,     0,   446,   715,   440,     0,
       0,     0,   675,     0,   106,   136,     0,   706,  2036,   255,
     254,  1142,     0,     0,     0,     0,     0,     0,  1917,  1947,
    1950,  1948,  1949,  1951,  1945,     0,     0,   321,     0,     0,
    1126,  1128,  1122,  1170,     0,     0,     0,     0,  1437,  1439,
       0,  1187,     0,  1055,  1041,     0,  1046,     0,  1038,     0,
    1076,     0,   517,   332,   558,   497,     0,   496,     0,   491,
     492,   487,     0,   467,     0,   467,   438,     0,  2027,     0,
    2024,     0,  2043,   138,     0,     0,  1973,   523,   526,   415,
     843,     0,   971,   853,   911,  1256,  1264,     0,  1424,  1130,
    1131,  1142,     0,   683,     0,     0,     0,     0,  1438,     0,
       0,  1445,  1447,     0,     0,     0,     0,  1082,     0,  1077,
     334,   333,   499,   500,   498,   484,   485,   381,   532,   383,
    2028,  2029,  1973,   116,   115,   107,     0,   175,     0,  2037,
     256,     0,     0,     0,   454,  1127,  1171,  1442,  1443,     0,
    1440,     0,     0,  1446,     0,     0,  1043,  1048,  1075,  2025,
     117,     0,   193,   179,     0,     0,     0,   177,   207,  2044,
       0,     0,   181,   205,   206,   182,   185,   186,     0,  1516,
       0,  1517,  2030,   106,   844,  1263,  1265,     0,  1425,     0,
    1441,  1449,  1448,     0,  1056,   192,   195,     0,     0,   198,
     188,   187,   189,     0,     0,     0,   176,   175,   175,   235,
     184,   232,   231,   224,   175,  2038,   455,  1436,   706,     0,
     194,     0,     0,     0,   178,   208,   219,   222,   214,   175,
       0,   175,     0,   147,     0,     0,  2031,   175,  1444,     0,
       0,  1174,  1176,     0,   190,     0,     0,     0,     0,   175,
     215,     0,     0,     0,   145,   238,     0,   143,   226,   226,
    2039,  1450,  1177,  1172,   706,  1315,     0,   180,   199,   216,
     222,   212,   220,   175,     0,   234,   146,     0,   236,     0,
     175,     0,   225,   227,   229,     0,  1452,  1175,   191,   196,
     175,     0,   213,     0,     0,   211,     0,   175,   158,   157,
       0,   149,   171,   233,     0,   148,     0,     0,  1459,     0,
     175,   217,     0,   175,     0,   175,     0,     0,     0,     0,
       0,   144,  1451,  1454,     0,     0,  1456,  1457,     0,  1426,
     197,   202,     0,   209,   175,   239,     0,   152,   172,   173,
       0,   155,  1458,  1453,     0,  1460,   198,   175,   201,   175,
     237,     0,     0,   150,   164,   151,   162,   154,     0,  1455,
     203,   175,   175,   170,   168,   175,   159,   166,   161,     0,
     167,   174,   165,     0,   156,     0,   153,   169,   163,   160
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    52,   474,  1095,    53,    54,    55,    56,    57,   983,
      58,   532,   930,  1402,  1403,    59,   425,    60,   709,  1142,
    1143,  1144,    61,  1621,  2490,  1160,   402,   420,  1618,  1106,
    3422,  1540,  3475,  1541,    62,   496,   707,  1124,  1125,  2792,
    2793,  3068,  2794,  3061,  3062,  3063,  3064,  3620,  3569,  3597,
    3621,  3658,  3691,  3697,  3698,  3640,  3705,  3706,  3707,  3713,
    3708,  3641,  3693,  3570,  3510,  3543,  3539,  3511,  3606,  3538,
    3628,  3562,  3563,  3630,  3671,  3688,  3512,  3513,  3544,  3587,
    3514,  3545,  3610,  3567,  3611,  3631,  3672,  3568,  3588,  3634,
    3591,  3515,  3574,  3622,  3516,  3575,  3517,  3518,  3552,  3573,
    3550,  3572,  3637,  3617,  2068,  2471,  2074,  2481,  3072,  2486,
    3251,  3426,  1897,  2293,  3137,  2802,  1609,  1101,  1102,   403,
     404,   405,   504,  2075,  1575,  2076,  2077,  1577,  1578,  1029,
    2444,  2435,  2421,  3300,  2477,  2448,  2449,  2450,  2451,  2399,
    2400,  1986,  1987,  2033,  2459,  2776,  3000,  3020,  2777,  2778,
    2779,  2780,  2781,  2782,  2783,  2817,  2818,  3195,  3196,  3197,
    2813,  2814,  3051,  3035,  3036,  3037,  3217,  3007,  2333,  2334,
    3528,  2343,  2344,  2381,  2671,  2382,  1105,  3008,  3045,  3205,
    3038,  2458,  2994,  3188,  3337,  3189,  3190,  3191,  3409,  1988,
    2398,  1121,  1122,   655,   406,  1176,  1625,  3076,  3077,  2389,
    2907,  3341,    63,  1108,   692,   694,   693,  2036,   481,  1579,
    1580,  1581,  2714,  2720,  3331,  1990,   111,  1399,  2455,  2024,
      64,  1078,  1073,    65,   666,   661,   662,  1076,  1077,  1509,
    1948,    66,   599,    67,   491,    68,   499,  1147,    69,   991,
    1889,  1890,  1891,    70,   699,    71,   500,  1154,  1155,  1156,
      72,   981,   116,    73,   588,   986,   988,   989,    74,   493,
     494,  1116,    75,  1429,  1872,  1873,   704,   705,  1123,  2630,
      76,    77,   471,   445,   605,   446,   447,  1456,  1909,  3301,
     616,   617,   618,  2317,  1008,  1009,  1010,  1914,  1457,  2322,
    1162,  2922,   901,   902,   903,  1336,  1337,  3039,   904,  1346,
    1808,   905,   906,  1836,   907,  2867,  2266,  2267,  2268,  2612,
    2613,   908,  2108,  2830,  2146,   909,  1329,  1793,  1702,  3094,
    2851,  1641,  2091,  2510,  2614,   521,   522,   910,  1254,  1255,
    1256,  1719,  1320,  2237,  1785,  1516,  1517,  1518,  1519,  2971,
    2970,  2972,  3315,  3160,  3317,  3164,  1959,  1520,  1521,  3454,
    2357,  2685,  2375,  2376,  3171,  1950,  1522,  2363,  3170,  2701,
    2977,  3323,  3458,  2038,  3319,  1386,  1763,  1387,  1699,   965,
     966,  1642,  1869,  2281,  3144,  3305,  2256,  2941,  3303,  3380,
    1582,  2425,  2426,  1911,  1912,  2379,  2704,  2724,  1032,  3302,
    2283,  1484,  1485,  2807,  3696,  2049,  3443,  3529,  3580,  3581,
    3582,  2653,  2654,  2945,  2946,  1913,  2314,  2655,  3145,    78,
     408,    79,  1839,  1846,   701,   524,   417,    80,   426,  1870,
      81,   439,  1444,   572,   592,   994,   995,  1898,  2294,  2301,
    1899,  2306,  2934,  2296,  2633,  2634,  1971,  1972,  2297,  2636,
    2931,  2923,  2924,  2626,  3135,    82,   459,  2696,  2370,  2371,
    3435,  3436,   593,    83,   407,   749,  1629,  1181,  1628,   750,
     751,  1183,   519,   520,    84,   457,  1053,  1054,  1055,  1499,
      85,   450,   656,  1480,  2347,  1933,   584,   658,  1491,   659,
    1492,  1471,  1928,  1020,    86,   688,   687,    87,   477,  1097,
      88,   533,   941,   942,  1407,  1847,    89,   440,   597,   598,
      90,   434,   585,  1437,    91,   427,   575,    92,    93,   576,
     974,  2627,  3299,  3484,  3557,  1428,   975,  2487,  3308,  3388,
    3389,  3391,  3451,  3452,  3626,  3648,  3665,  3666,  3669,   911,
     675,   912,  3181,   913,   914,  2302,  2303,  2705,   915,  3437,
     916,  2034,   669,   423,   917,   566,   676,  2286,   918,  3520,
     722,   723,   389,   390,    94,   619,   449,  1012,  1013,  1014,
    1466,  1467,   660,  2245,  1468,  1469,  1925,  1920,  2953,  2677,
    2669,    95,   579,   943,   979,   980,  1878,    96,   458,    97,
     967,  1423,  1424,  1866,  2280,  1867,    98,   601,    99,   555,
    1417,   556,   945,   557,   558,   957,   952,   960,   954,  3289,
    3127,  3128,  1854,   926,   724,   725,  1410,  1849,  1850,  2918,
    3130,  3295,  3296,   100,   120,   395,   502,   716,  1002,   101,
     102,   103,   104,  1005,  1090,  1905,  1091,  1092,  1093,  1529,
    1454,  2592,  1327,  1787,  2904,   507,   739,   731,   487,   488,
     489,   510,   511,   112,   113,   732,   733,  2071,  2462,  2786,
    3055,  3056,  3238,  3235,   734,  3554,   735,   736,  2472,  3244,
    3425,  3523,  3577,   737,  2065,  2790,  3354,  3477,   105,   677,
     468,  1088,  1083,  1085,  1525,  1966
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3141
static const int yypact[] =
{
    3828, -3141,    79,   101,   996, -3141,   176, 42243,    59,   996,
     996,  -182,  2840, -3141, -3141, -3141, -3141, -3141,  2901, 42243,
     101, -3141, 20719, -3141, -3141, -3141,   194,   996,   101, 42243,
   -3141,    19,   709,   101, -3141, -3141,   996, -3141,  -182, 42243,
   -3141,   256, -3141,   878,   610,    10,   324, -3141, -3141, 42243,
    1702,   -92,   664,   895, -3141, -3141,   550, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, 21269, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141,   816, 42243, 42243, -3141,
   42243,   486, -3141,   920, -3141, -3141,   996, -3141, -3141, -3141,
    -182, 20719, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,   407, -3141,
   -3141,   629, -3141, -3141, -3141,  1154,   999, -3141, -3141, -3141,
   -3141, -3141,   151,   648, -3141,   854,  1008,   912, -3141,  1102,
    1102, 42243,  1102, -3141,  1102, -3141,  1102,   996, -3141, -3141,
    3882, 42243,  1004,   152,  -107, 37293,   263,   106, -3141,  1159,
   20719, -3141,   996,  1223,   179, 42243, -3141, -3141,   996,   140,
     736, -3141,  3941,    97, -3141, -3141, -3141,  2904, -3141, -3141,
    5671, -3141, -3141, -3141,   858, -3141, -3141, 20719,   996,  1170,
   -3141, -3141,   150,   150,   150, -3141,   150, -3141,   150, -3141,
     -92,   855, -3141, -3141,   869, 42243,   429, -3141, -3141,   871,
     708, -3141, -3141, -3141, -3141, 20719,  1319,  1014, -3141, -3141,
   -3141, 20719, -3141,   -59, -3141, -3141,   910, 42243, -3141, 20719,
   20719,   175,   900,  1169, 42243, 35093,  1090, -3141,   158,   756,
     920,  1487, -3141,   999, -3141, 42243, -3141, -3141, -3141, 38943,
     912, -3141, 12833,  1353, 42243, 42243,  1173, 42243, 42243, 35093,
   20719,  1102,   985,  3532,  1150,  1127,   979, -3141, -3141, -3141,
   -3141,  1205, -3141, -3141,  1084, -3141, -3141, -3141,   120, -3141,
     100, -3141, -3141, -3141, -3141, -3141,  1233,  1009, -3141, -3141,
      94, -3141, -3141, 42243, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141,  1380, -3141, -3141, 12833,   202,  1550,  1428, 20719,
   -3141,  -164, -3141, -3141,  1342, -3141, -3141, 35093, 20719, -3141,
   -3141, -3141, 18506, -3141, -3141,  1562, -3141,  1044, -3141, 20719,
    1150, -3141,  1277,  1202,   900,  1108, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141,  1067,  2904, -3141, -3141,
    1373,  1496, -3141,  1213,   -17,  1146,  1083,   192,   -17, 37293,
    1407, -3141,   149, -3141,  1491, -3141, -3141,  1221, -3141, -3141,
   -3141,  1226,  1230,  1424,  1237, -3141,   184,  3012, -3141, -3141,
     -34, -3141,   684,  1407,   -17,   936, -3141,  1459,  1585,    84,
    -160, -3141,   847, -3141, -3141,  1656, -3141, -3141, -3141, -3141,
   -3141,  1380, -3141, -3141, -3141,  1174, -3141,  1383,  1257, -3141,
   -3141,    34, -3141,  1178,     8,  1759, -3141,   472, 35643, -3141,
   -3141, -3141,  1655, -3141, -3141, -3141, 35093,  1356,  1229, 20719,
     390, -3141, 39493, 20719, -3141,   231, 12833, -3141, -3141,  4164,
      81,   113, -3141,  1730,  1388, -3141, -3141, -3141, -3141,  1638,
   -3141,  1239,  1219,  1593,  1241, -3141, -3141, -3141, -3141, -3141,
    1643, -3141,  1282, -3141, -3141, -3141, -3141, -3141,  1661, -3141,
   -3141, -3141, -3141, -3141,  1014, -3141, 20719,   825, 20719, -3141,
    1259, -3141,  1249, -3141,  1274,  1276,  1279,  1281,  1284, 15718,
   -3141,  1293,  1297,  1301,  1313,  1325,  1332,  1336,  1352,  1355,
    1360,  1365,  1379,  1387,  1391,  1239,  1239,  1403,  1409,  1413,
    1416,  1318,  1423, -3141,  1427,  1436,  1440,  1445,  1449,  1454,
    1456,  1461,  1481,  1490, -3141,  1498, -3141,  1503,  1509,  1517,
    1529,  1533,  1547,  1555,  1557,  1568,  1572,  1590,  1597,  1599,
    1600, -3141,  1604,  1605,  1606, 12833,  1610,  1612,  1613,  1620,
    1625,  1628,  1632, -3141,  1635,  1636,  1641,  1644,  1646,  1649,
    1650,  1653,  1654,  1658,  1660,  1666,  1668,  1673,  1680, -3141,
   -3141, 12833,  1682, -3141, -3141,  1689,  1695, -3141,  1700,  1704,
    1705,  1710,  1712,  1715,  1716,  1719,  1723,  1725,  1726,  1732,
    1734,  1740,  1742,  1755,  1756,  1760,  1762,  1768,  1772, -3141,
    1364,  1777,  1781,  1422,  1784, -3141,  1785, -3141,   214,  1787,
    1789,  1790,  1239,  1239,  1239,  1791,  1796,  1797,  1806,  1807,
    1808, 12833, 15718, 15718, 15718,  8217, -3141, 42243, -3141, 42243,
    1856,  3331, -3141,  3739, 15718,  4812,   412, -3141, -3141, -3141,
    1320,  1426, -3141, -3141, -3141, -3141, -3141,  1811,  1375, -3141,
   -3141,  1486, 20719, -3141, -3141, -3141,  1637,    38, 20719,  1588,
   -3141, -3141, -3141, -3141, -3141, -3141,  2164, -3141, -3141, -3141,
    1676,  1675, -3141, -3141, -3141, -3141, -3141, -3141,  1745, -3141,
   -3141, -3141,  1814, -3141,  1814, -3141, -3141,  1814, -3141, -3141,
    1814,   650,  4030, -3141, -3141, 42243, -3141, 42793, -3141, 18506,
    1856, -3141,  1978, -3141, -3141,  2053, -3141,  2039,   169,  1813,
   -3141, 20719, 37293, -3141, -3141,   122,  1822,  1873,  1824, -3141,
    1897, 20719, 20719, -3141, -3141, -3141, -3141,   736,   -12,  1828,
     687, -3141, 42243, -3141,  1131, -3141, -3141, -3141,  1833, -3141,
   12833, -3141,  1842, -3141,   823, -3141,  2186, -3141,  1932, 12833,
   -3141, -3141,  1855,   999, 42243, 42243, 20719, 20719, -3141, -3141,
   -3141,   527, -3141, -3141, 42243,   -17, 35093, -3141, -3141, -3141,
    2255,   936, 42243,   -17, -3141,  2198,  1948, -3141, -3141, -3141,
    2272, -3141, -3141,  2261,  1872, -3141, -3141, -3141,   936, -3141,
   -3141, -3141, -3141, -3141, 20719, -3141, -3141,   936, -3141,   936,
     936,   -17,   -17,  1911, -3141, -3141,  1876, -3141,  1911,  1995,
    -130,   150,  2099, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141,    31, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141,    96, -3141, -3141, -3141,  1494,  1475,  1475,  1627, -3141,
     750, 20719,  1888,  1932, 20719, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141,  1891, -3141,  1892,  1893,  1856,  2324,  2325,  2327,
    2331,  2335,  2338,  2339,  2341,  2344,  2346,  2355,  2358,  2359,
    2360,  2361,  1933, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141,  1984, -3141, -3141, -3141, -3141,  1198, -3141, -3141, -3141,
     125,  1936, -3141, 37293,  2469, 35093,  2340, 42243, 42243, 42243,
   20719, 42243, -3141, -3141,   222,   222,  2173,  1259, -3141,    82,
   42243,  2364, 25135,   207, 12833, 12833, 12833,  1164,  1107,  2478,
    2521,  2521,  2521, 12833, 12833, -3141, -3141, 12833, -3141, 12833,
   12833, 12833, 12833,  1195, -3141, -3141,  8794, -3141,  1962, 12833,
   12833,  2055, 12833,  1426, 12833, 12833, 21819, 12833, 12833, 12833,
   12833, 12833,   566, 12833,  4812, 12833, 12833, 12833,  1971, 12833,
   12833, 12833, 12833, -3141, 12833, 12833,   223, 12833,  2423,   642,
   12833, 12833, 12833, -3141,  9371, 12833, 12833, 12833, -3141, 12833,
   12833, 12833, 12833, -3141,  2540, -3141, 21819,  1220, 12833, 12833,
    1242, 12833, 12833, 12833, 12833, 12833, -3141, -3141, -3141, -3141,
    8794, -3141, 12833, 12833, 12833, 12833, 12833, -3141, 15718, 12833,
    9948, 12833, 12833, 12833, 12833,  1976, 12833, 12833,  2521,  2521,
   12833, 12833, 12833,  1255,  8794, -3141, 12833,  1426,  2867,  2867,
   12833,  1426,  7063, 12833, -3141, -3141, -3141,   642, 10525,  1981,
   -3141, -3141, -3141,  2521, 21819,  2521, 12833, 12833, 12833,  1856,
    2011,  2478,  2478,  2478, -3141,  8217,   200,  1983, 12833, 22919,
    1979, -3141, -3141, -3141, -3141, 12833, 12833, 12833, -3141, 15718,
   -3141, -3141,  1805, -3141, -3141, -3141, 13410, 15718,  1990, 15718,
   15718, 15718, 15718, 15718,  2309, 15718, 15718, 15718, 15718, 15718,
   15718, 15718, 15718, 15718,   689,  2478, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141,  2008, -3141, 37293, 15718,
   12833, -3141, -3141, 42243, 42243, -3141, 35093, -3141, -3141, -3141,
      38, 37293,  1996, -3141, -3141,  2188,  3532, 20719, -3141, 42243,
   -3141, -3141, -3141, -3141, 19056, 19056, -3141, 19056, -3141, -3141,
      62,    66,  3066,  2034, -3141, -3141, -3141, -3141,  2366, 20719,
   -3141,   -39, 20719,  1888, -3141, 12833,  1932, -3141, 35093, 35093,
   20719, 20719,    -1, -3141,   876, -3141,  1932,  2395, 19056, 19056,
   19056, -3141, -3141, -3141, -3141, -3141,   782, -3141,  1856, -3141,
    2007, -3141, -3141, -3141, -3141, -3141, 40043,    98, -3141, -3141,
    1932,  2416, -3141,  1856,  2020, 42243, -3141, -3141, -3141, -3141,
     560, -3141, -3141, -3141, -3141,   -79, -3141, -3141, -3141, -3141,
    2157,   -17, 42243, -3141, -3141, -3141, -3141, -3141,  2222,  1407,
    3012,   -17,   936, 20719,   -17,   -17, -3141, -3141,  1464, -3141,
     847, -3141, -3141, -3141, -3141, 42243,   817,  2170,  2033, -3141,
   -3141, 20719, -3141,  2036, -3141,  2437,  2567,  1407, -3141, -3141,
   -3141,   615,   615,  1932,  2153,  2155,  2156,  2160,  2161,  2197,
   -3141, -3141,  3174,  2562,   615,   615,  2562,   615,   615,   615,
    2132,  2509,   615,  2397,  2148,  1731,  2405,   615, -3141,  2159,
    2522,   615,   615,   615,  2562,  2600,   615,   615,   615,   615,
     615,   119,   615,   615,   615, -3141,  4520, -3141, -3141,  2073,
   19608, -3141, -3141, -3141, -3141, -3141, -3141, -3141, 40593, -3141,
   12833,  1107,  1932,  1932,    83,  1932,  1107,  1932,  1932,  1932,
    1932,  1932,  1107,  1932,  1932,  1107,  4164, -3141, -3141, -3141,
     127, -3141, -3141,   332, -3141, 42243, -3141,  1235,  2076,   -80,
   -3141,  3697, -3141, -3141, -3141, -3141, -3141, 20719,  2121,  2034,
   25135, -3141,  -130, -3141,  2069, -3141,   297,   747,   204, -3141,
    2521,  2078, -3141, -3141, -3141, -3141, -3141, -3141, -3141,  2081,
    2083,  2085,  2088,   311,  1109,   408,  2090,  1404,  2091,   372,
     384,   228,   533, -3141,  2092,  2100,  1559, -3141,   815,   820,
    1591,  1595,   862,  2096,  2093,   236,   240,   864,   977,   272,
   -3141,  2102,  1018,  2504,  1025,  1062,   281, -3141,  1623,  1072,
    1100,   286,  2106,   295,   301, -3141, -3141, -3141, -3141,  2107,
    1104, -3141, -3141,  -191,  1629,  1137,  1162, -3141,  1639,  1171,
    1182,   329,  2111,  1190,   348,  1208,  1214,  2112,  2108,  2114,
   -3141,  2521,  2116,  1651,  1690,  2521,  2117,   358,  1225,  1738,
     374,   441,  2119,  2123,  2125,  1753,  1778,  1798,   695,  1231,
     700,  2128,  1492,  1802, -3141,  1820,  1244,  1248,  1250,   728,
   -3141,  1262,  1830,  2134,  2135,  1275,   252,  1310,  2521,  2136,
    1867,   739, -3141,  2137, -3141,  2144,  1878, 11102, 11679, 12256,
     340,  1322,   484, -3141,  1905, -3141,  2152,  2154, -3141,  2093,
    2177,   786,   791,  1928, 12833,   734, -3141,   -92, -3141, -3141,
   -3141,   129,   625, -3141,  2274, 42243,  1626,   117, -3141, -3141,
   -3141, -3141, -3141, -3141,   392, -3141,  2149, -3141,  2165,  2182,
    8217,   889,  2182,  3397,  1021,  1021, 15718,  2890,  3762,  2310,
     717,  4812,   717,  4812,  2182,  2182,  2182, -3141,  2171, 15718,
   15718, 15718, 12833, -3141,  2478,  1856,  2183,   563, -3141, -3141,
   -3141, -3141, -3141,  1588,  2467, -3141,  1888, -3141, -3141,   647,
   -3141,  2178, -3141,  2187,  2236,  2266,  2271, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,  1407,
     876,  2241,  2201, -3141, -3141,  2225,  2519, -3141, -3141, -3141,
    1856, -3141,  2280, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141,   379, -3141, -3141,  2207,  2207, 17395, -3141, -3141, -3141,
   -3141,  2432,  2608,  2614,  2615,   472, -3141,   145, -3141,   146,
    2569,  1407, -3141,  2627, 37843, 25687, -3141,  2223,  2570,  2228,
     615, 33443,   763, 23472, 33993, -3141, -3141,    83, -3141,    35,
   -3141, -3141, -3141, -3141,   527,   527,  2268, -3141, -3141,  2484,
   -3141, -3141, -3141,  2034,   936, -3141, -3141, -3141,  2249, -3141,
   -3141,  -130,  2591,  2592, -3141,  2470,   195,  2470,  -130,  -130,
   21819,  -130,  2371, -3141,  1107,  2527, -3141, -3141, -3141, -3141,
   -3141, -3141, 36193, 34543, -3141, -3141, -3141,  2736, -3141,  2741,
     980, -3141, 22369,   137,   137, -3141,   188,   196, 22369, -3141,
   -3141, 22369,    83,  1107, 22369,  1107,  1932,  1932,  1603,   615,
    1107, -3141, -3141,  2601,  2602, 22369, 22369, -3141, 37293, -3141,
     615,   875,    83,    83, 22369, 21819,  1161,  1932,  1107,  1107,
    2054, -3141, -3141, -3141, 20719,  1117, 37293,  2265, -3141,  5728,
   16845, 42243,   242,   290, -3141,  2260,  2275, -3141,  1103, -3141,
    1856, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141,  2362, -3141,  2436,  2281, -3141, -3141,   174, -3141,
     712,  2275, 20719, 16295, -3141,    89, -3141,  3615, -3141,  -130,
    2507,    88,  2034,  2297,   207, 13987, -3141, -3141, 12833,  2295,
   -3141, 12833, 12833, -3141, -3141, -3141,  2974, -3141, 36743, -3141,
   -3141, -3141, -3141, -3141, 12833, 36743,  2974, 12833, -3141, -3141,
    2296, -3141,  2646,  2646, -3141, -3141,  1426, -3141, 42243, -3141,
   12833, -3141, 12833, -3141,  1426, -3141, 12833, -3141, 12833, 12833,
   -3141,  2534, -3141, 12833, -3141, 12833, 12833, -3141, 12833, -3141,
   -3141, 12833, -3141, 12833, 12833, -3141, -3141,  2535, -3141, 12833,
   12833, -3141, -3141, 12833, -3141, 12833, -3141, 12833, -3141, 12833,
   -3141, 12833, -3141, 15718, 21819,  2307, -3141, -3141, -3141,  2312,
   -3141, -3141, 12833, 12833, -3141, -3141, 12833, -3141, 12833, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, 12833, 12833, -3141, 12833,
   -3141, 12833, -3141, -3141, 12833, 12833, 12833, -3141, 12833, -3141,
   -3141, -3141, -3141, 14564, 12833, 12833, 12833,  2315, -3141, -3141,
   -3141, 12833, 12833, 12833, -3141, 12833,   426, 12833,  1684, 12833,
    1840, 12833, -3141, 12833,  2554, -3141, -3141, -3141, -3141, -3141,
   12833, -3141, 12833, -3141,   546, 12833, 12833,  2752, -3141, -3141,
    2320, -3141,  2316,  2317,  2328, 37293, 12833, -3141, -3141, -3141,
   -3141, -3141,   566,   803,  2322, 15718, -3141,  3397, 15718, -3141,
   -3141,  8217,   889,  3397,  2916, -3141,  2334, -3141, -3141,  2336,
   42243, -3141, -3141, -3141, 42243,  2345, 26239, 35093, 35093, 35093,
    2329, 12833, -3141, -3141,  2571, -3141, -3141, 20719,  2699, -3141,
   -3141, 35093, -3141,  2904, 21819, -3141,  2343, -3141,  2343,   911,
    2351,  1128, -3141, -3141, -3141,  2348,  1108,  2745, 35093, 35093,
   35093, -3141,  2034,  2034,   163,  2403,  2706, -3141, -3141, -3141,
   -3141, 41143, -3141, -3141, -3141, -3141,   723, 42243,  2691, 42243,
    7640, -3141, -3141, -3141,  2878, 12833, -3141, 35093,   670,   625,
     615, -3141, -3141, -3141, -3141, -3141, -3141,  1407, -3141, -3141,
   -3141, -3141,  2673, -3141, -3141,   -17,  1464,   575, -3141,  1156,
   -3141, -3141, -3141,  2713,  -130,  2470,  2470,  2715,  2609,   -45,
    2377, -3141,   615,   817,   257, -3141,  2904, -3141, -3141, 12833,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, 12833,  2717,  2718,   137, -3141, 22369, -3141,
   -3141,   825,   104, -3141, -3141, -3141, -3141, -3141, -3141, 34543,
    1932, -3141, 22369, -3141, -3141,   279, -3141,  1932, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141,  2383, -3141,   757, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, 20719, -3141,  1143, -3141,
   -3141, -3141, -3141, 42243, -3141, -3141, 20719, -3141, -3141,  4802,
   42243, 42243,  2942, -3141, 42243, -3141,   712, -3141, -3141, -3141,
   -3141,  2617, 42243, -3141, -3141, -3141, -3141,  2455,  2947, -3141,
   20719, -3141,  2393,  1185, -3141, -3141, -3141,  2951,  5036, -3141,
    2398,  2034,  2720, -3141, -3141, 12833,  1939,  1946, -3141,  1856,
    1988,  2402,  2402, -3141, -3141,  2404,  2402,  2743, -3141,  2753,
    2411,  2417,  2418,  2005,  2420,  2422,  1337, -3141, -3141,  4812,
    4812,  2431,  2427,  2024,  2072,  2438,  2441,  2084,  1343,  2120,
    2443,  2448,  2124,  2131,  1347,  2139,  2143,  2172,  2174,  2449,
    2507,  2435,  1441,  1457,  2452,  2180,  2184,   829,  2200,  2453,
     929,  2943, -3141, -3141, -3141,  2219,  2232,  2245,  2259,  2321,
    2350,  2352,  2370,  2385,  1478,  2409,  2428,  2457, 12833,  2440,
    1314,   954,  1511, -3141,  2445,  1522,  1530,  2472, 12833,  2496,
   12833,  2514, 12833,  2531,  2537,  2459,  2553,  2560, 12833,  1692,
    1856, -3141, -3141, -3141, -3141, -3141, -3141, -3141,  2430,  1856,
    2458, -3141, -3141, -3141,   412, -3141,   965,  2462, -3141, 15718,
   -3141, 12833,  2468, -3141,  2463, -3141, -3141, -3141, -3141, -3141,
     -37,   -37,   -37, 15141,  1856,  2912, -3141,     0, -3141,  2801,
   -3141, -3141,  1067,  2475, -3141,   615, 15141,  2207,  2629, -3141,
   -3141,   911, 21819, 25687, -3141, 35093,  1241,  1241,  1241,  1407,
    2866,  2241,  2241, -3141, 24025, -3141, -3141,  2624, -3141, -3141,
   26791, -3141,  1086, -3141, -3141, 15718,  1436, -3141,  1856, -3141,
   36193, -3141,  1856,   615,  2490,  2492, -3141, -3141, 41693, 12833,
   -3141,  2921, -3141, -3141,  2498,  -130,  2722,  -130, -3141,  2837,
    2843,  -130, -3141, -3141, -3141, 21819,  2034, 15141,   137,   137,
     137, -3141,  1067,  1856,  2510,   757,  1856, 22369, -3141, -3141,
     825,  2523,  2981,  2984, 22369,  2878, -3141, -3141, -3141, -3141,
    4802, 21819, -3141, -3141, -3141,  2528, -3141, 16845, -3141, -3141,
   -3141,  2402,  2402,  2402, -3141, -3141, -3141, -3141, -3141,  2404,
    2734, -3141,  2404,  2404, -3141, -3141, -3141, -3141, -3141,   225,
     275, -3141, -3141,   225, -3141, -3141, -3141,    80,   425,  2404,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141,  2402,  2402, -3141,
   -3141, -3141,   225,  2402, -3141,  2402,  2945, -3141,   186,    56,
    2402,  2402,  2402,  2541,  2526, -3141,  1199, -3141, -3141,  2607,
     743, -3141,  2536,  2542, -3141, -3141,  1932, -3141,  2545, -3141,
    4520, -3141,   612, -3141, 42243, -3141,   527, -3141,  4812, -3141,
   -3141, -3141,   258, -3141, -3141,   225,   861, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, 12833,
    2546,  2549,  2550, -3141, -3141, -3141, -3141, -3141, -3141, 12833,
   -3141, -3141, -3141, -3141, -3141, 12833, -3141, -3141, -3141, -3141,
   -3141,  2693, -3141,  2790, 12833, 12833, -3141, -3141, -3141, -3141,
   12833, -3141, -3141, -3141, 12833,  3090,  2751,  2561, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, 12833, -3141, -3141,
   -3141,  4812, -3141, 12833, -3141, -3141, 12833, 12833, -3141, 12833,
   12833, -3141,  2577, -3141,  2585, -3141,  2589, -3141, -3141,  2799,
   -3141, -3141,  1856, 12833, -3141,  2565, 42243, -3141, -3141,  2573,
   -3141, -3141, -3141, -3141,  1856, -3141, -3141,   273,  2593,  2593,
    2593,  1436,  1856,  1246, -3141, -3141,  2917, -3141,  1833, 21819,
   15141,  2576,  2578, -3141,     8, -3141, -3141,  2563,  1241, -3141,
    3110,  2944, -3141, -3141, 37293,  2582, -3141, -3141,  2848, -3141,
     105,  2771, -3141, -3141, -3141,   670,  2675,  2679,   615,  1856,
    1932,  2802,  2033,  2926,  3100,  2640,  -130,  -130,  3253,  2645,
   12833, 12833,  2606, -3141,  2507, -3141,  3010, -3141, -3141, -3141,
    1833, 12833, -3141,  2611,  2616, 42243, -3141,  3364,   242, -3141,
    2945, -3141, -3141, -3141,   -84, -3141, -3141, -3141,   420, -3141,
    2618,   420,   420,  3153,   284, -3141,  3153, 36743, -3141,  1213,
   -3141,  2654,   225, -3141, -3141,  2659, -3141, -3141, -3141,   420,
    2619,   225, -3141, -3141, -3141,   420, -3141, 37293,  1932,  3393,
   -3141,  2663, -3141,  3083,  2966, -3141,  2945, -3141,  2970,  2872,
   -3141,   225, -3141, -3141,  3153, -3141,   225,  3153,   420,  2879,
   -3141,   420, 42243, -3141, 42243,  2662,   653,  1932, -3141, -3141,
   -3141,  2642,  2644, -3141, -3141, 20719, -3141, 42243,  4802, -3141,
    2662, -3141,     8,    89,  2629, -3141,  1304,   757,  2648, -3141,
    2649,  2650,  2657,  2665,  2666, -3141,  1329,  2603, -3141, -3141,
   -3141,   982,  2612,   150,  2668,  2647,  2625,  1548,  2653,  2727,
    2915,  3091, -3141,  2740,  2670,  2746,  2750,  2798,  2820,  2842,
   -3141, -3141, -3141,  2674,  1856, -3141, -3141, -3141,  2680, 37843,
   -3141,  2748,  2766, -3141, -3141,  2772, -3141, -3141,    95,  1677,
   -3141, -3141, -3141, -3141, 15141,  3024, -3141,   699, -3141, -3141,
   -3141, -3141, 12833, -3141,  2507,  3197, -3141, 24025, -3141, -3141,
   -3141, -3141, -3141,  2692,  2696,  7640,  3249, -3141,  -130, -3141,
    2742, -3141, -3141, -3141,  2744,  1856,  1856, 42243,  2720,  3040,
   -3141,   699,   757, 42243, 42243,  1376,   642,   642,   642,   235,
     235, -3141, -3141, -3141, -3141,   665,    28, 42243, -3141, -3141,
     857, -3141, -3141, -3141, -3141, -3141,   420, -3141,   150, -3141,
   -3141, -3141, -3141, -3141, 36743, -3141, -3141,  3153, -3141, -3141,
   -3141,   150, -3141, -3141, -3141, -3141,  1239, -3141, -3141,  2949,
    2755, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
    2704, -3141, -3141, -3141,   299, -3141, -3141, -3141, -3141, -3141,
   -3141,  1121, 42243,  3109,  2871, -3141, -3141, -3141, -3141, -3141,
    2712,  1108, -3141, 42243, -3141,  2950, -3141, -3141, -3141, -3141,
   -3141,  2954, -3141, -3141, 12833, -3141, -3141, -3141,  2521, -3141,
   12833, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,   102,
    2938,  1107,  1107,  1107,  1107,  1677, -3141, -3141,  2773,  2811,
   -3141,   146, -3141,  -180,   757, 12833,  1407,   788,  3043, -3141,
   -3141, -3141, -3141,  3026,  3602, 12833,  2731, 12833,  2732,  1384,
   -3141, -3141, -3141,  2733, -3141, -3141,  1417,  1451,   825, -3141,
   -3141,   242, -3141, -3141, -3141,   421,   421,  1462, -3141, -3141,
   -3141,  1473, -3141, -3141, -3141,  1495, -3141,  1239, -3141,  3250,
    2958,  3255, -3141,   -92, -3141, -3141,  4802, -3141, -3141, -3141,
   -3141,   757,  2747,  2749,   995,  2754,  2847,  2757, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, 21819, 20719, -3141,   121, 12833,
   -3141, -3141,  1856,  2941,  3271,  3282,  3195,  3290,   788, -3141,
     807, -3141,  3193, -3141,  1856, 42243,  1856, 42243, -3141, 42243,
   40593,  2948,   825, -3141, -3141, -3141,  3334, -3141,   167, -3141,
   -3141,   857, 42243,   225,   150,   225, -3141,  2994, -3141,  2996,
   -3141,  2779,  3677, -3141,  3212,  4802,     8, -3141, -3141, -3141,
   -3141, 12833, -3141, -3141, -3141,  2783, -3141,   615, -3141, -3141,
   -3141,   757, 42243, -3141,   150,   150,  3302,   150, -3141,  3309,
    3320,   807, -3141,    83, 12833,  1499,  1506, -3141,  2792,  2795,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141,     8, -3141, -3141, -3141,  3257, 31783,  2956, -3141,
   -3141,  2851, 21819, 15141,  1603, -3141, -3141, -3141, -3141,   150,
   -3141,   150,   150, -3141,  3358,   193, -3141, -3141, -3141, -3141,
   -3141, 42243,    90, -3141, 43343, 43343, 42243, -3141,  2839, -3141,
    4760,   -10, -3141, -3141, -3141, -3141, -3141, -3141,  3361, -3141,
    2804, -3141, -3141, -3141, -3141, -3141, -3141, 34543, -3141,  2828,
   -3141, -3141, -3141,  3123, -3141, -3141, -3141,  3231, 42243, -3141,
   -3141, -3141, -3141, 12833, 12833,  2863, -3141, 31783, 31783, -3141,
   -3141, -3141, -3141,  3381, 31783,  3677, -3141,  3197,  2836,  3268,
   -3141,  3188,  3274, 12833,  1856,  1856, -3141,   752, -3141, 29008,
    2841, 32338, 12833, -3141,   -10,  3361, -3141, 31783,  3043, 12833,
    2844,  2854, -3141,  1107, -3141,  3206,  2480,  2877, 12833, 31783,
   -3141,  3289,  3162,  2853, -3141,  2856,  1764,  3324, 43343, 43343,
   -3141,  3222,  1856, -3141, -3141, -3141, 42243, -3141, -3141, -3141,
     885, -3141,  1856, 29563,  2880, -3141, -3141, 12833, -3141, 38393,
   30118,  2860, -3141, -3141, -3141,  3102,  2869, -3141,  2870, -3141,
   31783, 12833, -3141,  3306,  2888, -3141,  1698, 31783, -3141, -3141,
    3251,  2876,  1317, -3141,  2873, -3141,  3208, 17947,  3029, 42243,
   27343,  1856,  2905, 31783,  3065, 30673,  3301, 42243,  4802,  3315,
    3316, -3141, -3141, -3141, 37293,  1510, -3141, -3141, 21819, -3141,
   -3141,    99,  2918, -3141, 27898, -3141,  2957, -3141, -3141,  3384,
    2129, -3141, -3141, -3141, 20160,  2783, -3141, 31783, -3141, 31783,
   -3141, 32893, 12833, -3141,  2965, -3141, -3141, -3141,  4760, -3141,
   -3141, 31228, 28453, -3141, -3141, 24578, -3141, -3141, -3141,  3330,
   -3141,  1856, -3141,  1426, -3141, 32893, -3141, -3141, -3141, -3141
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3141, -3141, -3141, -3141, -3141, -2586, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141,  1662, -3141, -3141, -3141, -3141, -3141,
    1908, -1437, -3141, -3141, -3141, -3141, -3141,   349,    71,  2823,
      -5, -3140, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141,   455,   454, -3141, -3141,   287, -3141, -3141,  -163, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141,  -190,  -153, -3141,
   -3141, -3141, -3141,   246, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141,  -154, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141,   -77, -3141, -3141,   -33, -3141, -3141,
     -75, -3141, -3141,   -63, -3141, -3141, -3141, -3141,   -38, -3141,
     -36, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,   466,
   -3141, -3141, -1847, -3141, -3141, -3141, -3141,  2382,  -979, -3141,
    3138, -3141,  -379,   744,  1969, -1917, -1046,  -624,  -619, -1646,
   -3141, -3141, -3141,   377,  1087,  1476,   827,  1970,  2010,  1523,
    1569, -3141, -3141,   843, -3141, -2659, -3141, -3141, -3141,   808,
   -3141,   810, -3141, -3141, -3141, -1011,   778, -1078, -3141,   369,
     354,  1631, -3141,   576, -3141,   532, -3141,  -445, -2053, -1944,
   -3141, -3141, -3141,   542,   859,   902, -3141, -2643, -1810, -3141,
   -3141,   172, -3141, -3141, -3141,   165, -3141,   388,   243, -3141,
   -3141, -1496, -1710, -3141, -3141, -2338,  2406, -2051,   330, -1899,
   -3141,   373, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141,  1551, -3141, -3141, -3141,   487,  -235, -1359, -2803, -3141,
   -3141, -3141, -3141, -3141, -3141,  1079, -3141, -3141,  2075,  2508,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141,  1696, -3141, -3141, -3141, -3141, -3141, -3141,  2433, -3141,
   -3141, -3141,  1363, -3141, -3141, -3141, -3141,  2150, -3141, -3141,
    2885, -3141, -3141, -3141, -3141,  1306,  1720, -3141, -3141, -3141,
    2908,  1693,  -469, -1760, -3141,  3131, -3141, -3141, -3141, -1316,
   -1946, -3141,  2986,   300, -2289,  2162,  -505,   690, -3141,   488,
    -766,  3459, -3141, -1308, -1159, -3141, -3141,  -501, -3141, -3141,
   -3141, -1275,  -735, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
     693, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -1137, -3141,  1504, -3141, -1102, -3141, -3141, -3141,  2356,
   -3141, -3141, -3141, -3141, -3141, -1903, -1455,   926, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -1891, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -1381, -3141, -1633, -3141, -3141,
   -1018, -3141, -3141,   205, -1905, -1196,  2319,   797, -3141, -3141,
    -955,  2412, -1582, -3141, -3141, -3141,  1354, -3141, -3141, -3141,
   -3141, -3141,   898, -2023, -1063, -3141, -3141, -2619,  -628, -1832,
    -614, -3141, -1860,   452, -1167, -1887, -3141, -3141, -3141, -3141,
      17, -3141, -3141, -3141,   475,  1717, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141,  -208,  -362,  1750, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141,  2656,  2634,  1758, -3141, -3141,
   -1965, -3141, -3141,  1737, -3141,   704, -1886,  2215,   992, -3141,
   -3141,   998, -2625, -3141, -3141, -3141, -3141, -3141, -3141,   940,
     -32,   155,  3182, -3141, -3141, -3141, -3141, -3141, -3141,  2896,
    2465, -1445,  3127, -3141, -3141, -3141, -3141, -3141,  2151, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141,  3199, -3141,  -988, -3141,
    -434, -3141, -3141,  -610, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141,  2247, -3141,  1209, -3141, -3141, -3141,  2661,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141,  1027,   107, -3141,
     268,    85, -3141,   211, -3141, -3141, -3141,   -19, -3141,  -764,
    -674, -1004,   637, -2119, -1066,  1026,  2664, -2833, -1152, -1294,
   -1307, -1867,    21, -3141,    -7,  -530,  -905,  -535,  1819, -1873,
    -412,  -510, -3141,  1859, -3141, -3141, -3141, -3141,  2212, -3141,
   -3141, -3141, -3141,  1339, -3141, -3141, -3141,   997, -3141,   721,
     526, -3141, -3141,  2651, -3141,  2253, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
    2686,  3245,  3088, -3141,  2735, -3141, -3141, -3141, -3141, -3141,
     404, -3141,   327, -3141,  -200,  2538,   464, -3141,  1425,  -500,
    -769, -3141,   401, -3141, -3141,  1141,  3261,  3096, -3141, -3141,
   -3141, -3141, -3141, -2246,  -597, -3141, -2324, -3141, -3141, -3141,
   -3141,  1466, -1172,  2388,  1113, -3141, -3141, -3141,  3203,  3305,
    3307, -3141, -3141,  -126, -3141,  3227,  -280, -3141,  1645, -3141,
     922, -3141, -3141,   652,  3216, -3141, -3141,  3219, -3141, -3141,
   -3141, -3141, -3141,  3223, -3141, -3141, -3141, -3141, -3141,  1206,
   -3141, -3141, -3141, -3141, -3141, -3141
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2014
static const yytype_int16 yytable[] =
{
     387,   683,   719,   730,   738,   654,  1391,  1778,  1006,  1204,
    1205,  1207,   387,   568,  1098,   387,  1033,  1213,  1028,   925,
    1777,  1649,   387,  1431,  1189,  1060,  2238,  1486,  1683,  2384,
    1527,  1799,   387,  2684,  2330,  2335,  2338,  2282,  1807,  1033,
    2346,  1841,   387,   422,  1061,  2511,  1989,  2080,  2359,  2300,
    1681,   984,  2514,  1650,  1651,  1652,  2369,  2492,  2373,  2005,
    2644,  2990,  1576,  2711,  1673, -1854,  1664,  2368,  1103, -1855,
    1501,  1947,  2975,  1104,  2350,  2351,  1271,   987,   386,  2319,
     387,  1504,  1505,  1821,  1823, -1505,  2982,  1397,  3043,  2401,
     106, -1506,  -252,  1655,  1656,   668,  1658, -1113, -1918,  -536,
     387,   387,  1295,   387,  1720,  2403,  1297,  3013,   478,  1301,
    3014,  3288,   963,   501,   387,  2390,  1310,  1311,  1312,  1742,
    1722,  2390,  1530,  1726,  2402,  2422,  2423,  2405,  -262,  3023,
    -263,  1692,  1331,  1332,   746,  3042,  3015,  2021,  2414,  2415,
    1910,  1963,   495,  3335,  1331,  1332,  1712,  2424,  3172,  1435,
    1067,  1753,  1754,   622,   623,  1886,  1759,  1321,  1322,  1323,
    2489,  3121,   106,  1446,  1732,  1733,  1734,  1148,   727,  1365,
     702,  1056,  3085,   107,  3149,  1741,  1776,  2082,  1780,   483,
     955,   484,  2348,   573,   672,  3183,  1109,   963,  1809,  2084,
    2044,  1812,  1813,  1814,  1815,   958,  1817,  1818,  1819,  1820,
    1822,  1824,  1825,  1826,  1827,  3185,  3003,  1100,  1331,  1332,
    3439,   582,  1034,   561,  2484,  1331,  1332,  1030,  3004,  1331,
    1332,  1064,  1166,  1167,  1168,   963,  2482,   712,  1635,   740,
     993,  1875,  3005,  2712,  3686,  1018,  1100,  1145,  1100,   964,
   -1505,   622,   623,  1331,  1332,  3003,  2393,  1042,  1304,  2045,
    2453,  1331,  1332,   590,  2393,  1331,  1332,  3004,   108,  3547,
    3186, -1976,  1934,   486,  2022,  3536,  1622,  1331,  1332,  1149,
    1086,  3005,  1150,  2391,  2392,  2312,   512,   971,  3463,  1956,
     622,   623,  3474,   700,  1031,  1151,  1023,  1331,  1332,  2468,
     428,   710,   711,   109,  2651,  3003,  1331,  1332,   674,  2693,
    1513,  1331,  1332,  2484,  3202,  3139,  1071,  3004,  1391,  3304,
    1331,  1332,  1331,  1332,   964, -1854,  1331,  1332,  2315, -1855,
    1695,  3005,   927,  1696,  2367,   565,  1331,  1332,  1397,  2096,
     622,  3009,  3121,  2070,  2639, -1505,  3122,   969,   469,   622,
     623, -1506,   783,  2928,  1331,  1332,   391,  2632,  2393,  3349,
    2046,  1876,   964,   673,  1119,  1331,  1332,  3350,  2394,   114,
   -1976,  2354,  2416,  1331,  1332,  3081,  -341,   394,  3378,  3208,
    2917,  1024,  2984,  1331,  1332,  1120,   569,   972,  3212,  1072,
    2445,  1887, -1113,  1526,  2147,   745,   442,  1331,  1332,  1331,
    1332,   998,  1391,   121,  3548,  3379,  1391,  2469,  3225,  1331,
    1332,   796,  1364,  3227,   387,  2485,  2454,  1523,  2316,  3246,
     591,   429,  1152,  2980,   387,  3474,   982,  1305,   387,  1921,
    3537,  2047,  1623,   387,  2041,  1488,  2698,  2204,   387,  2051,
    2702,  2364,  1057,  1494, -1505,  2057,  1080,   115,  2060, -1113,
   -1506,  1331,  1332,  1514,  2365,   435,  1087,  1515,  1119,  1398,
     387,   578,  2313,   110,  2679,   455,  1331,  1332,  3254,  1922,
    1068,  1506,  1507,  1146,  1172,  2715,   583,   570,   387,  1120,
    3405,  2699,   973,  2688,   563,  1703,  1388,  1103,   387,  1528,
    1333,   470,  1104,  1334,   387,  2694,  2697,   574,  1472,  3187,
     387,  1112,   387,   387,  2485,  1153,  1935,   387,   387,  2710,
    2493,   497,   823,  2089,  3464,   506,   695,  3122,   387,  3297,
     713,  1877,   387,  2717,  1943,  2221,   703,   387,   387,  2652,
     387,   387,   387,   387,  1004,  3082,  1489,  1888,  3404,  1019,
    1576,  2390,   728,   571,  1989,  1886,  1103,  3549,  1165,  3440,
    2713,  1104,   562,  1772,  1333,  2390,  3441,  1334,  1331,  1332,
    2248,  1333,  3336,  3325,  1334,  1333,   387,  3351,  1334, -1113,
    2395,  1331,  1332,  1114,  -574,   956,  1025,  1069,  -341,  2358,
    1434,  2803,   387,   844,  1114,  1513,  3125,  1989,  2349,  1333,
     387,   387,  1334,  1586,  2165,   387,  1070,  1333,  2169,  1778,
    1334,  1333,   387,  2048,  1334,   603,  3083,  2320,   923,   924,
     978,  2578,  2304,  1333,  3123,   448,  1334,   993, -1854,   990,
    3141,  2366, -1855,  1114,  1811,  1035,  3150,  2023,  3016,   697,
    1436,  2207,   387,  1333,  2491,  2259,  1334,  2260, -1505,  2812,
     993,  1530,  1333,  1503, -1506,  1334,  2084,  1333,  2254,   674,
    1334, -1854,   959, -1918,  1475, -1855,  1333,  1624,  1333,  1334,
    1043,  1334,  1333,  1778,  1834,  1334,  1114,  2257,  3687,   729,
    1532, -1505,  1333,  1630,   472,  1334,  2372, -1506,  -252,  2083,
    1335,  2263,  2264, -1113, -1918,  -536,  2935,  1026,  1923,   430,
    1333,   387,  1335,  1334,  2456,  3381,  2709,  2240,  1114,   387,
    1398,  1333,   387,  2062,  1334,   387,   387,  3423,  2470,  1333,
   -2013,  3006,  1334,  1306,  -262,  2396,  -263,  2241,  1778,  1333,
    1331,  1332,  1334,  -341,  1697,  1331,  1332,  1698,  1514, -1113,
    1400,  2427,  1515,  1333,   495,  1333,  1334,  3040,  1334,  2249,
    2649,  2650,  2689,  2690,  1027,  1333,  3124, -1113,  1334,   387,
    3006,   387,  3427,  1331,  1332,   877,  1335,  3125,  3248,  2930,
     505,  1612,  1587,  1335,  1331,  1332,  3406,  1335,  2105,  2812,
    1969,  1887,  1331,  1332,   529,  1389,  3479,  1173,  3084,  1178,
    3467,  3534,  3469,  1433,  1788,  1789,  2722,  1333,  2087,  2088,
    1334,  1335, -1113,  1442,  2964,   587,  2700,  2955,  2968,  1335,
    3006,  2300,  1333,  1335,  1481,  1334,  2965,  2377,  1391,  3203,
    2969,  1331,  1332,  2106,  -508,  1335,  1331,  1332,  2983,   456,
    2119,  2120,  3010,  2774,  2121,  2122,  2242,  2939,  1331,  1332,
    2473,  2063,  3485,  1931,  3126,  1335,  2404,  2205,  2406,  1414,
    1331,  1332,  3407,  2411,  1335,  1331,  1332,  2519,  2520,  1335,
    2390,  1804,  3332,  1347,  1331,  1332,  2125,  2126,  1335,  2429,
    1335,  2431,  2432,  2436,  1335,  2132,  2133,  3408,  3526, -1379,
    2137,  2138,  1583,  3192,  1335,  1482,  1448,  1391,  3182,  2140,
    2141,  1940,  2085,  2723,  1907,  2142,  2143,  1331,  1332,  1331,
    1332,  1937,  1335,  2243,  1333,  1033,  1840,  1334,  1113,   847,
     387,  1942,   387,  1335,  1945,  1946,  2250,  1333,   473,  1968,
    1334,  1335,    40,  2154,  2155,  1952,  1881,  1888,  1969,  2805,
    3182,  1335,  2251,  1033,  2222,   387,  1900,  1794,  1828,  2683,
     475,   387,  2158,  2159,  3546,  1335,  3384,  1335,  1882,  1883,
    1486,  1486,  2171,  2172,  3175,  2337,  3385,  1335,  2098,  2474,
    1926,  1829,  3193,  1395,  1331,  1332,  3079,  2103,  2175,  2176,
    2605,  3168,  1031,  1388,  3207,  3075,  2355,  1907,   387,  2104,
     387,   480,   387,  3017,  3058,  1114,  3018,   839,  3081,  1331,
    1332,   485,  3059,   674,   387,   387,  1833,  3194,  1584,  1335,
    1331,  1332,  2099,  1576,   387,   387,  1103,  1778,   497,  1842,
    3403,  1104,  1331,  1332,  1335,   387,  1324,  1331,  1332,  3679,
    2635,  2512, -1379,  1974,  2551,  3360,  2517,  2374,  1908,   689,
    1331,  1332,  2552,  2674,  1462,  2177,  2178,   387,   387,   387,
     387,  2525,  1924,   594,  1415,  3333,  1932,   387,  2530,   387,
    1350,  2675,   486,  1331,  1332,   387,  1953,  1483,  2255,  2418,
    1331,  1332,  1892,  2539,  2540,    51,  1333,  1478,  1479,  1334,
    2544,  1333,  1970,  1954,  1334,   453,  2718,   387,  2549,  2224,
    2244,  1449,  2042,  2043,  3461,  2050,  1955,  2052,  2053,  2054,
    2055,  2056,  3155,  2058,  2059,  3161,  3162,  1331,  1332,  1333,
    2600,  1463,  1334,  3236,  1830,  1502,  1335,  1331,  1332,  2607,
    1333,  1004,  2387,  1334,  2262,  1476,  1477,  2567,  1333,  1335,
    3060,  1334,  3480,  2475,   387,  1487,  2588,   387,  2107,  3334,
     454,  1062,  3714,  1493,  2974,  1331,  1332,   595,  2419,  1331,
    1332,  3306,  3326,  3327,  1331,  1332,   516,   498,  3082,  2494,
     728,   869,  1585,   513,  1526,  1416,  2269,  1333,  3386,  1680,
    1334,  1956,  1333,  1452,  2270,  1334,  3185,  1347,  3499, -1973,
    1058,  3343,  1331,  1332,  1333,  1211,   387,  1334,   387,  2676,
     387,   387,   387,   387,   387,  1063,  1333,  2615,  1464,  1334,
     501,  1333,  1416,   387,  1334,   387,  1639,  1331,  1332,   443,
    1333,   596,   517,  1334,  2476,  3074,  1331,  1332,  2438,  2439,
    1059,  1620,   117,  3201,   118,   690,  3206,  1331,  1332,  3086,
    1970,  3186,  2976,  2976,  2976,  1331,  1332,  1639,  2388,   387,
    2420,  2521,   503,  1333,  1643,  1333,  1334,   697,  1334,  2526,
     691,  2273,  2274,  1331,  1332,   515,  3237,  3250,  2440,  1331,
    1332,  1989,  1639,  1957,  3226,   714,   436,  3228,  1616,  1617,
    1331,  1332,  1389,  2066,  1952,  1074,  1331,  1332,  1335,   387,
    2441,  1831,  1148,  1335,  1639,  3314,  1453,   729,  1465,  1331,
    1332,   492,  2067,  1331,  1332,  1331,  1332,  1639,  1643,  2185,
    2186,  3449,  2428,  1644,  2188,  2189,  3387,  1331,  1332,  2235,
    1333,  1335,  2442,  1334,  1360,  1361,  1362,  1363,  1958,  1640,
    1331,  1332,  1335,  2236,   518,  3450,  2269,  3566, -2013,   715,
    1335,  2913,  2197,  2198,  2660,  1333,  1892,   387,  1334,  1075,
    1645,  3589,  1893,  2210,  2211,   523,  1333,  -134,  2239,  1334,
    1663,  2086,   387,  2831,  2832,  1331,  1332,  1644,  1333,  1331,
    1332,  1334,  1174,  1333,  1350,  1778,  1334,  1331,  1332,  1335,
     399,  1892,  3058,   451,  1335,  1721,  1333,   452,  2304,  1334,
    3059,   560,  1331,  1332,  1149,  1175,  1335,  1150,  1331,  1332,
    2229,  2230,  1331,  1332,  1645,  2231,  2232,  1725,  1335,  1333,
    1151,  3084,  1334,  1335,  1646,  1953,  1333,  2601,  2602,  1334,
    1758,   387,  1335,   419,  2323,   577,   387,   387,  1778,   387,
    2112,   432,  1954,  3659,   387,  2113,   438,  3344,   581,   947,
     387,  2372,   387,  2859,  2860,  2686,   665,   387,   387,  3660,
     387,  1894,  1895,  1333,  1778,  1335,  1334,  1335,  1411,  1331,
    1332,  1412,   387,  1333,  1413,   387,  1334,  2427,  1646,   684,
    3609,   387,   387,   387,   387,  1852,  1852,  2116,  1852,  2123,
     591,   387,   387,   387,  3589,  1647,  1894,  1895,   685,  1896,
    1874,  1333,   563,   978,  1334,  1333,  1331,  1332,  1334,   387,
    1333,   990,  1885,  1334,   696,   948,  2407,  2408,   387,  1852,
    1852,  1852,  1331,  1332,  3383,   697,  2950,  2852,  3060,   117,
    1956,   118,  1335,   706,  2638,   387,  2883,  2430,  1333,  2951,
    3455,  1334,  3456,  1331,  1332,   726,   387,  1152,   106,  1647,
    2909,   717,   718,  2863,  2864,   919,   949,  1335,   387,  2336,
    2443,  2340,  2345,  1333,   387,   929,  1334,   922,  1335,  2952,
    2604,   950,  1333,   944,  1944,  1334,  1331,  1332,  2885,  2886,
    1335,   663,   664,  1333,   667,  1335,  1334,  1331,  1332,  2910,
    2911,  1333,  1962,  1533,  1334,  1331,  1332,   946,  1335,   622,
     623,  3483,  2124,  2409,   951,  1534,  3263,  3264,  1531,  1333,
    2383,  2336,  1334,  1331,  1332,  1333,  3494,   953,  1334,  3430,
    3431,  1335,  1957,   387,  1331,  1332,  1333,   961,  1335,  1334,
    1153,   387,  1333,  3556,   962,  1334,  1358,  1359,  1360,  1361,
    1362,  1363,  3420,  2128,   109,  1333,  1030,   976,  1334,  1333,
    2130,  1333,  1334,   977,  1334,   985,  1331,  1332,   387,   996,
    1331,  1332,  3080,  1333,  1030,  1335,  1334,  1648,  1347,   997,
     387,  1000,  1778,   387,  1004,  1335,  1333,  1958,  1001,  1334,
    -545,  3540,  3541,  1542,  1007,  2635,  1015,  2131,  1331,  1332,
    1543,  1331,  1332,   839,  1331,  1332,  1016,  2135,  2078,  1017,
    1544,  1545,  1021,  1335,  1331,  1332,  1022,  1335,   622,   623,
    1031,  1333,  1335,  1036,  1334,  1333,  1331,  1332,  1334,   678,
     679,  1648,   680,  1333,   681,  2136,  1334,  2463,  2464,  2145,
    1546,  2978,  2979,  2097,  1547,  3104,  2336,  1037,  1333,   839,
    1335,  1334,  1038,  2336,  1333,  1548,  1039,  1334,  1333,  1331,
    1332,  1334,  2641,  2642,  1549,  1331,  1332,  1331,  1332,  1006,
    1550,  1040,  2149,  1331,  1332,  1335,  1535,  2726,  2727,  2680,
    1041,  2191,  1065,  1551,  1335,  3623,  3623,  1066,  2998,  1082,
     461,  3001,  3002,  1033,  1079,  1335,  1084,  2150,  1100,  1129,
    1130,  1552,  1855,  1335,  1856,  2682,  2152,   839,  3019,  1081,
    1553,  1554,  1089,  1331,  1332,  1333,  1555,  2153,  1334,  2800,
    2727,  1335,  1094,  2611,  1556,  2157,  1100,  1335,  1331,  1332,
    1557,  1111,   462,  3053,  3054,  1902,  1903,  1904,  1335,  1331,
    1332,  2631,  1157,  2160,  1335,  1110,  1536,  1158,   387,  2161,
    1159,  2658,  1333,  1331,  1332,  1334,  1558,  1335,  1981,  1163,
    2173,  1335,  1486,  1335,  1164,  1350,  2187,   869,  1333,  3118,
    1537,  1334,  1161,  1331,  1332,  1335,  1165,  1331,  1332,  2194,
    3133,  3134,  1169,  2195,  1170,  2196,   388,  2673,  1335,  1333,
    1182,  1211,  1334,  2598,  1180,  1331,  1332,  2199,   418,  3654,
    1171,   424,  1559,   463,  1560,  1331,  1332,  1184,   433,  1185,
    2203,  1561,  1186,   869,  1187,  1331,  1332,  1188,   444,  2580,
    1140,  1141,  1333,  1335,  1538,  1334,  1190,  1335,   460,  3290,
    1191,  1331,  1332,  1333,  1192,  1335,  1334,  1211,  3252,  3253,
    2716,  1333,  1331,  1332,  1334,  2206,  1193,  2719,  2884,   387,
    1335,  1212,  3618,  1331,  1332,  1390,  1335,  2223,  1194,  1333,
    1335,  2003,  1334,  3259,  3261,  1195,   479,   387,   387,  1196,
    1333,   869,  2829,  1334,   387,   674,   387,   387,  2839,  1562,
    1331,  1332,  2845,  3199,  3200,  1197,   482,   388,  1198,   388,
    1189,  1352,  1353,  1199,  1563,  1211,  1539,  1296,  1200,  1564,
     479,  3210,  1333,  1331,  1332,  1334,  1333,  3213,  1119,  1334,
    3328,  3253,  1201,   387,  1331,  1332,  1393,  1335,  3398,  3399,
    1202,  1331,  1332,  1800,  1203,   387,   387,  3291,  3292,  1120,
    3229,  3293,  3294,  3231,  1333,   387,  1206,  1334,  2101,  1565,
    1333,   387,  1208,  1334,   387,  1566,  1209,   387,  1567,  1210,
    1333,  3401,  3253,  1334,  1335,  1300,  1214,  2336,   387,   387,
    1215,   387,  1333,  1331,  1332,  1334,  3157,   387,   387,  1216,
    1335,  1568,  1569,  1217,  1570,  2582,  2854,   387,  1218,   387,
    1331,  1332,  1219,   387,   387,  3402,  3253,  1220,  1571,  1221,
    1991,  1335,  2855,  1994,  1222,  1333,  3411,  3412,  1334,  1331,
    1332,  1333,  2006,  1333,  1334,  2437,  1334,  3413,  3414,  1333,
    1572,  2014,  1334,  2877,  1223,  1356,  1357,  1358,  1359,  1360,
    1361,  1362,  1363,  1224,  1335,   387,   387,  1394,  1778,  3415,
    3414,  1225,   464,  3496,  3399,  1335,  1226,  2620,  2621,  2622,
    3497,  3399,  1227,  1335,  3683,  3684,  2887,  1331,  1332,  1333,
    1228,   387,  1334,  2479,   465,  1764,  1764,  2889,   387,  1331,
    1332,  1335,  1229,  2004,  1333,  2890,  1230,  1334,  2646,  2647,
    2648,   387,  1335,  3329,  3330,  1333,  2942,  2943,  1334,   466,
    1231,  2919,  2920,  3270,  3370,  3371,  3372,  3373,  1232,  1333,
    1233,  3365,  1334,  2111,  1573,  1331,  1332,   717,   718,  1331,
    1332,  1234,  1801,  1574,  1335,  1235,  1331,  1332,  1335,  1333,
    3131,  3132,  1334,  1333,  1331,  1332,  1334,   387,  1331,  1332,
     525,  1643,   527,  1236,   528,  2114,   530,   467,  1401,  2115,
    1237,  1333,  1238,  1239,  1334,  1778,  1335,  1240,  1241,  1242,
    3367,  1333,  1335,  1244,  1334,  1245,  1246,  1331,  1332,  1331,
    1332,  1333,  1335,  1247,  1334,  1331,  1332,  2134,  1248,  1331,
    1332,  1249,  -545,  2148,  1335,  1250,  -545,  1333,  1251,  1252,
    1334,  1404,  1396,  2151,  1253,  1331,  1332,  1257,  1333,  1258,
    1644,  1334,  1259,  1260,  1405,  2167,  1261,  1262,  1408,  1333,
     526,  1263,  1334,  1264,  1331,  1332,  1643,  1335,   387,  1265,
     559,  1266,  2947,  1335,   567,  1335,  1267,  1331,  1332,   479,
    1406,  1335,  2903,  1268,   586,  1270,  1333,  1645,  2383,  1334,
    1331,  1332,  1272,   387,  2168,  1426,  3069,   387,  1273,   387,
     387,   387,   387,  1274,  1331,  1332,   479,  1275,  1276,  1333,
     387,   928,  1334,  1277,   387,  1278,  3065,   387,  1279,  1280,
    1333,  1335,  1281,  1334,   686,  1644,  1282,  1333,  1283,  1284,
    1334,   387,   387,   387,   479,  1285,  1335,  1286,  1874,  1802,
     479,  1427,  2174,  1287,   387,  1288,   708,  1335,   479,   479,
     387,  1646,   387,   720,   567,  1803,  1430,  2182,  1289,  1290,
     387,  1335,  1645,  1291,   747,  1292,  1331,  1332,   752,  1333,
    1778,  1293,  1334,   920,   921,  1294,   388,   388,   567,   479,
    1298,  1335,  2183,  3667,  1299,  1335,  1333,  1302,  1303,  1334,
    1307,  1778,  1308,  1309,  1313,  1331,  1332,  1331,  1332,  1314,
    1315,  1439,  2184,  1335, -1113,  1333,  2192,  1778,  1334,  1316,
    1317,  1318,   968,  1335,  1392,  1331,  1332,  1409,  1432,   963,
    3667,   387,  1647,  1335,  2193,  1441,  1646,  1438,   479,  1440,
    1331,  1332,   387,  1447,  2200,   387,   567,   479,  1455,  1335,
    2611,   479,  1213,  1297,  1301,  1470,  3605,  1461,   479,  3266,
    1335,   565,  1474,  1333,  1331,  1332,  1334,  1490,  1495,  1496,
    3156,  1335,  1497,  1498,  1508,  1333,  1347,  2433,  1334,   387,
    2434,  2209,  1512,  1331,  1332,  2938,   387,  1500,   567,   387,
    3346,  1510,  2214,   387,   387,  1331,  1332,   387,  1335, -1113,
    1331,  1332,  1524,  1114,  1588,   387,  1589,  1647,  1590,  1591,
    1592,  1333,  1593,   387,  1334,  1333,  1594,  2729,  1334,  2225,
    1595,  1335,  1333,  1596,  1597,  1334,  1598,  1331,  1332,  1599,
    1333,  1600,  1335,  1334,  1333,  1331,  1332,  1334,  3215,  1335,
    1601,  2798,  2233,  1602,  1603,  1604,  1605,  1099,  1606,  1607,
    1611,  1331,  1332,  2809,  1613,   567,   964,  1627,   479,  1615,
    2810,  1117,   479,  1333,  3342,  1333,  1334,  3239,  1334,  1331,
    1332,  1333,  3146,  1639,  1334,  1333,  1667,  3342,  1334,  1632,
   -1113,  1335,  1388, -1113,  1306,  1687,  1331,  1332,  1701,  1718,
    1750,  1333,  1331,  1332,  1334,  1775,  1784,  1790,  1335,  3204,
    1795,  1816,  2811,  1810,  1648,   479, -1113,  1179,  1331,  1332,
    1333,  1843, -1113,  1334,  1832,  1331,  1332,  1335,  1844,  2826,
    1868,  3416,  3694,  1333,  1871, -1113,  1334,  1901,  1915,  2323,
   -1113,  1927,  1331,  1332,  1929,  2336,  1333, -1113,  2834,  1334,
    1331,  1332,  1936,  1939,  1331,  1332,  1960, -1113,  1961,  1965,
    1333,  1964,  1967,  1334,  1975,  2383,  1976,  1977,  1331,  1332,
   -1113,  1978,  1979,  1350, -1113,  1335,  1980,  1331,  1332,  1981,
    1998,  1999,  2002, -1113,  2001,   387,   387,  1335,   387,  1648,
    1331,  1332,  2007,  2009,  2010,  2015,  2835,   387,  2029,  2069,
    2083,  2079,  2090,   387,  1006,   119,  2092,  2093,  2838,  2094,
     392,   393,  2095,   387,  2100,  2102,  2109,  2110,  1331,  1332,
    2117,   387,  1333,  1335,  2118,  1334,  2127,  1335,   431,  2129,
    2139,  2163,  2144,   437,  1335,  2156,  2162,   441,   387,  2164,
    2166,  2170,  1335,  2179,  2840, -1113,  1335,  2180,  2843,  2181,
     387,  1333,  2190,  1333,  1334,  2844,  1334,   387,  2201,  2202,
    2208,  2246,  2212,  2846,   387, -1113,  1328,  2847,  1330,  2213,
     387,  1333,  -778, -1113,  1334,  1335,  2226,  1335,  2227,  2272,
    2285,  3352,  3353,  1335,  2277,  2947,  1333,  1335,  2252,  1334,
    3468,   479,  1331,  1332,  2261, -1113,  2848,   479,  2849,  1352,
    1353,  2228,  1363,  1335,  2857,  1331,  1332,  -954,  2858,  2275,
    1333,  1331,  1332,  1334,  2278,  1331,  1332,   490,  2276,  2279,
    3487,  3488,  1335,  3490,  2861,  2289,  2287,  2290,  2291,  1333,
    2295,  2307,  1334,  2308,  1419,  1335,  1422, -1113,   479,  2309,
    2310,  1333,  2336,  2868,  1334,  1908,  1333,   387,  1335,  1334,
     479,   567,  1907,  2328,  2327, -1113,  2869, -1113,  3718,  2329,
     479,   479,  1335,  1331,  1332,  3530,  2352,  3531,  3532,  2870,
     963,  1451,  2353,  1333,  2356,  2362,  1334,  2360,  2361,  1460,
    2378,  1333,  2385,  2871,  1334,  1331,  1332,  2386,  2446,  2412,
    2413,  2460, -1113,   388,   388,   479,   479,  1333,  2461,  2466,
    1334,  2465,  3424,   388,  2467,   567,  2815,  1331,  1332,  1526,
    2820,   388,  1331,  1332,  1633,  1333,  1331,  1332,  1334,  2498,
    2518,   815,  2531,  2541,  1335,  1358,  1359,  1360,  1361,  1362,
    1363,  2553,  1333,   479,  3421,  1334,  2554, -1113,  1333,  2573,
   -1113,  1334,  2585,  2591,  2594,  2872,  2603,  2595,  2596,   387,
   -1113, -1113,  2623,  1335,  1333,  1335,  2258,  1334,  2610,  2597,
   -1008,  1333,  2618,  2629,  1334,  2625,   606, -1113,  2637, -1113,
    2645,  3476,   387,  1335,  2873,  2640,  2874,  2656,  1333,  2643,
     479,  1334,  2609,   479,   396,  2657,  1333,   387,  1335,  1334,
    1333,  2662,  2670,  1334,  2875, -1113, -1113,   964,  2681,  2687,
   -1113,  2691,  2695,  2692,  1333,  2707,  2708,  1334,  2721,  2876,
    2787,  2791,  1335,  1333,  2796,  2797,  1334,  2799,  3026,  2801,
    2821,  2804,  1370,  2806, -1113,  2812,  1333,  2816,   387,  1334,
    2822,  1335,   567,  2878,   567,  2823,   388,   388,  1619,   479,
     388,  2824,  2825,  1335,  2827,   409,  2828, -1113,  1335,   752,
     387,  1634,  2879, -1113,  1333,  2833,  2501,  1334,  2270,  3027,
    2853,  2906,  2836,  3028,  2882,  2837,  1347,  2841,   397,  2888,
     387, -1113,  2842,  2850,  1044,  1335,  2856,  2862, -1113,   607,
    2502,  2880,  2908,  1335,  2899,  1674,  2912,  2916, -1113,  3527,
    3608,  1762,  1347,  2915,  2925,   387,  2891,   387,  2927,  1335,
    2929, -1113,  1045,  3579,  3476, -1113,  3029,  -513,   387,  1892,
     387,  2940,  2948,  2956, -1113,  2957,  2960,  1335,   531,  1347,
    2893,  2503,  2961,  2966,  2504,  1674,  1374,  2963,  1333,  2967,
     410,  1334,  2505,   580,  1335,  2981,  3243,  2997,  2895,   589,
    1335,  1333,  2986,  1046,  1334,  2987,  2985,  1333,  1047,  3579,
    1334,  1333,  2992,  2999,  1334,  2897,  1335,  3052,   608,   670,
    3066,  2898,   387,  1335,  3049,  2336,  3057,  3067,   411,  3071,
    3088,  3021,  3022,  3089,  3090,  3093, -1113,  2900,  3095,  3025,
    1335,  3100,  3101,  1779,  2901,  3102,  3048,  3113,  1335,  3115,
     387,  3129,  1335,  3136,  2660,  3143, -1113,  3117,   567,  1333,
    3140,  3110,  1334,  3134, -1113,  3142,  1335,  3147,  3148,  3111,
     387,  3151,  3158,  3112,  3153,  1335,   387,   387,  3154,  1375,
   -1042,  1333,  2865,  1378,  1334, -1047, -1113,  3262,  1335,  3167,
     387,  1379,  3169,  -479,  3173,  3043,  3265,  3219,  1952,  3174,
    3709,  3198,  3211,  1333,  3220,  3040,  1334,   387,  1333,  3269,
    3209,  1334,  1333,  1350,  3221,  1334,  1335,   567,  3223,  3224,
    3234,  1857,  1837,  1838,  3709,   567,  3240,  3230, -1113,  3241,
     567,  3255,  3268,  3256,  3257,  3273,   479,  3271,  1848,  1350,
    1858,  3258,  -340,  1853,  1853,   387,  1853,  3285, -1113,  3259,
    3260,  1981,  3267,  1048,  3276,  3274,   387,  1380,   479,  3282,
    1859,   479,  3682,  1982,  3283,  3286,  1350,   567,   567,   479,
     479,  3287,  3298,  3307,  1860,  3313,  3310,  1853,  1853,  1853,
    3311,   -59,  3316, -1113,  3318,   412,  3322,   717,   718,  3261,
    1335,  3357,  3030,  3347,  3358,  1919,  3359,  3369,  3362,  3031,
     398,  3348,  3363,  1335,  1930,  1382,  3376,  3375,  3390,  1335,
    2506,  3272,  3392,  1335,  3395,  3397,  3400,  3418,  3417,  1861,
    1862,  1938,  1049,  3419,  3275,  3442,  3444,  3032, -1113,  1953,
    3277,  3428,   479,  3429,  3278,  -268,   399,  3445,  3432,  1352,
    1353,  3434, -1113,  3446,  1951,  3447,  1954,  1863,  3453,  3462,
     479,  1952,  2456,  3470,  -340,  3471,  3478,  3489, -1113,  1955,
   -1113,  1335,  1983,  3472,  3491,  1352,  1353,   400,  3482,   609,
     610,   611,   612,   613,   614,  3492,  3498,   401,   387,   387,
    2464,  1050,  3279,  1335,  3533,   615, -1113, -1113,  3500,  3033,
    3522, -1113,  1352,  1353,  -210,  3571,  3553,   413,   387,  3551,
     387,  1119,   387,   387,  3280,  1335,  1864,  3438,   760,  2035,
    1335,  3558,   414,  3559,  1335,   387,  3560,  2039,  3566,  -228,
   -1173,  1383,  1120,  3583,  3584,  3585,  3281,  2507,  3603,  3607,
    3594,  3433,  3609,  1385,  1956,  3524,  3613,   760,   415,  3604,
    3614,  3615,  3616,  3619,  2064,   387,  3625,  1865, -1776,  3645,
    3646,  3635,  3647,   416,  3159,  3649,   479,  3652,  3653,  2081,
    3656,  3657,  3661,  1356,  1357,  1358,  1359,  1360,  1361,  1362,
    1363,  1051,  3034,  3662,  3176,  3668,  3673,  3650,  2508,  3675,
    3519,   783,  1953,  3677,  3655,   387,  1338,  1339,  3689,  1356,
    1357,  1358,  1359,  1360,  1361,  1362,  1363,  3680,  3681,  1954,
    3674,  2866,  1052,  3176,   387,  3692,  2509,  3519,  3519,   387,
     783,  3712,  1955,  3717,  3690,  2271,  1356,  1357,  1358,  1359,
    1360,  1361,  1362,  1363,  2061,  1340,  1957,  1107,  3555,  3242,
     387,  3245,   794,  1347,  3701,  3719,  3702,  3695,  3355,  1341,
     796,   387,  3700,  3632,  3590,  3633,  3624,  3599,  3598,  3249,
    3519,  3519,  1610,   514,  3073,  2028,  -340,  3519,  3324,  2483,
    2032,   794,  1985,  2789,  2993,  2397,  2457,  2988,  3011,   796,
    3012,  3050,  3519,  1342,  3519,  3340,  3184,   811,  3222,  3214,
    3519,  1958,  2954,  3460,  2989,  1343,  3465,  1956,  3339,  3410,
    2447,  1626,  3519,  3361,  3345,  1949,  1511,  2292,  1118,  1608,
    1884,  3519,  3519,  2628,  2288,  1096,   811,  3163,  2311,   387,
     682,  3377,  1344,  1011,  3119,  3459,  3519,  3284,  3120,  1717,
    2515,  2962,   387,  3519,  2247,  1665,  2608,  1906,  1765,  2991,
    3321,  3627,  3309,  3519,  1984,  1425,  1443,  2318,  2284,  2933,
    3519,   823,  2298,  3138,  2932,  2973,  3685,  3525,  1544,  1545,
     387,   671,   387,  3519,  1177,  1631,  3519,   753,  3519,   657,
     387,  1941,   931,  1845,  2926,  2725,  3448,   387,  1445,  1345,
     823,   387,  3493,  3601,  3578,  3699,  3218,  3519,  2936,  1957,
    -465,  -465,  1547,  1916,  1459,  2958,  3152,   387,  2678,  -465,
    3519,  3312,  3519,  1548,   387,  1879,  1450,   602,   999,   839,
    1952,  -340,  1549,  3368,  3519,  3519,  3374,  1418,  3519,  2617,
    1003,   843,   844,  1614,   604,  2593,  2905,   508,   387,   509,
    1350,  1551,  1786,   744,   698,  2305,  2478,     0,   839,  3070,
    1544,  1545,  3247,  3509,  1958,   741,  1100,  3216,   742,  1552,
     843,   844,   743,  2324,  2326,     0,     0,   932,     0,     0,
     567,     0,   567,   567,     0,  1533,     0,  1973,     0,     0,
       0,     0,  -465,  -465,  1547,     0,     0,  1534,  1557,  1992,
    1993,  -465,  1995,  1996,  1997,  1548,     0,  2000,     0,     0,
       0,     0,  2008,     0,  1549,     0,  2011,  2012,  2013,  1779,
       0,  2016,  2017,  2018,  2019,  2020,     0,  2025,  2026,  2027,
       0,   567,   567,  1551,     0,   933,     0,     0,  3473,     0,
    3576,  2035,     0,     0,     0,     0,     0,  2035,  1100,     0,
    2035,  1552,     0,  2035,     0,  3593,     0,  3593,     0,   934,
       0,  1953,     0,  3600,  2035,  2035,     0,   567,     0,     0,
       0,     1,  1560,  2035,  1779,     0,  1352,  1353,  1954,  1561,
    1557,     2,     3,   479,     0,   567,     0,     0,     0,  2035,
    2452,  1955,     0,   869,     4,  3177,     5,     0,  3178,  3593,
       0,     0,     0,     0,     0,  1347,  3644,     0,   875,     0,
       0,     0,     0,     0,   877,     6,     7,   878,     0,     0,
       0,     8,   869,     0,  3177,     9,    10,  3178,  1347,     0,
       0,   479,  2035,     0,   534,   535,  3593,   875,    11,     0,
       0,  3593,     0,   877,     0,   935,   878,  1562,     0,     0,
       0,     0,     0,   936,  1560,    12,     0,   567,  1535,     0,
    3593,  1561,  1563,     0,   567,     0,  1956,     0,     0,  3179,
    3180,     0,     0,     0,    13,     0,     0,  2522,     0,     0,
       0,   937,     0,    14,    15,    16,  3393,  3593,  3593,  2072,
       0,  3716,     0,   600,   535,     0,    17,    18,  3179,  3180,
    1356,  1357,  1358,  1359,  1360,  1361,  1362,  1363,  1348,   536,
       0,     0,     0,  1566,     0,     0,  1567,   938,     0,    19,
       0,   900,     0,  1674,     0,     0,     0,     0,  1536,  1562,
       0,  1349,     0,     0,     0,     0,    20,   537,   939,  1568,
    1569,     0,  1570,     0,  1563,     0,     0,     0,     0,   717,
     718,   538,  1537,     0,     0,   940,     0,   118,  1957,     0,
      21,     0,     0,     0,     0,     0,     0,    22,   536,     0,
      23,     0,     0,   539,   970,     0,     0,     0,  1572,     0,
       0,     0,     0,   535,     0,   540,     0,     0,     0,     0,
       0,    24,  1350,     0,     0,  1566,   537,     0,  1567,     0,
       0,     0,     0,     0,   567,     0,  1538,    25,     0,     0,
     538,   717,   718,  1958,   541,  1350,     0,     0,     0,     0,
       0,  1568,  1569,     0,  1570,    26,     0,     0,     0,  2616,
      27,     0,   539,  1848,     0,   968,   567,   567,   567,   542,
       0,     0,     0,     0,   540,   543,   479,     0,     0,     0,
     567,     0,     0,  1779,     0,     0,     0,   536,     0,     0,
    1572,     0,  1573,     0,     0,     0,     0,   567,   567,   567,
       0,  1574,     0,   541,  1351,     0,  2819,     0,  1539,     0,
    2659,     0,     0,     0,   544,   537,  2661,     0,  2663,     0,
       0,     0,     0,     0,     0,     0,   567,     0,   542,   538,
       0,     0,     0,     0,   543,  1126,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    28,     0,  1352,  1353,
       0,   539,     0,     0,     0,     0,     0,  1354,     0,     0,
    2488,     0,     0,   540,     0,     0,     0,     0,    29,     0,
       0,  1352,  1353,   544,  1573,     0,     0,    30,     0,     0,
       0,     0,     0,  1574,  2410,     0,     0,  2035,     0,     0,
       0,     0,   541,     0,     0,  2417,     0,    31,   567,    32,
      33,  2035,     0,    34,     0,     0,    35,     0,    36,     0,
       0,     0,     0,    37,     0,    38,     0,   542,     0,     0,
       0,     0,     0,   543,    39,     0,     0,   545,    40,     0,
       0,     0,     0,     0,    41,   479,     0,     0,     0,    42,
    2073,     0,  2728,    43,  1243,   479,   546,     0,     0,  2784,
    2785,     0,   547,  2788,     0,     0,     0,     0,   548,     0,
       0,  2795,   544,    44,     0,     0,     0,    45,     0,   479,
    1269,  1355,  1356,  1357,  1358,  1359,  1360,  1361,  1362,  1363,
       0,     0,   549,     0,     0,     0,   545,     0,     0,     0,
       0,     0,     0,   550,   551,     0,  1357,  1358,  1359,  1360,
    1361,  1362,  1363,    46,     0,   546,     0,     0,     0,     0,
       0,   547,     0,     0,     0,     0,     0,   548,     0,    47,
    1319,     0,    48,     0,  1326,     0,     0,    49,     0,     0,
     552,     0,  2995,  2996,     0,     0,     0,     0,     0,     0,
    2819,   549,     0,  2819,  2819,     0,     0,     0,     0,     0,
      50,     0,   550,   551,     0,     0,     0,     0,     0,     0,
    2819,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    51,     0,     0,  3024,   545,   553,     0,   554,  3041,
    3044,  3046,  3047,     0,     0,     0,     0,     0,     0,   552,
       0,     0,     0,     0,   546,     0,     0,     0,     0,     0,
     547,     0,     0,     0,     0,     0,   548,  1127,  1128,  1129,
    1130,  1131,  1132,     0,     0,  1133,  1134,  1135,  1136,  1137,
    1138,     0,  1139,     0,     0,     0,     0,     0,     0,     0,
     549,  2305,  2937,     0,   567,   553,     0,   554,     0,  1458,
       0,   550,   551,   567,     0,     0,     0,     0,  1473,  2616,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   567,
       0,     0,     0,     0,     0,     0,     0,  1919,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   552,     0,
       0,     0,     0,     0,  1779,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2035,     0,     0,     0,
       0,     0,     0,  2035,     0,     0,     0,     0,     0,     0,
    1779,     0,     0,  1544,  1545,     0,  2035,     0,     0,     0,
       0,     0,     0,     0,   553,     0,   554,     0,     0,     0,
    1140,  1141,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -465,  -465,  1547,     0,     0,
       0,     0,     0,     0,  -465,     0,     0,     0,  1548,     0,
       0,     0,     0,     0,     0,     0,     0,  1549,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1551,     0,     0,     0,
       0,     0,     0,  3078,     0,     0,     0,     0,     0,     0,
       0,  1100,     0,     0,  1552,     0,     0,     0,     0,     0,
       0,     0,     0,  1636,  1637,  1638,     0,     0,     0,     0,
       0,     0,  1653,  1654,     0,     0,  1657,     0,  1659,  1660,
    1661,  1662,     0,  1557,     0,  1666,     0,     0,  1668,  1669,
       0,  1670,     0,  1671,  1672,     0,  1675,  1676,  1677,  1678,
    1679,     0,  1682,     0,  1684,  1685,  1686,     0,  1688,  1689,
    1690,  1691,     0,  1693,  1694,     0,  1700,     0,     0,  1704,
    1705,  1706,     0,  1708,  1709,  1710,  1711,     0,  1713,  1714,
    1715,  1716,     0,     0,     0,     0,     0,  1723,  1724,     0,
    1727,  1728,  1729,  1730,  1731,  3116,     0,     0,     0,  1735,
       0,  1736,  1737,  1738,  1739,  1740,     0,  1560,  1743,  1745,
    1746,  1747,  1748,  1749,  1561,  1751,  1752,     0,  1779,  1755,
    1756,  1757,     0,  1760,     0,  1761,     0,     0,     0,  1766,
       0,  1770,  1771,   567,     0,     0,     0,  1774,     0,     0,
       0,     0,     0,     2,     3,  1781,  1782,  1783,     0,     0,
       0,     0,     0,     0,  1326,     0,     4,  1791,     0,     0,
       0,     0,     0,     0,  1796,  1797,  1798,     0,     0,     0,
       0,     0,     0,     0,  3078,     0,     0,     6,     7,     0,
       0,     0,  1562,     8,     0,     0,     0,     9,    10,     0,
       0,     0,     0,     0,     0,     0,   567,  1563,     0,     0,
      11,     0,     0,  2730,  2731,     0,     0,     0,     0,  2732,
       0,  2733,     0,  2734,  2735,     0,   567,    12,     0,  1835,
       0,     0,     0,     0,     0,     0,     0,     0,  2736,     0,
       0,     0,     0,     0,     0,     0,    13,     0,     0,     0,
       0,  3232,     0,  3233,     0,    14,    15,    16,  1566,     0,
       0,  1567,     0,     0,   479,     0,  2795,     0,    17,    18,
       0,     0,     0,     0,  1880,     0,     0,     0,     0,  2737,
       0,     0,  2738,     0,  1568,  1569,     0,  1570,     0,     0,
    2739,    19,     0,  1366,  1367,  1368,  1369,  1370,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    20,  2740,
       0,     0,     0,     0,     0,     0,     0,     0,  2324,     0,
       0,     0,     0,  1572,     0,     0,  2741,     0,     0,     0,
       0,     0,    21,     0,     0,     0,     0,     0,     0,    22,
       0,     0,    23,     0,     0,     0,   567,  2742,     0,  2743,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    24,     0,     0,  3320,     0,  2744,  2745,
       0,     0,  3078,  3078,     0,     0,     0,     0,     0,    25,
       0,     0,     0,     0,     0,     0,  3338,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    26,  1371,  1372,
    1373,  1374,    27,   567,     0,     0,     0,  1573,     0,  2746,
       0,     0,     0,     0,     0,     0,  1574,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2040,
       0,     0,     0,     0,     0,     0,     0,     0,  2747,  1544,
    1545,  3356,     0,     0,     0,     0,     0,  2748,  2749,     0,
    2750,     0,  3078,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1547,     0,     0,     0,     0,  2751,  2752,
    2753,     0,     0,     0,  1548,     0,     0,     0,    28,     0,
       0,     0,     0,  1549,  1375,     0,  1376,  1377,  1378,  2754,
    2755,  2756,     0,     0,     0,  2757,  1379,     0,  2758,     0,
      29,     0,  1551,     0,     0,     0,     0,     0,     0,    30,
       0,  2759,  2760,     0,     0,     0,     0,  1100,     0,     0,
    1552,     0,     0,     0,     0,     0,     0,     0,     0,    31,
       0,    32,    33,     0,     0,    34,     0,  2761,    35,  2762,
      36,     0,     0,     0,     0,    37,     0,    38,     0,  1557,
       0,     0,     0,     0,     0,     0,    39,     0,     0,     0,
      40,     0,  1380,  2763,  1779,   479,    41,     0,     0,     0,
       0,    42,     0,     0,     0,    43,     0,     0,     0,     0,
       0,     0,     0,     0,  3320,     0,  3320,     0,  3457,  2039,
       0,     0,     0,     0,     0,    44,  2216,  2218,  2220,    45,
       0,  3466,     0,     0,     0,     0,  2764,     0,  2765,  1381,
    1382,     0,     0,  2234,     0,     0,     0,     0,  2766,     0,
       0,     0,     0,  1560,     0,     0,     0,     0,     0,     0,
    1561,  3486,     0,     0,     0,    46,     0,     0,     0,  2253,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,    48,     0,     0,     0,     0,    49,
       0,  2265,  2767,  2768,     0,     0,  2769,  2770,  2771,  2772,
       0,  1779,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    50,     0,     0,     0,     0,     0,     0,     0,
    3535,     0,     0,     0,     0,  3542,     0,     0,  1562,     0,
       0,     0,     0,    51,     0,     0,  3521,     0,     0,  2773,
    2774,     0,     0,  1563,     0,     0,   567,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1383,  3561,  2775,     0,
       0,     0,     0,  3521,  3521,     0,     0,  1384,  1385,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1566,     0,     0,  1567,     0,     0,
       0,     0,     0,     0,     0,     0,  3521,  3521,     0,     0,
       0,     0,     0,  3521,     0,     0,     0,     0,     0,     0,
    1568,  1569,     0,  1570,     0,  3629,     0,     0,  3521,     0,
    3521,     0,     0,     0,     0,     0,  3521,     0,  3642,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3521,     0,
       0,     0,     0,     0,     0,     0,     0,  3521,  3521,  1572,
       0,     0,     0,     0,     0,     0,  1779,     0,  3670,     0,
       0,     0,  3521,     0,     0,     0,  3678,     0,     0,  3521,
       0,     0,     0,   567,     0,     0,     0,  1779,     0,  3521,
       0,     0,     0,     0,     0,     0,  3521,     0,     0,     0,
       0,     0,     0,  1779,     0,     0,     0,     0,     0,  3521,
    3710,     0,  3521,     0,  3521,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3521,  3710,     0,     0,     0,     0,     0,
       0,     0,     0,  1573,  2496,     0,  3521,  2497,  3521,     0,
    2499,  2500,  1574,     0,     0,     0,     0,     0,     0,     0,
    3521,  3521,     0,  2513,  3521,     0,  2516,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2523,
       0,  2524,     0,     0,     0,  2527,     0,  2528,  2529,     0,
       0,     0,  2532,     0,  2533,  2534,     0,  2535,     0,     0,
    2536,     0,  2537,  2538,     0,     0,     0,     0,  2542,  2543,
       0,     0,  2545,     0,  2546,     0,  2547,     0,  2548,     0,
    2550,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2555,  2556,     0,     0,  2557,     0,  2558,     0,     0,
       0,     0,     0,     0,     0,  2559,  2560,     0,  2561,     0,
    2562,     0,     0,  2563,  2564,  2565,     0,  2566,     0,     0,
       0,     0,  2569,  2570,  2571,  2572,     0,     0,     0,     0,
    2574,  2575,  2576,     0,  2577,     0,  2579,     0,  2581,     0,
    2583,     0,  2584,     0,     0,     0,     0,     0,     0,  2586,
       0,  2587,     0,     0,  2589,  2590,     0,     0,     0,     0,
       0,   620,     0,   582,   621,  2599,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2606,     0,     0,     0,     0,     0,   622,   623,     0,     0,
       0,     0,     0,     0,  1542,     0,   624,     0,   625,     0,
    2624,  1543,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1544,  1545,     0,     0,     0,   626,     0,   627,     0,
       0,     0,     0,     0,     0,     0,   628,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1546,     0,     0,     0,  1547,     0,     0,     0,  2668,
       0,     0,     0,     0,  2672,     0,  1548,     0,     0,     0,
       0,     0,     0,     0,     0,  1549,     0,     0,     0,     0,
       0,  1550,     0, -1357,   629,     0,     0,     0,   630,     0,
       0,     0,     0,     0,  1551,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2703,  1100,
       0,     0,  1552,     0,     0,     0,     0,     0,   631,     0,
     632,  1553,  2706,     0,     0,     0,     0,  1555,     0,     0,
       0,     0,   633,     0,   634,  1556,     0,     0,     0,     0,
       0,  1557,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   635,   636,     0,
       0,   637,     0,     0,     0,     0,     0,  1558,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   638,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   639,
       0,     0,     0,     0,   640,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1560,     0,     0,     0,     0,
       0,     0,  1561,     0,  2808,     0,     0,     0,   641,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   642,     0,     0,     0,     0,     0,     0,     0,     0,
     643,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   644,     0,
    1562,     0,     0,     0,     0,     0,     0,  2881,     0,     0,
       0,     0,     0,     0,     0,  1563,     0,  2892,     0,  2894,
    1564,  2896,     0,     0,   645,   646,     0,  2902,   647,   648,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2914,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1565,     0,     0,     0,     0,     0,  1566,     0,     0,  1567,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   649,     0,     0,     0,
       0,     0,  1568,  1569,     0,  1570,   650,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1571,
       0,     0,     0,     0,     0,     0,     0, -1801,  2959,     0,
       0,   651,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1572,     0,     0,     0,     0,   652,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1801,     0,     0,     0,   653,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1573,     0,     0,     0,     0,
       0,     0,     0,     0,  1574,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3087,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3091,     0,
       0,     0,     0,     0,  3092,     0,     0,     0,     0,     0,
       0,     0,     0,  3096,  3097,     0,     0,     0,     0,  3098,
       0,     0,     0,  3099,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3103,     0,     0,     0,
       0,     0,  3105,     0,     0,  3106,  3107,     0,  3108,  3109,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3114,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3165,
    3166,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2703,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2703,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2668,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3364,     0,     0,     0,     0,     0,  3366,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3382,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3394,     0,  3396,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2703,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3481,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3495,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3564,  3565,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3586,     0,     0,     0,     0,     0,     0,     0,
       0,  3596,     0,     0,     0,     0,     0,     0,  3602,     0,
       0,     0,     0,     0,     0,     0,     0,  3612,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   122,     0,
     754,   124,   125,   126,   127,     0,  3636,     0,     0,     0,
     128,     0,     0,   755,     0,   756,   130,   131,   757,   133,
    3651,   134,   758,   135,     0,   759,   136,   760,   761,   762,
     137,   763,     0,   138,   139,   140,  1767,   141,     0,   142,
     143,     0,     0,   144,   764,   145,     0,   146,   765,   766,
     148,     0,   149,   150,   151,   767,   152,     0,   768,   154,
       0,   155,   156,   157,   158,   159,   769,   770,   160,     0,
     161,   162,     0,   771,   164,     0,   772,   773,   774,   165,
       0,  3711,   166,   775,   776,     0,   777,   778,     0,   167,
     168,   779,   780,   781,     0,     0,     0,     0,   782,   171,
     783,     0,     0,   784,   785,   172,     0,   173,     0,     0,
       0,   786,   787,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,   788,
     182,     0,   789,   790,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,   791,     0,   191,   792,   192,
     793,   794,   193,   194,     0,   795,   195,   196,   197,   796,
       0,   198,     0,     0,   797,     0,   199,   200,     0,   798,
     201,     0,   202,   799,   800,   801,   802,     0,   803,   804,
     204,   805,   806,   807,   206,     0,   207,   808,     0,   809,
     810,     0,   208,   209,     0,   210,   811,     0,   211,     0,
       0,     0,   812,   213,   214,   215,   813,     0,   216,   217,
       0,     0,     0,   218,     0,     0,   814,   219,   815,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   816,   226,     0,  1768,   817,
     227,     0,   818,   228,     0,     0,     0,   819,     0,   820,
       0,   230,   821,     0,   231,     0,   232,   822,     0,     0,
     823,     0,     0,     0,     0,   824,   233,   234,   235,   236,
     237,   238,   825,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   826,   248,   249,   250,   827,   251,   252,     0,
       0,     0,   253,   254,   255,   828,   257,     0,     0,   829,
     259,   830,   831,   260,     0,   261,   832,   833,   834,   835,
     836,   837,   838,   266,   267,   268,   269,     0,   839,   270,
     271,     0,   272,   273,   274,   840,   841,   842,   275,     0,
     843,   844,     0,   276,   277,     0,   845,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   846,   847,   286,   848,   849,   850,
     851,   852,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   853,   297,   298,   299,   300,   301,   302,
     303,   854,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,   855,   856,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,   857,
     318,   319,   858,   320,   321,   859,   322,   860,   324,   325,
       0,   861,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
     862,   863,   345,   346,     0,   347,   864,   349,   865,   866,
     867,   350,   351,   352,   353,   868,   354,   355,     0,   356,
     357,     0,   869,   358,   870,   871,   872,   873,     0,     0,
       0,     0,  1769,   363,     0,   364,   874,   875,   876,   366,
     367,   368,     0,   877,   369,   370,   878,     0,   371,     0,
       0,   879,   880,   372,     0,     0,   373,     0,   374,     0,
     881,   376,     0,     0,   882,   883,   884,   885,   886,   377,
       0,     0,   378,   887,     0,   379,   380,   888,     0,     0,
       0,     0,   382,     0,   383,   384,     0,   889,     0,   890,
       0,     0,     0,     0,   891,     0,     0,     0,   892,   893,
       0,     0,     0,     0,   894,     0,   895,     0,     0,   896,
     897,     0,     0,   898,   899,   122,     0,   754,   124,   125,
     126,   127,  2664,     0,     0,     0,     0,   128,     0,     0,
     755,     0,   756,   130,   131,   757,   133,     0,   134,   758,
     135,     0,  2665,   136,   760,   761,   762,   137,   763,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,   764,   145,     0,   146,   765,   766,   148,     0,   149,
     150,   151,   767,   152,     0,   768,   154,     0,   155,   156,
     157,   158,   159,   769,   770,   160,     0,   161,   162,     0,
     771,   164,     0,   772,   773,   774,   165,     0,     0,   166,
     775,   776,     0,   777,   778,     0,   167,   168,   779,   780,
     781,     0,     0,     0,     0,   782,   171,   783,     0,     0,
     784,  2666,   172,     0,   173,     0,     0,     0,   786,   787,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,   788,   182,     0,   789,
     790,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,   791,     0,   191,   792,   192,   793,   794,   193,
     194,     0,   795,   195,   196,   197,   796,     0,   198,     0,
       0,   797,     0,   199,   200,     0,   798,   201,     0,   202,
     799,   800,   801,   802,     0,   803,   804,   204,   805,   806,
     807,   206,     0,   207,   808,     0,   809,   810,     0,   208,
     209,     0,   210,   811,     0,   211,     0,     0,     0,   812,
     213,   214,   215,   813,     0,   216,   217,     0,     0,     0,
     218,     0,     0,   814,   219,   815,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   816,   226,     0,     0,   817,   227,     0,   818,
     228,     0,     0,     0,   819,     0,   820,     0,   230,   821,
       0,   231,     0,   232,   822,     0,     0,   823,     0,     0,
       0,     0,   824,   233,   234,   235,   236,   237,   238,   825,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   826,
     248,   249,   250,   827,   251,   252,     0,     0,     0,   253,
     254,   255,   828,   257,     0,     0,   829,   259,   830,   831,
     260,     0,   261,   832,   833,   834,   835,   836,   837,   838,
     266,   267,   268,   269,     0,   839,   270,   271,     0,   272,
     273,   274,   840,   841,   842,   275,     0,   843,   844,     0,
     276,   277,     0,   845,  2667,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   846,   847,   286,   848,   849,   850,   851,   852,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     853,   297,   298,   299,   300,   301,   302,   303,   854,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,   855,   856,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,   857,   318,   319,   858,
     320,   321,   859,   322,   860,   324,   325,     0,   861,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,   862,   863,   345,
     346,     0,   347,   864,   349,   865,   866,   867,   350,   351,
     352,   353,   868,   354,   355,     0,   356,   357,     0,   869,
     358,   870,   871,   872,   873,     0,     0,     0,     0,     0,
     363,     0,   364,   874,   875,   876,   366,   367,   368,     0,
     877,   369,   370,   878,     0,   371,     0,     0,   879,   880,
     372,     0,     0,   373,     0,   374,     0,   881,   376,     0,
       0,   882,   883,   884,   885,   886,   377,     0,     0,   378,
     887,     0,   379,   380,   888,     0,     0,     0,     0,   382,
       0,   383,   384,     0,   889,     0,   890,     0,     0,     0,
       0,   891,     0,     0,     0,   892,   893,     0,     0,     0,
       0,   894,     0,   895,     0,     0,   896,   897,     0,     0,
     898,   899,   122,     0,   754,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   755,     0,   756,
     130,   131,   757,   133,     0,   134,   758,   135,     0,   759,
     136,   760,   761,   762,   137,   763,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,   764,   145,
       0,   146,   765,   766,   148,     0,   149,   150,   151,   767,
     152,     0,   768,   154,     0,   155,   156,   157,   158,   159,
     769,   770,   160,     0,   161,   162,     0,   771,   164,     0,
     772,   773,   774,   165,     0,     0,   166,   775,   776,     0,
     777,   778,     0,   167,   168,   779,   780,   781,     0,     0,
       0,     0,   782,   171,   783,     0,     0,   784,   785,   172,
       0,   173,     0,     0,     0,   786,   787,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,   788,   182,     0,   789,   790,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,   791,
       0,   191,   792,   192,   793,   794,   193,   194,     0,   795,
     195,   196,   197,   796,     0,   198,     0,     0,   797,     0,
     199,   200,     0,   798,   201,     0,   202,   799,   800,   801,
     802,     0,   803,   804,   204,   805,   806,   807,   206,     0,
     207,   808,     0,   809,   810,     0,   208,   209,     0,   210,
     811,     0,   211,     0,     0,     0,   812,   213,   214,   215,
     813,     0,   216,   217,     0,     0,     0,   218,     0,     0,
     814,   219,   815,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   816,
     226,     0,     0,   817,   227,     0,   818,   228,     0,     0,
       0,   819,     0,   820,     0,   230,   821,     0,   231,     0,
     232,   822,     0,     0,   823,     0,     0,     0,     0,   824,
     233,   234,   235,   236,   237,   238,   825,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   826,   248,   249,   250,
     827,   251,   252,     0,     0,     0,   253,   254,   255,   828,
     257,     0,     0,   829,   259,   830,   831,   260,     0,   261,
     832,   833,   834,   835,   836,   837,   838,   266,   267,   268,
     269,     0,   839,   270,   271,     0,   272,   273,   274,   840,
     841,   842,   275,     0,   843,   844,     0,   276,   277,     0,
     845,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   846,   847,
     286,   848,   849,   850,   851,   852,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   853,   297,   298,
     299,   300,   301,   302,   303,   854,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,   855,   856,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,   857,   318,   319,   858,   320,   321,   859,
     322,   860,   324,   325,     0,   861,   327,  1324,     0,     0,
     328,   329,   330,     0,     0,   331,     0,     0,     0,   332,
     333,   334,   335,     0,   336,   337,   338,     0,     0,     0,
       0,     0,     0,   339,   340,     0,   341,     0,     0,   342,
       0,     0,   343,   344,   862,   863,   345,   346,     0,   347,
     864,   349,   865,   866,   867,   350,   351,   352,   353,   868,
     354,   355,     0,   356,   357,     0,   869,   358,   870,   871,
     872,   873,     0,     0,     0,     0,     0,   363,     0,   364,
     874,   875,   876,   366,   367,   368,     0,   877,   369,   370,
     878,     0,   371,     0,     0,   879,   880,   372,     0,     0,
     373,     0,   374,     0,   881,   376,     0,     0,   882,   883,
     884,   885,   886,   377,     0,     0,   378,   887,     0,   379,
     380,   888,     0,     0,     0,     0,   382,     0,   383,   384,
       0,   889,     0,   890,     0,     0,     0,     0,   891,     0,
       0,     0,   892,   893,     0,     0,     0,     0,   894,     0,
    1325,     0,     0,   896,   897,     0,     0,   898,   899,   122,
       0,   754,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   755,     0,   756,   130,   131,   757,
     133,     0,   134,   758,   135,     0,   759,   136,   760,   761,
     762,   137,   763,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,   764,   145,     0,   146,   765,
     766,   148,     0,   149,   150,   151,   767,   152,     0,   768,
     154,     0,   155,   156,   157,   158,   159,   769,   770,   160,
       0,   161,   162,     0,   771,   164,     0,   772,   773,   774,
     165,     0,     0,   166,   775,   776,     0,   777,   778,     0,
     167,   168,   779,   780,   781,     0,     0,     0,     0,   782,
     171,   783,     0,     0,   784,   785,   172,     0,   173,     0,
       0,     0,   786,   787,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
     788,   182,     0,   789,   790,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,   791,     0,   191,   792,
     192,   793,   794,   193,   194,     0,   795,   195,   196,   197,
     796,     0,   198,     0,     0,   797,     0,   199,   200,     0,
     798,   201,     0,   202,   799,   800,   801,   802,     0,   803,
     804,   204,   805,   806,   807,   206,     0,   207,   808,     0,
     809,   810,     0,   208,   209,     0,   210,   811,     0,   211,
       0,     0,     0,   812,   213,   214,   215,   813,     0,   216,
     217,     0,     0,     0,   218,     0,     0,   814,   219,   815,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   816,   226,     0,     0,
     817,   227,     0,   818,   228,     0,     0,     0,   819,     0,
     820,     0,   230,   821,     0,   231,     0,   232,   822,     0,
       0,   823,     0,     0,     0,     0,   824,   233,   234,   235,
     236,   237,   238,   825,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   826,   248,   249,   250,   827,   251,   252,
       0,     0,     0,   253,   254,   255,   828,   257,     0,     0,
     829,   259,   830,   831,   260,     0,   261,   832,   833,   834,
     835,   836,   837,   838,   266,   267,   268,   269,     0,   839,
     270,   271,     0,   272,   273,   274,   840,   841,   842,   275,
       0,   843,   844,     0,   276,   277,     0,   845,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   846,   847,   286,   848,   849,
     850,   851,   852,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   853,   297,   298,   299,   300,   301,
     302,   303,   854,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,   855,   856,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
     857,   318,   319,   858,   320,   321,   859,   322,   860,   324,
     325,     0,   861,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,   862,   863,   345,   346,     0,   347,   864,   349,   865,
     866,   867,   350,   351,   352,   353,   868,   354,   355,     0,
     356,   357,     0,   869,   358,   870,   871,   872,   873,     0,
       0,     0,     0,     0,   363,     0,   364,   874,   875,   876,
     366,   367,   368,     0,   877,   369,   370,   878,     0,   371,
       0,     0,   879,   880,   372,     0,     0,   373,     0,   374,
       0,   881,   376,     0,     0,   882,   883,   884,   885,   886,
     377,     0,     0,   378,   887,     0,   379,   380,   888,     0,
       0,     0,     0,   382,     0,   383,   384,     0,   889,     0,
     890,     0,     0,     0,     0,   891,     0,     0,     0,   892,
     893,     0,     0,     0,     0,   894,     0,   895,  1611,     0,
     896,   897,     0,     0,   898,   899,   122,     0,   754,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   755,     0,   756,   130,   131,   757,   133,     0,   134,
     758,   135,     0,   759,   136,   760,   761,   762,   137,   763,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   764,   145,     0,   146,   765,   766,   148,     0,
     149,   150,   151,   767,   152,     0,   768,   154,     0,   155,
     156,   157,   158,   159,   769,   770,   160,     0,   161,   162,
       0,   771,   164,     0,   772,   773,   774,   165,     0,     0,
     166,   775,   776,     0,   777,   778,     0,   167,   168,   779,
     780,   781,     0,     0,     0,     0,   782,   171,   783,     0,
       0,   784,   785,   172,     0,   173,     0,     0,     0,   786,
     787,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   788,   182,     0,
     789,   790,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   791,     0,   191,   792,   192,   793,   794,
     193,   194,     0,   795,   195,   196,   197,   796,     0,   198,
       0,     0,   797,     0,   199,   200,     0,   798,   201,     0,
     202,   799,   800,   801,   802,     0,   803,   804,   204,   805,
     806,   807,   206,     0,   207,   808,     0,   809,   810,     0,
     208,   209,     0,   210,   811,     0,   211,     0,     0,     0,
     812,   213,   214,   215,   813,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   814,   219,   815,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   816,   226,     0,     0,   817,   227,     0,
     818,   228,     0,     0,     0,   819,     0,   820,     0,   230,
     821,     0,   231,     0,   232,   822,     0,     0,   823,     0,
       0,     0,     0,   824,   233,   234,   235,   236,   237,   238,
     825,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     826,   248,   249,   250,   827,   251,   252,     0,     0,     0,
     253,   254,   255,   828,   257,     0,     0,   829,   259,   830,
     831,   260,     0,   261,   832,   833,   834,   835,   836,   837,
     838,   266,   267,   268,   269,     0,   839,   270,   271,     0,
     272,   273,   274,   840,   841,   842,   275,     0,   843,   844,
       0,   276,   277,     0,   845,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   846,   847,   286,   848,   849,   850,   851,   852,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   853,   297,   298,   299,   300,   301,   302,   303,   854,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   855,   856,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   857,   318,   319,
     858,   320,   321,   859,   322,   860,   324,   325,     0,   861,
     327,     0,     0,     0,   328,   329,   330,     0,     0,   331,
       0,     0,     0,   332,   333,   334,   335,     0,   336,   337,
     338,     0,     0,     0,     0,     0,     0,   339,   340,     0,
     341,     0,     0,   342,     0,     0,   343,   344,   862,   863,
     345,   346,     0,   347,   864,   349,   865,   866,   867,   350,
     351,   352,   353,   868,   354,   355,     0,   356,   357,     0,
     869,   358,   870,   871,   872,   873,     0,     0,     0,     0,
       0,   363,     0,   364,   874,   875,   876,   366,   367,   368,
       0,   877,   369,   370,   878,     0,   371,     0,     0,   879,
     880,   372,     0,     0,   373,     0,   374,     0,   881,   376,
       0,     0,   882,   883,   884,   885,   886,   377,     0,     0,
     378,   887,     0,   379,   380,   888,     0,     0,     0,     0,
     382,     0,   383,   384,     0,   889,     0,   890,     0,     0,
       0,     0,   891,     0,     0,     0,   892,   893,     0,     0,
       0,     0,   894,     0,   895,  1707,     0,   896,   897,     0,
       0,   898,   899,   122,     0,   754,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   755,     0,
     756,   130,   131,   757,   133,     0,   134,   758,   135,     0,
     759,   136,   760,   761,   762,   137,   763,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,   764,
     145,     0,   146,   765,   766,   148,     0,   149,   150,   151,
     767,   152,     0,   768,   154,     0,   155,   156,   157,   158,
     159,   769,   770,   160,     0,   161,   162,     0,   771,   164,
       0,   772,   773,   774,   165,     0,     0,   166,   775,   776,
       0,   777,   778,     0,   167,   168,   779,   780,   781,     0,
       0,     0,     0,   782,   171,   783,     0,     0,   784,   785,
     172,     0,   173,     0,     0,     0,   786,   787,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,   788,   182,     0,   789,   790,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
     791,     0,   191,   792,   192,   793,   794,   193,   194,     0,
     795,   195,   196,   197,   796,     0,   198,     0,     0,   797,
       0,   199,   200,     0,   798,   201,     0,   202,   799,   800,
     801,   802,     0,   803,   804,   204,   805,   806,   807,   206,
       0,   207,   808,     0,   809,   810,     0,   208,   209,     0,
     210,   811,     0,   211,     0,     0,     0,   812,   213,   214,
     215,   813,     0,   216,   217,     0,     0,     0,   218,     0,
       0,   814,   219,   815,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     816,   226,     0,     0,   817,   227,     0,   818,   228,     0,
       0,     0,   819,     0,   820,     0,   230,   821,     0,   231,
       0,   232,   822,     0,     0,   823,     0,     0,     0,     0,
     824,   233,   234,   235,   236,   237,   238,   825,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   826,   248,   249,
     250,   827,   251,   252,     0,     0,     0,   253,   254,   255,
     828,   257,     0,     0,   829,   259,   830,   831,   260,     0,
     261,   832,   833,   834,   835,   836,   837,   838,   266,   267,
     268,   269,     0,   839,   270,   271,     0,   272,   273,   274,
     840,   841,   842,   275,     0,   843,   844,     0,   276,   277,
       0,   845,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   846,
     847,   286,   848,   849,   850,   851,   852,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   853,   297,
     298,   299,   300,   301,   302,   303,   854,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,   855,   856,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,   857,   318,   319,   858,   320,   321,
     859,   322,   860,   324,   325,     0,   861,   327,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,   333,   334,   335,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,   343,   344,   862,   863,   345,   346,     0,
     347,   864,   349,   865,   866,   867,   350,   351,   352,   353,
     868,   354,   355,     0,   356,   357,     0,   869,   358,   870,
     871,   872,   873,     0,     0,     0,     0,     0,   363,     0,
     364,   874,   875,   876,   366,   367,   368,     0,   877,   369,
     370,   878,     0,   371,     0,     0,   879,   880,   372,     0,
       0,   373,     0,   374,     0,   881,   376,     0,     0,   882,
     883,   884,   885,   886,   377,     0,     0,   378,   887,     0,
     379,   380,   888,     0,     0,     0,     0,   382,     0,   383,
     384,     0,   889,     0,   890,     0,     0,     0,     0,   891,
       0,     0,     0,   892,   893,     0,     0,     0,     0,   894,
       0,   895,  1744,     0,   896,   897,     0,     0,   898,   899,
     122,     0,   754,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   755,     0,   756,   130,   131,
     757,   133,     0,   134,   758,   135,     0,   759,   136,   760,
     761,   762,   137,   763,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,   764,   145,     0,   146,
     765,   766,   148,     0,   149,   150,   151,   767,   152,     0,
     768,   154,     0,   155,   156,   157,   158,   159,   769,   770,
     160,     0,   161,   162,     0,   771,   164,     0,   772,   773,
     774,   165,     0,     0,   166,   775,   776,     0,   777,   778,
       0,   167,   168,   779,   780,   781,     0,     0,     0,     0,
     782,   171,   783,     0,     0,   784,   785,   172,     0,   173,
       0,     0,     0,   786,   787,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,   788,   182,     0,   789,   790,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,   791,     0,   191,
     792,   192,   793,   794,   193,   194,     0,   795,   195,   196,
     197,   796,     0,   198,     0,     0,   797,     0,   199,   200,
       0,   798,   201,     0,   202,   799,   800,   801,   802,     0,
     803,   804,   204,   805,   806,   807,   206,     0,   207,   808,
       0,   809,   810,     0,   208,   209,     0,   210,   811,     0,
     211,     0,     0,     0,   812,   213,   214,   215,   813,     0,
     216,   217,     0,     0,     0,   218,     0,     0,   814,   219,
     815,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   816,   226,     0,
       0,   817,   227,     0,   818,   228,     0,     0,     0,   819,
       0,   820,     0,   230,   821,     0,   231,     0,   232,   822,
       0,     0,   823,     0,     0,     0,     0,   824,   233,   234,
     235,   236,   237,   238,   825,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   826,   248,   249,   250,   827,   251,
     252,     0,     0,     0,   253,   254,   255,   828,   257,     0,
       0,   829,   259,   830,   831,   260,     0,   261,   832,   833,
     834,   835,   836,   837,   838,   266,   267,   268,   269,     0,
     839,   270,   271,     0,   272,   273,   274,   840,   841,   842,
     275,     0,   843,   844,     0,   276,   277,     0,   845,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   846,   847,   286,   848,
     849,   850,   851,   852,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   853,   297,   298,   299,   300,
     301,   302,   303,   854,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,   855,
     856,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,   857,   318,   319,   858,   320,   321,   859,   322,   860,
     324,   325,     0,   861,   327,     0,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,   333,   334,
     335,     0,   336,   337,   338,     0,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
     343,   344,   862,   863,   345,   346,     0,   347,   864,   349,
     865,   866,   867,   350,   351,   352,   353,   868,   354,   355,
       0,   356,   357,     0,   869,   358,   870,   871,   872,   873,
       0,     0,     0,     0,     0,   363,     0,   364,   874,   875,
     876,   366,   367,   368,     0,   877,   369,   370,   878,     0,
     371,     0,     0,   879,   880,   372,     0,     0,   373,     0,
     374,     0,   881,   376,     0,     0,   882,   883,   884,   885,
     886,   377,     0,     0,   378,   887,     0,   379,   380,   888,
       0,     0,     0,     0,   382,     0,   383,   384,     0,   889,
       0,   890,     0,     0,     0,     0,   891,     0,     0,     0,
     892,   893,     0,     0,     0,     0,   894,     0,   895,  1773,
       0,   896,   897,     0,     0,   898,   899,   122,     0,   754,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   755,     0,   756,   130,   131,   757,   133,     0,
     134,   758,   135,     0,   759,   136,   760,   761,   762,   137,
     763,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,   764,   145,     0,   146,   765,   766,   148,
       0,   149,   150,   151,   767,   152,     0,   768,   154,     0,
     155,   156,   157,   158,   159,   769,   770,   160,     0,   161,
     162,     0,   771,   164,     0,   772,   773,   774,   165,     0,
       0,   166,   775,   776,     0,   777,   778,     0,   167,   168,
     779,   780,   781,     0,     0,     0,     0,   782,   171,   783,
       0,     0,   784,   785,   172,     0,   173,     0,     0,     0,
     786,   787,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,   788,   182,
       0,   789,   790,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,   791,     0,   191,   792,   192,   793,
     794,   193,   194,     0,   795,   195,   196,   197,   796,     0,
     198,     0,     0,   797,     0,   199,   200,  2215,   798,   201,
       0,   202,   799,   800,   801,   802,     0,   803,   804,   204,
     805,   806,   807,   206,     0,   207,   808,     0,   809,   810,
       0,   208,   209,     0,   210,   811,     0,   211,     0,     0,
       0,   812,   213,   214,   215,   813,     0,   216,   217,     0,
       0,     0,   218,     0,     0,   814,   219,   815,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   816,   226,     0,     0,   817,   227,
       0,   818,   228,     0,     0,     0,   819,     0,   820,     0,
     230,   821,     0,   231,     0,   232,   822,     0,     0,   823,
       0,     0,     0,     0,   824,   233,   234,   235,   236,   237,
     238,   825,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   826,   248,   249,   250,   827,   251,   252,     0,     0,
       0,   253,   254,   255,   828,   257,     0,     0,   829,   259,
     830,   831,   260,     0,   261,   832,   833,   834,   835,   836,
     837,   838,   266,   267,   268,   269,     0,   839,   270,   271,
       0,   272,   273,   274,   840,   841,   842,   275,     0,   843,
     844,     0,   276,   277,     0,   845,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   846,   847,   286,   848,   849,   850,   851,
     852,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   853,   297,   298,   299,   300,   301,   302,   303,
     854,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,   855,   856,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,   857,   318,
     319,   858,   320,   321,   859,   322,   860,   324,   325,     0,
     861,   327,     0,     0,     0,   328,   329,   330,     0,     0,
     331,     0,     0,     0,   332,   333,   334,   335,     0,   336,
     337,   338,     0,     0,     0,     0,     0,     0,   339,   340,
       0,   341,     0,     0,   342,     0,     0,   343,   344,   862,
     863,   345,   346,     0,   347,   864,   349,   865,   866,   867,
     350,   351,   352,   353,   868,   354,   355,     0,   356,   357,
       0,   869,   358,   870,   871,   872,   873,     0,     0,     0,
       0,     0,   363,     0,   364,   874,   875,   876,   366,   367,
     368,     0,   877,   369,   370,   878,     0,   371,     0,     0,
     879,   880,   372,     0,     0,   373,     0,   374,     0,   881,
     376,     0,     0,   882,   883,   884,   885,   886,   377,     0,
       0,   378,   887,     0,   379,   380,   888,     0,     0,     0,
       0,   382,     0,   383,   384,     0,   889,     0,   890,     0,
       0,     0,     0,   891,     0,     0,     0,   892,   893,     0,
       0,     0,     0,   894,     0,   895,     0,     0,   896,   897,
       0,     0,   898,   899,   122,     0,   754,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   755,
       0,   756,   130,   131,   757,   133,     0,   134,   758,   135,
       0,   759,   136,   760,   761,   762,   137,   763,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
     764,   145,     0,   146,   765,   766,   148,     0,   149,   150,
     151,   767,   152,     0,   768,   154,     0,   155,   156,   157,
     158,   159,   769,   770,   160,     0,   161,   162,     0,   771,
     164,     0,   772,   773,   774,   165,     0,     0,   166,   775,
     776,     0,   777,   778,     0,   167,   168,   779,   780,   781,
       0,     0,     0,     0,   782,   171,   783,     0,     0,   784,
     785,   172,     0,   173,     0,     0,     0,   786,   787,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,   788,   182,     0,   789,   790,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,   791,     0,   191,   792,   192,   793,   794,   193,   194,
       0,   795,   195,   196,   197,   796,     0,   198,     0,     0,
     797,     0,   199,   200,  2217,   798,   201,     0,   202,   799,
     800,   801,   802,     0,   803,   804,   204,   805,   806,   807,
     206,     0,   207,   808,     0,   809,   810,     0,   208,   209,
       0,   210,   811,     0,   211,     0,     0,     0,   812,   213,
     214,   215,   813,     0,   216,   217,     0,     0,     0,   218,
       0,     0,   814,   219,   815,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,   816,   226,     0,     0,   817,   227,     0,   818,   228,
       0,     0,     0,   819,     0,   820,     0,   230,   821,     0,
     231,     0,   232,   822,     0,     0,   823,     0,     0,     0,
       0,   824,   233,   234,   235,   236,   237,   238,   825,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   826,   248,
     249,   250,   827,   251,   252,     0,     0,     0,   253,   254,
     255,   828,   257,     0,     0,   829,   259,   830,   831,   260,
       0,   261,   832,   833,   834,   835,   836,   837,   838,   266,
     267,   268,   269,     0,   839,   270,   271,     0,   272,   273,
     274,   840,   841,   842,   275,     0,   843,   844,     0,   276,
     277,     0,   845,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     846,   847,   286,   848,   849,   850,   851,   852,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   853,
     297,   298,   299,   300,   301,   302,   303,   854,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,   855,   856,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,   857,   318,   319,   858,   320,
     321,   859,   322,   860,   324,   325,     0,   861,   327,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,   333,   334,   335,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,   343,   344,   862,   863,   345,   346,
       0,   347,   864,   349,   865,   866,   867,   350,   351,   352,
     353,   868,   354,   355,     0,   356,   357,     0,   869,   358,
     870,   871,   872,   873,     0,     0,     0,     0,     0,   363,
       0,   364,   874,   875,   876,   366,   367,   368,     0,   877,
     369,   370,   878,     0,   371,     0,     0,   879,   880,   372,
       0,     0,   373,     0,   374,     0,   881,   376,     0,     0,
     882,   883,   884,   885,   886,   377,     0,     0,   378,   887,
       0,   379,   380,   888,     0,     0,     0,     0,   382,     0,
     383,   384,     0,   889,     0,   890,     0,     0,     0,     0,
     891,     0,     0,     0,   892,   893,     0,     0,     0,     0,
     894,     0,   895,     0,     0,   896,   897,     0,     0,   898,
     899,   122,     0,   754,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   755,     0,   756,   130,
     131,   757,   133,     0,   134,   758,   135,     0,   759,   136,
     760,   761,   762,   137,   763,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   764,   145,     0,
     146,   765,   766,   148,     0,   149,   150,   151,   767,   152,
       0,   768,   154,     0,   155,   156,   157,   158,   159,   769,
     770,   160,     0,   161,   162,     0,   771,   164,     0,   772,
     773,   774,   165,     0,     0,   166,   775,   776,     0,   777,
     778,     0,   167,   168,   779,   780,   781,     0,     0,     0,
       0,   782,   171,   783,     0,     0,   784,   785,   172,     0,
     173,     0,     0,     0,   786,   787,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   788,   182,     0,   789,   790,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   791,     0,
     191,   792,   192,   793,   794,   193,   194,     0,   795,   195,
     196,   197,   796,     0,   198,     0,     0,   797,     0,   199,
     200,  2219,   798,   201,     0,   202,   799,   800,   801,   802,
       0,   803,   804,   204,   805,   806,   807,   206,     0,   207,
     808,     0,   809,   810,     0,   208,   209,     0,   210,   811,
       0,   211,     0,     0,     0,   812,   213,   214,   215,   813,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   814,
     219,   815,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   816,   226,
       0,     0,   817,   227,     0,   818,   228,     0,     0,     0,
     819,     0,   820,     0,   230,   821,     0,   231,     0,   232,
     822,     0,     0,   823,     0,     0,     0,     0,   824,   233,
     234,   235,   236,   237,   238,   825,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   826,   248,   249,   250,   827,
     251,   252,     0,     0,     0,   253,   254,   255,   828,   257,
       0,     0,   829,   259,   830,   831,   260,     0,   261,   832,
     833,   834,   835,   836,   837,   838,   266,   267,   268,   269,
       0,   839,   270,   271,     0,   272,   273,   274,   840,   841,
     842,   275,     0,   843,   844,     0,   276,   277,     0,   845,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   846,   847,   286,
     848,   849,   850,   851,   852,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   853,   297,   298,   299,
     300,   301,   302,   303,   854,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     855,   856,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   857,   318,   319,   858,   320,   321,   859,   322,
     860,   324,   325,     0,   861,   327,     0,     0,     0,   328,
     329,   330,     0,     0,   331,     0,     0,     0,   332,   333,
     334,   335,     0,   336,   337,   338,     0,     0,     0,     0,
       0,     0,   339,   340,     0,   341,     0,     0,   342,     0,
       0,   343,   344,   862,   863,   345,   346,     0,   347,   864,
     349,   865,   866,   867,   350,   351,   352,   353,   868,   354,
     355,     0,   356,   357,     0,   869,   358,   870,   871,   872,
     873,     0,     0,     0,     0,     0,   363,     0,   364,   874,
     875,   876,   366,   367,   368,     0,   877,   369,   370,   878,
       0,   371,     0,     0,   879,   880,   372,     0,     0,   373,
       0,   374,     0,   881,   376,     0,     0,   882,   883,   884,
     885,   886,   377,     0,     0,   378,   887,     0,   379,   380,
     888,     0,     0,     0,     0,   382,     0,   383,   384,     0,
     889,     0,   890,     0,     0,     0,     0,   891,     0,     0,
       0,   892,   893,     0,     0,     0,     0,   894,     0,   895,
       0,     0,   896,   897,     0,     0,   898,   899,   122,     0,
     754,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   755,     0,   756,   130,   131,   757,   133,
       0,   134,   758,   135,     0,   759,   136,   760,   761,   762,
     137,   763,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,   764,   145,     0,   146,   765,   766,
     148,     0,   149,   150,   151,   767,   152,     0,   768,   154,
       0,   155,   156,   157,   158,   159,   769,   770,   160,     0,
     161,   162,     0,   771,   164,     0,   772,   773,   774,   165,
       0,     0,   166,   775,   776,     0,   777,   778,     0,   167,
     168,   779,   780,   781,     0,     0,     0,     0,   782,   171,
     783,     0,     0,   784,   785,   172,     0,   173,     0,     0,
       0,   786,   787,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,   788,
     182,     0,   789,   790,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,   791,     0,   191,   792,   192,
     793,   794,   193,   194,     0,   795,   195,   196,   197,   796,
       0,   198,     0,     0,   797,     0,   199,   200,     0,   798,
     201,     0,   202,   799,   800,   801,   802,     0,   803,   804,
     204,   805,   806,   807,   206,     0,   207,   808,     0,   809,
     810,     0,   208,   209,     0,   210,   811,     0,   211,     0,
       0,     0,   812,   213,   214,   215,   813,     0,   216,   217,
       0,     0,     0,   218,     0,     0,   814,   219,   815,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   816,   226,     0,     0,   817,
     227,     0,   818,   228,     0,     0,     0,   819,     0,   820,
       0,   230,   821,     0,   231,     0,   232,   822,     0,     0,
     823,     0,     0,     0,     0,   824,   233,   234,   235,   236,
     237,   238,   825,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   826,   248,   249,   250,   827,   251,   252,     0,
       0,     0,   253,   254,   255,   828,   257,     0,     0,   829,
     259,   830,   831,   260,     0,   261,   832,   833,   834,   835,
     836,   837,   838,   266,   267,   268,   269,     0,   839,   270,
     271,     0,   272,   273,   274,   840,   841,   842,   275,     0,
     843,   844,     0,   276,   277,     0,   845,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   846,   847,   286,   848,   849,   850,
     851,   852,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   853,   297,   298,   299,   300,   301,   302,
     303,   854,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,   855,   856,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,   857,
     318,   319,   858,   320,   321,   859,   322,   860,   324,   325,
       0,   861,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
     862,   863,   345,   346,     0,   347,   864,   349,   865,   866,
     867,   350,   351,   352,   353,   868,   354,   355,     0,   356,
     357,     0,   869,   358,   870,   871,   872,   873,     0,     0,
       0,     0,     0,   363,     0,   364,   874,   875,   876,   366,
     367,   368,     0,   877,   369,   370,   878,     0,   371,     0,
       0,   879,   880,   372,     0,     0,   373,     0,   374,     0,
     881,   376,     0,     0,   882,   883,   884,   885,   886,   377,
       0,     0,   378,   887,     0,   379,   380,   888,     0,     0,
       0,     0,   382,     0,   383,   384,     0,   889,     0,   890,
       0,     0,     0,     0,   891,     0,     0,     0,   892,   893,
       0,     0,     0,     0,   894,     0,   895,     0,     0,   896,
     897,     0,     0,   898,   899,   122,     0,   754,   124,   125,
     126,   127,  1805,     0,     0,     0,     0,  1806,     0,     0,
     755,     0,   756,   130,   131,   757,   133,     0,   134,   758,
     135,     0,   759,   136,   760,   761,   762,   137,   763,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,   764,   145,     0,   146,   765,   766,   148,     0,   149,
     150,   151,   767,   152,     0,   768,   154,     0,   155,   156,
     157,   158,   159,   769,   770,   160,     0,   161,   162,     0,
     771,   164,     0,   772,   773,   774,   165,     0,     0,   166,
     775,   776,     0,   777,   778,     0,   167,   168,   779,   780,
     781,     0,     0,     0,     0,   782,   171,   783,     0,     0,
     784,   785,   172,     0,   173,     0,     0,     0,   786,   787,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,   788,   182,     0,   789,
     790,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,   791,     0,   191,   792,   192,   793,   794,   193,
     194,     0,   795,   195,   196,   197,   796,     0,   198,     0,
       0,   797,     0,   199,   200,     0,   798,   201,     0,   202,
     799,   800,   801,   802,     0,   803,   804,   204,   805,   806,
     807,   206,     0,   207,   808,     0,   809,   810,     0,   208,
     209,     0,   210,   811,     0,   211,     0,     0,     0,   812,
     213,   214,   215,   813,     0,   216,   217,     0,     0,     0,
     218,     0,     0,   814,   219,   815,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   816,   226,     0,     0,   817,   227,     0,   818,
     228,     0,     0,     0,   819,     0,   820,     0,   230,   821,
       0,   231,     0,   232,   822,     0,     0,   823,     0,     0,
       0,     0,   824,   233,   234,   235,   236,   237,   238,   825,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   826,
     248,   249,   250,   827,   251,   252,     0,     0,     0,   253,
     254,   255,   828,   257,     0,     0,   829,   259,   830,   831,
     260,     0,   261,   832,   833,   834,   835,   836,   837,   838,
     266,   267,   268,   269,     0,   839,   270,   271,     0,   272,
     273,   274,   840,     0,   842,   275,     0,   843,   844,     0,
     276,   277,     0,   845,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   846,   847,   286,   848,   849,   850,   851,   852,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     853,   297,   298,   299,   300,   301,   302,   303,   854,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,   855,   856,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,   857,   318,   319,   858,
     320,   321,   859,   322,   860,   324,   325,     0,   861,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,   862,   863,   345,
     346,     0,   347,   864,   349,   865,   866,   867,   350,   351,
     352,   353,   868,   354,   355,     0,   356,   357,     0,   869,
     358,   870,   871,   872,   873,     0,     0,     0,     0,     0,
     363,     0,   364,   874,   875,   876,   366,   367,   368,     0,
     877,   369,   370,   878,     0,   371,     0,     0,   879,   880,
     372,     0,     0,   373,     0,   374,     0,   881,   376,     0,
       0,   882,   883,   884,   885,   886,   377,     0,     0,   378,
     887,     0,   379,   380,   888,     0,     0,     0,     0,   382,
       0,   383,   384,     0,   889,     0,   890,     0,     0,     0,
       0,   891,     0,     0,     0,   892,   893,     0,     0,     0,
       0,   894,     0,   895,     0,     0,   896,   897,     0,     0,
     898,   899,   122,     0,   754,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   755,     0,   756,
     130,   131,   757,   133,     0,   134,   758,   135,     0,   759,
     136,   760,   761,   762,   137,   763,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,   764,   145,
       0,   146,   765,   766,   148,     0,   149,   150,   151,   767,
     152,     0,   768,   154,     0,   155,   156,   157,   158,   159,
     769,   770,   160,     0,   161,   162,     0,   771,   164,     0,
     772,   773,   774,   165,     0,     0,   166,   775,   776,     0,
     777,   778,     0,   167,   168,   779,   780,   781,     0,     0,
       0,     0,   782,   171,   783,     0,     0,   784,   785,   172,
       0,   173,     0,     0,     0,   786,   787,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,   788,   182,     0,   789,   790,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,   791,
       0,   191,   792,   192,   793,   794,   193,   194,     0,   795,
     195,   196,   197,   796,     0,   198,     0,     0,   797,     0,
     199,   200,     0,   798,   201,     0,   202,   799,   800,   801,
     802,     0,   803,   804,   204,   805,   806,   807,   206,     0,
     207,   808,     0,   809,   810,     0,   208,   209,     0,   210,
     811,     0,   211,     0,     0,     0,   812,   213,   214,   215,
     813,     0,   216,   217,     0,     0,     0,   218,     0,     0,
     814,   219,  2495,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   816,
     226,     0,     0,   817,   227,     0,   818,   228,     0,     0,
       0,   819,     0,   820,     0,   230,   821,     0,   231,     0,
     232,   822,     0,     0,   823,     0,     0,     0,     0,   824,
     233,   234,   235,   236,   237,   238,   825,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   826,   248,   249,   250,
     827,   251,   252,     0,     0,     0,   253,   254,   255,   828,
     257,     0,     0,   829,   259,   830,   831,   260,     0,   261,
     832,   833,   834,   835,   836,   837,   838,   266,   267,   268,
     269,     0,   839,   270,   271,     0,   272,   273,   274,   840,
     841,   842,   275,     0,   843,   844,     0,   276,   277,     0,
     845,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   846,   847,
     286,   848,   849,   850,   851,   852,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   853,   297,   298,
     299,   300,   301,   302,   303,   854,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,   855,   856,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,   857,   318,   319,   858,   320,   321,   859,
     322,   860,   324,   325,     0,   861,   327,     0,     0,     0,
     328,   329,   330,     0,     0,   331,     0,     0,     0,   332,
     333,   334,   335,     0,   336,   337,   338,     0,     0,     0,
       0,     0,     0,   339,   340,     0,   341,     0,     0,   342,
       0,     0,   343,   344,   862,   863,   345,   346,     0,   347,
     864,   349,   865,   866,   867,   350,   351,   352,   353,   868,
     354,   355,     0,   356,   357,     0,   869,   358,   870,   871,
     872,   873,     0,     0,     0,     0,     0,   363,     0,   364,
     874,   875,   876,   366,   367,   368,     0,   877,   369,   370,
     878,     0,   371,     0,     0,   879,   880,   372,     0,     0,
     373,     0,   374,     0,   881,   376,     0,     0,   882,   883,
     884,   885,   886,   377,     0,     0,   378,   887,     0,   379,
     380,   888,     0,     0,     0,     0,   382,     0,   383,   384,
       0,   889,     0,   890,     0,     0,     0,     0,   891,     0,
       0,     0,   892,   893,     0,     0,     0,     0,   894,     0,
     895,     0,     0,   896,   897,     0,     0,   898,   899,   122,
       0,   754,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   755,     0,   756,   130,   131,   757,
     133,     0,   134,   758,   135,     0,   759,   136,   760,   761,
     762,   137,   763,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,   764,   145,     0,   146,   765,
     766,   148,     0,   149,   150,   151,   767,   152,     0,   768,
     154,     0,   155,   156,   157,   158,   159,   769,   770,   160,
       0,   161,   162,     0,   771,   164,     0,   772,   773,   774,
     165,     0,     0,   166,   775,   776,     0,   777,   778,     0,
     167,   168,   779,   780,   781,     0,     0,     0,     0,   782,
     171,   783,     0,     0,   784,   785,   172,     0,   173,     0,
       0,     0,   786,   787,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
     788,   182,     0,   789,   790,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,   791,     0,   191,   792,
     192,   793,   794,   193,   194,     0,   795,   195,   196,   197,
     796,     0,   198,     0,     0,   797,     0,   199,   200,     0,
     798,   201,     0,   202,   799,   800,   801,   802,     0,   803,
     804,   204,   805,   806,   807,   206,     0,   207,   808,     0,
     809,   810,     0,   208,   209,     0,   210,   811,     0,   211,
       0,     0,     0,   812,   213,   214,   215,   813,     0,   216,
     217,     0,     0,     0,   218,     0,     0,   814,   219,  2568,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   816,   226,     0,     0,
     817,   227,     0,   818,   228,     0,     0,     0,   819,     0,
     820,     0,   230,   821,     0,   231,     0,   232,   822,     0,
       0,   823,     0,     0,     0,     0,   824,   233,   234,   235,
     236,   237,   238,   825,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   826,   248,   249,   250,   827,   251,   252,
       0,     0,     0,   253,   254,   255,   828,   257,     0,     0,
     829,   259,   830,   831,   260,     0,   261,   832,   833,   834,
     835,   836,   837,   838,   266,   267,   268,   269,     0,   839,
     270,   271,     0,   272,   273,   274,   840,   841,   842,   275,
       0,   843,   844,     0,   276,   277,     0,   845,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   846,   847,   286,   848,   849,
     850,   851,   852,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   853,   297,   298,   299,   300,   301,
     302,   303,   854,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,   855,   856,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
     857,   318,   319,   858,   320,   321,   859,   322,   860,   324,
     325,     0,   861,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,   862,   863,   345,   346,     0,   347,   864,   349,   865,
     866,   867,   350,   351,   352,   353,   868,   354,   355,     0,
     356,   357,     0,   869,   358,   870,   871,   872,   873,     0,
       0,     0,     0,     0,   363,     0,   364,   874,   875,   876,
     366,   367,   368,     0,   877,   369,   370,   878,     0,   371,
       0,     0,   879,   880,   372,     0,     0,   373,     0,   374,
       0,   881,   376,     0,     0,   882,   883,   884,   885,   886,
     377,     0,     0,   378,   887,     0,   379,   380,   888,     0,
       0,     0,     0,   382,     0,   383,   384,     0,   889,     0,
     890,     0,     0,     0,     0,   891,     0,     0,     0,   892,
     893,     0,     0,     0,     0,   894,     0,   895,     0,     0,
     896,   897,     0,     0,   898,   899,   122,     0,   754,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   755,     0,   756,   130,   131,   757,   133,     0,   134,
     758,   135,     0,   759,   136,   760,   761,   762,   137,   763,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   764,   145,     0,   146,   765,   766,   148,     0,
     149,   150,   151,   767,   152,     0,   768,   154,     0,   155,
     156,   157,   158,   159,   769,   770,   160,     0,   161,   162,
       0,   771,   164,     0,   772,   773,   774,   165,     0,     0,
     166,   775,   776,     0,   777,   778,     0,   167,   168,   779,
     780,   781,     0,     0,     0,     0,   782,   171,   783,     0,
       0,   784,  2921,   172,     0,   173,     0,     0,     0,   786,
     787,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   788,   182,     0,
     789,   790,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   791,     0,   191,   792,   192,   793,   794,
     193,   194,     0,   795,   195,   196,   197,   796,     0,   198,
       0,     0,   797,     0,   199,   200,     0,   798,   201,     0,
     202,   799,   800,   801,   802,     0,   803,   804,   204,   805,
     806,   807,   206,     0,   207,   808,     0,   809,   810,     0,
     208,   209,     0,   210,   811,     0,   211,     0,     0,     0,
     812,   213,   214,   215,   813,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   814,   219,   815,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   816,   226,     0,     0,   817,   227,     0,
     818,   228,     0,     0,     0,   819,     0,   820,     0,   230,
     821,     0,   231,     0,   232,   822,     0,     0,   823,     0,
       0,     0,     0,   824,   233,   234,   235,   236,   237,   238,
     825,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     826,   248,   249,   250,   827,   251,   252,     0,     0,     0,
     253,   254,   255,   828,   257,     0,     0,   829,   259,   830,
     831,   260,     0,   261,   832,   833,   834,   835,   836,   837,
     838,   266,   267,   268,   269,     0,   839,   270,   271,     0,
     272,   273,   274,   840,   841,   842,   275,     0,   843,   844,
       0,   276,   277,     0,   845,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   846,   847,   286,   848,   849,   850,   851,   852,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   853,   297,   298,   299,   300,   301,   302,   303,   854,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   855,   856,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   857,   318,   319,
     858,   320,   321,   859,   322,   860,   324,   325,     0,   861,
     327,     0,     0,     0,   328,   329,   330,     0,     0,   331,
       0,     0,     0,   332,   333,   334,   335,     0,   336,   337,
     338,     0,     0,     0,     0,     0,     0,   339,   340,     0,
     341,     0,     0,   342,     0,     0,   343,   344,   862,   863,
     345,   346,     0,   347,   864,   349,   865,   866,   867,   350,
     351,   352,   353,   868,   354,   355,     0,   356,   357,     0,
     869,   358,   870,   871,   872,   873,     0,     0,     0,     0,
       0,   363,     0,   364,   874,   875,   876,   366,   367,   368,
       0,   877,   369,   370,   878,     0,   371,     0,     0,   879,
     880,   372,     0,     0,   373,     0,   374,     0,   881,   376,
       0,     0,   882,   883,   884,   885,   886,   377,     0,     0,
     378,   887,     0,   379,   380,   888,     0,     0,     0,     0,
     382,     0,   383,   384,     0,   889,     0,   890,     0,     0,
       0,     0,   891,     0,     0,     0,   892,   893,     0,     0,
       0,     0,   894,     0,   895,     0,     0,   896,   897,     0,
       0,   898,   899,   122,     0,   754,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   755,     0,
     756,   130,   131,   757,   133,     0,   134,   758,   135,     0,
     759,   136,   760,   761,   762,   137,   763,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,   764,
     145,     0,   146,   765,   766,   148,     0,   149,   150,   151,
     767,   152,     0,   768,   154,     0,   155,   156,   157,   158,
     159,   769,   770,   160,     0,   161,   162,     0,   771,   164,
       0,   772,   773,   774,   165,     0,     0,   166,   775,   776,
       0,   777,   778,     0,   167,   168,   779,   780,   781,     0,
       0,     0,     0,   782,   171,   783,     0,     0,   784,   785,
     172,     0,   173,     0,     0,     0,   786,   787,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,   788,   182,     0,   789,   790,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
     791,     0,   191,   792,   192,   793,   794,   193,   194,     0,
     795,   195,   196,   197,   796,     0,   198,     0,     0,   797,
       0,   199,   200,     0,   798,   201,     0,   202,   799,   800,
     801,   802,     0,   803,   804,   204,   805,   806,   807,   206,
       0,   207,   808,     0,   809,   810,     0,   208,   209,     0,
     210,   811,     0,   211,     0,     0,     0,   812,   213,   214,
     215,   813,     0,   216,   217,     0,     0,     0,   218,     0,
       0,   814,   219,   815,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     816,   226,     0,     0,   817,   227,     0,   818,   228,     0,
       0,     0,   819,     0,   820,     0,   230,   821,     0,   231,
       0,   232,   822,     0,     0,   823,     0,     0,     0,     0,
     824,   233,   234,   235,   236,   237,   238,   825,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   826,   248,   249,
     250,   827,   251,   252,     0,     0,     0,   253,   254,   255,
     828,   257,     0,     0,   829,   259,   830,   831,   260,     0,
     261,   832,   833,   834,   835,   836,   837,   838,   266,   267,
     268,   269,     0,   839,   270,   271,     0,   272,   273,   274,
     840,     0,   842,   275,     0,   843,   844,     0,   276,   277,
       0,   845,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   846,
     847,   286,   848,   849,   850,   851,   852,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   853,   297,
     298,   299,   300,   301,   302,   303,   854,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,   855,   856,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,   857,   318,   319,   858,   320,   321,
     859,   322,   860,   324,   325,     0,   861,   327,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,   333,   334,   335,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,   343,   344,   862,   863,   345,   346,     0,
     347,   864,   349,   865,   866,   867,   350,   351,   352,   353,
     868,   354,   355,     0,   356,   357,     0,   869,   358,   870,
     871,   872,   873,     0,     0,     0,     0,     0,   363,     0,
     364,   874,   875,   876,   366,   367,   368,     0,   877,   369,
     370,   878,     0,   371,     0,     0,   879,   880,   372,     0,
       0,   373,     0,   374,     0,   881,   376,     0,     0,   882,
     883,   884,   885,   886,   377,     0,     0,   378,   887,     0,
     379,   380,   888,     0,     0,     0,     0,   382,     0,   383,
     384,     0,   889,     0,   890,     0,     0,     0,     0,   891,
       0,     0,     0,   892,   893,     0,     0,     0,     0,   894,
       0,   895,     0,     0,   896,   897,     0,     0,   898,   899,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,  1982,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,  1983,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,  1119,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,  1120,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,  2480,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,  1892,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,   333,   334,
     335,     0,   336,   337,   338,  1984,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
     343,   344,     0,     0,   345,   346,     0,   347,   348,   349,
       0,     0,     0,   350,   351,   352,   353,     0,   354,   355,
       0,   356,   357,     0,     0,   358,   359,   360,   361,   362,
       0,     0,     0,     0,     0,   363,     0,   364,     0,     0,
     365,   366,   367,   368,     0,     0,   369,   370,     0,     0,
     371,     0,     0,     0,     0,   372,     0,     0,   373,     0,
     374,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,   379,   380,   381,
       0,     0,     0,     0,   382,     0,   383,   384,     0,     0,
     122,   385,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,  2031,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,  1982,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,  1983,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,  1119,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,  1120,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,   333,   334,
     335,     0,   336,   337,   338,  1984,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
     343,   344,     0,     0,   345,   346,     0,   347,   348,   349,
       0,     0,     0,   350,   351,   352,   353,     0,   354,   355,
       0,   356,   357,     0,     0,   358,   359,   360,   361,   362,
       0,     0,     0,     0,     0,   363,     0,   364,     0,     0,
     365,   366,   367,   368,     0,     0,   369,   370,     0,     0,
     371,     0,     0,     0,     0,   372,     0,     0,   373,     0,
     374,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,   379,   380,   381,
       0,     0,     0,     0,   382,     0,   383,   384,     0,     0,
     122,   385,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,  2031,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,  1892,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,   333,   334,
     335,     0,   336,   337,   338,     0,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
     343,   344,     0,     0,   345,   346,     0,   347,   348,   349,
       0,     0,     0,   350,   351,   352,   353,     0,   354,   355,
       0,   356,   357,     0,     0,   358,   359,   360,   361,   362,
       0,     0,     0,     0,     0,   363,     0,   364,     0,     0,
     365,   366,   367,   368,     0,     0,   369,   370,     0,     0,
     371,     0,     0,     0,     0,   372,     0,     0,   373,     0,
     374,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,   379,   380,   381,
       0,     0,     0,     0,   382,     0,   383,   384,     0,     0,
       0,   385,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,  2299,
     130,   131,   132,   133,     0,   134,   899,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,   161,   162,     0,   163,   164,     0,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,   171,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,     0,   182,     0,     0,     0,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,     0,
       0,   191,     0,   192,     0,     0,   193,   194,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,   208,   209,     0,   210,
       0,     0,   211,     0,     0,     0,   212,   213,   214,   215,
       0,     0,   216,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,     0,
     226,     0,     0,     0,   227,     0,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,     0,
       0,     0,   275,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,     0,     0,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,     0,   320,   321,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
     328,   329,   330,     0,     0,   331,     0,     0,     0,   332,
     333,   334,   335,     0,   336,   337,   338,     0,     0,     0,
       0,     0,     0,   339,   340,     0,   341,     0,     0,   342,
       0,     0,   343,   344,     0,     0,   345,   346,     0,   347,
     348,   349,     0,     0,     0,   350,   351,   352,   353,     0,
     354,   355,     0,   356,   357,     0,     0,   358,   359,   360,
     361,   362,     0,     0,     0,     0,     0,   363,     0,   364,
       0,     0,   365,   366,   367,   368,     0,     0,   369,   370,
       0,     0,   371,     0,     0,     0,     0,   372,     0,     0,
     373,     0,   374,     0,   375,   376,     0,     0,     0,     0,
       0,     0,     0,   377,     0,     0,   378,     0,     0,   379,
     380,   381,     0,     0,     0,     0,   382,     0,   383,   384,
       0,     0,     0,   385,     0,     0,     0,     0,     0,     0,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,  3663,     0,   128,     0,     0,   129,  3664,   899,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,   992,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,   328,
     329,   330,     0,     0,   331,     0,     0,     0,   332,   333,
     334,   335,     0,   336,   337,   338,     0,     0,     0,     0,
       0,     0,   339,   340,     0,   341,     0,     0,   342,     0,
       0,   343,   344,     0,     0,   345,   346,     0,   347,   348,
     349,     0,     0,     0,   350,   351,   352,   353,     0,   354,
     355,     0,   356,   357,     0,     0,   358,   359,   360,   361,
     362,     0,     0,     0,     0,     0,   363,     0,   364,     0,
       0,   365,   366,   367,   368,     0,     0,   369,   370,     0,
       0,   371,     0,     0,     0,     0,   372,     0,     0,   373,
       0,   374,     0,   375,   376,     0,     0,     0,     0,     0,
       0,     0,   377,     0,     0,   378,     0,     0,   379,   380,
     381,     0,     0,     0,     0,   382,     0,   383,   384,     0,
       0,   122,   385,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,   421,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,   328,
     329,   330,     0,     0,   331,     0,     0,     0,   332,   333,
     334,   335,     0,   336,   337,   338,     0,     0,     0,     0,
       0,     0,   339,   340,     0,   341,     0,     0,   342,     0,
       0,   343,   344,     0,     0,   345,   346,     0,   347,   348,
     349,     0,     0,     0,   350,   351,   352,   353,     0,   354,
     355,     0,   356,   357,     0,     0,   358,   359,   360,   361,
     362,     0,     0,     0,     0,     0,   363,     0,   364,     0,
       0,   365,   366,   367,   368,     0,     0,   369,   370,     0,
       0,   371,     0,     0,     0,     0,   372,     0,     0,   373,
       0,   374,     0,   375,   376,     0,     0,     0,     0,     0,
       0,     0,   377,     0,     0,   378,     0,     0,   379,   380,
     381,     0,     0,     0,     0,   382,     0,   383,   384,     0,
       0,     0,   385,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,  1851,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,   421,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,   161,   162,     0,   163,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,   171,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,   208,   209,     0,
     210,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
       0,   226,     0,     0,     0,   227,     0,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,   275,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,     0,     0,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,     0,   320,   321,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,   333,   334,   335,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,   343,   344,     0,     0,   345,   346,     0,
     347,   348,   349,     0,     0,     0,   350,   351,   352,   353,
       0,   354,   355,     0,   356,   357,     0,     0,   358,   359,
     360,   361,   362,     0,     0,     0,     0,     0,   363,     0,
     364,     0,     0,   365,   366,   367,   368,     0,     0,   369,
     370,     0,     0,   371,     0,     0,     0,     0,   372,     0,
       0,   373,     0,   374,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,     0,     0,   378,     0,     0,
     379,   380,   381,     0,     0,     0,     0,   382,     0,   383,
     384,     0,     0,     0,   385,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,  2030,     0,   130,   131,   132,   133,     0,   134,  2031,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,     0,   385,     0,     0,     0,
       0,     0,     0,     0,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
    3664,   899,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,   333,   334,   335,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,   343,   344,     0,     0,   345,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,     0,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,   365,   366,   367,   368,     0,     0,
     369,   370,     0,     0,   371,     0,     0,     0,     0,   372,
       0,     0,   373,     0,   374,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,     0,     0,     0,     0,   382,     0,
     383,   384,     0,     0,   122,   385,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
     421,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   476,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,   333,   334,   335,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,   343,   344,     0,     0,   345,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,     0,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,   365,   366,   367,   368,     0,     0,
     369,   370,     0,     0,   371,     0,     0,     0,     0,   372,
       0,     0,   373,     0,   374,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,     0,     0,     0,     0,   382,     0,
     383,   384,     0,     0,   122,   385,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
     421,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,   333,   334,   335,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,   343,   344,     0,     0,   345,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,     0,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,   365,   366,   367,   368,     0,     0,
     369,   370,     0,     0,   371,     0,     0,     0,     0,   372,
       0,     0,   373,     0,   374,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,     0,     0,     0,     0,   382,     0,
     383,   384,     0,     0,   122,   385,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
     899,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,   333,   334,   335,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,   343,   344,     0,     0,   345,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,     0,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,   365,   366,   367,   368,     0,     0,
     369,   370,     0,     0,   371,     0,     0,     0,     0,   372,
       0,     0,   373,     0,   374,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,     0,     0,     0,     0,   382,     0,
     383,   384,     0,     0,   122,   385,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
    2031,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     564,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,   333,   334,   335,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,   343,   344,     0,     0,   345,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,   565,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,   365,   366,   367,   368,     0,     0,
     369,   370,     0,     0,   371,     0,     0,     0,     0,   372,
       0,     0,   373,     0,   374,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,     0,     0,     0,     0,   382,     0,
     383,   384,     0,     0,     0,   385,     0,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,  1792,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,     0,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,     0,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,   564,     0,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,   328,   329,   330,     0,     0,
     331,     0,     0,     0,   332,   333,   334,   335,     0,   336,
     337,   338,     0,     0,     0,     0,     0,     0,   339,   340,
       0,   341,     0,     0,   342,     0,     0,   343,   344,     0,
       0,   345,   346,     0,   347,   348,   349,     0,     0,     0,
     350,   351,   352,   353,     0,   354,   355,     0,   356,   357,
       0,   565,   358,   359,   360,   361,   362,     0,     0,     0,
       0,     0,   363,     0,   364,     0,     0,   365,   366,   367,
     368,     0,     0,   369,   370,     0,     0,   371,     0,     0,
       0,     0,   372,     0,     0,   373,     0,   374,     0,   375,
     376,     0,     0,     0,     0,     0,     0,     0,   377,     0,
       0,   378,     0,     0,   379,   380,   381,     0,     0,     0,
       0,   382,     0,   383,   384,     0,     0,     0,   385,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,  2339,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,   564,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,   333,   334,
     335,     0,   336,   337,   338,     0,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
     343,   344,     0,     0,   345,   346,     0,   347,   348,   349,
       0,     0,     0,   350,   351,   352,   353,     0,   354,   355,
       0,   356,   357,     0,   565,   358,   359,   360,   361,   362,
       0,     0,     0,     0,     0,   363,     0,   364,     0,     0,
     365,   366,   367,   368,     0,     0,   369,   370,     0,     0,
     371,     0,     0,     0,     0,   372,     0,     0,   373,     0,
     374,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,   379,   380,   381,
       0,     0,     0,     0,   382,     0,   383,   384,     0,     0,
       0,   385,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,  2944,  -230,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,     0,     0,     0,     0,   144,     0,
     145,     0,   146,     0,     0,     0,     0,   149,   150,  3501,
       0,   152,     0,   153,   154,     0,     0,   156,     0,   158,
     159,     0,     0,   160,     0,   161,   162,     0,     0,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,     0,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,     0,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,     0,
     184,   185,   186,     0,     0,   187,     0,   188,   189,     0,
       0,     0,   191,     0,   192,     0,     0,   193,   194,  3502,
       0,   195,   196,   197,     0,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,     0,   209,     0,
       0,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,  3503,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,  3504,     0,     0,     0,     0,     0,     0,
       0,   226,     0,     0,     0,   227,  3505,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,  -183,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,  3506,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,     0,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
       0,   311,  -183,     0,   312,     0,     0,   314,     0,     0,
     316,   317,  3507,     0,     0,     0,   319,     0,   320,   321,
       0,   322,   323,   324,     0,     0,   326,     0,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,     0,   334,     0,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,     0,   344,     0,     0,     0,   346,     0,
     347,   348,   349,     0,     0,     0,   350,   351,   352,   353,
       0,   354,   355,     0,   356,   357,     0,     0,   358,   359,
     360,   361,   362,     0,     0,     0,     0,     0,   363,     0,
     364,     0,     0,     0,   366,   367,   368,     0,     0,   369,
     370,     0,     0,     0,     0,     0,     0,     0,   372,     0,
       0,   373,     0,     0,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,     0,     0,   378,     0,     0,
     379,   380,   381,     0,     0,  -183,     0,   382,     0,   383,
       0,     0,     0,     0,   385,     0,     0,     0,     0,  3508,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,  3715,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,   333,   334,
     335,     0,   336,   337,   338,     0,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
     343,   344,     0,     0,   345,   346,     0,   347,   348,   349,
       0,     0,     0,   350,   351,   352,   353,     0,   354,   355,
       0,   356,   357,     0,     0,   358,   359,   360,   361,   362,
       0,     0,     0,     0,     0,   363,     0,   364,     0,     0,
     365,   366,   367,   368,     0,     0,   369,   370,     0,     0,
     371,     0,     0,     0,     0,   372,     0,     0,   373,     0,
     374,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,   379,   380,   381,
       0,     0,     0,     0,   382,     0,   383,   384,     0,     0,
       0,   385,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,  1633,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,   161,   162,     0,   163,   164,     0,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,   171,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,     0,   182,     0,     0,     0,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,     0,
       0,   191,     0,   192,     0,     0,   193,   194,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,   208,   209,     0,   210,
       0,     0,   211,     0,     0,     0,   212,   213,   214,   215,
       0,     0,   216,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,     0,
     226,     0,     0,     0,   227,     0,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,     0,
       0,     0,   275,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,     0,     0,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,     0,   320,   321,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
     328,   329,   330,     0,     0,   331,     0,     0,     0,   332,
     333,   334,   335,     0,   336,   337,   338,     0,     0,     0,
       0,     0,     0,   339,   340,     0,   341,     0,     0,   342,
       0,     0,   343,   344,     0,     0,   345,   346,     0,   347,
     348,   349,     0,     0,     0,   350,   351,   352,   353,     0,
     354,   355,     0,   356,   357,     0,     0,   358,   359,   360,
     361,   362,     0,     0,     0,     0,     0,   363,     0,   364,
       0,     0,   365,   366,   367,   368,     0,     0,   369,   370,
       0,     0,   371,     0,     0,     0,     0,   372,     0,     0,
     373,     0,   374,     0,   375,   376,     0,     0,     0,     0,
       0,     0,     0,   377,     0,     0,   378,     0,     0,   379,
     380,   381,     0,     0,     0,     0,   382,     0,   383,   384,
       0,     0,     0,   385,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,  2325,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,   333,   334,   335,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,   343,   344,     0,     0,   345,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,     0,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,   365,   366,   367,   368,     0,     0,
     369,   370,     0,     0,   371,     0,     0,     0,     0,   372,
       0,     0,   373,     0,   374,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,     0,     0,     0,     0,   382,     0,
     383,   384,     0,     0,     0,   385,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,  2619,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,   328,   329,   330,     0,     0,   331,
       0,     0,     0,   332,   333,   334,   335,     0,   336,   337,
     338,     0,     0,     0,     0,     0,     0,   339,   340,     0,
     341,     0,     0,   342,     0,     0,   343,   344,     0,     0,
     345,   346,     0,   347,   348,   349,     0,     0,     0,   350,
     351,   352,   353,     0,   354,   355,     0,   356,   357,     0,
       0,   358,   359,   360,   361,   362,     0,     0,     0,     0,
       0,   363,     0,   364,     0,     0,   365,   366,   367,   368,
       0,     0,   369,   370,     0,     0,   371,     0,     0,     0,
       0,   372,     0,     0,   373,     0,   374,     0,   375,   376,
       0,     0,     0,     0,     0,     0,     0,   377,     0,     0,
     378,     0,     0,   379,   380,   381,     0,     0,     0,     0,
     382,     0,   383,   384,     0,     0,     0,   385,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,  2949,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -230,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,     0,
       0,     0,     0,   144,     0,   145,     0,   146,     0,     0,
       0,     0,   149,   150,  3501,     0,   152,     0,   153,   154,
       0,     0,   156,     0,   158,   159,     0,     0,   160,     0,
     161,   162,     0,     0,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,     0,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,     0,     0,     0,   179,   180,   181,     0,  -200,     0,
     182,     0,     0,     0,  -200,   184,   185,   186,     0,     0,
     187,     0,   188,   189,     0,     0,     0,   191,     0,   192,
       0,     0,   193,   194,  3502,     0,   195,   196,   197,     0,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,     0,   209,     0,     0,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,  3503,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,  3504,     0,
       0,     0,     0,     0,     0,     0,   226,     0,     0,     0,
     227,  3505,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,  -183,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
    3506,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,     0,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,     0,   311,  -183,     0,   312,
       0,     0,   314,     0,     0,   316,   317,  3507,     0,     0,
       0,   319,     0,   320,   321,     0,   322,   323,   324,     0,
       0,   326,     0,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,     0,   334,     0,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,     0,   344,
       0,     0,     0,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,     0,   366,
     367,   368,     0,     0,   369,   370,     0,     0,     0,     0,
       0,     0,     0,   372,     0,     0,   373,     0,     0,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
    -183,     0,   382,     0,   383,     0,     0,     0,     0,   385,
       0,     0,  -200,   122,  3508,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -230,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,     0,     0,     0,     0,   144,     0,
     145,     0,   146,     0,     0,     0,     0,   149,   150,  3501,
       0,   152,     0,   153,   154,     0,     0,   156,     0,   158,
     159,     0,     0,   160,     0,   161,   162,     0,     0,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,     0,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,     0,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,  -221,
     184,   185,   186,     0,     0,   187,     0,   188,   189,     0,
       0,     0,   191,     0,   192,     0,     0,   193,   194,  3502,
       0,   195,   196,   197,     0,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,     0,   209,     0,
       0,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,  3503,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,  3504,     0,     0,     0,     0,     0,     0,
       0,   226,     0,     0,     0,   227,  3505,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,  -183,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,  3506,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,     0,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
       0,   311,  -183,     0,   312,     0,     0,   314,     0,     0,
     316,   317,  3507,     0,     0,     0,   319,     0,   320,   321,
       0,   322,   323,   324,     0,     0,   326,     0,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,     0,   334,     0,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,     0,   344,     0,     0,     0,   346,     0,
     347,   348,   349,     0,     0,     0,   350,   351,   352,   353,
       0,   354,   355,     0,   356,   357,     0,     0,   358,   359,
     360,   361,   362,     0,     0,     0,     0,     0,   363,     0,
     364,     0,     0,     0,   366,   367,   368,     0,     0,   369,
     370,     0,     0,     0,     0,     0,     0,     0,   372,     0,
       0,   373,     0,     0,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,     0,     0,   378,     0,     0,
     379,   380,   381,  -221,     0,  -183,     0,   382,     0,   383,
       0,     0,     0,     0,   385,     0,     0,  -221,   122,  3508,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -230,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,     0,
       0,     0,     0,   144,     0,   145,     0,   146,     0,     0,
       0,     0,   149,   150,  3501,     0,   152,     0,   153,   154,
       0,     0,   156,     0,   158,   159,     0,     0,   160,     0,
     161,   162,     0,     0,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,     0,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,     0,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,  -218,   184,   185,   186,     0,     0,
     187,     0,   188,   189,     0,     0,     0,   191,     0,   192,
       0,     0,   193,   194,  3502,     0,   195,   196,   197,     0,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,     0,   209,     0,     0,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,  3503,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,  3504,     0,
       0,     0,     0,     0,     0,     0,   226,     0,     0,     0,
     227,  3505,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,  -183,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
    3506,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,     0,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,     0,   311,  -183,     0,   312,
       0,     0,   314,     0,     0,   316,   317,  3507,     0,     0,
       0,   319,     0,   320,   321,     0,   322,   323,   324,     0,
       0,   326,     0,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,     0,   334,     0,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,     0,   344,
       0,     0,     0,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,     0,   366,
     367,   368,     0,     0,   369,   370,     0,     0,     0,     0,
       0,     0,     0,   372,     0,     0,   373,     0,     0,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,  -218,     0,
    -183,     0,   382,     0,   383,     0,     0,     0,     0,   385,
       0,     0,  -218,   122,  3508,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -230,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,     0,     0,     0,     0,   144,     0,
     145,     0,   146,     0,     0,     0,     0,   149,   150,  3501,
       0,   152,     0,   153,   154,     0,     0,   156,     0,   158,
     159,     0,     0,   160,     0,   161,   162,     0,     0,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,     0,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,     0,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,  3592,
     184,   185,   186,     0,     0,   187,     0,   188,   189,     0,
       0,     0,   191,     0,   192,     0,     0,   193,   194,  3502,
       0,   195,   196,   197,     0,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,     0,   209,     0,
       0,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,  3503,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,  3504,     0,     0,     0,     0,     0,     0,
       0,   226,     0,     0,     0,   227,  3505,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,  -183,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,  3506,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,     0,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
       0,   311,  -183,     0,   312,     0,     0,   314,     0,     0,
     316,   317,  3507,     0,     0,     0,   319,     0,   320,   321,
       0,   322,   323,   324,     0,     0,   326,     0,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,     0,   334,     0,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,     0,   344,     0,     0,     0,   346,     0,
     347,   348,   349,     0,     0,     0,   350,   351,   352,   353,
       0,   354,   355,     0,   356,   357,     0,     0,   358,   359,
     360,   361,   362,     0,     0,     0,     0,     0,   363,     0,
     364,     0,     0,     0,   366,   367,   368,     0,     0,   369,
     370,     0,     0,     0,     0,     0,     0,     0,   372,     0,
       0,   373,     0,     0,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,     0,     0,   378,     0,     0,
     379,   380,   381,     0,     0,  -183,     0,   382,     0,   383,
       0,     0,     0,     0,   385,     0,     0,     0,   122,  3508,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -230,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,     0,
       0,     0,     0,   144,     0,   145,     0,   146,     0,     0,
       0,     0,   149,   150,  3501,     0,   152,     0,   153,   154,
       0,     0,   156,     0,   158,   159,     0,     0,   160,     0,
     161,   162,     0,     0,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,     0,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,     0,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,  -223,   184,   185,   186,     0,     0,
     187,     0,   188,   189,     0,     0,     0,   191,     0,   192,
       0,     0,   193,   194,  3502,     0,   195,   196,   197,     0,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,     0,   209,     0,     0,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,  3503,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,  3504,     0,
       0,     0,     0,     0,     0,     0,   226,     0,     0,     0,
     227,  3505,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,  -183,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
    3506,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,     0,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,     0,   311,  -183,     0,   312,
       0,     0,   314,     0,     0,   316,   317,  3507,     0,     0,
       0,   319,     0,   320,   321,     0,   322,   323,   324,     0,
       0,   326,     0,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,     0,   334,     0,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,     0,   344,
       0,     0,     0,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,     0,   366,
     367,   368,     0,     0,   369,   370,     0,     0,     0,     0,
       0,     0,     0,   372,     0,     0,   373,     0,     0,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
    -183,     0,   382,     0,   383,     0,     0,     0,     0,   385,
       0,     0,     0,   122,  3508,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -230,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,     0,     0,     0,     0,   144,     0,
     145,     0,   146,     0,     0,     0,     0,   149,   150,  3501,
       0,   152,     0,   153,   154,     0,     0,   156,     0,   158,
     159,     0,     0,   160,     0,   161,   162,     0,     0,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,     0,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,     0,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,  3643,
     184,   185,   186,     0,     0,   187,     0,   188,   189,     0,
       0,     0,   191,     0,   192,     0,     0,   193,   194,  3502,
       0,   195,   196,   197,     0,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,     0,   209,     0,
       0,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,  3503,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,  3504,     0,     0,     0,     0,     0,     0,
       0,   226,     0,     0,     0,   227,  3505,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,  -183,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,  3506,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,     0,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
       0,   311,  -183,     0,   312,     0,     0,   314,     0,     0,
     316,   317,  3507,     0,     0,     0,   319,     0,   320,   321,
       0,   322,   323,   324,     0,     0,   326,     0,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,     0,   334,     0,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,     0,   344,     0,     0,     0,   346,     0,
     347,   348,   349,     0,     0,     0,   350,   351,   352,   353,
       0,   354,   355,     0,   356,   357,     0,     0,   358,   359,
     360,   361,   362,     0,     0,     0,     0,     0,   363,     0,
     364,     0,     0,     0,   366,   367,   368,     0,     0,   369,
     370,     0,     0,     0,     0,     0,     0,     0,   372,     0,
       0,   373,     0,     0,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,     0,     0,   378,     0,     0,
     379,   380,   381,     0,     0,  -183,     0,   382,     0,   383,
       0,     0,     0,     0,   385,     0,     0,     0,   122,  3508,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -230,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,     0,
       0,     0,     0,   144,     0,   145,     0,   146,     0,     0,
       0,     0,   149,   150,  3501,     0,   152,     0,   153,   154,
       0,     0,   156,     0,   158,   159,     0,     0,   160,     0,
     161,   162,     0,     0,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,     0,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,     0,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,  3676,   184,   185,   186,     0,     0,
     187,     0,   188,   189,     0,     0,     0,   191,     0,   192,
       0,     0,   193,   194,  3502,     0,   195,   196,   197,     0,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,     0,   209,     0,     0,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,  3503,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,  3504,     0,
       0,     0,     0,     0,     0,     0,   226,     0,     0,     0,
     227,  3505,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,  -183,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
    3506,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,     0,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,     0,   311,  -183,     0,   312,
       0,     0,   314,     0,     0,   316,   317,  3507,     0,     0,
       0,   319,     0,   320,   321,     0,   322,   323,   324,     0,
       0,   326,     0,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,     0,   334,     0,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,     0,   344,
       0,     0,     0,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,     0,   366,
     367,   368,     0,     0,   369,   370,     0,     0,     0,     0,
       0,     0,     0,   372,     0,     0,   373,     0,     0,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
    -183,     0,   382,     0,   383,     0,     0,     0,     0,   385,
       0,     0,     0,   122,  3508,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -230,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,     0,     0,     0,     0,   144,     0,
     145,     0,   146,     0,     0,     0,     0,   149,   150,  3501,
       0,   152,     0,   153,   154,     0,     0,   156,     0,   158,
     159,     0,     0,   160,     0,   161,   162,     0,     0,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,     0,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,     0,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,  -204,
     184,   185,   186,     0,     0,   187,     0,   188,   189,     0,
       0,     0,   191,     0,   192,     0,     0,   193,   194,  3502,
       0,   195,   196,   197,     0,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,     0,   209,     0,
       0,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,  3503,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,  3504,     0,     0,     0,     0,     0,     0,
       0,   226,     0,     0,     0,   227,  3505,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,  -183,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,  3506,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,     0,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
       0,   311,  -183,     0,   312,     0,     0,   314,     0,     0,
     316,   317,  3507,     0,     0,     0,   319,     0,   320,   321,
       0,   322,   323,   324,     0,     0,   326,     0,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,     0,   334,     0,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,     0,   344,     0,     0,     0,   346,     0,
     347,   348,   349,     0,     0,     0,   350,   351,   352,   353,
       0,   354,   355,     0,   356,   357,     0,     0,   358,   359,
     360,   361,   362,     0,     0,     0,     0,     0,   363,     0,
     364,     0,     0,     0,   366,   367,   368,     0,     0,   369,
     370,     0,     0,     0,     0,     0,     0,     0,   372,     0,
       0,   373,     0,     0,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,     0,     0,   378,     0,     0,
     379,   380,   381,     0,     0,  -183,     0,   382,     0,   383,
       0,     0,     0,     0,   385,     0,     0,     0,   122,  3508,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -230,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,     0,
       0,     0,     0,   144,     0,   145,     0,   146,     0,     0,
       0,     0,   149,   150,  3501,     0,   152,     0,   153,   154,
       0,     0,   156,     0,   158,   159,     0,     0,   160,     0,
     161,   162,     0,     0,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,     0,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,     0,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,     0,   184,   185,   186,     0,     0,
     187,     0,   188,   189,     0,     0,     0,   191,     0,   192,
       0,     0,   193,   194,  3502,     0,   195,   196,   197,     0,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,     0,   209,     0,     0,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,  3503,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,  3504,     0,
       0,     0,     0,     0,     0,     0,   226,     0,     0,     0,
     227,  3505,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,  -183,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
    3506,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,     0,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,     0,   311,  -183,     0,   312,
       0,     0,   314,     0,     0,   316,   317,  3507,     0,     0,
       0,   319,     0,   320,   321,     0,   322,   323,   324,     0,
       0,   326,     0,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,     0,   334,     0,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,     0,   344,
       0,     0,     0,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,     0,   366,
     367,   368,     0,     0,   369,   370,     0,     0,     0,     0,
       0,     0,     0,   372,     0,     0,   373,     0,     0,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
    -183,     0,   382,     0,   383,     0,     0,     0,     0,   385,
       0,     0,     0,   122,  3508,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -230,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,     0,     0,     0,     0,   144,     0,
     145,     0,   146,     0,     0,     0,     0,   149,   150,  3501,
       0,   152,     0,   153,   154,     0,     0,   156,     0,   158,
     159,     0,     0,   160,     0,   161,   162,     0,     0,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,     0,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,     0,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,     0,
     184,   185,   186,     0,     0,   187,     0,   188,   189,     0,
       0,     0,   191,     0,   192,     0,     0,   193,   194,  3502,
       0,   195,   196,   197,     0,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,     0,   209,     0,
       0,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,  3503,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,  3504,     0,     0,     0,     0,     0,     0,
       0,   226,     0,     0,     0,   227,  3505,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,  -183,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,  3506,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,     0,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
       0,   311,  -183,     0,   312,     0,     0,   314,     0,     0,
     316,   317,  3507,     0,     0,     0,   319,     0,   320,   321,
       0,   322,   323,   324,     0,     0,   326,     0,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,     0,   334,     0,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,     0,   344,     0,     0,     0,   346,     0,
     347,   348,   349,     0,     0,     0,   350,   351,   352,   353,
       0,   354,   355,     0,   356,   357,     0,     0,   358,   359,
     360,   361,   362,     0,     0,     0,     0,     0,   363,     0,
     364,     0,     0,     0,   366,   367,   368,     0,     0,   369,
     370,     0,     0,     0,     0,     0,     0,     0,   372,     0,
       0,  3595,     0,     0,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,     0,     0,   378,     0,     0,
     379,   380,   381,     0,     0,  -183,     0,   382,     0,   383,
       0,     0,     0,     0,   385,     0,     0,     0,   122,  3508,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
    1643,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,  1644,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,  1645,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
    1646,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,   717,   718,     0,   275,     0,
       0,  1647,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,  3703,  3694,  3704,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,  1648,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,  2331,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,  2332,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,  1969,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,   564,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
    1970,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,   565,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,  2341,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,  2342,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,   564,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,   565,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,  2331,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,  2332,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,   564,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,   565,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,   721,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,   564,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,   565,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,   672,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,   673,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,   674,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,  2380,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,   564,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,   565,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,  2331,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,   564,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,   565,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,   564,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,   565,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,  2321,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,   565,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,  3638,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,  3639,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,   748,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,  1115,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,  1917,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,  1918,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,  2037,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,   565,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,  1917,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,  1420,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,  1421,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,   122,   385,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,     0,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,     0,
       0,     0,     0,   144,     0,   145,     0,   146,     0,     0,
       0,     0,   149,   150,     0,     0,   152,     0,   153,   154,
       0,     0,   156,     0,   158,   159,     0,     0,   160,     0,
     161,   162,     0,     0,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,     0,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,     0,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,     0,   184,   185,   186,     0,     0,
     187,     0,   188,   189,     0,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,     0,   209,     0,     0,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,     0,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,     0,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,     0,   311,     0,     0,   312,
       0,     0,   314,     0,     0,   316,   317,     0,     0,     0,
       0,   319,     0,   320,   321,     0,   322,   323,   324,     0,
       0,   326,     0,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,     0,   334,     0,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,     0,   344,
       0,     0,     0,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,     0,   366,
     367,   368,     0,     0,   369,   370,     0,     0,     0,     0,
       0,     0,     0,   372,     0,     0,   373,     0,     0,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,     0,     0,     0,     0,   385
};

static const yytype_int16 yycheck[] =
{
       7,   470,   503,   508,   509,   450,   911,  1314,   605,   775,
     776,   777,    19,   425,   688,    22,   630,   781,   628,   529,
    1314,  1188,    29,   978,   759,   653,  1786,  1031,  1224,  1973,
    1093,  1339,    39,  2357,  1920,  1921,  1922,  1869,  1346,   653,
    1927,  1400,    49,    22,   654,  2098,  1542,  1629,  1951,  1896,
    1222,   581,  2105,  1190,  1191,  1192,  1959,  2080,  1961,  1555,
    2306,  2720,  1108,  2401,  1216,     3,  1203,  1958,   692,     3,
    1058,  1508,  2697,   692,  1934,  1935,   842,   587,     7,  1911,
      87,  1069,  1070,  1358,  1359,     3,  2705,    49,    32,  1988,
      11,     3,     3,  1195,  1196,   457,  1198,     3,     3,     3,
     107,   108,   868,   110,  1256,  1992,   870,  2750,    87,   873,
    2753,    16,    18,    16,   121,  1982,   882,   883,   884,  1278,
    1257,  1988,  1101,  1260,  1991,  2012,  2013,  1994,     3,  2772,
       3,  1233,    15,    16,   513,  2778,    56,    18,  2005,  2006,
    1456,  1522,   121,   115,    15,    16,  1248,  2014,  2981,    27,
      66,  1288,  1289,    55,    56,   156,  1293,   892,   893,   894,
    2077,    59,    11,   175,  1266,  1267,  1268,    54,    10,   904,
     229,   205,  2815,    94,    69,  1277,  1313,  1632,  1315,   108,
      60,   110,   147,    77,    34,  2988,   696,    18,  1347,  1634,
     107,  1350,  1351,  1352,  1353,    95,  1355,  1356,  1357,  1358,
    1359,  1360,  1361,  1362,  1363,   289,    20,   111,    15,    16,
      89,    32,    63,    61,   214,    15,    16,   629,    32,    15,
      16,   655,   727,   728,   729,    18,  2073,    52,  1183,   509,
     592,   270,    46,   129,   135,   252,   111,   156,   111,   145,
     347,    55,    56,    15,    16,    20,    58,    63,    34,   166,
       8,    15,    16,   113,    58,    15,    16,    32,   179,   269,
     344,   253,   341,   112,   145,   175,    44,    15,    16,   156,
     236,    46,   159,  1983,  1984,   130,   402,    75,   111,   324,
      55,    56,  3422,   491,   253,   172,    94,    15,    16,   115,
      96,   499,   500,   214,   131,    20,    15,    16,   489,   344,
     430,    15,    16,   214,    20,  2930,   466,    32,  1213,  3142,
      15,    16,    15,    16,   145,   253,    15,    16,   172,   253,
      97,    46,   530,   100,  1957,   489,    15,    16,    49,    18,
      55,    56,    59,   413,  2299,   253,   234,   572,   430,    55,
      56,   253,   107,  2632,    15,    16,   287,  2293,    58,    50,
     267,   390,   145,   203,   217,    15,    16,    58,   170,   258,
     352,  1943,  2008,    15,    16,   107,   170,   549,   548,  3012,
     407,   179,  2710,    15,    16,   238,   113,   175,  3021,   539,
    2026,   382,   175,   352,   575,   511,    37,    15,    16,    15,
      16,   599,  1297,   217,   404,   575,  1301,   223,  3041,    15,
      16,   166,   903,  3046,   411,   405,   164,  1081,   262,  3068,
     270,   217,   299,  2702,   421,  3555,   580,   203,   425,   321,
     330,   338,   200,   430,  1591,  1035,   169,   175,   435,  1596,
    2376,   236,   466,  1043,   352,  1602,   671,   336,  1605,   270,
     352,    15,    16,   573,   249,   426,   412,   577,   217,   411,
     457,   430,  1907,   374,  2340,   445,    15,    16,  3077,   361,
     376,  1071,  1072,   382,   744,  2409,   287,   204,   475,   238,
      49,   214,   270,  2364,   581,  1239,    64,  1101,   485,  1093,
     351,   573,  1101,   354,   491,   530,  2372,   381,  1018,   573,
     497,   699,   499,   500,   405,   382,   575,   504,   505,  2398,
    2082,   581,   267,  1640,   337,   354,   485,   234,   515,  3134,
     335,   550,   519,  2412,  1502,   175,   575,   524,   525,   356,
     527,   528,   529,   530,   516,   267,  1036,   528,  3331,   546,
    1576,  2398,   374,   270,  2030,   156,  1160,   547,   575,   418,
     436,  1160,   390,  1307,   351,  2412,  3379,   354,    15,    16,
     158,   351,   524,  3172,   354,   351,   563,   258,   354,   390,
     372,    15,    16,   575,   485,   445,   374,   483,   372,  1950,
     982,  2488,   579,   338,   575,   430,   474,  2073,   543,   351,
     587,   588,   354,  1113,  1721,   592,   502,   351,  1725,  1896,
     354,   351,   599,   510,   354,   498,   338,  1913,   527,   528,
     579,   175,  1896,   351,   331,   349,   354,   969,   546,   588,
    2934,   416,   546,   575,  1349,   466,   511,   498,   538,   461,
     498,  1758,   629,   351,  2079,  1821,   354,  1823,   546,   573,
     992,  1610,   351,  1067,   546,   354,  2081,   351,  1810,   489,
     354,   579,   542,   548,  1023,   579,   351,   425,   351,   354,
     466,   354,   351,  1960,  1389,   354,   575,  1816,   559,   501,
    1105,   579,   351,   581,     0,   354,  1960,   579,   579,   581,
     553,  1830,  1831,   579,   579,   579,  2641,   485,   580,   485,
     351,   688,   553,   354,   394,  3304,  2396,  1789,   575,   696,
     411,   351,   699,   361,   354,   702,   703,  3356,   524,   351,
     542,   515,   354,   489,   579,   517,   579,   578,  2015,   351,
      15,    16,   354,   517,   491,    15,    16,   494,   573,   550,
     928,  2015,   577,   351,   703,   351,   354,   541,   354,   337,
    2312,  2313,  2365,  2366,   542,   351,   463,   530,   354,   746,
     515,   748,  3361,    15,    16,   510,   553,   474,  3072,  2635,
     401,  1163,  1114,   553,    15,    16,   335,   553,   530,   573,
     145,   382,    15,    16,   415,   353,  3425,   746,   510,   748,
    3413,   578,  3415,   981,   574,   575,    19,   351,   574,   575,
     354,   553,   575,   991,  2687,   436,   529,  2673,  2691,   553,
     515,  2638,   351,   553,   267,   354,  2687,  1964,  1703,   515,
    2691,    15,    16,   575,   573,   553,    15,    16,  2707,   485,
     574,   575,   537,   538,   574,   575,   191,  2649,    15,    16,
     108,   489,  3441,   263,   551,   553,  1993,   575,  1995,   179,
      15,    16,   411,  2000,   553,    15,    16,  2112,  2113,   553,
    2707,  1342,   177,   126,    15,    16,   574,   575,   553,  2016,
     553,  2018,  2019,  2020,   553,   574,   575,   436,  3483,   430,
     574,   575,   112,   443,   553,   338,   179,  1772,  2987,   574,
     575,  1499,   575,   116,   175,   574,   575,    15,    16,    15,
      16,  1491,   553,   258,   351,  1499,  1396,   354,   498,   362,
     897,  1501,   899,   553,  1504,  1505,   504,   351,     3,  1527,
     354,   553,   430,   574,   575,    88,  1436,   528,   145,  2491,
    3029,   553,   520,  1527,   574,   922,  1446,  1329,   229,  2356,
     370,   928,   574,   575,  3510,   553,   138,   553,  1438,  1439,
    1934,  1935,   574,   575,  2985,   172,   148,   553,   530,   227,
    1470,   252,   522,   922,    15,    16,  2806,   575,   574,   575,
    2258,  2974,   253,    64,  3007,  2802,  1944,   175,   965,   575,
     967,   145,   969,   538,   221,   575,   541,   325,   107,    15,
      16,   485,   229,   489,   981,   982,  1388,   557,   228,   553,
      15,    16,   574,  2029,   991,   992,  1610,  2294,   581,  1401,
    3328,  1610,    15,    16,   553,  1002,   430,    15,    16,  3658,
    2294,  2103,   573,  1533,  2163,  3251,  2108,  1962,   226,   301,
      15,    16,  2164,   343,   191,   574,   575,  1024,  1025,  1026,
    1027,  2123,  1467,   287,   374,   360,   466,  1034,  2130,  1036,
     313,   361,   112,    15,    16,  1042,   219,   510,   149,   164,
      15,    16,   430,  2145,  2146,   573,   351,  1026,  1027,   354,
    2152,   351,   437,   236,   354,   445,  2415,  1064,  2160,   575,
     435,   374,  1592,  1593,  3402,  1595,   249,  1597,  1598,  1599,
    1600,  1601,  2958,  1603,  1604,  2966,  2967,    15,    16,   351,
    2252,   258,   354,   430,   395,  1064,   553,    15,    16,  2261,
     351,   516,   112,   354,  1829,  1024,  1025,  2199,   351,   553,
     357,   354,  3426,   391,  1111,  1034,   560,  1114,   575,   444,
     500,   175,  3698,  1042,  2696,    15,    16,   381,   243,    15,
      16,  3144,  3173,  3174,    15,    16,   214,   498,   267,  2084,
     374,   489,  1111,   485,   352,   485,   573,   351,   350,   573,
     354,   324,   351,    12,   581,   354,   289,   126,  3472,   574,
     466,  3204,    15,    16,   351,   513,  1163,   354,  1165,   489,
    1167,  1168,  1169,  1170,  1171,   229,   351,  2269,   345,   354,
      16,   351,   485,  1180,   354,  1182,    12,    15,    16,    38,
     351,   445,   270,   354,   472,   573,    15,    16,    71,    72,
     506,  1170,   483,  3003,   485,   487,  3006,    15,    16,   338,
     437,   344,  2698,  2699,  2700,    15,    16,    12,   228,  1216,
     335,  2116,   213,   351,   107,   351,   354,   461,   354,  2124,
     512,   574,   575,    15,    16,   217,   573,  3074,   111,    15,
      16,  2727,    12,   416,  3044,   335,   527,  3047,  1167,  1168,
      15,    16,   353,     8,    88,   398,    15,    16,   553,  1256,
     133,   562,    54,   553,    12,  3158,   125,   501,   435,    15,
      16,   120,    27,    15,    16,    15,    16,    12,   107,   574,
     575,   464,   111,   166,   574,   575,   488,    15,    16,   545,
     351,   553,   165,   354,   567,   568,   569,   570,   471,   125,
      15,    16,   553,   559,   382,   488,   573,   545,   542,   399,
     553,  2609,   574,   575,   581,   351,   430,  1314,   354,   462,
     203,   559,   436,   574,   575,   213,   351,   574,  1787,   354,
     125,   574,  1329,  2519,  2520,    15,    16,   166,   351,    15,
      16,   354,   507,   351,   313,  2642,   354,    15,    16,   553,
     486,   430,   221,   465,   553,   125,   351,   469,  2642,   354,
     229,   347,    15,    16,   156,   530,   553,   159,    15,    16,
     574,   575,    15,    16,   203,   574,   575,   125,   553,   351,
     172,   510,   354,   553,   267,   219,   351,   574,   575,   354,
     125,  1388,   553,    20,  1914,   226,  1393,  1394,  2695,  1396,
     575,    28,   236,    76,  1401,   575,    33,  3207,   175,   420,
    1407,  2695,  1409,   574,   575,   249,   548,  1414,  1415,    92,
    1417,   535,   536,   351,  2721,   553,   354,   553,   954,    15,
      16,   957,  1429,   351,   960,  1432,   354,  2721,   267,   574,
     545,  1438,  1439,  1440,  1441,  1414,  1415,   575,  1417,   575,
     270,  1448,  1449,  1450,   559,   338,   535,   536,   579,   573,
    1429,   351,   581,  1432,   354,   351,    15,    16,   354,  1466,
     351,  1440,  1441,   354,   145,   486,  1996,  1997,  1475,  1448,
    1449,  1450,    15,    16,  3306,   461,   390,  2540,   357,   483,
     324,   485,   553,   573,   573,  1492,   172,  2017,   351,   403,
    3395,   354,  3397,    15,    16,   405,  1503,   299,    11,   338,
    2602,   332,   333,   574,   575,   152,   527,   553,  1515,  1921,
     393,  1923,  1924,   351,  1521,   530,   354,   344,   553,   433,
    2255,   542,   351,   373,  1503,   354,    15,    16,   574,   575,
     553,   452,   453,   351,   455,   553,   354,    15,    16,   574,
     575,   351,  1521,    68,   354,    15,    16,   420,   553,    55,
      56,  3437,   575,  1998,   349,    80,   574,   575,    64,   351,
    1972,  1973,   354,    15,    16,   351,  3453,   483,   354,   574,
     575,   553,   416,  1580,    15,    16,   351,   344,   553,   354,
     382,  1588,   351,  3527,   575,   354,   565,   566,   567,   568,
     569,   570,  3352,   575,   214,   351,  2008,    47,   354,   351,
     575,   351,   354,   175,   354,   263,    15,    16,  1615,    47,
      15,    16,  2808,   351,  2026,   553,   354,   510,   126,   575,
    1627,   344,  2929,  1630,   516,   553,   351,   471,   426,   354,
       3,  3504,  3505,     6,   567,  2929,   263,   575,    15,    16,
      13,    15,    16,   325,    15,    16,   150,   575,  1627,   436,
      23,    24,   506,   553,    15,    16,   573,   553,    55,    56,
     253,   351,   553,   172,   354,   351,    15,    16,   354,   463,
     464,   510,   466,   351,   468,   575,   354,   574,   575,   575,
      53,  2699,  2700,   574,    57,  2881,  2098,   466,   351,   325,
     553,   354,   466,  2105,   351,    68,   466,   354,   351,    15,
      16,   354,   574,   575,    77,    15,    16,    15,    16,  2306,
      83,   287,   575,    15,    16,   553,   241,   574,   575,  2347,
     483,   229,   263,    96,   553,  3598,  3599,   142,  2739,   346,
      28,  2742,  2743,  2347,    78,   553,   479,   575,   111,   275,
     276,   114,  1415,   553,  1417,  2355,   575,   325,  2759,   575,
     123,   124,   574,    15,    16,   351,   129,   575,   354,   574,
     575,   553,     3,  2268,   137,   575,   111,   553,    15,    16,
     143,   542,    70,   574,   575,  1448,  1449,  1450,   553,    15,
      16,  2291,    52,   575,   553,   429,   311,   399,  1795,   575,
     152,  2321,   351,    15,    16,   354,   169,   553,    67,   580,
     575,   553,  2806,   553,   211,   313,   575,   489,   351,  2911,
     335,   354,   573,    15,    16,   553,   575,    15,    16,   575,
     574,   575,   179,   575,   542,   575,     7,  2337,   553,   351,
     581,   513,   354,  2245,   575,    15,    16,   575,    19,   141,
     179,    22,   215,   141,   217,    15,    16,   573,    29,   573,
     575,   224,   573,   489,   573,    15,    16,   573,    39,   175,
     396,   397,   351,   553,   389,   354,   573,   553,    49,   192,
     573,    15,    16,   351,   573,   553,   354,   513,   574,   575,
    2410,   351,    15,    16,   354,   575,   573,  2417,   574,  1896,
     553,   573,   128,    15,    16,   575,   553,   575,   573,   351,
     553,   170,   354,   574,   575,   573,    87,  1914,  1915,   573,
     351,   489,   575,   354,  1921,   489,  1923,  1924,   575,   292,
      15,    16,   575,  3001,  3002,   573,   107,   108,   573,   110,
    2665,   439,   440,   573,   307,   513,   461,   573,   573,   312,
     121,  3019,   351,    15,    16,   354,   351,  3025,   217,   354,
     574,   575,   573,  1960,    15,    16,   581,   553,   574,   575,
     573,    15,    16,   158,   573,  1972,  1973,   290,   291,   238,
    3048,   294,   295,  3051,   351,  1982,   573,   354,   574,   352,
     351,  1988,   573,   354,  1991,   358,   573,  1994,   361,   573,
     351,   574,   575,   354,   553,   573,   573,  2409,  2005,  2006,
     573,  2008,   351,    15,    16,   354,  2961,  2014,  2015,   573,
     553,   384,   385,   573,   387,   175,   575,  2024,   573,  2026,
      15,    16,   573,  2030,  2031,   574,   575,   573,   401,   573,
    1543,   553,   575,  1546,   573,   351,   574,   575,   354,    15,
      16,   351,  1555,   351,   354,  2024,   354,   574,   575,   351,
     423,  1564,   354,   575,   573,   563,   564,   565,   566,   567,
     568,   569,   570,   573,   553,  2072,  2073,   581,  3375,   574,
     575,   573,   370,   574,   575,   553,   573,  2277,  2278,  2279,
     574,   575,   573,   553,   574,   575,   575,    15,    16,   351,
     573,  2098,   354,  2072,   392,  1298,  1299,   575,  2105,    15,
      16,   553,   573,   372,   351,   575,   573,   354,  2308,  2309,
    2310,  2118,   553,  3179,  3180,   351,  2651,  2652,   354,   417,
     573,  2621,  2622,   575,  3291,  3292,  3293,  3294,   573,   351,
     573,  3268,   354,   574,   507,    15,    16,   332,   333,    15,
      16,   573,   337,   516,   553,   573,    15,    16,   553,   351,
    2919,  2920,   354,   351,    15,    16,   354,  2164,    15,    16,
     410,   107,   412,   573,   414,   574,   416,   465,   580,   574,
     573,   351,   573,   573,   354,  3482,   553,   573,   573,   573,
    3282,   351,   553,   573,   354,   573,   573,    15,    16,    15,
      16,   351,   553,   573,   354,    15,    16,   574,   573,    15,
      16,   573,   575,   574,   553,   573,   579,   351,   573,   573,
     354,    47,   575,   574,   573,    15,    16,   573,   351,   573,
     166,   354,   573,   573,   548,   574,   573,   573,   483,   351,
     411,   573,   354,   573,    15,    16,   107,   553,  2245,   573,
     421,   573,  2654,   553,   425,   553,   573,    15,    16,   430,
     575,   553,   560,   573,   435,   573,   351,   203,  2670,   354,
      15,    16,   573,  2270,   574,   287,  2796,  2274,   573,  2276,
    2277,  2278,  2279,   573,    15,    16,   457,   573,   573,   351,
    2287,   531,   354,   573,  2291,   573,  2791,  2294,   573,   573,
     351,   553,   573,   354,   475,   166,   573,   351,   573,   573,
     354,  2308,  2309,  2310,   485,   573,   553,   573,  2287,   504,
     491,   258,   574,   573,  2321,   573,   497,   553,   499,   500,
    2327,   267,  2329,   504,   505,   520,   287,   574,   573,   573,
    2337,   553,   203,   573,   515,   573,    15,    16,   519,   351,
    3647,   573,   354,   524,   525,   573,   527,   528,   529,   530,
     573,   553,   574,  3647,   573,   553,   351,   573,   573,   354,
     573,  3668,   573,   573,   573,    15,    16,    15,    16,   573,
     573,   498,   574,   553,     3,   351,   574,  3684,   354,   573,
     573,   573,   563,   553,   573,    15,    16,   573,   575,    18,
    3684,  2398,   338,   553,   574,   498,   267,   575,   579,   575,
      15,    16,  2409,   575,   574,  2412,   587,   588,   575,   553,
    2915,   592,  3176,  3177,  3178,   229,  3583,   575,   599,  3093,
     553,   489,   567,   351,    15,    16,   354,   172,   230,   481,
    2960,   553,   160,   172,   523,   351,   126,   383,   354,  2446,
     386,   574,   447,    15,    16,  2645,  2453,   575,   629,  2456,
    3216,   575,   574,  2460,  2461,    15,    16,  2464,   553,    88,
      15,    16,   363,   575,   573,  2472,   574,   338,   575,   145,
     145,   351,   145,  2480,   354,   351,   145,  2456,   354,   574,
     145,   553,   351,   145,   145,   354,   145,    15,    16,   145,
     351,   145,   553,   354,   351,    15,    16,   354,  3028,   553,
     145,  2480,   574,   145,   145,   145,   145,   688,   575,   525,
     574,    15,    16,   574,    45,   696,   145,   344,   699,   179,
     574,   702,   703,   351,  3198,   351,   354,  3057,   354,    15,
      16,   351,  2944,    12,   354,   351,   574,  3211,   354,   175,
     169,   553,    64,   172,   489,   574,    15,    16,   125,     9,
     574,   351,    15,    16,   354,   574,   545,   574,   553,  3004,
     581,   252,   574,   573,   510,   746,   195,   748,    15,    16,
     351,   575,   201,   354,   566,    15,    16,   553,   390,   574,
     546,  3347,   453,   351,   218,   214,   354,   192,   581,  3119,
     219,   175,    15,    16,   574,  3007,   351,   226,   574,   354,
      15,    16,   445,   381,    15,    16,   436,   236,   575,   172,
     351,   575,    45,   354,   461,  3027,   461,   461,    15,    16,
     249,   461,   461,   313,   253,   553,   429,    15,    16,    67,
     498,   122,   484,   262,   237,  2642,  2643,   553,  2645,   510,
      15,    16,   237,   484,   122,    45,   574,  2654,   575,   573,
     581,   530,   574,  2660,  3251,     4,   575,   574,   574,   574,
       9,    10,   574,  2670,   574,   574,   574,   567,    15,    16,
     574,  2678,   351,   553,   581,   354,   574,   553,    27,   175,
     574,   573,   575,    32,   553,   574,   574,    36,  2695,   575,
     574,   574,   553,   574,   574,   324,   553,   574,   574,   574,
    2707,   351,   574,   351,   354,   574,   354,  2714,   574,   574,
     574,   437,   575,   574,  2721,   344,   897,   574,   899,   575,
    2727,   351,   573,   352,   354,   553,   574,   553,   574,   262,
     489,  3236,  3237,   553,   498,  3147,   351,   553,   573,   354,
    3414,   922,    15,    16,   573,   374,   574,   928,   574,   439,
     440,   574,   570,   553,   574,    15,    16,   574,   574,   581,
     351,    15,    16,   354,   498,    15,    16,   116,   581,   498,
    3444,  3445,   553,  3447,   574,   550,   575,   258,   498,   351,
     573,   349,   354,   175,   965,   553,   967,   416,   969,   175,
     175,   351,  3204,   574,   354,   226,   351,  2804,   553,   354,
     981,   982,   175,   233,   581,     3,   574,   436,  3713,   581,
     991,   992,   553,    15,    16,  3489,   548,  3491,  3492,   574,
      18,  1002,   338,   351,   575,   355,   354,   236,   236,  1010,
     303,   351,    96,   574,   354,    15,    16,    96,   573,   238,
     238,   581,   471,  1024,  1025,  1026,  1027,   351,   573,   413,
     354,   489,  3357,  1034,   573,  1036,  2502,    15,    16,   352,
    2506,  1042,    15,    16,   567,   351,    15,    16,   354,   574,
     574,   225,   338,   338,   553,   565,   566,   567,   568,   569,
     570,   574,   351,  1064,  3353,   354,   574,   516,   351,   574,
      88,   354,   338,   141,   574,   574,   574,   581,   581,  2906,
     529,   530,   573,   553,   351,   553,    16,   354,   574,   581,
     574,   351,   567,   214,   354,   344,    12,   546,   575,   548,
     175,  3422,  2929,   553,   574,   574,   574,   524,   351,   581,
    1111,   354,    16,  1114,    94,   229,   351,  2944,   553,   354,
     351,   250,    64,   354,   574,   574,   575,   145,   275,   236,
     579,   236,   575,   344,   351,   238,   238,   354,   575,   574,
      18,   344,   553,   351,   509,    18,   354,   574,    23,    18,
     227,   573,   105,   253,   172,   573,   351,   573,  2985,   354,
     227,   553,  1163,   574,  1165,   574,  1167,  1168,  1169,  1170,
    1171,   574,   574,   553,   574,    94,   574,   195,   553,  1180,
    3007,  1182,   574,   201,   351,   574,    32,   354,   581,    64,
     575,   581,   574,    68,   574,   574,   126,   574,   178,   574,
    3027,   219,   574,   574,    12,   553,   574,   574,   226,   125,
      56,   574,   574,   553,   575,  1216,   574,   574,   236,  3484,
     560,   174,   126,   575,   132,  3052,   574,  3054,   247,   553,
     575,   249,    40,  3558,  3555,   253,   111,   217,  3065,   430,
    3067,   195,   438,   573,   262,   573,   145,   553,   417,   126,
     574,    97,   574,   236,   100,  1256,   209,   355,   351,   236,
     179,   354,   108,   432,   553,   575,  3065,  2733,   574,   438,
     553,   351,   111,    81,   354,   111,   573,   351,    86,  3604,
     354,   351,   574,   369,   354,   574,   553,   581,   204,   458,
     574,   574,  3119,   553,   573,  3527,   509,   575,   217,   574,
     574,  2767,  2768,   574,   574,   432,   324,   574,   338,  2775,
     553,    41,   381,  1314,   574,   574,  2782,   338,   553,   574,
    3147,   548,   553,   226,   581,   201,   344,   574,  1329,   351,
     574,   574,   354,   575,   352,    45,   553,   575,   310,   574,
    3167,   390,   236,   574,   489,   553,  3173,  3174,   489,   302,
     530,   351,   229,   306,   354,   530,   374,   574,   553,   573,
    3187,   314,   172,   238,   573,    32,   574,   524,    88,   573,
    3691,   573,   573,   351,   111,   541,   354,  3204,   351,   574,
     541,   354,   351,   313,   238,   354,   553,  1388,   238,   337,
     548,   145,  1393,  1394,  3715,  1396,   574,   338,   416,   575,
    1401,   573,   575,   574,   574,   310,  1407,   574,  1409,   313,
     164,   574,    58,  1414,  1415,  3242,  1417,   489,   436,   574,
     574,    67,   574,   231,   574,   154,  3253,   380,  1429,   575,
     184,  1432,  3664,    79,   574,   489,   313,  1438,  1439,  1440,
    1441,   489,   238,    66,   198,    16,   574,  1448,  1449,  1450,
     574,   370,   530,   471,   530,   374,   236,   332,   333,   575,
     553,   172,   337,   334,   413,  1466,   574,   349,   338,   344,
     450,   536,   338,   553,  1475,   428,   485,   524,   255,   553,
     326,   574,   276,   553,   573,   573,   573,   349,    58,   243,
     244,  1492,   300,    58,   574,   374,    45,   372,   516,   219,
     574,   574,  1503,   574,   574,   485,   486,    45,   574,   439,
     440,   574,   530,   138,  1515,    45,   236,   271,   145,     5,
    1521,    88,   394,   349,   170,   349,   134,    45,   546,   249,
     548,   553,   178,   574,    45,   439,   440,   517,   575,   455,
     456,   457,   458,   459,   460,    45,   574,   527,  3375,  3376,
     575,   359,   574,   553,    16,   471,   574,   575,   121,   434,
     424,   579,   439,   440,   545,  3548,   582,   486,  3395,    28,
    3397,   217,  3399,  3400,   574,   553,   330,  3376,    34,  1580,
     553,   573,   501,   280,   553,  3412,   175,  1588,   545,    28,
     574,   544,   238,   145,   226,   141,   574,   443,   574,   213,
     579,   574,   545,   556,   324,   574,  3589,    34,   527,   575,
     141,   269,   579,   109,  1615,  3442,   214,   371,   582,   579,
     338,   561,   573,   542,   344,   575,  1627,   141,   560,  1630,
     199,   575,   579,   563,   564,   565,   566,   567,   568,   569,
     570,   449,   517,   255,   100,   436,   561,  3630,   494,   404,
    3477,   107,   219,   172,  3637,  3482,   145,   146,   560,   563,
     564,   565,   566,   567,   568,   569,   570,   172,   172,   236,
    3653,   548,   480,   100,  3501,   111,   522,  3504,  3505,  3506,
     107,   536,   249,   173,   547,  1843,   563,   564,   565,   566,
     567,   568,   569,   570,  1606,   184,   416,   694,  3523,  3064,
    3527,  3067,   158,   126,  3687,  3715,  3689,  3680,  3241,   198,
     166,  3538,  3686,  3610,  3567,  3610,  3599,  3575,  3574,  3073,
    3547,  3548,  1160,   405,  2800,  1576,   372,  3554,  3171,  2073,
    1580,   158,  1542,  2466,  2727,  1986,  2033,  2714,  2750,   166,
    2750,  2783,  3569,   232,  3571,  3196,  2990,   203,  3036,  3027,
    3577,   471,  2670,  3401,  2715,   244,  3411,   324,  3190,  3336,
    2029,  1175,  3589,  3253,  3211,  1510,  1078,  1891,   703,  1156,
    1440,  3598,  3599,  2287,  1874,   687,   203,   344,  1905,  3606,
     469,  3301,   271,   617,  2914,  3400,  3613,  3119,  2915,  1253,
    2106,  2685,  3619,  3620,  1795,  1203,  2262,  1455,  1299,  2721,
    3168,  3604,  3147,  3630,   450,   969,   992,  1910,  1870,  2637,
    3637,   267,  1895,  2929,  2636,  2695,  3668,  3482,    23,    24,
    3647,   459,  3649,  3650,   748,  1180,  3653,   520,  3655,   450,
    3657,  1500,   120,  1406,  2627,  2446,  3388,  3664,   997,   328,
     267,  3668,  3451,  3578,  3557,  3684,  3029,  3674,  2642,   416,
      55,    56,    57,  1461,  1010,  2678,  2955,  3684,  2339,    64,
    3687,  3155,  3689,    68,  3691,  1432,  1000,   442,   600,   325,
      88,   517,    77,  3289,  3701,  3702,  3295,   962,  3705,  2274,
     604,   337,   338,  1165,   443,  2239,  2593,   402,  3715,   402,
     313,    96,  1324,   510,   487,  1896,  2071,    -1,   325,  2797,
      23,    24,  3070,  3477,   471,   509,   111,   334,   509,   114,
     337,   338,   509,  1914,  1915,    -1,    -1,   205,    -1,    -1,
    1921,    -1,  1923,  1924,    -1,    68,    -1,  1532,    -1,    -1,
      -1,    -1,    55,    56,    57,    -1,    -1,    80,   143,  1544,
    1545,    64,  1547,  1548,  1549,    68,    -1,  1552,    -1,    -1,
      -1,    -1,  1557,    -1,    77,    -1,  1561,  1562,  1563,  1960,
      -1,  1566,  1567,  1568,  1569,  1570,    -1,  1572,  1573,  1574,
      -1,  1972,  1973,    96,    -1,   263,    -1,    -1,   121,    -1,
    3554,  1982,    -1,    -1,    -1,    -1,    -1,  1988,   111,    -1,
    1991,   114,    -1,  1994,    -1,  3569,    -1,  3571,    -1,   287,
      -1,   219,    -1,  3577,  2005,  2006,    -1,  2008,    -1,    -1,
      -1,     3,   217,  2014,  2015,    -1,   439,   440,   236,   224,
     143,    13,    14,  2024,    -1,  2026,    -1,    -1,    -1,  2030,
    2031,   249,    -1,   489,    26,   491,    28,    -1,   494,  3613,
      -1,    -1,    -1,    -1,    -1,   126,  3620,    -1,   504,    -1,
      -1,    -1,    -1,    -1,   510,    47,    48,   513,    -1,    -1,
      -1,    53,   489,    -1,   491,    57,    58,   494,   126,    -1,
      -1,  2072,  2073,    -1,    12,    13,  3650,   504,    70,    -1,
      -1,  3655,    -1,   510,    -1,   373,   513,   292,    -1,    -1,
      -1,    -1,    -1,   381,   217,    87,    -1,  2098,   241,    -1,
    3674,   224,   307,    -1,  2105,    -1,   324,    -1,    -1,   565,
     566,    -1,    -1,    -1,   106,    -1,    -1,  2118,    -1,    -1,
      -1,   409,    -1,   115,   116,   117,   344,  3701,  3702,   252,
      -1,  3705,    -1,    12,    13,    -1,   128,   129,   565,   566,
     563,   564,   565,   566,   567,   568,   569,   570,   229,    87,
      -1,    -1,    -1,   358,    -1,    -1,   361,   445,    -1,   151,
      -1,   522,    -1,  2164,    -1,    -1,    -1,    -1,   311,   292,
      -1,   252,    -1,    -1,    -1,    -1,   168,   115,   466,   384,
     385,    -1,   387,    -1,   307,    -1,    -1,    -1,    -1,   332,
     333,   129,   335,    -1,    -1,   483,    -1,   485,   416,    -1,
     192,    -1,    -1,    -1,    -1,    -1,    -1,   199,    87,    -1,
     202,    -1,    -1,   151,   575,    -1,    -1,    -1,   423,    -1,
      -1,    -1,    -1,    13,    -1,   163,    -1,    -1,    -1,    -1,
      -1,   223,   313,    -1,    -1,   358,   115,    -1,   361,    -1,
      -1,    -1,    -1,    -1,  2245,    -1,   389,   239,    -1,    -1,
     129,   332,   333,   471,   192,   313,    -1,    -1,    -1,    -1,
      -1,   384,   385,    -1,   387,   257,    -1,    -1,    -1,  2270,
     262,    -1,   151,  2274,    -1,  2276,  2277,  2278,  2279,   217,
      -1,    -1,    -1,    -1,   163,   223,  2287,    -1,    -1,    -1,
    2291,    -1,    -1,  2294,    -1,    -1,    -1,    87,    -1,    -1,
     423,    -1,   507,    -1,    -1,    -1,    -1,  2308,  2309,  2310,
      -1,   516,    -1,   192,   395,    -1,  2505,    -1,   461,    -1,
    2321,    -1,    -1,    -1,   262,   115,  2327,    -1,  2329,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2337,    -1,   217,   129,
      -1,    -1,    -1,    -1,   223,   706,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   348,    -1,   439,   440,
      -1,   151,    -1,    -1,    -1,    -1,    -1,   448,    -1,    -1,
     575,    -1,    -1,   163,    -1,    -1,    -1,    -1,   370,    -1,
      -1,   439,   440,   262,   507,    -1,    -1,   379,    -1,    -1,
      -1,    -1,    -1,   516,  1999,    -1,    -1,  2398,    -1,    -1,
      -1,    -1,   192,    -1,    -1,  2010,    -1,   399,  2409,   401,
     402,  2412,    -1,   405,    -1,    -1,   408,    -1,   410,    -1,
      -1,    -1,    -1,   415,    -1,   417,    -1,   217,    -1,    -1,
      -1,    -1,    -1,   223,   426,    -1,    -1,   375,   430,    -1,
      -1,    -1,    -1,    -1,   436,  2446,    -1,    -1,    -1,   441,
     573,    -1,  2453,   445,   815,  2456,   394,    -1,    -1,  2460,
    2461,    -1,   400,  2464,    -1,    -1,    -1,    -1,   406,    -1,
      -1,  2472,   262,   465,    -1,    -1,    -1,   469,    -1,  2480,
     841,   562,   563,   564,   565,   566,   567,   568,   569,   570,
      -1,    -1,   430,    -1,    -1,    -1,   375,    -1,    -1,    -1,
      -1,    -1,    -1,   441,   442,    -1,   564,   565,   566,   567,
     568,   569,   570,   505,    -1,   394,    -1,    -1,    -1,    -1,
      -1,   400,    -1,    -1,    -1,    -1,    -1,   406,    -1,   521,
     891,    -1,   524,    -1,   895,    -1,    -1,   529,    -1,    -1,
     478,    -1,  2731,  2732,    -1,    -1,    -1,    -1,    -1,    -1,
    2739,   430,    -1,  2742,  2743,    -1,    -1,    -1,    -1,    -1,
     552,    -1,   441,   442,    -1,    -1,    -1,    -1,    -1,    -1,
    2759,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   573,    -1,    -1,  2773,   375,   524,    -1,   526,  2778,
    2779,  2780,  2781,    -1,    -1,    -1,    -1,    -1,    -1,   478,
      -1,    -1,    -1,    -1,   394,    -1,    -1,    -1,    -1,    -1,
     400,    -1,    -1,    -1,    -1,    -1,   406,   273,   274,   275,
     276,   277,   278,    -1,    -1,   281,   282,   283,   284,   285,
     286,    -1,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     430,  2642,  2643,    -1,  2645,   524,    -1,   526,    -1,  1010,
      -1,   441,   442,  2654,    -1,    -1,    -1,    -1,  1019,  2660,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2670,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2678,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   478,    -1,
      -1,    -1,    -1,    -1,  2695,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2707,    -1,    -1,    -1,
      -1,    -1,    -1,  2714,    -1,    -1,    -1,    -1,    -1,    -1,
    2721,    -1,    -1,    23,    24,    -1,  2727,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   524,    -1,   526,    -1,    -1,    -1,
     396,   397,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    55,    56,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    64,    -1,    -1,    -1,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    -1,    -1,    -1,
      -1,    -1,    -1,  2804,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   111,    -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1184,  1185,  1186,    -1,    -1,    -1,    -1,
      -1,    -1,  1193,  1194,    -1,    -1,  1197,    -1,  1199,  1200,
    1201,  1202,    -1,   143,    -1,  1206,    -1,    -1,  1209,  1210,
      -1,  1212,    -1,  1214,  1215,    -1,  1217,  1218,  1219,  1220,
    1221,    -1,  1223,    -1,  1225,  1226,  1227,    -1,  1229,  1230,
    1231,  1232,    -1,  1234,  1235,    -1,  1237,    -1,    -1,  1240,
    1241,  1242,    -1,  1244,  1245,  1246,  1247,    -1,  1249,  1250,
    1251,  1252,    -1,    -1,    -1,    -1,    -1,  1258,  1259,    -1,
    1261,  1262,  1263,  1264,  1265,  2906,    -1,    -1,    -1,  1270,
      -1,  1272,  1273,  1274,  1275,  1276,    -1,   217,  1279,  1280,
    1281,  1282,  1283,  1284,   224,  1286,  1287,    -1,  2929,  1290,
    1291,  1292,    -1,  1294,    -1,  1296,    -1,    -1,    -1,  1300,
      -1,  1302,  1303,  2944,    -1,    -1,    -1,  1308,    -1,    -1,
      -1,    -1,    -1,    13,    14,  1316,  1317,  1318,    -1,    -1,
      -1,    -1,    -1,    -1,  1325,    -1,    26,  1328,    -1,    -1,
      -1,    -1,    -1,    -1,  1335,  1336,  1337,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2985,    -1,    -1,    47,    48,    -1,
      -1,    -1,   292,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3007,   307,    -1,    -1,
      70,    -1,    -1,    31,    32,    -1,    -1,    -1,    -1,    37,
      -1,    39,    -1,    41,    42,    -1,  3027,    87,    -1,  1390,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    56,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   106,    -1,    -1,    -1,
      -1,  3052,    -1,  3054,    -1,   115,   116,   117,   358,    -1,
      -1,   361,    -1,    -1,  3065,    -1,  3067,    -1,   128,   129,
      -1,    -1,    -1,    -1,  1435,    -1,    -1,    -1,    -1,    97,
      -1,    -1,   100,    -1,   384,   385,    -1,   387,    -1,    -1,
     108,   151,    -1,   101,   102,   103,   104,   105,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   168,   127,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3119,    -1,
      -1,    -1,    -1,   423,    -1,    -1,   144,    -1,    -1,    -1,
      -1,    -1,   192,    -1,    -1,    -1,    -1,    -1,    -1,   199,
      -1,    -1,   202,    -1,    -1,    -1,  3147,   165,    -1,   167,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   223,    -1,    -1,  3167,    -1,   186,   187,
      -1,    -1,  3173,  3174,    -1,    -1,    -1,    -1,    -1,   239,
      -1,    -1,    -1,    -1,    -1,    -1,  3187,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   257,   206,   207,
     208,   209,   262,  3204,    -1,    -1,    -1,   507,    -1,   227,
      -1,    -1,    -1,    -1,    -1,    -1,   516,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1590,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   256,    23,
      24,  3242,    -1,    -1,    -1,    -1,    -1,   265,   266,    -1,
     268,    -1,  3253,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,   296,   297,
     298,    -1,    -1,    -1,    68,    -1,    -1,    -1,   348,    -1,
      -1,    -1,    -1,    77,   302,    -1,   304,   305,   306,   317,
     318,   319,    -1,    -1,    -1,   323,   314,    -1,   326,    -1,
     370,    -1,    96,    -1,    -1,    -1,    -1,    -1,    -1,   379,
      -1,   339,   340,    -1,    -1,    -1,    -1,   111,    -1,    -1,
     114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   399,
      -1,   401,   402,    -1,    -1,   405,    -1,   365,   408,   367,
     410,    -1,    -1,    -1,    -1,   415,    -1,   417,    -1,   143,
      -1,    -1,    -1,    -1,    -1,    -1,   426,    -1,    -1,    -1,
     430,    -1,   380,   391,  3375,  3376,   436,    -1,    -1,    -1,
      -1,   441,    -1,    -1,    -1,   445,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3395,    -1,  3397,    -1,  3399,  3400,
      -1,    -1,    -1,    -1,    -1,   465,  1767,  1768,  1769,   469,
      -1,  3412,    -1,    -1,    -1,    -1,   434,    -1,   436,   427,
     428,    -1,    -1,  1784,    -1,    -1,    -1,    -1,   446,    -1,
      -1,    -1,    -1,   217,    -1,    -1,    -1,    -1,    -1,    -1,
     224,  3442,    -1,    -1,    -1,   505,    -1,    -1,    -1,  1810,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   521,    -1,    -1,   524,    -1,    -1,    -1,    -1,   529,
      -1,  1832,   490,   491,    -1,    -1,   494,   495,   496,   497,
      -1,  3482,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   552,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3501,    -1,    -1,    -1,    -1,  3506,    -1,    -1,   292,    -1,
      -1,    -1,    -1,   573,    -1,    -1,  3477,    -1,    -1,   537,
     538,    -1,    -1,   307,    -1,    -1,  3527,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   544,  3538,   556,    -1,
      -1,    -1,    -1,  3504,  3505,    -1,    -1,   555,   556,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,    -1,    -1,   361,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3547,  3548,    -1,    -1,
      -1,    -1,    -1,  3554,    -1,    -1,    -1,    -1,    -1,    -1,
     384,   385,    -1,   387,    -1,  3606,    -1,    -1,  3569,    -1,
    3571,    -1,    -1,    -1,    -1,    -1,  3577,    -1,  3619,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3589,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3598,  3599,   423,
      -1,    -1,    -1,    -1,    -1,    -1,  3647,    -1,  3649,    -1,
      -1,    -1,  3613,    -1,    -1,    -1,  3657,    -1,    -1,  3620,
      -1,    -1,    -1,  3664,    -1,    -1,    -1,  3668,    -1,  3630,
      -1,    -1,    -1,    -1,    -1,    -1,  3637,    -1,    -1,    -1,
      -1,    -1,    -1,  3684,    -1,    -1,    -1,    -1,    -1,  3650,
    3691,    -1,  3653,    -1,  3655,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3674,  3715,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   507,  2085,    -1,  3687,  2088,  3689,    -1,
    2091,  2092,   516,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3701,  3702,    -1,  2104,  3705,    -1,  2107,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2120,
      -1,  2122,    -1,    -1,    -1,  2126,    -1,  2128,  2129,    -1,
      -1,    -1,  2133,    -1,  2135,  2136,    -1,  2138,    -1,    -1,
    2141,    -1,  2143,  2144,    -1,    -1,    -1,    -1,  2149,  2150,
      -1,    -1,  2153,    -1,  2155,    -1,  2157,    -1,  2159,    -1,
    2161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2172,  2173,    -1,    -1,  2176,    -1,  2178,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2186,  2187,    -1,  2189,    -1,
    2191,    -1,    -1,  2194,  2195,  2196,    -1,  2198,    -1,    -1,
      -1,    -1,  2203,  2204,  2205,  2206,    -1,    -1,    -1,    -1,
    2211,  2212,  2213,    -1,  2215,    -1,  2217,    -1,  2219,    -1,
    2221,    -1,  2223,    -1,    -1,    -1,    -1,    -1,    -1,  2230,
      -1,  2232,    -1,    -1,  2235,  2236,    -1,    -1,    -1,    -1,
      -1,    30,    -1,    32,    33,  2246,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2261,    -1,    -1,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    -1,    -1,     6,    -1,    65,    -1,    67,    -1,
    2281,    13,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    23,    24,    -1,    -1,    -1,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    53,    -1,    -1,    -1,    57,    -1,    -1,    -1,  2330,
      -1,    -1,    -1,    -1,  2335,    -1,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,
      -1,    83,    -1,   142,   143,    -1,    -1,    -1,   147,    -1,
      -1,    -1,    -1,    -1,    96,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2379,   111,
      -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,   177,    -1,
     179,   123,  2393,    -1,    -1,    -1,    -1,   129,    -1,    -1,
      -1,    -1,   191,    -1,   193,   137,    -1,    -1,    -1,    -1,
      -1,   143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   216,   217,    -1,
      -1,   220,    -1,    -1,    -1,    -1,    -1,   169,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   258,
      -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   217,    -1,    -1,    -1,    -1,
      -1,    -1,   224,    -1,  2495,    -1,    -1,    -1,   287,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   320,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     329,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   347,    -1,
     292,    -1,    -1,    -1,    -1,    -1,    -1,  2568,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   307,    -1,  2578,    -1,  2580,
     312,  2582,    -1,    -1,   373,   374,    -1,  2588,   377,   378,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2611,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     352,    -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,   361,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   435,    -1,    -1,    -1,
      -1,    -1,   384,   385,    -1,   387,   445,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   401,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   466,  2679,    -1,
      -1,   470,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   423,    -1,    -1,    -1,    -1,   485,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     539,    -1,    -1,    -1,   543,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   516,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2829,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2839,    -1,
      -1,    -1,    -1,    -1,  2845,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2854,  2855,    -1,    -1,    -1,    -1,  2860,
      -1,    -1,    -1,  2864,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2877,    -1,    -1,    -1,
      -1,    -1,  2883,    -1,    -1,  2886,  2887,    -1,  2889,  2890,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2903,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2970,
    2971,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2981,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3155,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3264,    -1,    -1,    -1,    -1,    -1,  3270,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3305,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3315,    -1,  3317,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3379,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3431,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3454,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3543,  3544,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3563,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3572,    -1,    -1,    -1,    -1,    -1,    -1,  3579,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3588,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,  3617,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
    3631,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    42,    43,    44,    -1,    46,
      47,    -1,    -1,    50,    51,    52,    -1,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    83,    84,    85,    86,
      -1,  3692,    89,    90,    91,    -1,    93,    94,    -1,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,
      -1,   118,   119,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,   154,   155,   156,
     157,   158,   159,   160,    -1,   162,   163,   164,   165,   166,
      -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,   186,
     187,   188,   189,   190,   191,    -1,   193,   194,    -1,   196,
     197,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,   245,   246,
     247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
     267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,    -1,
     337,   338,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
     467,   468,   469,   470,    -1,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,   499,   500,    -1,   502,   503,   504,   505,   506,
     507,   508,    -1,   510,   511,   512,   513,    -1,   515,    -1,
      -1,   518,   519,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,   531,   532,   533,   534,   535,   536,
      -1,    -1,   539,   540,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,   554,    -1,   556,
      -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,   565,   566,
      -1,    -1,    -1,    -1,   571,    -1,   573,    -1,    -1,   576,
     577,    -1,    -1,   580,   581,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    51,    52,    -1,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    83,    84,    85,    86,    -1,    -1,    89,
      90,    91,    -1,    93,    94,    -1,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,    -1,   154,   155,   156,   157,   158,   159,
     160,    -1,   162,   163,   164,   165,   166,    -1,   168,    -1,
      -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,   186,   187,   188,   189,
     190,   191,    -1,   193,   194,    -1,   196,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,   249,
     250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,   308,   309,
     310,    -1,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,    -1,   325,   326,   327,    -1,   329,
     330,   331,   332,   333,   334,   335,    -1,   337,   338,    -1,
     340,   341,    -1,   343,   344,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,   388,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,   404,   405,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,   467,   468,   469,
     470,    -1,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,   503,   504,   505,   506,   507,   508,    -1,
     510,   511,   512,   513,    -1,   515,    -1,    -1,   518,   519,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,   531,   532,   533,   534,   535,   536,    -1,    -1,   539,
     540,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,
      -1,   561,    -1,    -1,    -1,   565,   566,    -1,    -1,    -1,
      -1,   571,    -1,   573,    -1,    -1,   576,   577,    -1,    -1,
     580,   581,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      -1,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      83,    84,    85,    86,    -1,    -1,    89,    90,    91,    -1,
      93,    94,    -1,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,   112,
      -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
      -1,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,
     173,   174,    -1,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
     223,   224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,
      -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,    -1,   337,   338,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,   388,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,   428,   429,   430,    -1,    -1,
     433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,
     443,   444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,
      -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,
      -1,    -1,   465,   466,   467,   468,   469,   470,    -1,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
     483,   484,    -1,   486,   487,    -1,   489,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,
     503,   504,   505,   506,   507,   508,    -1,   510,   511,   512,
     513,    -1,   515,    -1,    -1,   518,   519,   520,    -1,    -1,
     523,    -1,   525,    -1,   527,   528,    -1,    -1,   531,   532,
     533,   534,   535,   536,    -1,    -1,   539,   540,    -1,   542,
     543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,
      -1,   554,    -1,   556,    -1,    -1,    -1,    -1,   561,    -1,
      -1,    -1,   565,   566,    -1,    -1,    -1,    -1,   571,    -1,
     573,    -1,    -1,   576,   577,    -1,    -1,   580,   581,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    51,    52,    -1,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    73,    74,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    83,    84,    85,
      86,    -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,
      -1,    -1,   118,   119,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,    -1,   154,   155,
     156,   157,   158,   159,   160,    -1,   162,   163,   164,   165,
     166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,
     176,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
     186,   187,   188,   189,   190,   191,    -1,   193,   194,    -1,
     196,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,
     246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,   308,   309,   310,    -1,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,    -1,   325,
     326,   327,    -1,   329,   330,   331,   332,   333,   334,   335,
      -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,   467,   468,   469,   470,    -1,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,
     506,   507,   508,    -1,   510,   511,   512,   513,    -1,   515,
      -1,    -1,   518,   519,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,   531,   532,   533,   534,   535,
     536,    -1,    -1,   539,   540,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,   554,    -1,
     556,    -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,   565,
     566,    -1,    -1,    -1,    -1,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,   581,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,
      -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,   448,
     449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,
     459,    -1,    -1,   462,    -1,    -1,   465,   466,   467,   468,
     469,   470,    -1,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,   483,   484,    -1,   486,   487,    -1,
     489,   490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,
      -1,   500,    -1,   502,   503,   504,   505,   506,   507,   508,
      -1,   510,   511,   512,   513,    -1,   515,    -1,    -1,   518,
     519,   520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,
      -1,    -1,   531,   532,   533,   534,   535,   536,    -1,    -1,
     539,   540,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,
     549,    -1,   551,   552,    -1,   554,    -1,   556,    -1,    -1,
      -1,    -1,   561,    -1,    -1,    -1,   565,   566,    -1,    -1,
      -1,    -1,   571,    -1,   573,   574,    -1,   576,   577,    -1,
      -1,   580,   581,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,
      52,    -1,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    83,    84,    85,    86,    -1,    -1,    89,    90,    91,
      -1,    93,    94,    -1,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,
     112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,   154,   155,   156,   157,   158,   159,   160,    -1,
     162,   163,   164,   165,   166,    -1,   168,    -1,    -1,   171,
      -1,   173,   174,    -1,   176,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
      -1,   193,   194,    -1,   196,   197,    -1,   199,   200,    -1,
     202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,   243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,   308,   309,   310,    -1,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,    -1,   329,   330,   331,
     332,   333,   334,   335,    -1,   337,   338,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,   388,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,   404,   405,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,   467,   468,   469,   470,    -1,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,   483,   484,    -1,   486,   487,    -1,   489,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,   503,   504,   505,   506,   507,   508,    -1,   510,   511,
     512,   513,    -1,   515,    -1,    -1,   518,   519,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,   531,
     532,   533,   534,   535,   536,    -1,    -1,   539,   540,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,   561,
      -1,    -1,    -1,   565,   566,    -1,    -1,    -1,    -1,   571,
      -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,   581,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    83,    84,
      85,    86,    -1,    -1,    89,    90,    91,    -1,    93,    94,
      -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,   111,   112,    -1,   114,
      -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,   154,
     155,   156,   157,   158,   159,   160,    -1,   162,   163,   164,
     165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,
      -1,   176,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,   186,   187,   188,   189,   190,   191,    -1,   193,   194,
      -1,   196,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,
     225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,
      -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,
      -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
     325,   326,   327,    -1,   329,   330,   331,   332,   333,   334,
     335,    -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,
     445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
     465,   466,   467,   468,   469,   470,    -1,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
      -1,   486,   487,    -1,   489,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,   506,   507,   508,    -1,   510,   511,   512,   513,    -1,
     515,    -1,    -1,   518,   519,   520,    -1,    -1,   523,    -1,
     525,    -1,   527,   528,    -1,    -1,   531,   532,   533,   534,
     535,   536,    -1,    -1,   539,   540,    -1,   542,   543,   544,
      -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,   554,
      -1,   556,    -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,
     565,   566,    -1,    -1,    -1,    -1,   571,    -1,   573,   574,
      -1,   576,   577,    -1,    -1,   580,   581,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    51,    52,    -1,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    73,    74,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    83,    84,    85,    86,    -1,
      -1,    89,    90,    91,    -1,    93,    94,    -1,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,
     118,   119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,    -1,   154,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,   164,   165,   166,    -1,
     168,    -1,    -1,   171,    -1,   173,   174,   175,   176,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,   186,   187,
     188,   189,   190,   191,    -1,   193,   194,    -1,   196,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,   213,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,
      -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
     308,   309,   310,    -1,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,    -1,   325,   326,   327,
      -1,   329,   330,   331,   332,   333,   334,   335,    -1,   337,
     338,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
     388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,   404,   405,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
     428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,
     438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,
     448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,
      -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,   467,
     468,   469,   470,    -1,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   483,   484,    -1,   486,   487,
      -1,   489,   490,   491,   492,   493,   494,    -1,    -1,    -1,
      -1,    -1,   500,    -1,   502,   503,   504,   505,   506,   507,
     508,    -1,   510,   511,   512,   513,    -1,   515,    -1,    -1,
     518,   519,   520,    -1,    -1,   523,    -1,   525,    -1,   527,
     528,    -1,    -1,   531,   532,   533,   534,   535,   536,    -1,
      -1,   539,   540,    -1,   542,   543,   544,    -1,    -1,    -1,
      -1,   549,    -1,   551,   552,    -1,   554,    -1,   556,    -1,
      -1,    -1,    -1,   561,    -1,    -1,    -1,   565,   566,    -1,
      -1,    -1,    -1,   571,    -1,   573,    -1,    -1,   576,   577,
      -1,    -1,   580,   581,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    83,    84,    85,    86,    -1,    -1,    89,    90,
      91,    -1,    93,    94,    -1,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
     111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,   152,    -1,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,    -1,   168,    -1,    -1,
     171,    -1,   173,   174,   175,   176,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,    -1,   196,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,    -1,   246,   247,    -1,   249,   250,
      -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,    -1,   337,   338,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,   388,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,   467,   468,   469,   470,
      -1,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,   483,   484,    -1,   486,   487,    -1,   489,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,   503,   504,   505,   506,   507,   508,    -1,   510,
     511,   512,   513,    -1,   515,    -1,    -1,   518,   519,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
     531,   532,   533,   534,   535,   536,    -1,    -1,   539,   540,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,
     561,    -1,    -1,    -1,   565,   566,    -1,    -1,    -1,    -1,
     571,    -1,   573,    -1,    -1,   576,   577,    -1,    -1,   580,
     581,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,   175,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,
     434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,
     444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,
      -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,
      -1,   465,   466,   467,   468,   469,   470,    -1,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   483,
     484,    -1,   486,   487,    -1,   489,   490,   491,   492,   493,
     494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,   503,
     504,   505,   506,   507,   508,    -1,   510,   511,   512,   513,
      -1,   515,    -1,    -1,   518,   519,   520,    -1,    -1,   523,
      -1,   525,    -1,   527,   528,    -1,    -1,   531,   532,   533,
     534,   535,   536,    -1,    -1,   539,   540,    -1,   542,   543,
     544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,
     554,    -1,   556,    -1,    -1,    -1,    -1,   561,    -1,    -1,
      -1,   565,   566,    -1,    -1,    -1,    -1,   571,    -1,   573,
      -1,    -1,   576,   577,    -1,    -1,   580,   581,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    51,    52,    -1,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    83,    84,    85,    86,
      -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,
      -1,   118,   119,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,   154,   155,   156,
     157,   158,   159,   160,    -1,   162,   163,   164,   165,   166,
      -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,   186,
     187,   188,   189,   190,   191,    -1,   193,   194,    -1,   196,
     197,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,
     247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
     267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,    -1,
     337,   338,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
     467,   468,   469,   470,    -1,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,   506,
     507,   508,    -1,   510,   511,   512,   513,    -1,   515,    -1,
      -1,   518,   519,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,   531,   532,   533,   534,   535,   536,
      -1,    -1,   539,   540,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,   554,    -1,   556,
      -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,   565,   566,
      -1,    -1,    -1,    -1,   571,    -1,   573,    -1,    -1,   576,
     577,    -1,    -1,   580,   581,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    51,    52,    -1,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    83,    84,    85,    86,    -1,    -1,    89,
      90,    91,    -1,    93,    94,    -1,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,    -1,   154,   155,   156,   157,   158,   159,
     160,    -1,   162,   163,   164,   165,   166,    -1,   168,    -1,
      -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,   186,   187,   188,   189,
     190,   191,    -1,   193,   194,    -1,   196,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,   249,
     250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,   308,   309,
     310,    -1,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,    -1,   325,   326,   327,    -1,   329,
     330,   331,   332,    -1,   334,   335,    -1,   337,   338,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,   388,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,   404,   405,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,   467,   468,   469,
     470,    -1,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,   503,   504,   505,   506,   507,   508,    -1,
     510,   511,   512,   513,    -1,   515,    -1,    -1,   518,   519,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,   531,   532,   533,   534,   535,   536,    -1,    -1,   539,
     540,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,
      -1,   561,    -1,    -1,    -1,   565,   566,    -1,    -1,    -1,
      -1,   571,    -1,   573,    -1,    -1,   576,   577,    -1,    -1,
     580,   581,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      -1,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      83,    84,    85,    86,    -1,    -1,    89,    90,    91,    -1,
      93,    94,    -1,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,   112,
      -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
      -1,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,
     173,   174,    -1,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
     223,   224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,
      -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,    -1,   337,   338,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,   388,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,
     433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,
     443,   444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,
      -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,
      -1,    -1,   465,   466,   467,   468,   469,   470,    -1,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
     483,   484,    -1,   486,   487,    -1,   489,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,
     503,   504,   505,   506,   507,   508,    -1,   510,   511,   512,
     513,    -1,   515,    -1,    -1,   518,   519,   520,    -1,    -1,
     523,    -1,   525,    -1,   527,   528,    -1,    -1,   531,   532,
     533,   534,   535,   536,    -1,    -1,   539,   540,    -1,   542,
     543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,
      -1,   554,    -1,   556,    -1,    -1,    -1,    -1,   561,    -1,
      -1,    -1,   565,   566,    -1,    -1,    -1,    -1,   571,    -1,
     573,    -1,    -1,   576,   577,    -1,    -1,   580,   581,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    51,    52,    -1,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    73,    74,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    83,    84,    85,
      86,    -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,
      -1,    -1,   118,   119,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,    -1,   154,   155,
     156,   157,   158,   159,   160,    -1,   162,   163,   164,   165,
     166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,
     176,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
     186,   187,   188,   189,   190,   191,    -1,   193,   194,    -1,
     196,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,
     246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,   308,   309,   310,    -1,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,    -1,   325,
     326,   327,    -1,   329,   330,   331,   332,   333,   334,   335,
      -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,   467,   468,   469,   470,    -1,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,
     506,   507,   508,    -1,   510,   511,   512,   513,    -1,   515,
      -1,    -1,   518,   519,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,   531,   532,   533,   534,   535,
     536,    -1,    -1,   539,   540,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,   554,    -1,
     556,    -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,   565,
     566,    -1,    -1,    -1,    -1,   571,    -1,   573,    -1,    -1,
     576,   577,    -1,    -1,   580,   581,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,
      -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,   448,
     449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,
     459,    -1,    -1,   462,    -1,    -1,   465,   466,   467,   468,
     469,   470,    -1,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,   483,   484,    -1,   486,   487,    -1,
     489,   490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,
      -1,   500,    -1,   502,   503,   504,   505,   506,   507,   508,
      -1,   510,   511,   512,   513,    -1,   515,    -1,    -1,   518,
     519,   520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,
      -1,    -1,   531,   532,   533,   534,   535,   536,    -1,    -1,
     539,   540,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,
     549,    -1,   551,   552,    -1,   554,    -1,   556,    -1,    -1,
      -1,    -1,   561,    -1,    -1,    -1,   565,   566,    -1,    -1,
      -1,    -1,   571,    -1,   573,    -1,    -1,   576,   577,    -1,
      -1,   580,   581,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,
      52,    -1,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    83,    84,    85,    86,    -1,    -1,    89,    90,    91,
      -1,    93,    94,    -1,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,
     112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,   154,   155,   156,   157,   158,   159,   160,    -1,
     162,   163,   164,   165,   166,    -1,   168,    -1,    -1,   171,
      -1,   173,   174,    -1,   176,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
      -1,   193,   194,    -1,   196,   197,    -1,   199,   200,    -1,
     202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,   243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,   308,   309,   310,    -1,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,    -1,   329,   330,   331,
     332,    -1,   334,   335,    -1,   337,   338,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,   388,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,   404,   405,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,   467,   468,   469,   470,    -1,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,   483,   484,    -1,   486,   487,    -1,   489,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,   503,   504,   505,   506,   507,   508,    -1,   510,   511,
     512,   513,    -1,   515,    -1,    -1,   518,   519,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,   531,
     532,   533,   534,   535,   536,    -1,    -1,   539,   540,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,   561,
      -1,    -1,    -1,   565,   566,    -1,    -1,    -1,    -1,   571,
      -1,   573,    -1,    -1,   576,   577,    -1,    -1,   580,   581,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    79,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,   178,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,   217,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,   238,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,   252,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,   430,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,
     445,    -1,   447,   448,   449,   450,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
     465,   466,    -1,    -1,   469,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,    -1,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
     505,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
     515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
     525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,
       5,   556,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,   581,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    79,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,   178,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,   217,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,   238,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,
     445,    -1,   447,   448,   449,   450,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
     465,   466,    -1,    -1,   469,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,    -1,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
     505,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
     515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
     525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,
       5,   556,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,   581,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,   430,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,
     445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
     465,   466,    -1,    -1,   469,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,    -1,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
     505,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
     515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
     525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,
      -1,   556,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,   574,
      23,    24,    25,    26,    -1,    28,   581,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,
     433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,
     443,   444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,
      -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,
      -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,
     473,   474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,
     483,   484,    -1,   486,   487,    -1,    -1,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,
      -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,   512,
      -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,
     523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,
     543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,
      -1,    -1,    -1,   556,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,   574,    -1,    17,    -1,    -1,    20,   580,   581,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,   226,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,
     434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,
     444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,
      -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,
      -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,   473,
     474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,
     484,    -1,   486,   487,    -1,    -1,   490,   491,   492,   493,
     494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,
      -1,   505,   506,   507,   508,    -1,    -1,   511,   512,    -1,
      -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,
      -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,
     544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,
      -1,     5,   556,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,   581,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,
     434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,
     444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,
      -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,
      -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,   473,
     474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,
     484,    -1,   486,   487,    -1,    -1,   490,   491,   492,   493,
     494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,
      -1,   505,   506,   507,   508,    -1,    -1,   511,   512,    -1,
      -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,
      -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,
     544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,
      -1,    -1,   556,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,   567,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,   581,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,    -1,    -1,   556,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,   573,    -1,    23,    24,    25,    26,    -1,    28,   581,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,    -1,   556,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
     580,   581,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,    -1,     5,   556,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
     581,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,    -1,     5,   556,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
     581,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,    -1,     5,   556,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
     581,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,    -1,     5,   556,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
     581,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,   489,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,    -1,    -1,   556,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,   580,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,
     438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,
     448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,
      -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,    -1,
      -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,    -1,
     478,   479,   480,   481,    -1,   483,   484,    -1,   486,   487,
      -1,   489,   490,   491,   492,   493,   494,    -1,    -1,    -1,
      -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,   507,
     508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,    -1,
      -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,   527,
     528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,
      -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,    -1,
      -1,   549,    -1,   551,   552,    -1,    -1,    -1,   556,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,   580,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,
     445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
     465,   466,    -1,    -1,   469,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,   489,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
     505,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
     515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
     525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,
      -1,   556,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,   580,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,
      52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,    -1,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
      -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
      -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,    -1,
     412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,   547,    -1,   549,    -1,   551,
      -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,    -1,   561,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,   575,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,
     445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
     465,   466,    -1,    -1,   469,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,    -1,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
     505,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
     515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
     525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,
      -1,   556,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,   567,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,
     433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,
     443,   444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,
      -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,
      -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,
     473,   474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,
     483,   484,    -1,   486,   487,    -1,    -1,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,
      -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,   512,
      -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,
     523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,
     543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,
      -1,    -1,    -1,   556,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,   567,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,    -1,    -1,   556,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,   567,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,
      -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,   448,
     449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,
     459,    -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,
     469,   470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,
     479,   480,   481,    -1,   483,   484,    -1,   486,   487,    -1,
      -1,   490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,
      -1,   500,    -1,   502,    -1,    -1,   505,   506,   507,   508,
      -1,    -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,
      -1,   520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,
     539,    -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,
     549,    -1,   551,   552,    -1,    -1,    -1,   556,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,   567,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    -1,
      -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,    -1,
      -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,   135,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,   163,   164,   165,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,   235,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,
     247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,   406,
      -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,    -1,
      -1,   418,    -1,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,   466,
      -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
     547,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,   556,
      -1,    -1,   559,     5,   561,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,
      52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,    -1,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
      -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
      -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,    -1,
     412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,   545,    -1,   547,    -1,   549,    -1,   551,
      -1,    -1,    -1,    -1,   556,    -1,    -1,   559,     5,   561,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    -1,
      -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,    -1,
      -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,   163,   164,   165,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,   235,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,
     247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,   406,
      -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,    -1,
      -1,   418,    -1,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,   466,
      -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,   545,    -1,
     547,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,   556,
      -1,    -1,   559,     5,   561,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,
      52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,    -1,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
      -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
      -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,    -1,
     412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,   547,    -1,   549,    -1,   551,
      -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,     5,   561,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    -1,
      -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,    -1,
      -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,   163,   164,   165,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,   235,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,
     247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,   406,
      -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,    -1,
      -1,   418,    -1,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,   466,
      -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
     547,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,   556,
      -1,    -1,    -1,     5,   561,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,
      52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,    -1,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
      -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
      -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,    -1,
     412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,   547,    -1,   549,    -1,   551,
      -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,     5,   561,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    -1,
      -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,    -1,
      -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,   163,   164,   165,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,   235,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,
     247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,   406,
      -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,    -1,
      -1,   418,    -1,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,   466,
      -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
     547,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,   556,
      -1,    -1,    -1,     5,   561,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,
      52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,    -1,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
      -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
      -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,    -1,
     412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,   547,    -1,   549,    -1,   551,
      -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,     5,   561,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    -1,
      -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,    -1,
      -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,   163,   164,   165,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,   235,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,
     247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,   406,
      -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,    -1,
      -1,   418,    -1,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,   466,
      -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
     547,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,   556,
      -1,    -1,    -1,     5,   561,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,
      52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,    -1,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,    -1,
      -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
      -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,    -1,
     412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,   421,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,   547,    -1,   549,    -1,   551,
      -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,     5,   561,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,   166,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
     267,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,   332,   333,    -1,   335,    -1,
      -1,   338,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,   452,   453,   454,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,   510,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,   145,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    91,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    34,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    18,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    82,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,   153,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,   175,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,   372,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,   556,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    -1,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    -1,
      -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,    -1,
      -1,    -1,    59,    60,    -1,    -1,    63,    -1,    65,    66,
      -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,    -1,   403,    -1,    -1,   406,
      -1,    -1,   409,    -1,    -1,   412,   413,    -1,    -1,    -1,
      -1,   418,    -1,   420,   421,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,   466,
      -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,   556
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,     3,    13,    14,    26,    28,    47,    48,    53,    57,
      58,    70,    87,   106,   115,   116,   117,   128,   129,   151,
     168,   192,   199,   202,   223,   239,   257,   262,   348,   370,
     379,   399,   401,   402,   405,   408,   410,   415,   417,   426,
     430,   436,   441,   445,   465,   469,   505,   521,   524,   529,
     552,   573,   584,   587,   588,   589,   590,   591,   593,   598,
     600,   605,   617,   785,   803,   806,   814,   816,   818,   821,
     826,   828,   833,   836,   841,   845,   853,   854,   992,   994,
    1000,  1003,  1028,  1036,  1047,  1053,  1067,  1070,  1073,  1079,
    1083,  1087,  1090,  1091,  1137,  1154,  1160,  1162,  1169,  1171,
    1196,  1202,  1203,  1204,  1205,  1251,    11,    94,   179,   214,
     374,   799,  1226,  1227,   258,   336,   835,   483,   485,  1156,
    1197,   217,     5,     7,     8,     9,    10,    11,    17,    20,
      23,    24,    25,    26,    28,    30,    33,    37,    40,    41,
      42,    44,    46,    47,    50,    52,    54,    55,    57,    59,
      60,    61,    63,    65,    66,    68,    69,    70,    71,    72,
      75,    77,    78,    80,    81,    86,    89,    96,    97,   100,
     105,   106,   112,   114,   120,   122,   123,   124,   128,   131,
     132,   133,   137,   141,   142,   143,   144,   147,   149,   150,
     151,   154,   156,   159,   160,   163,   164,   165,   168,   173,
     174,   177,   179,   186,   187,   190,   191,   193,   199,   200,
     202,   205,   209,   210,   211,   212,   215,   216,   220,   224,
     228,   230,   231,   233,   234,   241,   243,   247,   250,   256,
     258,   261,   263,   273,   274,   275,   276,   277,   278,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   290,   291,
     292,   294,   295,   299,   300,   301,   302,   303,   306,   307,
     310,   312,   314,   317,   318,   319,   320,   321,   322,   323,
     326,   327,   329,   330,   331,   335,   340,   341,   343,   345,
     346,   347,   358,   359,   360,   361,   363,   365,   367,   370,
     371,   373,   375,   376,   377,   378,   380,   381,   382,   383,
     384,   385,   386,   387,   392,   393,   396,   397,   398,   400,
     402,   403,   406,   408,   409,   410,   412,   413,   417,   418,
     420,   421,   423,   424,   425,   426,   428,   429,   433,   434,
     435,   438,   442,   443,   444,   445,   447,   448,   449,   456,
     457,   459,   462,   465,   466,   469,   470,   472,   473,   474,
     478,   479,   480,   481,   483,   484,   486,   487,   490,   491,
     492,   493,   494,   500,   502,   505,   506,   507,   508,   511,
     512,   515,   520,   523,   525,   527,   528,   536,   539,   542,
     543,   544,   549,   551,   552,   556,   611,  1127,  1131,  1135,
    1136,   287,  1156,  1156,   549,  1198,    94,   178,   450,   486,
     517,   527,   609,   702,   703,   704,   777,  1037,   993,    94,
     179,   217,   374,   486,   501,   527,   542,   999,  1131,   835,
     610,   581,  1125,  1126,  1131,   599,  1001,  1088,    96,   217,
     485,  1156,   835,  1131,  1084,   426,   527,  1156,   835,  1004,
    1080,  1156,   610,  1198,  1131,   856,   858,   859,   349,  1139,
    1054,   465,   469,   445,   500,   445,   485,  1048,  1161,  1029,
    1131,    28,    70,   141,   370,   392,   417,   465,  1253,   430,
     573,   855,     0,     3,   585,   370,   156,  1071,  1125,  1131,
     145,   791,  1131,   611,   611,   485,   112,  1221,  1222,  1223,
    1156,   817,  1198,   842,   843,  1125,   618,   581,   498,   819,
     829,    16,  1199,   213,   705,   610,   354,  1218,  1222,  1223,
    1224,  1225,  1226,   485,   703,   217,   214,   270,   382,  1045,
    1046,   908,   909,   213,   998,   998,  1131,   998,   998,   610,
     998,  1156,   594,  1074,    12,    13,    87,   115,   129,   151,
     163,   192,   217,   223,   262,   375,   394,   400,   406,   430,
     441,   442,   478,   524,   526,  1172,  1174,  1176,  1177,  1131,
     347,    61,   390,   581,   251,   489,  1128,  1131,  1133,   113,
     204,   270,  1006,    77,   381,  1089,  1092,   226,  1125,  1155,
    1156,   175,    32,   287,  1059,  1085,  1131,   610,   837,  1156,
     113,   270,  1007,  1035,   287,   381,   445,  1081,  1082,   815,
      12,  1170,  1174,   498,  1199,   857,    12,   125,   204,   455,
     456,   457,   458,   459,   460,   471,   863,   864,   865,  1138,
      30,    33,    55,    56,    65,    67,    85,    87,    95,   143,
     147,   177,   179,   191,   193,   216,   217,   220,   237,   258,
     263,   287,   320,   329,   347,   373,   374,   377,   378,   435,
     445,   470,   485,   543,   750,   776,  1055,  1059,  1060,  1062,
    1145,   808,   809,   808,   808,   548,   807,   808,   997,  1125,
    1156,  1035,    34,   203,   489,  1113,  1129,  1252,  1252,  1252,
    1252,  1252,   858,   855,   574,   579,  1131,  1069,  1068,   301,
     487,   512,   787,   789,   788,  1125,   145,   461,  1228,   827,
     996,   997,   229,   575,   849,   850,   573,   619,  1131,   601,
     996,   996,    52,   335,   335,   399,  1200,   332,   333,   880,
    1131,    91,  1133,  1134,  1187,  1188,   405,    10,   374,   501,
     869,  1220,  1228,  1229,  1237,  1239,  1240,  1246,   869,  1219,
    1229,  1237,  1240,  1246,  1221,  1226,   705,  1131,   175,  1038,
    1042,  1043,  1131,  1045,     7,    20,    22,    25,    29,    32,
      34,    35,    36,    38,    51,    55,    56,    62,    65,    73,
      74,    80,    83,    84,    85,    90,    91,    93,    94,    98,
      99,   100,   105,   107,   110,   111,   118,   119,   136,   139,
     140,   152,   155,   157,   158,   162,   166,   171,   176,   180,
     181,   182,   183,   185,   186,   188,   189,   190,   194,   196,
     197,   203,   209,   213,   223,   225,   242,   246,   249,   254,
     256,   259,   264,   267,   272,   279,   289,   293,   302,   306,
     308,   309,   313,   314,   315,   316,   317,   318,   319,   325,
     332,   333,   334,   337,   338,   343,   361,   362,   364,   365,
     366,   367,   368,   380,   388,   404,   405,   416,   419,   422,
     424,   428,   467,   468,   473,   475,   476,   477,   482,   489,
     491,   492,   493,   494,   503,   504,   505,   510,   513,   518,
     519,   527,   531,   532,   533,   534,   535,   540,   544,   554,
     556,   561,   565,   566,   571,   573,   576,   577,   580,   581,
     874,   875,   876,   877,   881,   884,   885,   887,   894,   898,
     910,  1112,  1114,  1116,  1117,  1121,  1123,  1127,  1131,   152,
    1131,  1131,   344,   611,   611,  1134,  1186,   996,   998,   530,
     595,   120,   205,   263,   287,   373,   381,   409,   445,   466,
     483,  1075,  1076,  1156,   373,  1175,   420,   420,   486,   527,
     542,   349,  1179,   483,  1181,    60,   445,  1178,    95,   542,
    1180,   344,   575,    18,   145,   952,   953,  1163,  1131,   799,
     874,    75,   175,   270,  1093,  1099,    47,   175,  1125,  1157,
    1158,   834,   580,   592,  1128,   263,   838,  1134,   839,   840,
    1125,   822,   226,   997,  1008,  1009,    47,   575,   996,  1175,
     344,   426,  1201,  1200,   516,  1206,  1207,   567,   867,   868,
     869,   865,  1140,  1141,  1142,   263,   150,   436,   252,   546,
    1066,   506,   573,    94,   179,   374,   485,   542,  1066,   712,
    1133,   253,   971,   973,    63,   466,   172,   466,   466,   466,
     287,   483,    63,   466,    12,    40,    81,    86,   231,   300,
     359,   449,   480,  1049,  1050,  1051,   205,   466,   466,   506,
     971,  1066,   175,   229,  1063,   263,   142,    66,   376,   483,
     502,   466,   539,   805,   398,   462,   810,   811,   804,    78,
     799,   575,   346,  1255,   479,  1256,   236,   412,  1254,   574,
    1207,  1209,  1210,  1211,     3,   586,   853,  1072,  1113,  1131,
     111,   700,   701,   710,   711,   759,   612,   612,   786,  1134,
     429,   542,   996,   498,   575,   111,   844,  1131,   843,   217,
     238,   774,   775,   851,   620,   621,   874,   273,   274,   275,
     276,   277,   278,   281,   282,   283,   284,   285,   286,   288,
     396,   397,   602,   603,   604,   156,   382,   820,    54,   156,
     159,   172,   299,   382,   830,   831,   832,    52,   399,   152,
     608,   573,   873,   580,   211,   575,   869,   869,   869,   179,
     542,   179,  1229,  1125,   507,   530,   778,  1042,  1125,  1131,
     575,  1040,   581,  1044,   573,   573,   573,   573,   573,   885,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   873,   873,   573,   873,   573,   573,
     573,   513,   573,  1112,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   874,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   911,   912,   913,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   874,
     573,   873,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   873,   573,  1112,   573,   573,
     573,  1112,   573,   573,    34,   203,   489,   573,   573,   573,
     873,   873,   873,   573,   573,   573,   573,   573,   573,   874,
     915,   885,   885,   885,   430,   573,   874,  1215,  1131,   899,
    1131,    15,    16,   351,   354,   553,   878,   879,   145,   146,
     184,   198,   232,   244,   271,   328,   882,   126,   229,   252,
     313,   395,   439,   440,   448,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   880,   885,   101,   102,   103,   104,
     105,   206,   207,   208,   209,   302,   304,   305,   306,   314,
     380,   427,   428,   544,   555,   556,   948,   950,    64,   353,
     575,  1129,   573,   581,   581,  1125,   575,    49,   411,   800,
     996,   580,   596,   597,    47,   548,   575,  1077,   483,   573,
    1189,  1189,  1189,  1189,   179,   374,   485,  1173,  1177,  1131,
     164,   330,  1131,  1164,  1165,  1008,   287,   258,  1098,   846,
     287,   953,   575,   996,  1133,    27,   498,  1086,   575,   498,
     575,   498,   996,  1009,  1005,  1082,   175,   575,   179,   374,
    1173,  1131,    12,   125,  1213,   575,   860,   871,   874,  1119,
    1131,   575,   191,   258,   345,   435,  1143,  1144,  1147,  1148,
     229,  1064,  1128,   874,   567,   705,   611,   611,  1125,  1125,
    1056,   267,   338,   510,   974,   975,  1114,   611,  1066,  1134,
     172,  1061,  1063,   611,  1066,   230,   481,   160,   172,  1052,
     575,  1061,  1125,  1063,  1061,  1061,  1066,  1066,   523,   812,
     575,   812,   447,   430,   573,   577,   918,   919,   920,   921,
     930,   931,   939,  1113,   363,  1257,   352,   967,   973,  1212,
     701,    64,   750,    68,    80,   241,   311,   335,   389,   461,
     614,   616,     6,    13,    23,    24,    53,    57,    68,    77,
      83,    96,   114,   123,   124,   129,   137,   143,   169,   215,
     217,   224,   292,   307,   312,   352,   358,   361,   384,   385,
     387,   401,   423,   507,   516,   707,   709,   710,   711,   792,
     793,   794,   963,   112,   228,  1125,  1128,   997,   573,   574,
     575,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   145,   145,   145,   145,   575,   525,   831,   699,
     700,   574,  1133,    45,  1188,   179,   611,   611,   611,  1131,
    1125,   606,    44,   200,   425,   779,   779,   344,  1041,  1039,
     581,  1043,   175,   567,  1131,   953,   874,   874,   874,    12,
     125,   904,   954,   107,   166,   203,   267,   338,   510,   977,
     904,   904,   904,   874,   874,   908,   908,   874,   908,   874,
     874,   874,   874,   125,   904,   954,   874,   574,   874,   874,
     874,   874,   874,  1121,  1131,   874,   874,   874,   874,   874,
     573,  1215,   874,   948,   874,   874,   874,   574,   874,   874,
     874,   874,   908,   874,   874,    97,   100,   491,   494,   951,
     874,   125,   901,  1112,   874,   874,   874,   574,   874,   874,
     874,   874,   908,   874,   874,   874,   874,   912,     9,   914,
    1121,   125,   904,   874,   874,   125,   904,   874,   874,   874,
     874,   874,   908,   908,   908,   874,   874,   874,   874,   874,
     874,   908,   877,   874,   574,   874,   874,   874,   874,   874,
     574,   874,   874,   904,   904,   874,   874,   874,   125,   904,
     874,   874,   174,   949,   950,   949,   874,    43,   245,   499,
     874,   874,  1112,   574,   874,   574,   904,  1122,  1123,  1131,
     904,   874,   874,   874,   545,   917,  1216,  1216,   574,   575,
     574,   874,   580,   900,  1133,   581,   874,   874,   874,   876,
     158,   337,   504,   520,   880,    12,    17,   876,   883,   877,
     573,   885,   877,   877,   877,   877,   252,   877,   877,   877,
     877,   884,   877,   884,   877,   877,   877,   877,   229,   252,
     395,   562,   566,  1133,   885,   874,   886,  1131,  1131,   995,
    1134,   800,  1133,   575,   390,  1076,   996,  1078,  1131,  1190,
    1191,   567,  1125,  1131,  1185,  1185,  1185,   145,   164,   184,
     198,   243,   244,   271,   330,   371,  1166,  1168,   546,   955,
    1002,   218,   847,   848,  1125,   270,   390,   550,  1159,  1158,
     874,  1128,  1134,  1134,   840,  1125,   156,   382,   528,   823,
     824,   825,   430,   436,   535,   536,   573,   695,  1010,  1013,
    1128,   192,  1185,  1185,  1185,  1208,   868,   175,   226,   861,
     862,   966,   967,   988,   870,   581,  1141,   111,   500,  1131,
    1150,   321,   361,   580,   750,  1149,  1128,   175,  1065,   574,
    1131,   263,   466,  1058,   341,   575,   445,  1066,  1131,   381,
     971,  1051,  1066,  1061,  1125,  1066,  1066,   604,   813,   811,
     938,  1131,    88,   219,   236,   249,   324,   416,   471,   929,
     436,   575,  1125,   938,   575,   172,  1258,    45,   971,   145,
     437,  1019,  1020,  1020,  1128,   461,   461,   461,   461,   461,
     429,    67,    79,   178,   450,   721,   724,   725,   772,   774,
     798,   798,  1020,  1020,   798,  1020,  1020,  1020,   498,   122,
    1020,   237,   484,   170,   372,   774,   798,   237,  1020,   484,
     122,  1020,  1020,  1020,   798,    45,  1020,  1020,  1020,  1020,
    1020,    18,   145,   498,   802,  1020,  1020,  1020,   707,   575,
     573,   581,   720,   726,  1124,  1131,   790,   372,   946,  1131,
     874,   977,  1128,  1128,   107,   166,   267,   338,   510,   978,
    1128,   977,  1128,  1128,  1128,  1128,  1128,   977,  1128,  1128,
     977,   603,   361,   489,  1131,  1247,     8,    27,   687,   573,
     413,  1230,   252,   573,   689,   706,   708,   709,  1125,   530,
     955,  1131,   919,   581,  1044,   575,   574,   574,   575,   904,
     574,   905,   575,   574,   574,   574,    18,   574,   530,   574,
     574,   574,   574,   575,   575,   530,   575,   575,   895,   574,
     567,   574,   575,   575,   574,   574,   575,   574,   581,   574,
     575,   574,   575,   575,   575,   574,   575,   574,   575,   175,
     575,   575,   574,   575,   574,   575,   575,   574,   575,   574,
     574,   575,   574,   575,   575,   575,   897,   575,   574,   575,
     575,   574,   575,   575,   574,   575,   574,   575,   574,   575,
     575,   575,   574,   573,   575,   904,   574,   574,   574,   904,
     574,   574,   575,   575,   574,   574,   575,   574,   575,   574,
     574,   574,   574,   574,   574,   574,   575,   575,   574,   575,
     574,   229,   574,   574,   575,   575,   575,   574,   575,   575,
     574,   574,   574,   575,   175,   575,   575,   904,   574,   574,
     574,   575,   575,   575,   574,   175,   874,   175,   874,   175,
     874,   175,   574,   575,   575,   574,   574,   574,   574,   574,
     575,   574,   575,   574,   874,   545,   559,   916,   856,   855,
     908,   578,   191,   258,   435,  1146,   437,  1131,   158,   337,
     504,   520,   573,   874,  1215,   149,   959,   877,    16,   948,
     948,   573,   885,   877,   877,   874,   889,   890,   891,   573,
     581,   597,   262,   574,   575,   581,   581,   498,   498,   498,
    1167,   956,   972,   973,  1010,   489,  1130,   575,   849,   550,
     258,   498,   824,   696,  1011,   573,  1016,  1021,  1016,   574,
     695,  1012,  1118,  1119,  1122,  1131,  1014,   349,   175,   175,
     175,   854,   130,   919,   989,   172,   262,   866,   988,   972,
     862,    18,   872,  1128,  1131,   567,  1131,   581,   233,   581,
    1019,    32,   111,   751,   752,  1019,  1133,   172,  1019,   580,
    1133,    32,   111,   754,   755,  1133,   978,  1057,   147,   543,
     975,   975,   548,   338,   955,  1061,   575,   933,   938,   918,
     236,   236,   355,   940,   236,   249,   416,   940,   930,   918,
    1031,  1032,  1122,   918,   953,   935,   936,   977,   303,   968,
     111,   756,   758,  1133,   752,    96,    96,   112,   228,   782,
    1124,   775,   775,    58,   170,   372,   517,   723,   773,   722,
     723,   782,  1124,   978,   977,  1124,   977,  1128,  1128,   750,
    1020,   977,   238,   238,  1124,  1124,   712,  1020,   164,   243,
     335,   715,   978,   978,  1124,   964,   965,  1122,   111,   977,
    1128,   977,   977,   383,   386,   714,   977,  1125,    71,    72,
     111,   133,   165,   393,   713,   712,   573,   794,   718,   719,
     720,   721,  1131,     8,   164,   801,   394,   722,   764,   727,
     581,   573,  1231,   574,   575,   489,   413,   573,   115,   223,
     524,   688,  1241,   108,   227,   391,   472,   717,  1231,  1125,
     252,   690,   695,   718,   214,   405,   692,  1100,   575,   708,
     607,   919,   966,   955,   953,   225,   874,   874,   574,   874,
     874,    32,    56,    97,   100,   108,   326,   443,   494,   522,
     906,   751,   908,   874,   751,   906,   874,   908,   574,   884,
     884,  1129,  1131,   874,   874,   908,  1129,   874,   874,   874,
     908,   338,   874,   874,   874,   874,   874,   874,   874,   908,
     908,   338,   874,   874,   908,   874,   874,   874,   874,   908,
     874,   877,  1121,   574,   574,   874,   874,   874,   874,   874,
     874,   874,   874,   874,   874,   874,   874,   908,   225,   874,
     874,   874,   874,   574,   874,   874,   874,   874,   175,   874,
     175,   874,   175,   874,   874,   338,   874,   874,   560,   874,
     874,   141,  1214,  1214,   574,   581,   581,   581,  1133,   874,
    1215,   574,   575,   574,   885,   876,   874,  1215,   959,    16,
     574,   869,   892,   893,   907,   908,  1131,  1191,   567,   567,
    1187,  1187,  1187,   573,   874,   344,  1026,  1094,   848,   214,
     852,  1134,   863,  1017,  1018,  1122,  1022,   575,   573,  1013,
     574,   574,   575,   581,  1206,   175,  1187,  1187,  1187,   955,
     955,   131,   356,   984,   985,   990,   524,   229,  1128,  1131,
     581,  1131,   250,  1131,    12,    32,   111,   344,   874,  1153,
      64,   757,   874,  1134,   343,   361,   489,  1152,  1146,  1019,
     971,   275,  1066,   604,  1209,   934,   249,   236,   930,   940,
     940,   236,   344,   344,   530,   575,  1030,  1019,   169,   214,
     529,   942,   863,   874,   969,  1120,   874,   238,   238,   775,
     782,   778,   129,   436,   795,   752,  1128,   782,   800,  1128,
     796,   575,    19,   116,   970,  1078,   574,   575,  1131,  1125,
      31,    32,    37,    39,    41,    42,    56,    97,   100,   108,
     127,   144,   165,   167,   186,   187,   227,   256,   265,   266,
     268,   296,   297,   298,   317,   318,   319,   323,   326,   339,
     340,   365,   367,   391,   434,   436,   446,   490,   491,   494,
     495,   496,   497,   537,   538,   556,   728,   731,   732,   733,
     734,   735,   736,   737,  1131,  1131,  1232,    18,  1131,   717,
    1248,   344,   622,   623,   625,  1131,   509,    18,  1125,   574,
     574,    18,   698,   708,   573,   955,   253,   976,   874,   574,
     574,   574,   573,   743,   744,   743,   573,   738,   739,   744,
     743,   227,   227,   574,   574,   574,   574,   574,   574,   575,
     896,   948,   948,   574,   574,   574,   574,   574,   574,   575,
     574,   574,   574,   574,   574,   575,   574,   574,   574,   574,
     574,   903,   967,   575,   575,   575,   574,   574,   574,   574,
     575,   574,   574,   574,   575,   229,   548,   888,   574,   574,
     574,   574,   574,   574,   574,   574,   574,   575,   574,   574,
     574,   874,   574,   172,   574,   574,   575,   575,   574,   575,
     575,   574,   874,   574,   874,   574,   874,   574,   574,   575,
     574,   574,   874,   560,  1217,  1217,   581,   783,   574,   908,
     574,   575,   574,   876,   874,   575,   574,   407,  1192,  1192,
    1192,   111,   874,  1024,  1025,   132,  1100,   247,   867,   575,
    1019,  1023,  1024,  1021,  1015,  1013,  1118,  1131,  1187,   972,
     195,   960,  1130,  1130,   580,   986,   987,  1133,   438,   567,
     390,   403,   433,  1151,   758,  1019,   573,   573,  1150,   874,
     145,   574,   920,   355,   918,   930,   236,   236,   918,   930,
     923,   922,   924,  1032,   955,  1025,   774,   943,   943,   943,
     867,   575,   970,   782,   778,   573,   111,   111,   726,   757,
     728,   965,   574,   719,   765,   744,   744,   743,   738,   369,
     729,   738,   738,    20,    32,    46,   515,   750,   760,    56,
     537,   732,   734,   760,   760,    56,   538,   538,   541,   738,
     730,   743,   743,   760,   744,   743,    23,    64,    68,   111,
     337,   344,   372,   434,   517,   746,   747,   748,   763,   880,
     541,   744,   760,    32,   744,   761,   744,   744,   743,   573,
     739,   745,   581,   574,   575,  1233,  1234,   509,   221,   229,
     357,   626,   627,   628,   629,   869,   574,   575,   624,  1128,
    1233,   574,   691,   706,   573,   695,   780,   781,  1131,   975,
     948,   107,   267,   338,   510,   760,   338,   874,   574,   574,
     574,   874,   874,   432,   902,   338,   874,   874,   874,   874,
      41,   381,   574,   874,   948,   874,   874,   874,   874,   874,
     574,   574,   574,   338,   874,   574,  1131,   574,   908,   870,
     893,    59,   234,   331,   463,   474,   551,  1183,  1184,   548,
    1193,  1193,  1193,   574,   575,  1027,   226,   697,  1018,  1025,
     574,  1209,    45,   201,   957,   991,  1133,   575,   310,    69,
     511,   390,  1152,   489,   489,  1019,  1128,   953,   236,   344,
     926,   930,   930,   344,   928,   874,   874,   573,   966,   172,
     941,   937,  1120,   573,   573,   780,   100,   491,   494,   565,
     566,  1115,  1116,   801,   746,   289,   344,   573,   766,   768,
     769,   770,   443,   522,   557,   740,   741,   742,   573,   740,
     740,   761,    20,   515,   750,   762,   761,   751,   760,   541,
     740,   573,   760,   740,   756,  1128,   334,   749,  1115,   524,
     111,   238,   748,   238,   337,   760,   761,   760,   761,   740,
     338,   740,  1131,  1131,   548,  1236,   430,   573,  1235,  1128,
     574,   575,   624,  1125,  1242,   625,   728,  1236,  1209,   692,
     695,   693,   574,   575,   970,   573,   574,   574,   574,   574,
     574,   575,   574,   574,   575,   574,  1113,   574,   575,   574,
     575,   574,   574,   310,   154,   574,   574,   574,   574,   574,
     574,   574,   575,   574,   872,   489,   489,   489,    16,  1182,
     192,   290,   291,   294,   295,  1194,  1195,  1025,   238,  1095,
     716,   862,   972,   961,  1120,   958,   966,    66,  1101,   987,
     574,   574,  1153,    16,   918,   925,   530,   927,   530,   947,
    1131,   976,   236,   944,   716,   970,   780,   780,   574,  1117,
    1117,   797,   177,   360,   444,   115,   524,   767,  1131,   770,
     742,   784,  1113,   751,   761,   784,   873,   334,   536,    50,
      58,   258,   869,   869,  1249,   628,  1131,   172,   413,   574,
    1206,   781,   338,   338,   874,   904,   874,   908,  1183,   349,
     977,   977,   977,   977,  1195,   524,   485,   866,   548,   575,
     962,   970,   874,   972,   138,   148,   350,   488,  1102,  1103,
     255,  1104,   276,   344,   874,   573,   874,   573,   574,   575,
     573,   574,   574,   778,   801,    49,   335,   411,   436,   771,
     771,   574,   575,   574,   575,   574,   873,    58,   349,    58,
     856,   855,   613,   728,   869,  1243,   694,   970,   574,   574,
     574,   575,   574,   574,   574,  1033,  1034,  1122,  1125,    89,
     418,  1120,   374,   979,    45,    45,   138,    45,  1103,   464,
     488,  1105,  1106,   145,   932,   947,   947,  1131,   945,   946,
     764,   778,     5,   111,   337,   768,  1131,   760,  1113,   760,
     349,   349,   574,   121,   614,   615,   880,  1250,   134,   728,
    1209,   874,   575,  1019,  1096,   970,  1131,  1113,  1113,    45,
    1113,    45,    45,  1106,   978,   874,   574,   574,   574,  1209,
     121,    61,   161,   213,   235,   248,   347,   414,   561,   646,
     647,   650,   659,   660,   663,   674,   677,   679,   680,  1127,
    1132,  1136,   424,  1244,   574,  1034,  1025,   750,   753,   980,
    1113,  1113,  1113,    16,   578,  1131,   175,   330,   652,   649,
    1132,  1132,  1131,   648,   661,   664,   588,   269,   404,   547,
     683,    28,   681,   582,  1238,   613,   752,  1097,   573,   280,
     175,  1131,   654,   655,   874,   874,   545,   666,   670,   631,
     646,   631,   684,   682,   675,   678,   646,  1245,  1101,   869,
     981,   982,   983,   145,   226,   141,   874,   662,   671,   559,
     670,   673,   141,   646,   579,   523,   874,   632,   683,   681,
     646,  1104,   874,   574,   575,   977,   651,   213,   560,   545,
     665,   667,   874,   631,   141,   269,   579,   686,   128,   109,
     630,   633,   676,  1132,   676,   214,  1107,   983,   653,  1131,
     656,   668,   667,   673,   672,   561,   874,   685,    82,   153,
     638,   644,  1131,   141,   646,   579,   338,   573,  1108,   575,
     631,   874,   141,   560,   141,   631,   199,   575,   634,    76,
      92,   579,   255,   574,   580,  1109,  1110,  1122,   436,  1111,
    1131,   657,   669,   561,   631,   404,   141,   172,  1131,   728,
     172,   172,  1133,   574,   575,  1033,   135,   559,   658,   560,
     547,   635,   111,   645,   453,   641,   977,   636,   637,  1110,
     654,   631,   631,   452,   454,   639,   640,   641,   643,   880,
    1131,   874,   536,   642,   588,   575,   646,   173,  1129,   640
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}

/* Prevent warnings from -Wmissing-prototypes.  */
#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */





/*-------------------------.
| yyparse or yypush_parse.  |
`-------------------------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks thru separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yytoken = 0;
  yyss = yyssa;
  yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */
  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:

/* Line 1455 of yacc.c  */
#line 1227 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            if (!thd->bootstrap &&
              (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
            {
              my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
              MYSQL_YYABORT;
            }
            thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
            YYLIP->found_semicolon= NULL;
          }
    break;

  case 3:

/* Line 1455 of yacc.c  */
#line 1239 "sql_yacc.yy"
    {
            Lex_input_stream *lip = YYLIP;

            if ((YYTHD->client_capabilities & CLIENT_MULTI_QUERIES) &&
                ! lip->stmt_prepare_mode &&
                ! (lip->ptr >= lip->end_of_query))
            {
              /*
                We found a well formed query, and multi queries are allowed:
                - force the parser to stop after the ';'
                - mark the start of the next query for the next invocation
                  of the parser.
              */
              lip->next_state= MY_LEX_END;
              lip->found_semicolon= lip->ptr;
            }
            else
            {
              /* Single query, terminated. */
              lip->found_semicolon= NULL;
            }
          }
    break;

  case 5:

/* Line 1455 of yacc.c  */
#line 1264 "sql_yacc.yy"
    {
            /* Single query, not terminated. */
            YYLIP->found_semicolon= NULL;
          }
    break;

  case 57:

/* Line 1455 of yacc.c  */
#line 1333 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= (yyvsp[(3) - (3)].lex_str);
        }
    break;

  case 60:

/* Line 1455 of yacc.c  */
#line 1348 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= (yyvsp[(2) - (4)].lex_str);
        }
    break;

  case 61:

/* Line 1455 of yacc.c  */
#line 1357 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[(1) - (1)].lex_str);
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 62:

/* Line 1455 of yacc.c  */
#line 1364 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[(2) - (2)].lex_str);
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 63:

/* Line 1455 of yacc.c  */
#line 1373 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= (yyvsp[(2) - (2)].lex_str);
        }
    break;

  case 64:

/* Line 1455 of yacc.c  */
#line 1380 "sql_yacc.yy"
    {}
    break;

  case 69:

/* Line 1455 of yacc.c  */
#line 1394 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&(yyvsp[(2) - (2)].lex_str), sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              MYSQL_YYABORT;
        }
    break;

  case 70:

/* Line 1455 of yacc.c  */
#line 1406 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           MYSQL_YYABORT;
         }
       }
    break;

  case 71:

/* Line 1455 of yacc.c  */
#line 1414 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 72:

/* Line 1455 of yacc.c  */
#line 1424 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 73:

/* Line 1455 of yacc.c  */
#line 1430 "sql_yacc.yy"
    {}
    break;

  case 76:

/* Line 1455 of yacc.c  */
#line 1439 "sql_yacc.yy"
    {
	 Lex->mi.host = (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 77:

/* Line 1455 of yacc.c  */
#line 1444 "sql_yacc.yy"
    {
	 Lex->mi.user = (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 78:

/* Line 1455 of yacc.c  */
#line 1449 "sql_yacc.yy"
    {
	 Lex->mi.password = (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 79:

/* Line 1455 of yacc.c  */
#line 1454 "sql_yacc.yy"
    {
	 Lex->mi.port = (yyvsp[(3) - (3)].ulong_num);
       }
    break;

  case 80:

/* Line 1455 of yacc.c  */
#line 1459 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = (yyvsp[(3) - (3)].ulong_num);
       }
    break;

  case 81:

/* Line 1455 of yacc.c  */
#line 1463 "sql_yacc.yy"
    {
           Lex->mi.ssl= (yyvsp[(3) - (3)].ulong_num) ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 82:

/* Line 1455 of yacc.c  */
#line 1468 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 83:

/* Line 1455 of yacc.c  */
#line 1472 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 84:

/* Line 1455 of yacc.c  */
#line 1476 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 85:

/* Line 1455 of yacc.c  */
#line 1480 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 86:

/* Line 1455 of yacc.c  */
#line 1484 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= (yyvsp[(3) - (3)].lex_str).str;
	 }
    break;

  case 88:

/* Line 1455 of yacc.c  */
#line 1493 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 89:

/* Line 1455 of yacc.c  */
#line 1497 "sql_yacc.yy"
    {
           Lex->mi.pos = (yyvsp[(3) - (3)].ulonglong_number);
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 90:

/* Line 1455 of yacc.c  */
#line 1513 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 91:

/* Line 1455 of yacc.c  */
#line 1517 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = (yyvsp[(3) - (3)].ulong_num);
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 92:

/* Line 1455 of yacc.c  */
#line 1528 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[(5) - (5)].table), NULL,
						 TL_OPTION_UPDATING,
						 TL_WRITE))
	    MYSQL_YYABORT;
          lex->alter_info.reset();
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=(yyvsp[(2) - (5)].num) | (yyvsp[(4) - (5)].num);
	  lex->create_info.db_type= (enum db_type) lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	}
    break;

  case 93:

/* Line 1455 of yacc.c  */
#line 1545 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 94:

/* Line 1455 of yacc.c  */
#line 1547 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, (yyvsp[(7) - (7)].table), NULL,
							TL_OPTION_UPDATING))
	      MYSQL_YYABORT;
            lex->alter_info.reset();
            lex->alter_info.flags= ALTER_ADD_INDEX;
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 95:

/* Line 1455 of yacc.c  */
#line 1559 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[(2) - (11)].key_type), (yyvsp[(4) - (11)].lex_str).str, (yyvsp[(5) - (11)].key_alg), 0, lex->col_list);
            if (key == NULL)
              MYSQL_YYABORT;

            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();
	  }
    break;

  case 96:

/* Line 1455 of yacc.c  */
#line 1569 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 97:

/* Line 1455 of yacc.c  */
#line 1574 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name=(yyvsp[(4) - (6)].lex_str).str;
            lex->create_info.options=(yyvsp[(3) - (6)].num);
	  }
    break;

  case 98:

/* Line 1455 of yacc.c  */
#line 1581 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 99:

/* Line 1455 of yacc.c  */
#line 1587 "sql_yacc.yy"
    {}
    break;

  case 100:

/* Line 1455 of yacc.c  */
#line 1589 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 101:

/* Line 1455 of yacc.c  */
#line 1596 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 102:

/* Line 1455 of yacc.c  */
#line 1611 "sql_yacc.yy"
    {
            if (!(yyvsp[(1) - (3)].lex_str).str || check_db_name((yyvsp[(1) - (3)].lex_str).str))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), (yyvsp[(1) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    if (check_routine_name((yyvsp[(3) - (3)].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[(3) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spname)= new sp_name((yyvsp[(1) - (3)].lex_str), (yyvsp[(3) - (3)].lex_str), true);
            if ((yyval.spname) == NULL)
              MYSQL_YYABORT;
	    (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 103:

/* Line 1455 of yacc.c  */
#line 1628 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            LEX_STRING db;

	    if (check_routine_name((yyvsp[(1) - (1)].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	      MYSQL_YYABORT;
	    }
            if (lex->copy_db_to(&db.str, &db.length))
              MYSQL_YYABORT;
	    (yyval.spname)= new sp_name(db, (yyvsp[(1) - (1)].lex_str), false);
            if ((yyval.spname) == NULL)
              MYSQL_YYABORT;
	    (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 104:

/* Line 1455 of yacc.c  */
#line 1647 "sql_yacc.yy"
    {}
    break;

  case 105:

/* Line 1455 of yacc.c  */
#line 1648 "sql_yacc.yy"
    {}
    break;

  case 106:

/* Line 1455 of yacc.c  */
#line 1652 "sql_yacc.yy"
    {}
    break;

  case 107:

/* Line 1455 of yacc.c  */
#line 1653 "sql_yacc.yy"
    {}
    break;

  case 108:

/* Line 1455 of yacc.c  */
#line 1659 "sql_yacc.yy"
    { Lex->sp_chistics.comment= (yyvsp[(2) - (2)].lex_str); }
    break;

  case 109:

/* Line 1455 of yacc.c  */
#line 1661 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 110:

/* Line 1455 of yacc.c  */
#line 1663 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 111:

/* Line 1455 of yacc.c  */
#line 1665 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 112:

/* Line 1455 of yacc.c  */
#line 1667 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 113:

/* Line 1455 of yacc.c  */
#line 1669 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 114:

/* Line 1455 of yacc.c  */
#line 1671 "sql_yacc.yy"
    { }
    break;

  case 115:

/* Line 1455 of yacc.c  */
#line 1676 "sql_yacc.yy"
    { }
    break;

  case 116:

/* Line 1455 of yacc.c  */
#line 1677 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 117:

/* Line 1455 of yacc.c  */
#line 1678 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 118:

/* Line 1455 of yacc.c  */
#line 1683 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 119:

/* Line 1455 of yacc.c  */
#line 1687 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 120:

/* Line 1455 of yacc.c  */
#line 1694 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= (yyvsp[(2) - (2)].spname);
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, (yyvsp[(2) - (2)].spname), TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 121:

/* Line 1455 of yacc.c  */
#line 1702 "sql_yacc.yy"
    {}
    break;

  case 126:

/* Line 1455 of yacc.c  */
#line 1718 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[(3) - (3)].item));
	  }
    break;

  case 127:

/* Line 1455 of yacc.c  */
#line 1722 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[(1) - (1)].item));
	  }
    break;

  case 132:

/* Line 1455 of yacc.c  */
#line 1740 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 133:

/* Line 1455 of yacc.c  */
#line 1760 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[(1) - (3)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[(1) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[(1) - (3)].lex_str),
                                                     (enum enum_field_types)(yyvsp[(3) - (3)].num),
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[(3) - (3)].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 138:

/* Line 1455 of yacc.c  */
#line 1797 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[(3) - (4)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[(3) - (4)].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[(3) - (4)].lex_str),
                                                     (enum enum_field_types)(yyvsp[(4) - (4)].num),
                                                     (sp_param_mode_t)(yyvsp[(1) - (4)].num));

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[(4) - (4)].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 139:

/* Line 1455 of yacc.c  */
#line 1822 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 140:

/* Line 1455 of yacc.c  */
#line 1823 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 141:

/* Line 1455 of yacc.c  */
#line 1824 "sql_yacc.yy"
    { (yyval.num)= sp_param_out; }
    break;

  case 142:

/* Line 1455 of yacc.c  */
#line 1825 "sql_yacc.yy"
    { (yyval.num)= sp_param_inout; }
    break;

  case 143:

/* Line 1455 of yacc.c  */
#line 1829 "sql_yacc.yy"
    {}
    break;

  case 145:

/* Line 1455 of yacc.c  */
#line 1834 "sql_yacc.yy"
    {}
    break;

  case 147:

/* Line 1455 of yacc.c  */
#line 1840 "sql_yacc.yy"
    {
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	  }
    break;

  case 148:

/* Line 1455 of yacc.c  */
#line 1844 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if (((yyvsp[(2) - (3)].spblock).vars || (yyvsp[(2) - (3)].spblock).conds) && ((yyvsp[(1) - (3)].spblock).curs || (yyvsp[(1) - (3)].spblock).hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      MYSQL_YYABORT;
	    }
	    if ((yyvsp[(2) - (3)].spblock).curs && (yyvsp[(1) - (3)].spblock).hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    (yyval.spblock).vars= (yyvsp[(1) - (3)].spblock).vars + (yyvsp[(2) - (3)].spblock).vars;
	    (yyval.spblock).conds= (yyvsp[(1) - (3)].spblock).conds + (yyvsp[(2) - (3)].spblock).conds;
	    (yyval.spblock).hndlrs= (yyvsp[(1) - (3)].spblock).hndlrs + (yyvsp[(2) - (3)].spblock).hndlrs;
	    (yyval.spblock).curs= (yyvsp[(1) - (3)].spblock).curs + (yyvsp[(2) - (3)].spblock).curs;
	  }
    break;

  case 149:

/* Line 1455 of yacc.c  */
#line 1870 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            if (lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
            lex->spcont->declare_var_boundary((yyvsp[(2) - (2)].num));
          }
    break;

  case 150:

/* Line 1455 of yacc.c  */
#line 1879 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            if (pctx == 0)
            {
              MYSQL_YYABORT;
            }
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) (yyvsp[(4) - (5)].num);
            Item *dflt_value_item= (yyvsp[(5) - (5)].item);
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              if (dflt_value_item == NULL)
                MYSQL_YYABORT;
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-(yyvsp[(2) - (5)].num) ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                MYSQL_YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                MYSQL_YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              sp_instr_set *is= new sp_instr_set(lex->sphead->instructions(),
                                                 pctx,
                                                 var_idx,
                                                 dflt_value_item,
                                                 var_type,
                                                 lex,
                                                 (i == num_vars - 1));
              if (is == NULL ||
                  lex->sphead->add_instr(is))
                MYSQL_YYABORT;
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            (yyval.spblock).vars= (yyvsp[(2) - (5)].num);
            (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
          }
    break;

  case 151:

/* Line 1455 of yacc.c  */
#line 1939 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&(yyvsp[(2) - (5)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), (yyvsp[(2) - (5)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    if(YYTHD->lex->spcont->push_cond(&(yyvsp[(2) - (5)].lex_str), (yyvsp[(5) - (5)].spcondtype)))
              MYSQL_YYABORT;
	    (yyval.spblock).vars= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	    (yyval.spblock).conds= 1;
	  }
    break;

  case 152:

/* Line 1455 of yacc.c  */
#line 1954 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            lex->spcont= lex->spcont->push_context(LABEL_HANDLER_SCOPE);

	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, (yyvsp[(2) - (4)].num),
	                              ctx->current_var_count());
            if (i == NULL ||
	        sp->add_instr(i))
              MYSQL_YYABORT;

	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 153:

/* Line 1455 of yacc.c  */
#line 1971 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if ((yyvsp[(2) - (7)].num) == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
              if (i == NULL ||
	          sp->add_instr(i))
                MYSQL_YYABORT;
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);
              if (i == NULL ||
	          sp->add_instr(i) ||
	          sp->push_backpatch(i, lex->spcont->last_label())) /* Block end */
                MYSQL_YYABORT;
	    }
	    lex->sphead->backpatch(hlab);

            lex->spcont= ctx->pop_context();

	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).curs= 0;
	    (yyval.spblock).hndlrs= (yyvsp[(6) - (7)].num);
	    lex->spcont->add_handlers((yyvsp[(6) - (7)].num));
	  }
    break;

  case 154:

/* Line 1455 of yacc.c  */
#line 2003 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&(yyvsp[(2) - (5)].lex_str), &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), (yyvsp[(2) - (5)].lex_str).str);
	      delete (yyvsp[(5) - (5)].lex);
	      MYSQL_YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, (yyvsp[(5) - (5)].lex),
                                  ctx->current_cursor_count());
	    if (i == NULL ||
                sp->add_instr(i) ||
	        ctx->push_cursor(&(yyvsp[(2) - (5)].lex_str)))
              MYSQL_YYABORT;
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= 0;
	    (yyval.spblock).curs= 1;
	  }
    break;

  case 155:

/* Line 1455 of yacc.c  */
#line 2028 "sql_yacc.yy"
    {
	    if(Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;

	    /* We use statement here just be able to get a better
	       error message. Using 'select' works too, but will then
	       result in a generic "syntax error" if a non-select
	       statement is given. */
	  }
    break;

  case 156:

/* Line 1455 of yacc.c  */
#line 2038 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT)
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    (yyval.lex)= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 157:

/* Line 1455 of yacc.c  */
#line 2060 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_EXIT; }
    break;

  case 158:

/* Line 1455 of yacc.c  */
#line 2061 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_CONTINUE; }
    break;

  case 159:

/* Line 1455 of yacc.c  */
#line 2067 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 160:

/* Line 1455 of yacc.c  */
#line 2069 "sql_yacc.yy"
    { (yyval.num)+= 1; }
    break;

  case 161:

/* Line 1455 of yacc.c  */
#line 2074 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont->parent_context();

	    if (ctx->find_handler((yyvsp[(1) - (1)].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[(1) - (1)].spcondtype));
	      ctx->push_handler((yyvsp[(1) - (1)].spcondtype));
	    }
	  }
    break;

  case 162:

/* Line 1455 of yacc.c  */
#line 2097 "sql_yacc.yy"
    {			/* mysql errno */
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
            if ((yyval.spcondtype) == NULL)
              YYABORT;
	    (yyval.spcondtype)->type= sp_cond_type_t::number;
	    (yyval.spcondtype)->mysqlerr= (yyvsp[(1) - (1)].ulong_num);
	  }
    break;

  case 163:

/* Line 1455 of yacc.c  */
#line 2105 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&(yyvsp[(3) - (3)].lex_str)))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), (yyvsp[(3) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
            if ((yyval.spcondtype) == NULL)
              YYABORT;
	    (yyval.spcondtype)->type= sp_cond_type_t::state;
	    memcpy((yyval.spcondtype)->sqlstate, (yyvsp[(3) - (3)].lex_str).str, 5);
	    (yyval.spcondtype)->sqlstate[5]= '\0';
	  }
    break;

  case 164:

/* Line 1455 of yacc.c  */
#line 2121 "sql_yacc.yy"
    {}
    break;

  case 165:

/* Line 1455 of yacc.c  */
#line 2122 "sql_yacc.yy"
    {}
    break;

  case 166:

/* Line 1455 of yacc.c  */
#line 2127 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (yyvsp[(1) - (1)].spcondtype);
	  }
    break;

  case 167:

/* Line 1455 of yacc.c  */
#line 2131 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= Lex->spcont->find_cond(&(yyvsp[(1) - (1)].lex_str));
	    if ((yyval.spcondtype) == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	  }
    break;

  case 168:

/* Line 1455 of yacc.c  */
#line 2140 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
            if ((yyval.spcondtype) == NULL)
              YYABORT;
	    (yyval.spcondtype)->type= sp_cond_type_t::warning;
	  }
    break;

  case 169:

/* Line 1455 of yacc.c  */
#line 2147 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
            if ((yyval.spcondtype) == NULL)
              YYABORT;
	    (yyval.spcondtype)->type= sp_cond_type_t::notfound;
	  }
    break;

  case 170:

/* Line 1455 of yacc.c  */
#line 2154 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
            if ((yyval.spcondtype) == NULL)
              YYABORT;
	    (yyval.spcondtype)->type= sp_cond_type_t::exception;
	  }
    break;

  case 171:

/* Line 1455 of yacc.c  */
#line 2164 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[(1) - (1)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[(1) - (1)].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= 1;
	  }
    break;

  case 172:

/* Line 1455 of yacc.c  */
#line 2179 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[(3) - (3)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[(3) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[(3) - (3)].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= (yyvsp[(1) - (3)].num) + 1;
	  }
    break;

  case 173:

/* Line 1455 of yacc.c  */
#line 2196 "sql_yacc.yy"
    { (yyval.item) = NULL; }
    break;

  case 174:

/* Line 1455 of yacc.c  */
#line 2197 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[(2) - (2)].item); }
    break;

  case 175:

/* Line 1455 of yacc.c  */
#line 2201 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= YYLIP;

	    if (lex->sphead->reset_lex(thd))
              MYSQL_YYABORT;
	    lex->sphead->m_tmp_query= lip->tok_start;
	  }
    break;

  case 176:

/* Line 1455 of yacc.c  */
#line 2211 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= YYLIP;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      MYSQL_YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i= new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);
              if (i == NULL)
                MYSQL_YYABORT;
              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= (uint) (lip->ptr - sp->m_tmp_query);
              else
                i->m_query.length= (uint) (lip->tok_end - sp->m_tmp_query);
              if (!(i->m_query.str= strmake_root(thd->mem_root,
                                                 sp->m_tmp_query,
                                                 i->m_query.length)) ||
                    sp->add_instr(i))
                MYSQL_YYABORT;
            }
	    sp->restore_lex(thd);
          }
    break;

  case 177:

/* Line 1455 of yacc.c  */
#line 2254 "sql_yacc.yy"
    {
            if(Lex->sphead->reset_lex(YYTHD))
               MYSQL_YYABORT;
          }
    break;

  case 178:

/* Line 1455 of yacc.c  */
#line 2259 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, (yyvsp[(3) - (3)].item),
                                      sp->m_return_field_def.sql_type, lex);
              if (i == NULL ||
	          sp->add_instr(i))
                MYSQL_YYABORT;
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 179:

/* Line 1455 of yacc.c  */
#line 2282 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 180:

/* Line 1455 of yacc.c  */
#line 2284 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 182:

/* Line 1455 of yacc.c  */
#line 2287 "sql_yacc.yy"
    {}
    break;

  case 183:

/* Line 1455 of yacc.c  */
#line 2288 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 184:

/* Line 1455 of yacc.c  */
#line 2294 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 185:

/* Line 1455 of yacc.c  */
#line 2300 "sql_yacc.yy"
    {}
    break;

  case 186:

/* Line 1455 of yacc.c  */
#line 2302 "sql_yacc.yy"
    {}
    break;

  case 187:

/* Line 1455 of yacc.c  */
#line 2304 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[(2) - (2)].lex_str).str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", (yyvsp[(2) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;
              /*
                When jumping to a BEGIN-END block end, the target jump
                points to the block hpop/cpop cleanup instructions,
                so we should exclude the block context here.
                When jumping to something else (i.e., SP_LAB_ITER),
                there are no hpop/cpop at the jump destination,
                so we should include the block context here for cleanup.
              */
              bool exclusive= (lab->type == SP_LAB_BEGIN);

	      n= ctx->diff_handlers(lab->ctx, exclusive);
	      if (n)
              {
                sp_instr_hpop *hpop= new sp_instr_hpop(ip++, ctx, n);
                if (hpop == NULL ||
	            sp->add_instr(hpop))
                  MYSQL_YYABORT;
              }
	      n= ctx->diff_cursors(lab->ctx, exclusive);
	      if (n)
              {
                sp_instr_cpop *cpop= new sp_instr_cpop(ip++, ctx, n);
                if (cpop == NULL ||
	            sp->add_instr(cpop))
                  MYSQL_YYABORT;
              }
	      i= new sp_instr_jump(ip, ctx);
              if (i == NULL ||
	          sp->push_backpatch(i, lab) ||  /* Jumping forward */
                  sp->add_instr(i))
                MYSQL_YYABORT;
	    }
	  }
    break;

  case 188:

/* Line 1455 of yacc.c  */
#line 2354 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[(2) - (2)].lex_str).str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", (yyvsp[(2) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
              {
                sp_instr_hpop *hpop= new sp_instr_hpop(ip++, ctx, n);
                if (hpop == NULL ||
	            sp->add_instr(hpop))
                  MYSQL_YYABORT;
              }
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
              {
                sp_instr_cpop *cpop= new sp_instr_cpop(ip++, ctx, n);
                if (cpop == NULL ||
	            sp->add_instr(cpop))
                  MYSQL_YYABORT;
              }
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              if (i == NULL ||
                  sp->add_instr(i))
                MYSQL_YYABORT;
	    }
	  }
    break;

  case 189:

/* Line 1455 of yacc.c  */
#line 2394 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[(2) - (2)].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[(2) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
            if (i == NULL ||
	        sp->add_instr(i))
              MYSQL_YYABORT;
	  }
    break;

  case 190:

/* Line 1455 of yacc.c  */
#line 2411 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[(3) - (4)].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[(3) - (4)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
            if (i == NULL ||
	        sp->add_instr(i))
              MYSQL_YYABORT;
	  }
    break;

  case 191:

/* Line 1455 of yacc.c  */
#line 2428 "sql_yacc.yy"
    { }
    break;

  case 192:

/* Line 1455 of yacc.c  */
#line 2430 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[(2) - (2)].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[(2) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
            if (i == NULL ||
	        sp->add_instr(i))
              MYSQL_YYABORT;
	  }
    break;

  case 196:

/* Line 1455 of yacc.c  */
#line 2456 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[(1) - (1)].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 197:

/* Line 1455 of yacc.c  */
#line 2477 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[(3) - (3)].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[(3) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 198:

/* Line 1455 of yacc.c  */
#line 2499 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 199:

/* Line 1455 of yacc.c  */
#line 2504 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               (yyvsp[(2) - (3)].item), lex);
            if (i == NULL ||
	        sp->push_backpatch(i, ctx->push_label((char *)"", 0)) ||
                sp->add_cont_backpatch(i) ||
                sp->add_instr(i))
              MYSQL_YYABORT;
            sp->restore_lex(YYTHD);
	  }
    break;

  case 200:

/* Line 1455 of yacc.c  */
#line 2519 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);
            if (i == NULL ||
	        sp->add_instr(i))
              MYSQL_YYABORT;
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 201:

/* Line 1455 of yacc.c  */
#line 2531 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 207:

/* Line 1455 of yacc.c  */
#line 2551 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            if (lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 208:

/* Line 1455 of yacc.c  */
#line 2558 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, (yyvsp[(3) - (3)].item)))
              MYSQL_YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 209:

/* Line 1455 of yacc.c  */
#line 2569 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 210:

/* Line 1455 of yacc.c  */
#line 2577 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 211:

/* Line 1455 of yacc.c  */
#line 2585 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 216:

/* Line 1455 of yacc.c  */
#line 2603 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 217:

/* Line 1455 of yacc.c  */
#line 2608 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            if (case_stmt_action_when(lex, (yyvsp[(3) - (3)].item), true))
              MYSQL_YYABORT;
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 218:

/* Line 1455 of yacc.c  */
#line 2618 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_then(lex))
              MYSQL_YYABORT;
          }
    break;

  case 219:

/* Line 1455 of yacc.c  */
#line 2627 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 220:

/* Line 1455 of yacc.c  */
#line 2632 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_when(lex, (yyvsp[(3) - (3)].item), false))
              MYSQL_YYABORT;
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 221:

/* Line 1455 of yacc.c  */
#line 2640 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_then(lex))
              MYSQL_YYABORT;
          }
    break;

  case 222:

/* Line 1455 of yacc.c  */
#line 2649 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            if (i == NULL ||
                sp->add_instr(i))
              MYSQL_YYABORT;
          }
    break;

  case 224:

/* Line 1455 of yacc.c  */
#line 2664 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[(1) - (2)].lex_str).str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[(1) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label((yyvsp[(1) - (2)].lex_str).str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 225:

/* Line 1455 of yacc.c  */
#line 2682 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
            sp_label_t *lab= lex->spcont->pop_label();

	    if ((yyvsp[(5) - (5)].lex_str).str)
	    {
	      if (my_strcasecmp(system_charset_info, (yyvsp[(5) - (5)].lex_str).str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[(5) - (5)].lex_str).str);
	        MYSQL_YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lab);
	  }
    break;

  case 226:

/* Line 1455 of yacc.c  */
#line 2699 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 227:

/* Line 1455 of yacc.c  */
#line 2700 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str); }
    break;

  case 228:

/* Line 1455 of yacc.c  */
#line 2705 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *ctx= lex->spcont;
            sp_label_t *lab= ctx->find_label((yyvsp[(1) - (2)].lex_str).str);

            if (lab)
            {
              my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[(1) - (2)].lex_str).str);
              MYSQL_YYABORT;
            }

            lab= lex->spcont->push_label((yyvsp[(1) - (2)].lex_str).str,
                                         lex->sphead->instructions());
            lab->type= SP_LAB_BEGIN;
          }
    break;

  case 229:

/* Line 1455 of yacc.c  */
#line 2721 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_label_t *lab= lex->spcont->pop_label();

            if ((yyvsp[(5) - (5)].lex_str).str)
            {
              if (my_strcasecmp(system_charset_info, (yyvsp[(5) - (5)].lex_str).str, lab->name) != 0)
              {
                my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[(5) - (5)].lex_str).str);
                MYSQL_YYABORT;
              }
            }
          }
    break;

  case 230:

/* Line 1455 of yacc.c  */
#line 2737 "sql_yacc.yy"
    { /* Unlabeled blocks get a secret label. */
            LEX *lex= Lex;
            uint ip= lex->sphead->instructions();
            sp_label_t *lab= lex->spcont->push_label((char *)"", ip);
            lab->type= SP_LAB_BEGIN;
          }
    break;

  case 231:

/* Line 1455 of yacc.c  */
#line 2744 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->spcont->pop_label();
          }
    break;

  case 232:

/* Line 1455 of yacc.c  */
#line 2752 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    lex->spcont= lex->spcont->push_context(LABEL_DEFAULT_SCOPE);
	  }
    break;

  case 233:

/* Line 1455 of yacc.c  */
#line 2761 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if ((yyvsp[(3) - (5)].spblock).hndlrs)
            {
              sp_instr_hpop *hpop= new sp_instr_hpop(sp->instructions(), ctx,
                                                     (yyvsp[(3) - (5)].spblock).hndlrs);
              if (hpop == NULL ||
	          sp->add_instr(hpop))
                MYSQL_YYABORT;
            }
	    if ((yyvsp[(3) - (5)].spblock).curs)
            {
              sp_instr_cpop *cpop= new sp_instr_cpop(sp->instructions(), ctx,
                                                     (yyvsp[(3) - (5)].spblock).curs);
              if (cpop == NULL ||
	          sp->add_instr(cpop))
                MYSQL_YYABORT;
            }
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 234:

/* Line 1455 of yacc.c  */
#line 2790 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);
            if (i == NULL ||
	        lex->sphead->add_instr(i))
              MYSQL_YYABORT;
	  }
    break;

  case 235:

/* Line 1455 of yacc.c  */
#line 2800 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 236:

/* Line 1455 of yacc.c  */
#line 2805 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       (yyvsp[(3) - (4)].item), lex);
            if (i == NULL ||
	    /* Jumping forward */
                sp->push_backpatch(i, lex->spcont->last_label()) ||
                sp->new_cont_backpatch(i) ||
                sp->add_instr(i))
              MYSQL_YYABORT;
            sp->restore_lex(YYTHD);
	  }
    break;

  case 237:

/* Line 1455 of yacc.c  */
#line 2820 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);
            if (i == NULL ||
	        lex->sphead->add_instr(i))
              MYSQL_YYABORT;
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 238:

/* Line 1455 of yacc.c  */
#line 2831 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 239:

/* Line 1455 of yacc.c  */
#line 2836 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               (yyvsp[(5) - (7)].item), lab->ip,
                                                               lex);
            if (i == NULL ||
                lex->sphead->add_instr(i))
              MYSQL_YYABORT;
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 240:

/* Line 1455 of yacc.c  */
#line 2854 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 241:

/* Line 1455 of yacc.c  */
#line 2856 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 242:

/* Line 1455 of yacc.c  */
#line 2861 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 243:

/* Line 1455 of yacc.c  */
#line 2863 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 244:

/* Line 1455 of yacc.c  */
#line 2865 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 245:

/* Line 1455 of yacc.c  */
#line 2869 "sql_yacc.yy"
    {}
    break;

  case 246:

/* Line 1455 of yacc.c  */
#line 2870 "sql_yacc.yy"
    {}
    break;

  case 247:

/* Line 1455 of yacc.c  */
#line 2872 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, (yyvsp[(2) - (2)].table), NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 248:

/* Line 1455 of yacc.c  */
#line 2878 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, (yyvsp[(3) - (4)].table), NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 249:

/* Line 1455 of yacc.c  */
#line 2886 "sql_yacc.yy"
    {}
    break;

  case 250:

/* Line 1455 of yacc.c  */
#line 2887 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 251:

/* Line 1455 of yacc.c  */
#line 2887 "sql_yacc.yy"
    {}
    break;

  case 252:

/* Line 1455 of yacc.c  */
#line 2891 "sql_yacc.yy"
    {}
    break;

  case 253:

/* Line 1455 of yacc.c  */
#line 2893 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 254:

/* Line 1455 of yacc.c  */
#line 2893 "sql_yacc.yy"
    {}
    break;

  case 255:

/* Line 1455 of yacc.c  */
#line 2895 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 256:

/* Line 1455 of yacc.c  */
#line 2895 "sql_yacc.yy"
    {}
    break;

  case 257:

/* Line 1455 of yacc.c  */
#line 2900 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->lock_option= using_update_log ? TL_READ_NO_INSERT : TL_READ;
	    if (lex->sql_command == SQLCOM_INSERT)
	      lex->sql_command= SQLCOM_INSERT_SELECT;
	    else if (lex->sql_command == SQLCOM_REPLACE)
	      lex->sql_command= SQLCOM_REPLACE_SELECT;
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    lex->current_select->table_list.save_and_clear(&lex->save_list);
	    mysql_init_select(lex);
	    lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 258:

/* Line 1455 of yacc.c  */
#line 2916 "sql_yacc.yy"
    {
	    Select->parsing_place= NO_MATTER;
	  }
    break;

  case 259:

/* Line 1455 of yacc.c  */
#line 2920 "sql_yacc.yy"
    {
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    Lex->current_select->table_list.push_front(&Lex->save_list);
	  }
    break;

  case 260:

/* Line 1455 of yacc.c  */
#line 2930 "sql_yacc.yy"
    {}
    break;

  case 261:

/* Line 1455 of yacc.c  */
#line 2931 "sql_yacc.yy"
    {}
    break;

  case 262:

/* Line 1455 of yacc.c  */
#line 2934 "sql_yacc.yy"
    {}
    break;

  case 263:

/* Line 1455 of yacc.c  */
#line 2935 "sql_yacc.yy"
    {}
    break;

  case 264:

/* Line 1455 of yacc.c  */
#line 2938 "sql_yacc.yy"
    {}
    break;

  case 265:

/* Line 1455 of yacc.c  */
#line 2939 "sql_yacc.yy"
    {}
    break;

  case 266:

/* Line 1455 of yacc.c  */
#line 2942 "sql_yacc.yy"
    {}
    break;

  case 267:

/* Line 1455 of yacc.c  */
#line 2943 "sql_yacc.yy"
    {}
    break;

  case 268:

/* Line 1455 of yacc.c  */
#line 2946 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 269:

/* Line 1455 of yacc.c  */
#line 2947 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[(1) - (1)].num);}
    break;

  case 270:

/* Line 1455 of yacc.c  */
#line 2950 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[(1) - (1)].num); }
    break;

  case 271:

/* Line 1455 of yacc.c  */
#line 2951 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[(1) - (2)].num) | (yyvsp[(2) - (2)].num); }
    break;

  case 272:

/* Line 1455 of yacc.c  */
#line 2954 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_TMP_TABLE; }
    break;

  case 273:

/* Line 1455 of yacc.c  */
#line 2957 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 274:

/* Line 1455 of yacc.c  */
#line 2958 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_IF_NOT_EXISTS; }
    break;

  case 282:

/* Line 1455 of yacc.c  */
#line 2974 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[(3) - (3)].db_type); Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 283:

/* Line 1455 of yacc.c  */
#line 2975 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[(3) - (3)].db_type); WARN_DEPRECATED("TYPE=storage_engine","ENGINE=storage_engine");   Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 284:

/* Line 1455 of yacc.c  */
#line 2976 "sql_yacc.yy"
    { Lex->create_info.max_rows= (yyvsp[(3) - (3)].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MAX_ROWS;}
    break;

  case 285:

/* Line 1455 of yacc.c  */
#line 2977 "sql_yacc.yy"
    { Lex->create_info.min_rows= (yyvsp[(3) - (3)].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MIN_ROWS;}
    break;

  case 286:

/* Line 1455 of yacc.c  */
#line 2978 "sql_yacc.yy"
    { Lex->create_info.avg_row_length=(yyvsp[(3) - (3)].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_AVG_ROW_LENGTH;}
    break;

  case 287:

/* Line 1455 of yacc.c  */
#line 2979 "sql_yacc.yy"
    { Lex->create_info.password=(yyvsp[(3) - (3)].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_PASSWORD; }
    break;

  case 288:

/* Line 1455 of yacc.c  */
#line 2980 "sql_yacc.yy"
    { Lex->create_info.comment=(yyvsp[(3) - (3)].lex_str); Lex->create_info.used_fields|= HA_CREATE_USED_COMMENT; }
    break;

  case 289:

/* Line 1455 of yacc.c  */
#line 2981 "sql_yacc.yy"
    { Lex->create_info.auto_increment_value=(yyvsp[(3) - (3)].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_AUTO;}
    break;

  case 290:

/* Line 1455 of yacc.c  */
#line 2983 "sql_yacc.yy"
    {
            switch((yyvsp[(3) - (3)].ulong_num)) {
            case 0:
                Lex->create_info.table_options|= HA_OPTION_NO_PACK_KEYS;
                break;
            case 1:
                Lex->create_info.table_options|= HA_OPTION_PACK_KEYS;
                break;
            default:
                my_parse_error(ER(ER_SYNTAX_ERROR));
                MYSQL_YYABORT;
            }
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 291:

/* Line 1455 of yacc.c  */
#line 2998 "sql_yacc.yy"
    {
            Lex->create_info.table_options&=
              ~(HA_OPTION_PACK_KEYS | HA_OPTION_NO_PACK_KEYS);
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 292:

/* Line 1455 of yacc.c  */
#line 3003 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[(3) - (3)].ulong_num) ? HA_OPTION_CHECKSUM : HA_OPTION_NO_CHECKSUM; Lex->create_info.used_fields|= HA_CREATE_USED_CHECKSUM; }
    break;

  case 293:

/* Line 1455 of yacc.c  */
#line 3004 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[(3) - (3)].ulong_num) ? HA_OPTION_DELAY_KEY_WRITE : HA_OPTION_NO_DELAY_KEY_WRITE;  Lex->create_info.used_fields|= HA_CREATE_USED_DELAY_KEY_WRITE; }
    break;

  case 294:

/* Line 1455 of yacc.c  */
#line 3005 "sql_yacc.yy"
    { Lex->create_info.row_type= (yyvsp[(3) - (3)].row_type);  Lex->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT; }
    break;

  case 295:

/* Line 1455 of yacc.c  */
#line 3007 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_TYPE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 296:

/* Line 1455 of yacc.c  */
#line 3012 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKS", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 297:

/* Line 1455 of yacc.c  */
#line 3017 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKSIZE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 298:

/* Line 1455 of yacc.c  */
#line 3022 "sql_yacc.yy"
    {
	    /* Move the union list to the merge_list */
	    LEX *lex=Lex;
	    TABLE_LIST *table_list= lex->select_lex.get_table_list();
	    lex->create_info.merge_list= lex->select_lex.table_list;
	    lex->create_info.merge_list.elements--;
	    lex->create_info.merge_list.first=
	      (byte*) (table_list->next_local);
	    lex->select_lex.table_list.elements=1;
	    lex->select_lex.table_list.next=
	      (byte**) &(table_list->next_local);
	    table_list->next_local= 0;
	    lex->create_info.used_fields|= HA_CREATE_USED_UNION;
	  }
    break;

  case 301:

/* Line 1455 of yacc.c  */
#line 3038 "sql_yacc.yy"
    { Lex->create_info.merge_insert_method= (yyvsp[(3) - (3)].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_INSERT_METHOD;}
    break;

  case 302:

/* Line 1455 of yacc.c  */
#line 3039 "sql_yacc.yy"
    { Lex->create_info.data_file_name= (yyvsp[(4) - (4)].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_DATADIR; }
    break;

  case 303:

/* Line 1455 of yacc.c  */
#line 3040 "sql_yacc.yy"
    { Lex->create_info.index_file_name= (yyvsp[(4) - (4)].lex_str).str;  Lex->create_info.used_fields|= HA_CREATE_USED_INDEXDIR; }
    break;

  case 304:

/* Line 1455 of yacc.c  */
#line 3041 "sql_yacc.yy"
    { Lex->create_info.connect_string.str= (yyvsp[(3) - (3)].lex_str).str; Lex->create_info.connect_string.length= (yyvsp[(3) - (3)].lex_str).length;  Lex->create_info.used_fields|= HA_CREATE_USED_CONNECTION; }
    break;

  case 305:

/* Line 1455 of yacc.c  */
#line 3046 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[(4) - (4)].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[(4) - (4)].charset)))
          {
            my_error(ER_CONFLICTING_DECLARATIONS, MYF(0),
                     "CHARACTER SET ", cinfo->default_table_charset->csname,
                     "CHARACTER SET ", (yyvsp[(4) - (4)].charset)->csname);
            MYSQL_YYABORT;
          }
	  Lex->create_info.default_table_charset= (yyvsp[(4) - (4)].charset);
          Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 306:

/* Line 1455 of yacc.c  */
#line 3063 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[(4) - (4)].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[(4) - (4)].charset)))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[(4) - (4)].charset)->name, cinfo->default_table_charset->csname);
              MYSQL_YYABORT;
            }
            Lex->create_info.default_table_charset= (yyvsp[(4) - (4)].charset);
            Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 307:

/* Line 1455 of yacc.c  */
#line 3079 "sql_yacc.yy"
    {
	  (yyval.db_type) = ha_resolve_by_name((yyvsp[(1) - (1)].lex_str).str,(yyvsp[(1) - (1)].lex_str).length);
	  if ((yyval.db_type) == DB_TYPE_UNKNOWN) {
	    my_error(ER_UNKNOWN_STOR