#include <glib.h>
#include <glib/gprintf.h>
#include "jabber.h"
#include "converter.h"
#include "debug.h"
#include <loudmouth-1.0/loudmouth/loudmouth.h>
#include <libxml2/libxml/parser.h>

#define DRV_DEBUG_PREFIX "JB_TEST:"

static xmlDocPtr build_get_profile_response()
{
    DRIVER_DEBUG(5)("%s build_get_profile_response START", DRV_DEBUG_PREFIX);
    xmlChar* text_profile = BAD_CAST jabber_get_own_profile();
    xmlDocPtr jb_profile = xmlParseDoc(text_profile);
    xmlFree(text_profile);
    xmlDocPtr profile = convert_jabber_profile_to_inner_format(jb_profile,"d","x", "updateProfile");
    DRIVER_DEBUG(5)("%s build_get_profile_response END", DRV_DEBUG_PREFIX);
    return profile;
}


static xmlNodePtr* transform_xmlnodes_to_lmnodes(xmlNodePtr node, LmMessageNode* parent)
{
    if (node == NULL) {
        return NULL;
    }

    if (xmlNodeIsText(node) == 1) {
        if (xmlNodeIsText(node->children) == 1) {
     //       node = node->children;
        }
    }

    LmMessageNode* new_parent = NULL;
    if (xmlNodeIsText(node) == 1) {
        g_debug("add name %s %s %i", node->name, node->content, xmlNodeIsText(node));
        lm_message_node_set_value(parent, (gchar*)xmlNodeGetContent(node));
        new_parent = parent;
        //node = NULL;
    } else {
        new_parent = lm_message_node_add_child(parent, (const gchar*)node->name, NULL);
    }

    xmlNodePtr child = node;
    if (child != NULL) {
        g_debug("child name %s %s %i", child->name, node->content, xmlNodeIsText(child));
        //sibling =
               transform_xmlnodes_to_lmnodes(child->children, new_parent);
        
    }

    xmlNodePtr sibling = node;
    if (sibling != NULL) {
            g_debug("sib %s %s %i", sibling->name, node->content, xmlNodeIsText(sibling));
        //sibling =
               transform_xmlnodes_to_lmnodes(sibling->next, new_parent);
      //  sibling = sibling->next;
    }

    //sleep(5);
    return NULL;

    //xmlNodePtr sibling = node;
    while (sibling != NULL) {
            g_debug("name %s %s %i", sibling->name, node->content, xmlNodeIsText(sibling));
        //sibling =
               transform_xmlnodes_to_lmnodes(sibling->next, NULL);
        sibling = sibling->next;
    }


    return NULL;






/*
    return NULL;
    g_debug("name %s %s %i", node->name, node->content, xmlNodeIsText(node));


    LmMessageNode* child = lm_message_node_add_child(parent, node->name, NULL);

    xmlNodePtr* children = node->children;
    while (children != NULL) {

        if (xmlNodeIsText(children) == 1) {
            gchar* content = (gchar*)xmlNodeGetContent(children);
            lm_message_node_set_value(parent, content);
            //break;
        }
       // children =
                transform_xmlnodes_to_lmnodes(children, child);
        children = children->children;
    }

    xmlNodePtr* sibling = node->next;
    if (sibling != NULL) {
        sibling =
                transform_xmlnodes_to_lmnodes(node->next, child);
        sibling = node->next;
    }

    if (xmlNodeIsText(children) == 1) {
        gchar* content = (gchar*)xmlNodeGetContent(node);
        lm_message_node_set_value(parent, content);
    }
    sleep(5);
    return node;
*/
}



void print_menu()
{
    printf("\n\nMENU\n");
    printf("1 - init jabber\n");
    printf("2 - shtd jabber\n");
    printf("3 - set context\n");
    printf("4 - set proxy\n");
    printf("5 - Connect\n");
    printf("6 - Get profile\n");
  printf("7 - test\n");
    printf("0 - exit\n");
    
    
}

//#define JID "kolosys@jabber.org"//
//#define JID "lomalan@jabber.infos.ru/suse_test"
#define JID "kolossal_boot@jabber.org"
#define PASSWORD "12qwasD"
//#define PASSWORD "B1`7nh367s_=-a"
//#define PASSWORD "123456"

//#define PROXY_HOST "10.10.99.26"
//#define PROXY_PORT 8085

#define PROXY_HOST "127.0.0.1"
#define PROXY_PORT 8080



gint main() {

    gchar option = 0;

    gboolean cycle_flag = TRUE;
    while (cycle_flag == TRUE) {

        print_menu();
        
        option = (gchar)getchar();

        switch (option) {
            case '1': {
                jabber_init();
                break;
            }

            case '2': {
                jabber_shtd();
                break;
            }
            case '3': {
                jabber_set_user_context(JID, PASSWORD);
                break;
            }
            case '4': {
                jabber_set_proxy(PROXY_HOST, PROXY_PORT);
                break;
            }
            case '5': {
                jabber_use_proxy(FALSE);
                g_debug("Connect = %i", jabber_connect());
                break;
            }
            case '6': {
                jabber_use_proxy(FALSE);
                build_get_profile_response();
                break;
            }
            case '7': {
                 xmlDocPtr elem = xmlParseFile("data/vcard.xml");
                jabber_use_proxy(FALSE);
                xmlNodePtr node = xmlDocGetRootElement(elem);
                 LmMessage* message = lm_message_new_with_sub_type(NULL, LM_MESSAGE_TYPE_IQ,
            LM_MESSAGE_SUB_TYPE_SET);
                 xmlDocDump(stdout, elem);
                transform_xmlnodes_to_lmnodes(node, message->node);
                  g_debug("REC; %s", lm_message_node_to_string(message->node) );
                break;
            }
            case '0': {
                cycle_flag = FALSE;
                break;
            }

        }



    }

    g_debug("%i",is_jabber_connect());
    return 0;
}
