
/*
 * jabber_requests.c - contains function for build jabber requests.
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Alexander A. Lomov. All rights reserved.
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with <program name>; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#include <libxml/tree.h>
#include <libxml2/libxml/tree.h>

#include "jabber_requests.h"
#include "debug.h"

#define JABBER_FROM_ATTR "from"
#define JABBER_TYPE_ATTR "type"
#define JABBER_ERROR_CODE_ATTR "code"
#define JABBER_ERROR_TYPE_ATTR "type"
#define JABBER_GET_VALUE "get"
#define JABBER_TYPE_ERROR_VALUE "error"
#define JABBER_QUERY_NODE_NAME "query"
#define JABBER_ERROR_NODE_NAME "error"
#define XMLNS_ATTR "xmlns"
#define JABBER_IQ_REGISTER_NS "jabber:iq:register"
#define JABBER_ROSTER_NS "jabber:iq:roster"

#define JABBER_VCARD_NS "vcard-temp"
#define JABBER_VCARD_NODE_NAME "vCard"

#define DRV_DEBUG_PREFIX "JB_PARSER:"

LmMessage* build_presence_prob_message(gchar* from, gchar* to)
{
    LmMessage* message = lm_message_new_with_sub_type(to, LM_MESSAGE_TYPE_PRESENCE,
            LM_MESSAGE_SUB_TYPE_PROBE);

    lm_message_node_set_attribute(message->node, JABBER_FROM_ATTR, from);

    return message;
}


LmMessage* build_presence_request(LmMessageSubType type)
{
    return lm_message_new_with_sub_type(NULL, LM_MESSAGE_TYPE_PRESENCE, type);
}


LmMessage* build_get_roster_request(const gchar* to)
{
    LmMessage* message = lm_message_new_with_sub_type(to, LM_MESSAGE_TYPE_IQ,
            LM_MESSAGE_SUB_TYPE_GET);

    LmMessageNode* query_node = lm_message_node_add_child(message->node,
            JABBER_QUERY_NODE_NAME , NULL);

    lm_message_node_set_attribute(query_node, XMLNS_ATTR, JABBER_ROSTER_NS);

    return message;
}




LmMessage* build_get_vcard_request(const gchar* from, const gchar* to)
{
    DRIVER_DEBUG(5)("%s build_get_vcard_request START", DRV_DEBUG_PREFIX);
    LmMessage* message = lm_message_new_with_sub_type(to, LM_MESSAGE_TYPE_IQ,
            LM_MESSAGE_SUB_TYPE_GET);

    if (from != NULL) {
        lm_message_node_set_attribute(message->node,JABBER_FROM_ATTR, from);
    }

    LmMessageNode* vcard_node = lm_message_node_add_child(message->node,
            JABBER_VCARD_NODE_NAME, NULL);

    lm_message_node_set_attribute(vcard_node, XMLNS_ATTR, JABBER_VCARD_NS);

    DRIVER_DEBUG(5)("%s build_get_vcard_request END", DRV_DEBUG_PREFIX);
    return message;
}

LmMessage* build_set_vcard_request(const gchar* from, const gchar* to, const xmlDocPtr vcadr_doc)
{
    DRIVER_DEBUG(5)("%s build_set_vcard_request START", DRV_DEBUG_PREFIX);
    LmMessage* message = lm_message_new_with_sub_type(to, LM_MESSAGE_TYPE_IQ,
            LM_MESSAGE_SUB_TYPE_SET);

    xmlNodePtr root_node = xmlDocGetRootElement(vcadr_doc);
    xmlBufferPtr buf = xmlBufferCreate();
    xmlNodeDump(buf, NULL, root_node, 0, 1);
    const gchar* content = (const gchar*)xmlBufferContent(buf);

    DRIVER_MESSAGE(10)("%s vCard content: %s", DRV_DEBUG_PREFIX, content);
    lm_message_node_set_raw_mode(message->node, TRUE);
    lm_message_node_set_value(message->node, content);

    if (from != NULL) {
        lm_message_node_set_attribute(message->node,JABBER_FROM_ATTR, from);
    }

    xmlBufferFree(buf);

    DRIVER_DEBUG(5)("%s build_set_vcard_request END", DRV_DEBUG_PREFIX);
    return message;
}


LmMessage* build_send_message_request(const xmlDocPtr message_doc)
{
    DRIVER_DEBUG(5)("%s build_send_message_request START", DRV_DEBUG_PREFIX);
    xmlNodePtr root_node = xmlDocGetRootElement(message_doc);
    xmlChar* to = xmlGetProp(root_node, "to");
    xmlChar* from = xmlGetProp(root_node, "from");
    xmlChar* content = xmlNodeGetContent(root_node->children);
    gchar* mes_content = g_uri_unescape_string((const gchar*)content, NULL);

    LmMessage* message = lm_message_new(to, LM_MESSAGE_TYPE_MESSAGE);
    lm_message_node_add_child(message->node, "body", mes_content);

    if (from != NULL) {
        lm_message_node_set_attribute(message->node, JABBER_FROM_ATTR, from);
    }
    g_free(mes_content);
    xmlFree(to);
    xmlFree(from);
    xmlFree(content);

    DRIVER_DEBUG(5)("%s build_send_message_request END", DRV_DEBUG_PREFIX);
    return message;
}


LmMessage* build_get_friends_request(const gchar* from, const gchar* to)
{
    DRIVER_DEBUG(5)("%s build_get_friends_request START", DRV_DEBUG_PREFIX);
    LmMessage* message = lm_message_new_with_sub_type(to, LM_MESSAGE_TYPE_IQ,
            LM_MESSAGE_SUB_TYPE_GET);

    if (from != NULL) {
        lm_message_node_set_attribute(message->node,JABBER_FROM_ATTR, from);
    }

    LmMessageNode* node = lm_message_node_add_child(message->node,
            JABBER_QUERY_NODE_NAME, NULL);

    lm_message_node_set_attribute(node, XMLNS_ATTR, JABBER_ROSTER_NS);

    DRIVER_DEBUG(5)("%s build_get_friends_request END", DRV_DEBUG_PREFIX);
    return message;
}


/******************************************************************************/
/********************* Not used now function (maybe later) ********************/

/**
 * Creates from xmlNode's tree LmMessageNodes.
 *
 * @param node Node for start transform.
 * @param parent Parent node for the transform node. 
 */
/*
static void transform_xmlnodes_to_lmnodes(xmlNodePtr node, LmMessageNode* parent)
{
    if (node == NULL) {
        return NULL;
    }

    LmMessageNode* child = lm_message_node_add_child(parent, node->name, NULL);

    xmlNodePtr* children = node->children;
    while (children != NULL) {

        //children = transform_xmlnodes_to_lmnodes(node->children, child);
//        children = node->children;
    }

    xmlNodePtr* sibling = node->next;
    if (sibling != NULL) {
        //sibling = transform_xmlnodes_to_lmnodes(node->next, child);
        //sibling = node->next;
    }

    if (xmlNodeIsText(children) == 1) {
        gchar* content = (gchar*)xmlNodeGetContent(node);
        lm_message_node_set_value(parent, content);
    }

    return NULL;
}
*/
