<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
    xmlns:bio="http://purl.org/vocab/bio/0.1/"
    xmlns:foaf="http://xmlns.com/foaf/0.1/"
    xmlns:sonet="http://cs.karelia.ru/social_network/"
    xmlns:contact="http://www.w3.org/2000/10/swap/pim/contact"
    xmlns:ad="http://schemas.talis.com/2005/address/schema#"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:doclist="http://www.junkwork.net/xml/DocumentList#"
           
    version="1.0"
	exclude-result-prefixe="rdf sonet foaf bio xsl contact ad dc doclist"
    extension-element-prefixes="rdf sonet foaf bio xsl contact ad dc doclist" >

	<xsl:param name="ID"></xsl:param>
	<xsl:param name="FROM" select="1"></xsl:param>
	<xsl:param name="TO" select="10"></xsl:param>
	<xsl:param name="ALL"></xsl:param>	


    <xsl:output  method="xml" indent="yes"   encoding="UTF-8"/>

	<xsl:template match="rdf:RDF">
	<data>
	<xsl:apply-templates>

        <xsl:sort order="descending" select="dc:date" />
	</xsl:apply-templates>        
	</data>	
	</xsl:template>

        <!-- "position() - 1" because have rdf:RDF -->
	<xsl:template match="doclist:Document">        
			<xsl:if test="(position() - 1 >= $FROM and not(position() - 1 > $TO)) or $ALL" >
			<struct>

				<xsl:attribute name="name">
					<xsl:text>message</xsl:text>
				</xsl:attribute>
				
				<xsl:attribute name="id">
					<xsl:value-of select="position()"/>	
				</xsl:attribute>
		
				<string>
					<xsl:attribute name="name">
						<xsl:text>SenderId</xsl:text>
					</xsl:attribute>				
					<xsl:value-of select="dc:creator/@rdf:ID"/>			
				</string>
				
				<string>
					<xsl:attribute name="name">
						<xsl:text>SenderName</xsl:text>
					</xsl:attribute>				
					<xsl:value-of select="dc:creator"/>			
				</string>
				
				<string>
					<xsl:attribute name="name">
						<xsl:text>RecipientId</xsl:text>
					</xsl:attribute>				
					<xsl:value-of select="sonet:recipient/@rdf:ID"/>			
				</string>
				
				<string>
					<xsl:attribute name="name">
						<xsl:text>RecipientName</xsl:text>
					</xsl:attribute>				
					<xsl:value-of select="sonet:recipient"/>			
				</string>

				<date>
					<xsl:attribute name="name">
						<xsl:text>Time</xsl:text>
					</xsl:attribute>				
					<xsl:value-of select="dc:date"/>			
				</date>

				<string>
					<xsl:attribute name="name">
						<xsl:text>Text</xsl:text>
					</xsl:attribute>				
					<xsl:value-of select="dc:text"/>			
				</string>
		
				<string>
					<xsl:attribute name="name">
						<xsl:text>Status</xsl:text>
					</xsl:attribute>				
					<xsl:value-of select="sonet:status"/>			
				</string>

			</struct>
</xsl:if>
	</xsl:template>

	
</xsl:stylesheet>
