/*
 * db_logic.h - header file for DB function
 * This file is part of MSA program
 *
 * Copyright (C) 2009 Alexander A. Lomov
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */
  

#ifndef __DB_LOGIC_H__
#define __DB_LOGIC_H__

#include <glib.h>
#include <glib/gprintf.h>
#include <string.h>

#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h> 

#include <libxslt/transform.h>
#include <libxslt/xslt.h>
#include <libxslt/xsltInternals.h>
#include <libxslt/xsltutils.h>

#include <stdio.h>
#include <stdlib.h>



//#define SCHEMA_NAME_PROFILES "profiles"
#define SCHEMA_NAME_METACONTACTS "metacontacts"
#define SCHEMA_NAME_CONTACTS "contacts"
#define SCHEMA_NAME_CONTACTS_LIST "contactsList"
#define SCHEMA_NAME_CONTACTS_LIST_FILTER "contactsListFilter"
//#define SCHEMA_NAME_SERVICES "services"
#define SCHEMA_NAME_MESSAGES "messages"
#define SCHEMA_NAME_OWNER_MESSAGES "ownerMessages"
#define SCHEMA_NAME_OWNER_MESSAGES_FILTER "ownerMessagesFilter"
#define SCHEMA_NAME_MESSAGES_FILTER "ownerMessagesFilter"
//#define SCHEMA_NAME_TEST "test"

#define SCHEMAS_COUNT 8


void db_prepare(const gchar* db_name);
xmlDocPtr get_table_from_list(const gchar* schema_name); 
//gint db_add_data_to_db(const gchar* schema_name, const xmlDocPtr new_data,
//                    const gchar** parameters);
gchar* db_add_data_to_db(const gchar* schema_name, const xmlDocPtr new_data, const gchar** parameters);
gint db_remove_node_by_id(const gchar* schema_name ,const gchar* id);
GSList* db_get_node_by_id(const gchar* schema_name ,const gchar* id);
gint db_add_data_to_db_with_id(const gchar* schema_name, const xmlDocPtr new_data,
                               const gchar** parameters);


GSList* get_nodes_ids(const gchar* schema_name, gchar* xpath);
gchar* create_list_value_filter(const gchar* key, const GSList* values, const gchar* logic_op);
gint load_binary_data_to_doc(const gchar* schema_name, xmlDocPtr doc);

gchar* db_get_binary_data_content(const gchar* binary_id);
gboolean db_set_binary_data_content(const gchar* binary_id, const gchar* content);
#endif /* __DB_LOGIC_H__ */



